/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.rng;

import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueRandomGenerator;
import org.nd4j.rng.NativeRandom;

public class CpuNativeRandom
extends NativeRandom {
    private NativeOps nativeOps;

    public CpuNativeRandom() {
    }

    public CpuNativeRandom(long seed) {
        super(seed);
    }

    public CpuNativeRandom(long seed, long numberOfElements) {
        super(seed, numberOfElements);
    }

    public void init() {
        this.nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        this.statePointer = this.nativeOps.createRandomGenerator(this.seed, this.seed ^ 0xFFFFFFFFDEADBEEFL);
    }

    public void close() {
        this.nativeOps.deleteRandomGenerator((OpaqueRandomGenerator)this.statePointer);
    }

    public PointerPointer getExtraPointers() {
        return null;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.currentPosition.set(0L);
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, seed, seed ^ 0xFFFFFFFFDEADBEEFL);
    }

    public long getSeed() {
        return this.seed;
    }

    public int nextInt() {
        return this.nativeOps.getRandomGeneratorNextInt((OpaqueRandomGenerator)this.statePointer);
    }

    public float nextFloat() {
        return this.nativeOps.getRandomGeneratorNextFloat((OpaqueRandomGenerator)this.statePointer);
    }

    public double nextDouble() {
        return this.nativeOps.getRandomGeneratorNextDouble((OpaqueRandomGenerator)this.statePointer);
    }

    public long nextLong() {
        return this.nativeOps.getRandomGeneratorNextLong((OpaqueRandomGenerator)this.statePointer);
    }

    public long rootState() {
        return this.nativeOps.getRandomGeneratorRootState((OpaqueRandomGenerator)this.statePointer);
    }

    public long nodeState() {
        return this.nativeOps.getRandomGeneratorNodeState((OpaqueRandomGenerator)this.statePointer);
    }

    public void setStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, rootState, nodeState);
    }
}

