/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import org.neo4j.cypher.CypherParser;
import org.neo4j.cypher.ExecutionEngine$;
import org.neo4j.cypher.ExecutionPlan;
import org.neo4j.cypher.ExecutionResult;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.LRUCache;
import org.neo4j.cypher.internal.commands.Query;
import org.neo4j.cypher.internal.executionplan.ExecutionPlanImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.util.StringLogger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001%\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\taaY=qQ\u0016\u0014(BA\u0003\u0007\u0003\u0015qWm\u001c\u001bk\u0015\u00059\u0011aA8sO\u000e\u00011C\u0001\u0001\u000b!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\b\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB4sCBDGMY\u0005\u00033Y\u0011Ac\u0012:ba\"$\u0015\r^1cCN,7+\u001a:wS\u000e,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\r1|wmZ3s!\tiB%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003vi&d'BA\u0011#\u0003\u0011IW\u000e\u001d7\u000b\u0005\r\"\u0011AB6fe:,G.\u0003\u0002&=\ta1\u000b\u001e:j]\u001edunZ4fe\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"2!K\u0016-!\tQ\u0003!D\u0001\u0003\u0011\u0015\u0019b\u00051\u0001\u0015\u0011\u001dYb\u0005%AA\u0002qAqA\f\u0001C\u0002\u0013\u0005q&\u0001\u0004qCJ\u001cXM]\u000b\u0002aA\u0011!&M\u0005\u0003e\t\u0011AbQ=qQ\u0016\u0014\b+\u0019:tKJDa\u0001\u000e\u0001!\u0002\u0013\u0001\u0014a\u00029beN,'\u000f\t\u0005\u0006m\u0001!IaN\u0001\u0014GJ,\u0017\r^3D_J\u0014Xm\u0019;QCJ\u001cXM\u001d\u000b\u0002a!)\u0011\b\u0001C\u0001u\u00059Q\r_3dkR,GCA\u001e?!\tQC(\u0003\u0002>\u0005\tyQ\t_3dkRLwN\u001c*fgVdG\u000fC\u0003@q\u0001\u0007\u0001)A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002B\u000f:\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\u00061\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t15\tK\u00029\u0017v\u00032A\u0011'O\u0013\ti5I\u0001\u0004uQJ|wo\u001d\t\u0003\u001fBc\u0001\u0001B\u0003R\u0001\t\u0007!KA\u0001U#\t\u0019f\u000b\u0005\u0002C)&\u0011Qk\u0011\u0002\b\u001d>$\b.\u001b8h!\t9&L\u0004\u0002C1&\u0011\u0011lQ\u0001\ba\u0006\u001c7.Y4f\u0013\tYFLA\u0005UQJ|w/\u00192mK*\u0011\u0011lQ\u0012\u0002=B\u0011!fX\u0005\u0003A\n\u0011qbU=oi\u0006DX\t_2faRLwN\u001c\u0005\u0006s\u0001!\tA\u0019\u000b\u0004w\r$\u0007\"B b\u0001\u0004\u0001\u0005\"B3b\u0001\u00041\u0017A\u00029be\u0006l7\u000f\u0005\u0003BO\u0002K\u0017B\u00015J\u0005\ri\u0015\r\u001d\t\u0003\u0005*L!a[\"\u0003\u0007\u0005s\u0017\u0010K\u0002b[v\u00032A\u0011'o!\tyu\u000eB\u0003R\u0001\t\u0007!\u000bC\u0003:\u0001\u0011\u0005\u0011\u000fF\u0002<eNDQa\u00109A\u0002\u0001CQ!\u001a9A\u0002Q\u0004B!^<AS6\taO\u0003\u0002 \u001d%\u0011\u0001N\u001e\u0015\u0004afl\u0006c\u0001\"MuB\u0011qj\u001f\u0003\u0006#\u0002\u0011\rA\u0015\u0005\u0006{\u0002!\tA`\u0001\baJ,\u0007/\u0019:f)\ry\u0018Q\u0001\t\u0004U\u0005\u0005\u0011bAA\u0002\u0005\tiQ\t_3dkRLwN\u001c)mC:DQa\u0010?A\u0002\u0001CC\u0001`A\u0005;B!!\tTA\u0006!\ry\u0015Q\u0002\u0003\u0006#\u0002\u0011\rA\u0015\u0005\b\u0003#\u0001A\u0011AA\n\u0003)I7\u000f\u0015:fa\u0006\u0014X\r\u001a\u000b\u0005\u0003+\tY\u0002E\u0002C\u0003/I1!!\u0007D\u0005\u001d\u0011un\u001c7fC:DaaPA\b\u0001\u0004\u0001\u0005BB\u001d\u0001\t\u0003\ty\u0002F\u0002<\u0003CAqaPA\u000f\u0001\u0004\t\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0011\r|W.\\1oINT1!!\f\u0003\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA\u0019\u0003O\u0011Q!U;fefD\u0003\"!\b\u00026\u0005m\u0012q\b\t\u0004\u0005\u0006]\u0012bAA\u001d\u0007\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005u\u0012aT-pk\u0002\u001a\bn\\;mI\u0002rw\u000e\u001e\u0011qCJ\u001cX\rI9vKJLWm\u001d\u0011nC:,\u0018\r\u001c7zA\u0005t\u0017\u0010I7pe\u0016t\u0003%V:fAQDW\rI3yK\u000e,H/\u001a\u0015TiJLgnZ\u0015!S:\u001cH/Z1ec!\u0019\u0003)!\u0011\u0002J\u0005\r\u0013\u0002BA\"\u0003\u000b\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012$bAA$\u0007\u0006QA-\u001a9sK\u000e\fG/\u001a32\u0013\r\nY%!\u0014\u0002P\u0005\u001dcb\u0001\"\u0002N%\u0019\u0011qI\"2\u000b\t\u00125)!\u0015\u0003\u000bM\u001c\u0017\r\\1)\u000b\u0005u\u0011QK/\u0011\t\tc\u0015q\u000b\t\u0004\u001f\u0006eC!B)\u0001\u0005\u0004\u0011\u0006BB\u001d\u0001\t\u0003\ti\u0006F\u0003<\u0003?\n\t\u0007C\u0004@\u00037\u0002\r!a\t\t\u000f\u0005\r\u00141\fa\u0001i\u0006\u0019Q.\u00199)\u0011\u0005m\u0013QGA\u001e\u0003O\n\u0004b\t!\u0002B\u0005%\u00141I\u0019\nG\u0005-\u0013QJA6\u0003\u000f\nTA\t\"D\u0003#BS!a\u0017\u0002pu\u0003BA\u0011'\u0002rA\u0019q*a\u001d\u0005\u000bE\u0003!\u0019\u0001*\t\re\u0002A\u0011AA<)\u0015Y\u0014\u0011PA>\u0011\u001dy\u0014Q\u000fa\u0001\u0003GAa!ZA;\u0001\u00041\u0007\u0006CA;\u0003k\tY$a 2\u0011\r\u0002\u0015\u0011IAA\u0003\u0007\n\u0014bIA&\u0003\u001b\n\u0019)a\u00122\u000b\t\u00125)!\u0015)\u000b\u0005U\u0014qQ/\u0011\t\tc\u0015\u0011\u0012\t\u0004\u001f\u0006-E!B)\u0001\u0005\u0004\u0011\u0006bBAH\u0001\u0011%\u0011\u0011S\u0001\u0012G\",7m[*dC2\fg+\u001a:tS>tGCAAJ!\r\u0011\u0015QS\u0005\u0004\u0003/\u001b%\u0001B+oSRD\u0011\"a'\u0001\u0005\u0004%I!!(\u0002%\u0015DXmY;uS>t\u0007\u000b\\1o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003?\u0003b!!)\u0002$\u0002{XBAA\u0016\u0013\u0011\t)+a\u000b\u0003\u00111\u0013VkQ1dQ\u0016D\u0001\"!+\u0001A\u0003%\u0011qT\u0001\u0014Kb,7-\u001e;j_:\u0004F.\u00198DC\u000eDW\r\t\u0005\b\u0003[\u0003A\u0011BAX\u0003E9W\r^)vKJL8)Y2iKNK'0\u001a\u000b\u0003\u0003c\u00032AQAZ\u0013\r\t)l\u0011\u0002\u0004\u0013:$x!CA]\u0005\u0005\u0005\t\u0012AA^\u0003=)\u00050Z2vi&|g.\u00128hS:,\u0007c\u0001\u0016\u0002>\u001aA\u0011AAA\u0001\u0012\u0003\tyl\u0005\u0003\u0002>\u0006\u0005\u0007c\u0001\"\u0002D&\u0019\u0011QY\"\u0003\r\u0005s\u0017PU3g\u0011\u001d9\u0013Q\u0018C\u0001\u0003\u0013$\"!a/\t\u0015\u0005\r\u0013QXI\u0001\n\u0003\ti-\u0006\u0002\u0002P*\u001aA$!5,\u0005\u0005M\u0007\u0003BAk\u0003?l!!a6\u000b\t\u0005e\u00171\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!8D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\f9NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ExecutionEngine {
    public final GraphDatabaseService org$neo4j$cypher$ExecutionEngine$$graph;
    private final StringLogger logger;
    private final CypherParser parser;
    private final LRUCache<String, ExecutionPlan> executionPlanCache;

    public static StringLogger $lessinit$greater$default$2() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$2();
    }

    public CypherParser parser() {
        return this.parser;
    }

    private CypherParser createCorrectParser() {
        CypherParser cypherParser;
        if (this.org$neo4j$cypher$ExecutionEngine$$graph instanceof InternalAbstractGraphDatabase) {
            CypherParser cypherParser2;
            InternalAbstractGraphDatabase database = (InternalAbstractGraphDatabase)this.org$neo4j$cypher$ExecutionEngine$$graph;
            String string2 = (String)database.getConfig().get((Setting)GraphDatabaseSettings.cypher_parser_version);
            if (string2 != null) {
                String x2 = string2;
                cypherParser2 = new CypherParser(x2);
            } else {
                cypherParser2 = new CypherParser();
            }
            cypherParser = cypherParser2;
        } else {
            cypherParser = new CypherParser();
        }
        return cypherParser;
    }

    public ExecutionResult execute(String query2) throws SyntaxException {
        return this.execute(query2, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public ExecutionResult execute(String query2, Map<String, Object> params) throws SyntaxException {
        this.logger.info(query2);
        return this.prepare(query2).execute(params);
    }

    public ExecutionResult execute(String query2, java.util.Map<String, Object> params) throws SyntaxException {
        return this.execute(query2, (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    public ExecutionPlan prepare(String query2) throws SyntaxException {
        return this.executionPlanCache().getOrElseUpdate(query2, (Function0<ExecutionPlan>)new Serializable(this, query2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final String query$1;

            public final ExecutionPlanImpl apply() {
                return new ExecutionPlanImpl(this.$outer.parser().parse(this.query$1), this.$outer.org$neo4j$cypher$ExecutionEngine$$graph);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
    }

    public boolean isPrepared(String query2) {
        return this.executionPlanCache().containsKey(query2);
    }

    public ExecutionResult execute(Query query2) throws SyntaxException {
        return this.execute(query2, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public ExecutionResult execute(Query query2, java.util.Map<String, Object> map) throws SyntaxException {
        return this.execute(query2, (Map<String, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    public ExecutionResult execute(Query query2, Map<String, Object> params) throws SyntaxException {
        return new ExecutionPlanImpl(query2, this.org$neo4j$cypher$ExecutionEngine$$graph).execute(params);
    }

    private void checkScalaVersion() {
        if (Properties$.MODULE$.versionString().matches("^version 2.9.0")) {
            throw new Error(new StringBuilder().append((Object)"Cypher can only run with Scala 2.9.0. It looks like the Scala version is: ").append((Object)Properties$.MODULE$.versionString()).toString());
        }
    }

    private LRUCache<String, ExecutionPlan> executionPlanCache() {
        return this.executionPlanCache;
    }

    public int org$neo4j$cypher$ExecutionEngine$$getQueryCacheSize() {
        int n;
        if (this.org$neo4j$cypher$ExecutionEngine$$graph instanceof InternalAbstractGraphDatabase) {
            int n2;
            InternalAbstractGraphDatabase database = (InternalAbstractGraphDatabase)this.org$neo4j$cypher$ExecutionEngine$$graph;
            Integer n3 = (Integer)database.getConfig().get((Setting)GraphDatabaseSettings.query_cache_size);
            if (n3 != null) {
                Integer x2 = n3;
                n2 = Predef$.MODULE$.Integer2int(x2);
            } else {
                n2 = 100;
            }
            n = n2;
        } else {
            n = 100;
        }
        return n;
    }

    public ExecutionEngine(GraphDatabaseService graph, StringLogger logger) {
        this.org$neo4j$cypher$ExecutionEngine$$graph = graph;
        this.logger = logger;
        this.checkScalaVersion();
        Predef$.MODULE$.require(graph != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.parser = this.createCorrectParser();
        this.executionPlanCache = new $anon$1(this);
    }
}

