/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi.gdsimpl;

import org.neo4j.cypher.internal.spi.QueryContext;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.IterableWrapper;

public class RepeatableReadQueryContext
implements QueryContext {
    private final QueryContext inner;
    private final Locker locker;
    private final QueryContext.Operations<Node> nodeOps;
    private final QueryContext.Operations<Relationship> relOps;

    public RepeatableReadQueryContext(QueryContext inner, Locker locker) {
        this.inner = inner;
        this.locker = locker;
        this.nodeOps = new LockingOperations<Node>(inner.nodeOps());
        this.relOps = new LockingOperations<Relationship>(inner.relationshipOps());
    }

    @Override
    public QueryContext.Operations<Node> nodeOps() {
        return this.nodeOps;
    }

    @Override
    public QueryContext.Operations<Relationship> relationshipOps() {
        return this.relOps;
    }

    @Override
    public Node createNode() {
        return this.inner.createNode();
    }

    @Override
    public Relationship createRelationship(Node start2, Node end, String relType) {
        return this.inner.createRelationship(start2, end, relType);
    }

    @Override
    public Iterable<Relationship> getRelationshipsFor(Node node2, Direction dir, String ... types) {
        this.locker.readLock((PropertyContainer)node2);
        Iterable<Relationship> iter = this.inner.getRelationshipsFor(node2, dir, types);
        return new LockingIterator(iter);
    }

    @Override
    public void close() {
        this.locker.releaseAllReadLocks();
    }

    private class LockingOperations<T extends PropertyContainer>
    implements QueryContext.Operations<T> {
        private final QueryContext.Operations<T> inner;

        private LockingOperations(QueryContext.Operations<T> inner) {
            this.inner = inner;
        }

        @Override
        public void delete(T obj) {
            this.inner.delete(obj);
        }

        @Override
        public void setProperty(T obj, String propertyKey, Object value) {
            this.inner.setProperty(obj, propertyKey, value);
        }

        @Override
        public void removeProperty(T obj, String propertyKey) {
            this.inner.removeProperty(obj, propertyKey);
        }

        @Override
        public Object getProperty(T obj, String propertyKey) {
            RepeatableReadQueryContext.this.locker.readLock((PropertyContainer)obj);
            return this.inner.getProperty(obj, propertyKey);
        }

        @Override
        public boolean hasProperty(T obj, String propertyKey) {
            RepeatableReadQueryContext.this.locker.readLock((PropertyContainer)obj);
            return this.inner.hasProperty(obj, propertyKey);
        }

        @Override
        public Iterable<String> propertyKeys(T obj) {
            RepeatableReadQueryContext.this.locker.readLock((PropertyContainer)obj);
            return this.inner.propertyKeys(obj);
        }

        @Override
        public T getById(long id2) {
            T obj = this.inner.getById(id2);
            RepeatableReadQueryContext.this.locker.readLock((PropertyContainer)obj);
            return obj;
        }
    }

    private class LockingIterator
    extends IterableWrapper<Relationship, Relationship> {
        public LockingIterator(Iterable<Relationship> iterableToWrap) {
            super(iterableToWrap);
        }

        protected Relationship underlyingObjectToObject(Relationship rel) {
            RepeatableReadQueryContext.this.locker.readLock((PropertyContainer)rel);
            return rel;
        }
    }

    public static interface Locker {
        public void readLock(PropertyContainer var1);

        public void releaseAllReadLocks();
    }
}

