/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.executionplan.builders;

import org.neo4j.cypher.MissingIndexException;
import org.neo4j.cypher.internal.ExecutionContext;
import org.neo4j.cypher.internal.commands.NodeById;
import org.neo4j.cypher.internal.commands.NodeByIndex;
import org.neo4j.cypher.internal.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.commands.RelationshipByIndex;
import org.neo4j.cypher.internal.commands.RelationshipByIndexQuery;
import org.neo4j.cypher.internal.commands.StartItem;
import org.neo4j.cypher.internal.commands.expressions.Expression;
import org.neo4j.cypher.internal.executionplan.builders.GetGraphElements$;
import org.neo4j.cypher.internal.pipes.QueryState;
import org.neo4j.cypher.internal.spi.Operations;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ManifestFactory$;

public final class IndexQueryBuilder$ {
    public static final IndexQueryBuilder$ MODULE$;

    static {
        new IndexQueryBuilder$();
    }

    public Function2<ExecutionContext, QueryState, Iterator<Node>> getNodeGetter(StartItem startItem, GraphDatabaseService graph) {
        StartItem startItem2;
        block5: {
            Object object;
            block3: {
                NodeById x4;
                block4: {
                    NodeByIndexQuery x3;
                    block2: {
                        NodeByIndex x2;
                        startItem2 = startItem;
                        if (!(startItem2 instanceof NodeByIndex) || (x2 = (NodeByIndex)startItem2) == null) break block2;
                        String varName = x2.varName();
                        String idxName = x2.idxName();
                        Expression key = x2.key();
                        Expression value = x2.expression();
                        this.checkNodeIndex(idxName, graph);
                        object = new Serializable(idxName, key, value){
                            public static final long serialVersionUID = 0L;
                            private final String idxName$1;
                            private final Expression key$1;
                            private final Expression value$1;

                            public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                                String keyVal = this.key$1.apply(m, state).toString();
                                Object valueVal = this.value$1.apply(m, state);
                                return state.query().nodeOps().indexGet(this.idxName$1, keyVal, valueVal);
                            }
                            {
                                this.idxName$1 = idxName$1;
                                this.key$1 = key$1;
                                this.value$1 = value$1;
                            }
                        };
                        break block3;
                    }
                    if (!(startItem2 instanceof NodeByIndexQuery) || (x3 = (NodeByIndexQuery)startItem2) == null) break block4;
                    String varName = x3.varName();
                    String idxName = x3.idxName();
                    Expression query2 = x3.query();
                    this.checkNodeIndex(idxName, graph);
                    object = new Serializable(idxName, query2){
                        public static final long serialVersionUID = 0L;
                        private final String idxName$2;
                        private final Expression query$1;

                        public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                            Object queryText = this.query$1.apply(m, state);
                            return state.query().nodeOps().indexQuery(this.idxName$2, queryText);
                        }
                        {
                            this.idxName$2 = idxName$2;
                            this.query$1 = query$1;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof NodeById) || (x4 = (NodeById)startItem2) == null) break block5;
                String varName = x4.varName();
                Expression ids2 = x4.expression();
                object = new Serializable(varName, ids2){
                    public static final long serialVersionUID = 0L;
                    private final String varName$1;
                    private final Expression ids$1;

                    public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                        Operations<Node> operations = state.query().nodeOps();
                        return GetGraphElements$.MODULE$.getElements(this.ids$1.apply(m, state), this.varName$1, new Serializable(this, operations){
                            public static final long serialVersionUID = 0L;
                            private final Operations eta$0$1$1;

                            public final Node apply(long id2) {
                                return (Node)this.eta$0$1$1.getById(id2);
                            }
                            {
                                this.eta$0$1$1 = eta$0$1$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(Node.class));
                    }
                    {
                        this.varName$1 = varName$1;
                        this.ids$1 = ids$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    public Function2<ExecutionContext, QueryState, Iterator<Relationship>> getRelationshipGetter(StartItem startItem, GraphDatabaseService graph) {
        StartItem startItem2;
        block4: {
            Object object;
            block3: {
                RelationshipByIndexQuery x3;
                block2: {
                    RelationshipByIndex x2;
                    startItem2 = startItem;
                    if (!(startItem2 instanceof RelationshipByIndex) || (x2 = (RelationshipByIndex)startItem2) == null) break block2;
                    String varName = x2.varName();
                    String idxName = x2.idxName();
                    Expression key = x2.key();
                    Expression value = x2.expression();
                    this.checkRelIndex(idxName, graph);
                    object = new Serializable(idxName, key, value){
                        public static final long serialVersionUID = 0L;
                        private final String idxName$3;
                        private final Expression key$2;
                        private final Expression value$2;

                        public final Iterator<Relationship> apply(ExecutionContext m, QueryState state) {
                            String keyVal = this.key$2.apply(m, state).toString();
                            Object valueVal = this.value$2.apply(m, state);
                            return state.query().relationshipOps().indexGet(this.idxName$3, keyVal, valueVal);
                        }
                        {
                            this.idxName$3 = idxName$3;
                            this.key$2 = key$2;
                            this.value$2 = value$2;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof RelationshipByIndexQuery) || (x3 = (RelationshipByIndexQuery)startItem2) == null) break block4;
                String varName = x3.varName();
                String idxName = x3.idxName();
                Expression query2 = x3.query();
                this.checkRelIndex(idxName, graph);
                object = new Serializable(idxName, query2){
                    public static final long serialVersionUID = 0L;
                    private final String idxName$4;
                    private final Expression query$2;

                    public final Iterator<Relationship> apply(ExecutionContext m, QueryState state) {
                        Object queryText = this.query$2.apply(m, state);
                        return state.query().relationshipOps().indexQuery(this.idxName$4, queryText);
                    }
                    {
                        this.idxName$4 = idxName$4;
                        this.query$2 = query$2;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    private void checkNodeIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForNodes(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private void checkRelIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForRelationships(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private IndexQueryBuilder$() {
        MODULE$ = this;
    }
}

