/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.tooling.GlobalGraphOperations;

public class DatabaseSubGraph
implements SubGraph {
    private final GraphDatabaseService gdb;

    public DatabaseSubGraph(GraphDatabaseService gdb) {
        this.gdb = gdb;
    }

    public static SubGraph from(GraphDatabaseService gdb) {
        return new DatabaseSubGraph(gdb);
    }

    @Override
    public Iterable<Node> getNodes() {
        GlobalGraphOperations operations = GlobalGraphOperations.at((GraphDatabaseService)this.gdb);
        return operations.getAllNodes();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        GlobalGraphOperations operations = GlobalGraphOperations.at((GraphDatabaseService)this.gdb);
        return operations.getAllRelationships();
    }

    @Override
    public Node getReferenceNode() {
        return this.gdb.getReferenceNode();
    }

    @Override
    public boolean contains(Relationship relationship2) {
        return relationship2.getGraphDatabase().equals(this.gdb);
    }

    @Override
    public Iterable<IndexDefinition> indexes() {
        return this.gdb.schema().getIndexes();
    }
}

