/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.LongStream;
import org.neo4j.cypher.internal.codegen.PrimitiveEntityStream;
import org.neo4j.cypher.internal.codegen.RelationshipIdWrapper;
import org.neo4j.graphdb.Relationship;

public class PrimitiveRelationshipStream
extends PrimitiveEntityStream<RelationshipIdWrapper> {
    private static final PrimitiveRelationshipStream empty = new PrimitiveRelationshipStream(LongStream.empty());

    public PrimitiveRelationshipStream(LongStream inner) {
        super(inner);
    }

    public static PrimitiveRelationshipStream of(long[] array) {
        return new PrimitiveRelationshipStream(LongStream.of(array));
    }

    public static PrimitiveRelationshipStream of(Object list) {
        if (null == list) {
            return empty;
        }
        if (list instanceof List) {
            return new PrimitiveRelationshipStream(((List)list).stream().mapToLong(Relationship::getId));
        }
        if (list instanceof Relationship[]) {
            return new PrimitiveRelationshipStream(Arrays.stream((Relationship[])list).mapToLong(Relationship::getId));
        }
        throw new IllegalArgumentException(String.format("Can not convert to stream: %s", list.getClass().getName()));
    }

    @Override
    public Iterator<RelationshipIdWrapper> iterator() {
        return this.inner.mapToObj(RelationshipIdWrapper::new).iterator();
    }
}

