/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.cypher.internal.codegen.CompiledCursorUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.helpers.Nodes;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;

public abstract class CompiledExpandUtils {
    private static final int NOT_DENSE_DEGREE = -1;

    public static RelationshipSelectionCursor connectingRelationships(Read read, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode) {
        int fromDegree = CompiledExpandUtils.nodeGetDegreeIfDense(read, fromNode, nodeCursor, cursors, direction);
        if (fromDegree == 0) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean fromNodeIsDense = fromDegree != -1;
        read.singleNode(toNode, nodeCursor);
        if (!nodeCursor.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean toNodeIsDense = nodeCursor.isDense();
        if (fromNodeIsDense && toNodeIsDense) {
            Direction relDirection;
            long endNode;
            long startNode;
            int toDegree = CompiledExpandUtils.nodeGetDegree(nodeCursor, cursors, direction);
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, startNode, relDirection), endNode);
        }
        if (fromNodeIsDense) {
            return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, toNode, direction.reverse()), fromNode);
        }
        return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, fromNode, direction), toNode);
    }

    public static RelationshipSelectionCursor connectingRelationships(Read read, CursorFactory cursors, NodeCursor nodeCursor, long fromNode, Direction direction, long toNode, int[] relTypes) {
        int fromDegree = CompiledExpandUtils.calculateTotalDegreeIfDense(read, fromNode, nodeCursor, direction, relTypes, cursors);
        if (fromDegree == 0) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean fromNodeIsDense = fromDegree != -1;
        read.singleNode(toNode, nodeCursor);
        if (!nodeCursor.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        boolean toNodeIsDense = nodeCursor.isDense();
        if (fromNodeIsDense && toNodeIsDense) {
            Direction relDirection;
            long endNode;
            long startNode;
            int toDegree = CompiledExpandUtils.calculateTotalDegree(nodeCursor, direction, relTypes, cursors);
            if (fromDegree < toDegree) {
                startNode = fromNode;
                endNode = toNode;
                relDirection = direction;
            } else {
                startNode = toNode;
                endNode = fromNode;
                relDirection = direction.reverse();
            }
            return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, startNode, relDirection), endNode);
        }
        if (fromNodeIsDense) {
            return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, toNode, direction.reverse()), fromNode);
        }
        return CompiledExpandUtils.connectingRelationshipsIterator(CompiledCursorUtils.nodeGetRelationships(read, cursors, nodeCursor, fromNode, direction), toNode);
    }

    static int nodeGetDegreeIfDense(Read read, long node, NodeCursor nodeCursor, CursorFactory cursors, Direction direction) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.nodeGetDegree(nodeCursor, cursors, direction);
    }

    private static int nodeGetDegree(NodeCursor nodeCursor, CursorFactory cursors, Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    static int nodeGetDegreeIfDense(Read read, long node, NodeCursor nodeCursor, CursorFactory cursors, Direction direction, int type) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.nodeGetDegree(nodeCursor, cursors, direction, type);
    }

    private static int nodeGetDegree(NodeCursor nodeCursor, CursorFactory cursors, Direction direction, int type) {
        switch (direction) {
            case OUTGOING: {
                return Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type);
            }
            case INCOMING: {
                return Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type);
            }
            case BOTH: {
                return Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)cursors, (int)type);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    private static int calculateTotalDegreeIfDense(Read read, long node, NodeCursor nodeCursor, Direction direction, int[] relTypes, CursorFactory cursors) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return 0;
        }
        if (!nodeCursor.isDense()) {
            return -1;
        }
        return CompiledExpandUtils.calculateTotalDegree(nodeCursor, direction, relTypes, cursors);
    }

    private static int calculateTotalDegree(NodeCursor nodeCursor, Direction direction, int[] relTypes, CursorFactory cursors) {
        int degree = 0;
        for (int relType2 : relTypes) {
            degree += CompiledExpandUtils.nodeGetDegree(nodeCursor, cursors, direction, relType2);
        }
        return degree;
    }

    private static RelationshipSelectionCursor connectingRelationshipsIterator(final RelationshipSelectionCursor allRelationships, final long toNode) {
        return new RelationshipSelectionCursor(){

            public void close() {
                allRelationships.close();
            }

            public long relationshipReference() {
                return allRelationships.relationshipReference();
            }

            public int type() {
                return allRelationships.type();
            }

            public long otherNodeReference() {
                return allRelationships.otherNodeReference();
            }

            public long sourceNodeReference() {
                return allRelationships.sourceNodeReference();
            }

            public long targetNodeReference() {
                return allRelationships.targetNodeReference();
            }

            public boolean next() {
                while (allRelationships.next()) {
                    if (allRelationships.otherNodeReference() != toNode) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

