/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CachedExecutableQuery;
import org.neo4j.cypher.internal.CompatibilityFactory;
import org.neo4j.cypher.internal.CompilerEngineDelegator;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ParsedQuery;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.compatibility.LFUCache;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.runtime.interpreted.ValueConversion$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.ResultBuffer;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import org.opencypher.v9_0.frontend.phases.CompilationPhaseTracer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMa\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB\u00111H\u0010\b\u0003\u001bqJ!!\u0010\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{9A\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAN\u0001\rG\u0006\u001c\u0007.\u001a+sC\u000e,'\u000f\t\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\u000611m\u001c8gS\u001e,\u0012A\u0012\t\u0003o\u001dK!\u0001\u0013\u0002\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011)\u0003!\u0011!Q\u0001\n\u0019\u000bqaY8oM&<\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003Q\u0019w.\u001c9bi&\u0014\u0017\u000e\\5us\u001a\u000b7\r^8ssV\ta\n\u0005\u00028\u001f&\u0011\u0001K\u0001\u0002\u0015\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=GC\u000e$xN]=\t\u0011I\u0003!\u0011!Q\u0001\n9\u000bQcY8na\u0006$\u0018NY5mSRLh)Y2u_JL\b\u0005\u0003\u0005U\u0001\t\u0015\r\u0011\"\u0001V\u0003-awn\u001a)s_ZLG-\u001a:\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0004\u0002\u000f1|wmZ5oO&\u00111\f\u0017\u0002\f\u0019><\u0007K]8wS\u0012,'\u000f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003W\u00031awn\u001a)s_ZLG-\u001a:!\u0011!y\u0006A!b\u0001\n\u0003\u0001\u0017!B2m_\u000e\\W#A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017\u0001\u0002;j[\u0016T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n)1\t\\8dW\"A!\u000e\u0001B\u0001B\u0003%\u0011-\u0001\u0004dY>\u001c7\u000e\t\u0005\u0006Y\u0002!\t!\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00139|\u0007/\u001d:tiV4\bCA\u001c\u0001\u0011\u0015\u00192\u000e1\u0001\u0016\u0011\u0015q2\u000e1\u0001!\u0011\u0015I3\u000e1\u0001,\u0011\u0015!4\u000e1\u00017\u0011\u0015!5\u000e1\u0001G\u0011\u0015a5\u000e1\u0001O\u0011\u0015!6\u000e1\u0001W\u0011\u001dy6\u000e%AA\u0002\u0005Dq\u0001\u001f\u0001C\u0002\u0013%\u00110A\u0005qe\u0016\u0004\u0016M]:feV\t!\u0010\u0005\u00028w&\u0011AP\u0001\u0002\n!J,\u0007+\u0019:tKJDaA \u0001!\u0002\u0013Q\u0018A\u00039sKB\u000b'o]3sA!I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111A\u0001\u001aY\u0006\u001cHoQ8n[&$H/\u001a3Uq&#\u0007K]8wS\u0012,'/\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011aC5oi\u0016\u0014\bO]3uK\u0012T1!a\u0004\u0003\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u0005\u0002\n\tIB*Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u0015\u0011A\u00077bgR\u001cu.\\7jiR,G\r\u0016=JIB\u0013xN^5eKJ\u0004\u0003bBA\u000e\u0001\u0011%\u0011QD\u0001\u0011a2\fgNU3vg\u0006\u0014\u0017\u000e\\5uSf$b!a\b\u0002&\u0005=\u0002cA\u001c\u0002\"%\u0019\u00111\u0005\u0002\u0003!I+Wo]1cS2LG/_*uCR,\u0007\u0002CA\u0014\u00033\u0001\r!!\u000b\u0002+\r\f7\r[3e\u000bb,7-\u001e;bE2,\u0017+^3ssB\u0019q'a\u000b\n\u0007\u00055\"AA\u000bDC\u000eDW\rZ#yK\u000e,H/\u00192mKF+XM]=\t\u0011\u0005E\u0012\u0011\u0004a\u0001\u0003g\tA\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\b\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0006cV,'/\u001f\u0006\u0004\u0003{9\u0012\u0001B5na2LA!!\u0011\u00028\t!BK]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqRD\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\u0002\u00071|w-\u0006\u0002\u0002JA\u0019q+a\u0013\n\u0007\u00055\u0003LA\u0002M_\u001eD\u0001\"!\u0015\u0001A\u0003%\u0011\u0011J\u0001\u0005Y><\u0007\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X\u0005\u0019\u0002\u000f\\1o'R\fG.\u001a8fgN\u001c\u0015\r\u001c7feV\u0011\u0011\u0011\f\t\u0006o\u0005m\u0013\u0011F\u0005\u0004\u0003;\u0012!a\u0005)mC:\u001cF/\u00197f]\u0016\u001c8oQ1mY\u0016\u0014\b\u0002CA1\u0001\u0001\u0006I!!\u0017\u0002)Ad\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:!\u0011%\t)\u0007\u0001b\u0001\n\u0013\t9'\u0001\u0006rk\u0016\u0014\u0018pQ1dQ\u0016,\"!!\u001b\u0011\r]\nYGOA\u0015\u0013\r\tiG\u0001\u0002\u000b#V,'/_\"bG\",\u0007\u0002CA9\u0001\u0001\u0006I!!\u001b\u0002\u0017E,XM]=DC\u000eDW\r\t\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003o\nqcY8na&dWM]#oO&tW\rR3mK\u001e\fGo\u001c:\u0016\u0005\u0005e\u0004cA\u001c\u0002|%\u0019\u0011Q\u0010\u0002\u0003/\r{W\u000e]5mKJ,enZ5oK\u0012+G.Z4bi>\u0014\b\u0002CAA\u0001\u0001\u0006I!!\u001f\u00021\r|W\u000e]5mKJ,enZ5oK\u0012+G.Z4bi>\u0014\b\u0005C\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002\b\u0006i\u0001/\u0019:tK\u0012\fV/\u001a:jKN,\"!!#\u0011\u000f\u0005-\u0015\u0011\u0013\u001e\u0002\u00166\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f\u0013\u0011!D2p[B\fG/\u001b2jY&$\u00180\u0003\u0003\u0002\u0014\u00065%\u0001\u0003'G+\u000e\u000b7\r[3\u0011\u0007]\n9*C\u0002\u0002\u001a\n\u00111\u0002U1sg\u0016$\u0017+^3ss\"A\u0011Q\u0014\u0001!\u0002\u0013\tI)\u0001\bqCJ\u001cX\rZ)vKJLWm\u001d\u0011\t\u0013\u0005\u0005\u0006A1A\u0005\n\u0005\r\u0016\u0001D:dQ\u0016l\u0017\rS3ma\u0016\u0014XCAAS!\r9\u0014qU\u0005\u0004\u0003S\u0013!\u0001D*dQ\u0016l\u0017\rS3ma\u0016\u0014\b\u0002CAW\u0001\u0001\u0006I!!*\u0002\u001bM\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:!\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000bq\u0001\u001d:pM&dW\r\u0006\u0005\u00026\u0006\u0005\u00171YAl!\u0011\t9,!0\u000e\u0005\u0005e&bAA^\r\u00059qM]1qQ\u0012\u0014\u0017\u0002BA`\u0003s\u0013aAU3tk2$\bbBA\u001d\u0003_\u0003\rA\u000f\u0005\t\u0003\u000b\fy\u000b1\u0001\u0002H\u00061\u0001/\u0019:b[N\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-A\u0004wSJ$X/\u00197\u000b\u0007\u0005Eg!\u0001\u0004wC2,Xm]\u0005\u0005\u0003+\fYM\u0001\u0005NCB4\u0016\r\\;f\u0011!\tI.a,A\u0002\u0005M\u0012aB2p]R,\u0007\u0010\u001e\u0005\b\u0003;\u0004A\u0011AAp\u0003\u001d)\u00070Z2vi\u0016$\"\"!.\u0002b\u0006\r\u0018Q]At\u0011\u001d\tI$a7A\u0002iB\u0001\"!2\u0002\\\u0002\u0007\u0011q\u0019\u0005\t\u00033\fY\u000e1\u0001\u00024!Q\u0011\u0011WAn!\u0003\u0005\r!!;\u0011\u00075\tY/C\u0002\u0002n:\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002^\u0002!\t!!=\u0015\u0015\u0005M\u0018\u0011`A~\u0003\u007f\u0014\t\u0001\u0005\u0003\u00026\u0005U\u0018\u0002BA|\u0003o\u0011a\"U;fef,\u00050Z2vi&|g\u000eC\u0004\u0002:\u0005=\b\u0019\u0001\u001e\t\u0011\u0005u\u0018q\u001ea\u0001\u0003\u000f\f\u0011\"\\1q!\u0006\u0014\u0018-\\:\t\u0011\u0005e\u0017q\u001ea\u0001\u0003gA\u0001Ba\u0001\u0002p\u0002\u0007!QA\u0001\re\u0016\u001cX\u000f\u001c;Ck\u001a4WM\u001d\t\u0005\u0003k\u00119!\u0003\u0003\u0003\n\u0005]\"\u0001\u0004*fgVdGOQ;gM\u0016\u0014\bb\u0002B\u0007\u0001\u0011%!qB\u0001\rO\u0016$xJ]\"p[BLG.\u001a\u000b\t\u0003S\u0011\tBa\u0005\u0003\u001e!A\u0011\u0011\u001cB\u0006\u0001\u0004\t\u0019\u0004\u0003\u0005\u0003\u0016\t-\u0001\u0019\u0001B\f\u00039\u0001(/\u001a)beN,G-U;fef\u00042a\u000eB\r\u0013\r\u0011YB\u0001\u0002\u000f!J,\u0007+\u0019:tK\u0012\fV/\u001a:z\u0011\u001dI#1\u0002a\u0001\u0005?\u0001BA!\t\u0003B9!!1\u0005B\u001f\u001d\u0011\u0011)Ca\u000f\u000f\t\t\u001d\"\u0011\b\b\u0005\u0005S\u00119D\u0004\u0003\u0003,\tUb\u0002\u0002B\u0017\u0005gi!Aa\f\u000b\u0007\tE\"\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u00059\u0012\u0011b\u0001B [\u0005\t2i\\7qS2\fG/[8o)J\f7-\u001a:\n\t\t\r#Q\t\u0002\u0016#V,'/_\"p[BLG.\u0019;j_:,e/\u001a8u\u0015\r\u0011y$\f\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u00031\u0019w.\u001c9jY\u0016\fV/\u001a:z)!\tIC!\u0014\u0003P\t%\u0004\u0002\u0003B\u000b\u0005\u000f\u0002\rAa\u0006\t\u000f%\u00129\u00051\u0001\u0003RA!!1\u000bB3\u001b\t\u0011)F\u0003\u0003\u0003X\te\u0013A\u00029iCN,7O\u0003\u0003\u0003\\\tu\u0013\u0001\u00034s_:$XM\u001c3\u000b\t\t}#\u0011M\u0001\u0005mfz\u0006GC\u0002\u0003d!\t!b\u001c9f]\u000eL\b\u000f[3s\u0013\u0011\u00119G!\u0016\u0003-\r{W\u000e]5mCRLwN\u001c)iCN,GK]1dKJD\u0001Ba\u001b\u0003H\u0001\u0007\u00111G\u0001\u0003i\u000eDqAa\u001c\u0001\t\u0013\u0011\t(A\nqCJ\u001cX\r\u0015:f!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002\u0016\nM$Q\u000f\u0005\t\u0005+\u0011i\u00071\u0001\u0003\u0018!9\u0011F!\u001cA\u0002\tE\u0003F\u0002B7\u0005s\u00129\tE\u0003\u000e\u0005w\u0012y(C\u0002\u0003~9\u0011a\u0001\u001e5s_^\u001c\b\u0003\u0002BA\u0005\u0007k\u0011\u0001B\u0005\u0004\u0005\u000b#!aD*z]R\f\u00070\u0012=dKB$\u0018n\u001c8$\u0005\t}\u0004b\u0002BF\u0001\u0011\u0005!QR\u0001\u0011G2,\u0017M])vKJL8)Y2iKN$\"Aa$\u0011\u00075\u0011\t*C\u0002\u0003\u0014:\u0011A\u0001T8oO\"9!q\u0013\u0001\u0005\u0002\te\u0015\u0001E5t!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u)\u0011\tIOa'\t\u000f\u0005e\"Q\u0013a\u0001u!9!q\u0014\u0001\u0005\n\t\u0005\u0016aD2iK\u000e\\\u0007+\u0019:b[\u0016$XM]:\u0015\u0011\t\r&\u0011\u0016B`\u0005\u0007\u00042!\u0004BS\u0013\r\u00119K\u0004\u0002\u0005+:LG\u000f\u0003\u0005\u0003,\nu\u0005\u0019\u0001BW\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\u0011\u000b\t=&\u0011\u0018\u001e\u000f\t\tE&Q\u0017\b\u0005\u0005[\u0011\u0019,C\u0001\u0010\u0013\r\u00119LD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YL!0\u0003\u0007M+\u0017OC\u0002\u00038:A\u0001B!1\u0003\u001e\u0002\u0007\u0011qY\u0001\fO&4XM\u001c)be\u0006l7\u000f\u0003\u0005\u0003F\nu\u0005\u0019AAd\u0003=)\u0007\u0010\u001e:bGR,G\rU1sC6\u001c\bF\u0002BO\u0005\u0013\u0014\t\u000eE\u0003\u000e\u0005w\u0012Y\r\u0005\u0003\u0003\u0002\n5\u0017b\u0001Bh\t\tQ\u0002+\u0019:b[\u0016$XM\u001d(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!1\u001a\u0005\n\u0005+\u0004\u0011\u0013!C\u0001\u0005/\f\u0011#\u001a=fGV$X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011IN\u000b\u0003\u0002j\nm7F\u0001Bo!\u0011\u0011yN!;\u000e\u0005\t\u0005(\u0002\u0002Br\u0005K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dh\"\u0001\u0006b]:|G/\u0019;j_:LAAa;\u0003b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000f\t=(\u0001#\u0001\u0003r\u0006yQ\t_3dkRLwN\\#oO&tW\rE\u00028\u0005g4a!\u0001\u0002\t\u0002\tU8c\u0001Bz\u0019!9ANa=\u0005\u0002\teHC\u0001By\u0011)\u0011iPa=C\u0002\u0013\u0005!q`\u0001\u0014!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUiU\u000b\u0003\u0007\u0003\u00012!DB\u0002\u0013\r\u0019)A\u0004\u0002\u0004\u0013:$\b\"CB\u0005\u0005g\u0004\u000b\u0011BB\u0001\u0003Q\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#TA!Q1Q\u0002Bz#\u0003%\taa\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019\tBK\u0002b\u00057\u0004")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<String> cacheTracer;
    private final CypherConfiguration config;
    private final CompatibilityFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<CachedExecutableQuery> planStalenessCaller;
    private final QueryCache<String, CachedExecutableQuery> queryCache;
    private final CompilerEngineDelegator org$neo4j$cypher$internal$ExecutionEngine$$compilerEngineDelegator;
    private final LFUCache<String, ParsedQuery> org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<String> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompatibilityFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(CachedExecutableQuery cachedExecutableQuery, TransactionalContext transactionalContext) {
        return cachedExecutableQuery.plan().reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<CachedExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, CachedExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public CompilerEngineDelegator org$neo4j$cypher$internal$ExecutionEngine$$compilerEngineDelegator() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$compilerEngineDelegator;
    }

    public LFUCache<String, ParsedQuery> org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile) {
        Result result;
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile);
            CachedExecutableQuery cachedExecutableQuery = this.getOrCompile(context, preParsedQuery, queryTracer);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(cachedExecutableQuery.paramNames(), params, cachedExecutableQuery.extractedParams());
            }
            MapValue combinedParams = VirtualValues.combine((MapValue)params, (MapValue)cachedExecutableQuery.extractedParams());
            context.executingQuery().planningCompleted(cachedExecutableQuery.plan().plannerInfo());
            result = cachedExecutableQuery.plan().run(context, preParsedQuery.executionMode(), combinedParams);
            queryTracer.close();
        }
        catch (Throwable throwable) {
            try {
                context.close(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        return result;
    }

    public QueryExecution execute(String query, MapValue mapParams, TransactionalContext context, ResultBuffer resultBuffer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean execute$default$4() {
        return false;
    }

    private CachedExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer) {
        String cacheKey = preParsedQuery.statementWithVersionAndPlanner();
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                BoxedUnit boxedUnit;
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                CacheLookup<CachedExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<CachedExecutableQuery>)new Serializable(this, preParsedQuery, tracer, tc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final TransactionalContext tc$1;

                    public final CachedExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$compileQuery(this.preParsedQuery$1, this.tracer$1, this.tc$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.tc$1 = tc$1;
                    }
                }, preParsedQuery.rawStatement());
                CacheLookup<CachedExecutableQuery> cacheLookup2 = cacheLookup;
                boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                if (bl) {
                    CachedExecutableQuery executableQuery = cacheLookup.executableQuery();
                    if (this.schemaHelper().lockLabels(schemaToken, executableQuery.plan(), preParsedQuery.version(), tc)) {
                        tc.cleanForReuse();
                        return executableQuery;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (cacheLookup2 instanceof CacheMiss) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(cacheLookup2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public CachedExecutableQuery org$neo4j$cypher$internal$ExecutionEngine$$compileQuery(PreParsedQuery preParsedQuery, CompilationPhaseTracer tracer, TransactionalContext tc) {
        ParsedQuery parsedQuery = this.parsePreParsedQuery(preParsedQuery, tracer);
        Tuple3<ExecutionPlan, Map<String, Object>, Seq<String>> tuple3 = parsedQuery.plan(tc, tracer);
        if (tuple3 != null) {
            Tuple3 tuple32;
            ExecutionPlan executionPlan = (ExecutionPlan)tuple3._1();
            Map extractedParams = (Map)tuple3._2();
            Seq paramNames = (Seq)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)executionPlan, (Object)extractedParams, (Object)paramNames);
            ExecutionPlan executionPlan2 = (ExecutionPlan)tuple33._1();
            Map extractedParams2 = (Map)tuple33._2();
            Seq paramNames2 = (Seq)tuple33._3();
            return new CachedExecutableQuery(executionPlan2, (Seq<String>)paramNames2, ValueConversion$.MODULE$.asValues(extractedParams2));
        }
        throw new MatchError(tuple3);
    }

    private ParsedQuery parsePreParsedQuery(PreParsedQuery preParsedQuery, CompilationPhaseTracer tracer) throws SyntaxException {
        return (ParsedQuery)this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries().get(preParsedQuery.statementWithVersionAndPlanner()).getOrElse((Function0)new Serializable(this, preParsedQuery, tracer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;
            private final PreParsedQuery preParsedQuery$2;
            private final CompilationPhaseTracer tracer$2;

            /*
             * WARNING - void declaration
             */
            public final ParsedQuery apply() {
                void var1_1;
                ParsedQuery parsedQuery = this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$compilerEngineDelegator().parseQuery(this.preParsedQuery$2, this.tracer$2);
                if (!parsedQuery.hasErrors()) {
                    this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries().put(this.preParsedQuery$2.statementWithVersionAndPlanner(), parsedQuery);
                }
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.preParsedQuery$2 = preParsedQuery$2;
                this.tracer$2 = tracer$2;
            }
        });
    }

    public long clearQueryCaches() {
        return Math.max(this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries().clear(), this.queryCache().clear());
    }

    public boolean isPeriodicCommit(String query) {
        return this.preParser().preParseQuery(query, false).isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$2 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$3 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$2);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$2, x$3);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<String> cacheTracer, CypherConfiguration config, CompatibilityFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheDiscard(String ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(CachedExecutableQuery cachedExecutableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(cachedExecutableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache<String, CachedExecutableQuery>(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$compilerEngineDelegator = new CompilerEngineDelegator(queryService, kernelMonitors, config, logProvider, compatibilityFactory);
        this.org$neo4j$cypher$internal$ExecutionEngine$$parsedQueries = new LFUCache(config.queryCacheSize());
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

