/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_5.runtime;

import org.neo4j.cypher.internal.PlanFingerprint;
import org.neo4j.cypher.internal.PlanFingerprint$;
import org.neo4j.cypher.internal.PlanFingerprintReference;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.BuildInterpretedExecutionPlan;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.CommunityRuntimeContext;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.InterpretedPipeBuilderFactory$;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.InterpretedRuntimeName$;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.PipeExecutionPlanBuilder;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.RuntimeName;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.executionplan.ExecutionPlan;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.executionplan.ExecutionResultBuilder;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.executionplan.ExecutionResultBuilderFactory;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.executionplan.InterpretedExecutionResultBuilderFactory;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.executionplan.PeriodicCommitInfo;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.phases.CompilationState;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.profiler.Profiler;
import org.neo4j.cypher.internal.compiler.v3_5.phases.CompilationContains;
import org.neo4j.cypher.internal.compiler.v3_5.phases.LogicalPlanState;
import org.neo4j.cypher.internal.ir.v3_5.PeriodicCommit;
import org.neo4j.cypher.internal.ir.v3_5.PlannerQuery;
import org.neo4j.cypher.internal.planner.v3_5.spi.PlanningAttributes;
import org.neo4j.cypher.internal.planner.v3_5.spi.TokenContext;
import org.neo4j.cypher.internal.runtime.ExecutionMode;
import org.neo4j.cypher.internal.runtime.InternalExecutionResult;
import org.neo4j.cypher.internal.runtime.ProfileMode$;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.UpdateCountingQueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.CommunityExpressionConverter$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.ExpressionConverter;
import org.neo4j.cypher.internal.runtime.interpreted.commands.convert.ExpressionConverters;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeExecutionBuilderContext;
import org.neo4j.cypher.internal.v3_5.logical.plans.LogicalPlan;
import org.neo4j.values.virtual.MapValue;
import org.opencypher.v9_0.frontend.PlannerName;
import org.opencypher.v9_0.frontend.phases.BaseContext;
import org.opencypher.v9_0.frontend.phases.CompilationPhaseTracer;
import org.opencypher.v9_0.frontend.phases.Condition;
import org.opencypher.v9_0.frontend.phases.InternalNotificationLogger;
import org.opencypher.v9_0.frontend.phases.Phase;
import org.opencypher.v9_0.frontend.phases.Transformer;
import org.opencypher.v9_0.util.PeriodicCommitInOpenTransactionException;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.util.Success;
import scala.util.Try;

public final class BuildInterpretedExecutionPlan$
implements Phase<CommunityRuntimeContext, LogicalPlanState, CompilationState> {
    public static final BuildInterpretedExecutionPlan$ MODULE$;

    static {
        new BuildInterpretedExecutionPlan$();
    }

    public Object transform(Object from, BaseContext context) {
        return Phase.class.transform((Phase)this, (Object)from, (BaseContext)context);
    }

    public String name() {
        return Phase.class.name((Phase)this);
    }

    public <D extends CommunityRuntimeContext, TO2> Transformer<D, LogicalPlanState, TO2> andThen(Transformer<D, CompilationState, TO2> other) {
        return Transformer.class.andThen((Transformer)this, other);
    }

    public Transformer<CommunityRuntimeContext, LogicalPlanState, CompilationState> adds(Condition condition) {
        return Transformer.class.adds((Transformer)this, (Condition)condition);
    }

    public CompilationPhaseTracer.CompilationPhase phase() {
        return CompilationPhaseTracer.CompilationPhase.PIPE_BUILDING;
    }

    public String description() {
        return "create interpreted execution plan";
    }

    public Set<Condition> postConditions() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Condition[]{new CompilationContains(ClassTag$.MODULE$.apply(ExecutionPlan.class), ManifestFactory$.MODULE$.classType(ExecutionPlan.class))}));
    }

    public CompilationState process(LogicalPlanState from, CommunityRuntimeContext context) {
        ExpressionConverters converters;
        boolean readOnly = ((PlannerQuery)from.solveds().apply(from.logicalPlan().id())).readOnly();
        PlanningAttributes.Cardinalities cardinalities = from.cardinalities();
        LogicalPlan logicalPlan = from.logicalPlan();
        ExpressionConverters x$1 = converters = new ExpressionConverters((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExpressionConverter[]{CommunityExpressionConverter$.MODULE$}));
        InterpretedPipeBuilderFactory$ x$2 = InterpretedPipeBuilderFactory$.MODULE$;
        PipeExecutionPlanBuilder executionPlanBuilder = new PipeExecutionPlanBuilder(x$2, x$1);
        PipeExecutionBuilderContext pipeBuildContext = new PipeExecutionBuilderContext(from.semanticTable(), readOnly, cardinalities);
        Pipe pipe = executionPlanBuilder.build(logicalPlan, pipeBuildContext, (TokenContext)context.planContext());
        Option periodicCommitInfo = from.periodicCommit().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PeriodicCommitInfo apply(PeriodicCommit x) {
                return new PeriodicCommitInfo((Option<Object>)x.batchSize());
            }
        });
        List columns = from.statement().returnColumns();
        InterpretedExecutionResultBuilderFactory resultBuilderFactory = new InterpretedExecutionResultBuilderFactory(pipe, readOnly, (List<String>)columns, logicalPlan);
        Function3<QueryContext, ExecutionMode, MapValue, InternalExecutionResult> func = this.getExecutionPlanFunction((Option<PeriodicCommitInfo>)periodicCommitInfo, resultBuilderFactory, context.notificationLogger(), from.plannerName(), InterpretedRuntimeName$.MODULE$, readOnly, cardinalities);
        Option<PlanFingerprint> fingerprint = PlanFingerprint$.MODULE$.take(context.clock(), (Function0<Object>)context.planContext().txIdProvider(), context.planContext().statistics());
        BuildInterpretedExecutionPlan.InterpretedExecutionPlan execPlan = new BuildInterpretedExecutionPlan.InterpretedExecutionPlan(func, logicalPlan, periodicCommitInfo.isDefined(), from.plannerName(), new PlanFingerprintReference(fingerprint));
        return new CompilationState(from, (Try<ExecutionPlan>)new Success((Object)execPlan));
    }

    public Function3<QueryContext, ExecutionMode, MapValue, InternalExecutionResult> getExecutionPlanFunction(Option<PeriodicCommitInfo> periodicCommit, ExecutionResultBuilderFactory resultBuilderFactory, InternalNotificationLogger notificationLogger2, PlannerName plannerName, RuntimeName runtimeName, boolean readOnly, PlanningAttributes.Cardinalities cardinalities) {
        return new Serializable(periodicCommit, resultBuilderFactory, notificationLogger2, plannerName, runtimeName, readOnly, cardinalities){
            public static final long serialVersionUID = 0L;
            private final Option periodicCommit$1;
            private final ExecutionResultBuilderFactory resultBuilderFactory$1;
            private final InternalNotificationLogger notificationLogger$1;
            private final PlannerName plannerName$1;
            private final RuntimeName runtimeName$1;
            private final boolean readOnly$1;
            private final PlanningAttributes.Cardinalities cardinalities$1;

            public final InternalExecutionResult apply(QueryContext queryContext, ExecutionMode planType, MapValue params) {
                ExecutionResultBuilder builder = this.resultBuilderFactory$1.create();
                ExecutionMode executionMode2 = planType;
                ProfileMode$ profileMode$ = ProfileMode$.MODULE$;
                boolean profiling = !(executionMode2 != null ? !executionMode2.equals(profileMode$) : profileMode$ != null);
                UpdateCountingQueryContext builderContext = this.readOnly$1 && !profiling ? queryContext : new UpdateCountingQueryContext(queryContext);
                builder.setQueryContext((QueryContext)builderContext);
                if (this.periodicCommit$1.isDefined()) {
                    if (builderContext.transactionalContext().isTopLevelTx()) {
                        builder.setLoadCsvPeriodicCommitObserver(((PeriodicCommitInfo)this.periodicCommit$1.get()).batchRowCount());
                    } else {
                        throw new PeriodicCommitInOpenTransactionException();
                    }
                }
                if (profiling) {
                    builder.setPipeDecorator(new Profiler(queryContext.transactionalContext().databaseInfo()));
                }
                return builder.build(planType, params, this.notificationLogger$1, this.plannerName$1, this.runtimeName$1, this.readOnly$1, this.cardinalities$1);
            }
            {
                this.periodicCommit$1 = periodicCommit$1;
                this.resultBuilderFactory$1 = resultBuilderFactory$1;
                this.notificationLogger$1 = notificationLogger$1;
                this.plannerName$1 = plannerName$1;
                this.runtimeName$1 = runtimeName$1;
                this.readOnly$1 = readOnly$1;
                this.cardinalities$1 = cardinalities$1;
            }
        };
    }

    private BuildInterpretedExecutionPlan$() {
        MODULE$ = this;
        Transformer.class.$init$((Transformer)this);
        Phase.class.$init$((Phase)this);
    }
}

