/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.cypher.internal.codegen.CompiledConversionUtils;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.values.storable.Values;

public final class CompiledIndexUtils {
    private CompiledIndexUtils() {
        throw new UnsupportedOperationException();
    }

    public static NodeValueIndexCursor indexSeek(Read read, CursorFactory cursors, IndexReference index, Object value) throws KernelException {
        assert (index.properties().length == 1);
        if (value == Values.NO_VALUE || value == null) {
            return NodeValueIndexCursor.EMPTY;
        }
        NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor();
        IndexQuery.ExactPredicate query = IndexQuery.exact((int)index.properties()[0], (Object)CompiledConversionUtils.makeValueNeoSafe(value));
        read.nodeIndexSeek(index, cursor, IndexOrder.NONE, new IndexQuery[]{query});
        return cursor;
    }
}

