/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.time.Clock;
import org.neo4j.cypher.ParameterNotFoundException;
import org.neo4j.cypher.exceptionHandler;
import org.neo4j.cypher.internal.CacheDisabled;
import org.neo4j.cypher.internal.CacheHit;
import org.neo4j.cypher.internal.CacheLookup;
import org.neo4j.cypher.internal.CacheMiss;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CypherConfiguration;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.StringCacheMonitor;
import org.neo4j.cypher.internal.compatibility.CypherCacheFlushingMonitor$class;
import org.neo4j.cypher.internal.compatibility.CypherCacheHitMonitor$class;
import org.neo4j.cypher.internal.runtime.interpreted.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.ResultBuffer;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0001\u0003\u0001-\u0011q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#\u0001\u0007rk\u0016\u0014\u0018pU3sm&\u001cW-F\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\tAb!\u0001\u0004lKJtW\r\\\u0005\u00035]\u0011\u0011d\u0012:ba\"$\u0015\r^1cCN,\u0017+^3ssN+'O^5dK\"AA\u0004\u0001B\u0001B\u0003%Q#A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u0005q1.\u001a:oK2luN\\5u_J\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r:\u0012AC7p]&$xN]5oO&\u0011QE\t\u0002\t\u001b>t\u0017\u000e^8sg\"Aq\u0005\u0001B\u0001B\u0003%\u0001%A\blKJtW\r\\'p]&$xN]:!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013A\u0002;sC\u000e,'/F\u0001,!\tas&D\u0001.\u0015\tq#!A\u0004ue\u0006\u001c\u0017N\\4\n\u0005Aj#!E\"p[BLG.\u0019;j_:$&/Y2fe\"A!\u0007\u0001B\u0001B\u0003%1&A\u0004ue\u0006\u001cWM\u001d\u0011\t\u0011Q\u0002!Q1A\u0005\u0002U\n1bY1dQ\u0016$&/Y2feV\ta\u0007E\u00028qij\u0011AA\u0005\u0003s\t\u00111bQ1dQ\u0016$&/Y2feB!1\b\u0011\"J\u001b\u0005a$BA\u001f?\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0003\u007f\u0019\tq\u0001[3ma\u0016\u00148/\u0003\u0002By\t!\u0001+Y5s!\t\u0019eI\u0004\u0002\u000e\t&\u0011QID\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F\u001dA\u0011!\n\u0017\b\u0003\u0017Zs!\u0001T+\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\t&\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005]\u0013\u0011AC)vKJL8)Y2iK&\u0011\u0011L\u0017\u0002\u0011!\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCBT!a\u0016\u0002\t\u0011q\u0003!\u0011!Q\u0001\nY\nAbY1dQ\u0016$&/Y2fe\u0002B\u0001B\u0018\u0001\u0003\u0006\u0004%\taX\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0004\"aN1\n\u0005\t\u0014!aE\"za\",'oQ8oM&<WO]1uS>t\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00021\u0002\u000f\r|gNZ5hA!Aa\r\u0001BC\u0002\u0013\u0005q-\u0001\u000bd_6\u0004\u0018\r^5cS2LG/\u001f$bGR|'/_\u000b\u0002QB\u0011q'[\u0005\u0003U\n\u0011qbQ8na&dWM\u001d$bGR|'/\u001f\u0005\tY\u0002\u0011\t\u0011)A\u0005Q\u0006)2m\\7qCRL'-\u001b7jif4\u0015m\u0019;pef\u0004\u0003\u0002\u00038\u0001\u0005\u000b\u0007I\u0011A8\u0002\u00171|w\r\u0015:pm&$WM]\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\bY><w-\u001b8h\u0013\t)(OA\u0006M_\u001e\u0004&o\u001c<jI\u0016\u0014\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u00029\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\t\u0011e\u0004!Q1A\u0005\u0002i\fQa\u00197pG.,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018\u0001\u0002;j[\u0016T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bi(!B\"m_\u000e\\\u0007\"CA\u0005\u0001\t\u0005\t\u0015!\u0003|\u0003\u0019\u0019Gn\\2lA!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011A\u0002\u001fj]&$h\b\u0006\n\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u0002CA\u001c\u0001\u0011\u0019\u0019\u00121\u0002a\u0001+!1a$a\u0003A\u0002\u0001Ba!KA\u0006\u0001\u0004Y\u0003B\u0002\u001b\u0002\f\u0001\u0007a\u0007\u0003\u0004_\u0003\u0017\u0001\r\u0001\u0019\u0005\u0007M\u0006-\u0001\u0019\u00015\t\r9\fY\u00011\u0001q\u0011!I\u00181\u0002I\u0001\u0002\u0004Y\b\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002*A\u0019q'a\u000b\n\u0007\u00055\"AA\u0005Qe\u0016\u0004\u0016M]:fe\"A\u0011\u0011\u0007\u0001!\u0002\u0013\tI#\u0001\u0006qe\u0016\u0004\u0016M]:fe\u0002B\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\u000231\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM]\u000b\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0006j]R,'\u000f\u001d:fi\u0016$'bAA\"\u0005\u00059!/\u001e8uS6,\u0017\u0002BA$\u0003{\u0011\u0011\u0004T1ti\u000e{W.\\5ui\u0016$G\u000b_%e!J|g/\u001b3fe\"A\u00111\n\u0001!\u0002\u0013\tI$\u0001\u000emCN$8i\\7nSR$X\r\u001a+y\u0013\u0012\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0004\u0002P\u0001!I!!\u0015\u0002!Ad\u0017M\u001c*fkN\f'-\u001b7ji&LHCBA*\u00033\n\u0019\u0007E\u00028\u0003+J1!a\u0016\u0003\u0005A\u0011V-^:bE&d\u0017\u000e^=Ti\u0006$X\r\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003=)\u00070Z2vi\u0006\u0014G.Z)vKJL\bcA\u001c\u0002`%\u0019\u0011\u0011\r\u0002\u0003\u001f\u0015CXmY;uC\ndW-U;fefD\u0001\"!\u001a\u0002N\u0001\u0007\u0011qM\u0001\u0015iJ\fgn]1di&|g.\u00197D_:$X\r\u001f;\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005)\u0011/^3ss*\u0019\u0011\u0011O\f\u0002\t%l\u0007\u000f\\\u0005\u0005\u0003k\nYG\u0001\u000bUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003w\n1\u0001\\8h+\t\ti\bE\u0002r\u0003\u007fJ1!!!s\u0005\raun\u001a\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002~\u0005!An\\4!\u0011%\tI\t\u0001b\u0001\n\u0013\tY)A\nqY\u0006t7\u000b^1mK:,7o]\"bY2,'/\u0006\u0002\u0002\u000eB)q'a$\u0002^%\u0019\u0011\u0011\u0013\u0002\u0003'Ac\u0017M\\*uC2,g.Z:t\u0007\u0006dG.\u001a:\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001b\u000bA\u0003\u001d7b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\u0003\"CAM\u0001\t\u0007I\u0011BAN\u0003)\tX/\u001a:z\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003;\u0003raNAP\u0005j\ni&C\u0002\u0002\"\n\u0011!\"U;fef\u001c\u0015m\u00195f\u0011!\t)\u000b\u0001Q\u0001\n\u0005u\u0015aC9vKJL8)Y2iK\u0002B\u0011\"!+\u0001\u0005\u0004%I!a+\u0002\u001d5\f7\u000f^3s\u0007>l\u0007/\u001b7feV\u0011\u0011Q\u0016\t\u0004o\u0005=\u0016bAAY\u0005\tqQ*Y:uKJ\u001cu.\u001c9jY\u0016\u0014\b\u0002CA[\u0001\u0001\u0006I!!,\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002B\u0011\"!/\u0001\u0005\u0004%I!a/\u0002\u0019M\u001c\u0007.Z7b\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005u\u0006cA\u001c\u0002@&\u0019\u0011\u0011\u0019\u0002\u0003\u0019M\u001b\u0007.Z7b\u0011\u0016d\u0007/\u001a:\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003{\u000bQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0003bBAe\u0001\u0011\u0005\u00111Z\u0001\baJ|g-\u001b7f)!\ti-!7\u0002\\\u0006=\b\u0003BAh\u0003+l!!!5\u000b\u0007\u0005Mg!A\u0004he\u0006\u0004\b\u000e\u001a2\n\t\u0005]\u0017\u0011\u001b\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\u00055\u0014q\u0019a\u0001\u0005\"A\u0011Q\\Ad\u0001\u0004\ty.\u0001\u0004qCJ\fWn\u001d\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003\u001d1\u0018N\u001d;vC2T1!!;\u0007\u0003\u00191\u0018\r\\;fg&!\u0011Q^Ar\u0005!i\u0015\r\u001d,bYV,\u0007\u0002CAy\u0003\u000f\u0004\r!a\u001a\u0002\u000f\r|g\u000e^3yi\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018aB3yK\u000e,H/\u001a\u000b\u000b\u0003\u001b\fI0a?\u0002~\u0006}\bbBA7\u0003g\u0004\rA\u0011\u0005\t\u0003;\f\u0019\u00101\u0001\u0002`\"A\u0011\u0011_Az\u0001\u0004\t9\u0007\u0003\u0006\u0002J\u0006M\b\u0013!a\u0001\u0005\u0003\u00012!\u0004B\u0002\u0013\r\u0011)A\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0010\u0001C\u0001\u0005\u0013!\"Ba\u0003\u0003\u0012\tM!q\u0003B\r!\u0011\tIG!\u0004\n\t\t=\u00111\u000e\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\tiGa\u0002A\u0002\tC\u0001B!\u0006\u0003\b\u0001\u0007\u0011q\\\u0001\n[\u0006\u0004\b+\u0019:b[ND\u0001\"!=\u0003\b\u0001\u0007\u0011q\r\u0005\t\u00057\u00119\u00011\u0001\u0003\u001e\u0005a!/Z:vYR\u0014UO\u001a4feB!\u0011\u0011\u000eB\u0010\u0013\u0011\u0011\t#a\u001b\u0003\u0019I+7/\u001e7u\u0005V4g-\u001a:\t\u000f\t\u0015\u0002\u0001\"\u0003\u0003(\u0005aq-\u001a;Pe\u000e{W\u000e]5mKRQ\u0011Q\fB\u0015\u0005W\u0011)D!\u0013\t\u0011\u0005E(1\u0005a\u0001\u0003OB\u0001B!\f\u0003$\u0001\u0007!qF\u0001\u000faJ,\u0007+\u0019:tK\u0012\fV/\u001a:z!\r9$\u0011G\u0005\u0004\u0005g\u0011!A\u0004)sKB\u000b'o]3e#V,'/\u001f\u0005\bS\t\r\u0002\u0019\u0001B\u001c!\u0011\u0011IDa\u0011\u000f\t\tm\"q\b\b\u0004\u0017\nu\u0012B\u0001\u0018\u0003\u0013\r\u0011\t%L\u0001\u0012\u0007>l\u0007/\u001b7bi&|g\u000e\u0016:bG\u0016\u0014\u0018\u0002\u0002B#\u0005\u000f\u0012Q#U;fef\u001cu.\u001c9jY\u0006$\u0018n\u001c8Fm\u0016tGOC\u0002\u0003B5B\u0001\"!8\u0003$\u0001\u0007\u0011q\u001c\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0003A\u0019G.Z1s#V,'/_\"bG\",7\u000f\u0006\u0002\u0003RA\u0019QBa\u0015\n\u0007\tUcB\u0001\u0003M_:<\u0007b\u0002B-\u0001\u0011\u0005!1L\u0001\u0011SN\u0004VM]5pI&\u001c7i\\7nSR$BA!\u0001\u0003^!9\u0011Q\u000eB,\u0001\u0004\u0011\u0005b\u0002B1\u0001\u0011%!1M\u0001\u0010G\",7m\u001b)be\u0006lW\r^3sgRA!Q\rB6\u0005\u0003\u0013)\tE\u0002\u000e\u0005OJ1A!\u001b\u000f\u0005\u0011)f.\u001b;\t\u0011\t5$q\fa\u0001\u0005_\n1\"];fef\u0004\u0016M]1ngB)!\u0011\u000fB>\u0005:!!1\u000fB<\u001d\ry%QO\u0005\u0002\u001f%\u0019!\u0011\u0010\b\u0002\u000fA\f7m[1hK&!!Q\u0010B@\u0005\r\u0019V-\u001d\u0006\u0004\u0005sr\u0001\u0002\u0003BB\u0005?\u0002\r!a8\u0002\u0017\u001dLg/\u001a8QCJ\fWn\u001d\u0005\t\u0005\u000f\u0013y\u00061\u0001\u0002`\u0006yQ\r\u001f;sC\u000e$X\r\u001a)be\u0006l7\u000f\u000b\u0004\u0003`\t-%\u0011\u0014\t\u0006\u001b\t5%\u0011S\u0005\u0004\u0005\u001fs!A\u0002;ie><8\u000f\u0005\u0003\u0003\u0014\nUU\"\u0001\u0003\n\u0007\t]EA\u0001\u000eQCJ\fW.\u001a;fe:{GOR8v]\u0012,\u0005pY3qi&|gn\t\u0002\u0003\u0012\"I!Q\u0014\u0001\u0012\u0002\u0013\u0005!qT\u0001\u0012Kb,7-\u001e;fI\u0011,g-Y;mi\u0012\"TC\u0001BQU\u0011\u0011\tAa),\u0005\t\u0015\u0006\u0003\u0002BT\u0005ck!A!+\u000b\t\t-&QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa,\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005g\u0013IKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016<qAa.\u0003\u0011\u0003\u0011I,A\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f!\r9$1\u0018\u0004\u0007\u0003\tA\tA!0\u0014\u0007\tmF\u0002\u0003\u0005\u0002\u000e\tmF\u0011\u0001Ba)\t\u0011I\f\u0003\u0006\u0003F\nm&\u0019!C\u0001\u0005\u000f\f1\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN+\"A!3\u0011\u00075\u0011Y-C\u0002\u0003N:\u00111!\u00138u\u0011%\u0011\tNa/!\u0002\u0013\u0011I-\u0001\u000bQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5\u000b\t\u0005\u000b\u0005+\u0014Y,%A\u0005\u0002\t]\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0003Z*\u001a1Pa)")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerFactory compatibilityFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final PlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache;
    private final MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerFactory compatibilityFactory() {
        return this.compatibilityFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ReusabilityState org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private PlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, Map<String, Class<?>>>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    public MasterCompiler org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public Result profile(String query, MapValue params, TransactionalContext context) {
        return this.execute(query, params, context, true);
    }

    /*
     * WARNING - void declaration
     */
    public Result execute(String query, MapValue params, TransactionalContext context, boolean profile2) {
        Result result;
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        try {
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile2);
            ExecutableQuery executableQuery = this.getOrCompile(context, preParsedQuery, queryTracer, params);
            String string = preParsedQuery.executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            MapValue combinedParams = params.updatedWith(executableQuery.extractedParams());
            context.executingQuery().compilationCompleted(executableQuery.compilerInfo());
            result = executableQuery.execute(context, preParsedQuery.executionMode(), combinedParams);
            queryTracer.close();
        }
        catch (Throwable throwable) {
            try {
                context.close(false);
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        return result;
    }

    public QueryExecution execute(String query, MapValue mapParams, TransactionalContext context, ResultBuffer resultBuffer) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public boolean execute$default$4() {
        return false;
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, PreParsedQuery preParsedQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        Pair cacheKey = Pair.of((Object)preParsedQuery.statementWithVersionAndPlanner(), QueryCache$.MODULE$.extractParameterTypeMap(params));
        TransactionalContext tc = context.getOrBeginNewIfClosed();
        try (KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));){
            for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                BoxedUnit boxedUnit;
                long schemaToken = this.schemaHelper().readSchemaToken(tc);
                CacheLookup<ExecutableQuery> cacheLookup = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, (Function0<ExecutableQuery>)new Serializable(this, preParsedQuery, tracer, params, tc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ExecutionEngine $outer;
                    private final PreParsedQuery preParsedQuery$1;
                    private final CompilationTracer.QueryCompilationEvent tracer$1;
                    private final MapValue params$1;
                    private final TransactionalContext tc$1;

                    public final ExecutableQuery apply() {
                        return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().compile(this.preParsedQuery$1, this.tracer$1, this.tc$1, this.params$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.preParsedQuery$1 = preParsedQuery$1;
                        this.tracer$1 = tracer$1;
                        this.params$1 = params$1;
                        this.tc$1 = tc$1;
                    }
                }, preParsedQuery.rawStatement());
                CacheLookup<ExecutableQuery> cacheLookup2 = cacheLookup;
                boolean bl = cacheLookup2 instanceof CacheHit ? true : cacheLookup2 instanceof CacheDisabled;
                if (bl) {
                    ExecutableQuery executableQuery = cacheLookup.executableQuery();
                    if (this.schemaHelper().lockLabels(schemaToken, executableQuery, preParsedQuery.version(), tc)) {
                        tc.cleanForReuse();
                        return executableQuery;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (cacheLookup2 instanceof CacheMiss) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(cacheLookup2);
            }
            throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
        }
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        return this.preParser().preParseQuery(query, false).isPeriodicCommit();
    }

    private void checkParameters(Seq<String> queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        Serializable x$1 = new Serializable(this, queryParams, givenParams, extractedParams){
            public static final long serialVersionUID = 0L;
            private final Seq queryParams$1;
            public final MapValue givenParams$1;
            public final MapValue extractedParams$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq missingKeys = (Seq)this.queryParams$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$checkParameters$1 $outer;

                    public final boolean apply(String key) {
                        return !this.$outer.givenParams$1.containsKey(key) && !this.$outer.extractedParams$1.containsKey(key);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (missingKeys.nonEmpty()) {
                    throw new ParameterNotFoundException(new StringBuilder().append((Object)"Expected parameter(s): ").append((Object)missingKeys.mkString(", ")).toString());
                }
            }
            {
                this.queryParams$1 = queryParams$1;
                this.givenParams$1 = givenParams$1;
                this.extractedParams$1 = extractedParams$1;
            }
        };
        Function1 x$2 = exceptionHandler.runSafely$.MODULE$.apply$default$2((Function0)x$1);
        exceptionHandler.runSafely$.MODULE$.apply((Function0)x$1, x$2);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, Map<String, Class<?>>>> cacheTracer, CypherConfiguration config, CompilerFactory compatibilityFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compatibilityFactory = compatibilityFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Can't work with a null graph database";
            }
        });
        this.preParser = new PreParser(config.version(), config.planner(), config.runtime(), config.queryCacheSize());
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new StringCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor$class.cacheFlushDetected(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor$class.cacheHit(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor$class.cacheMiss(this, key);
            }

            public void cacheDiscard(Pair<String, Map<String, Class<?>>> ignored, String query, int secondsSinceReplan) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarded stale query from the query cache after ", " seconds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)secondsSinceReplan), query})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor$class.$init$(this);
                CypherCacheFlushingMonitor$class.$init$(this);
            }
        }, new String[0]);
        this.planStalenessCaller = new PlanStalenessCaller(clock, config.statsDivergenceCalculator(), (Function0<Object>)this.lastCommittedTxIdProvider(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutionEngine $outer;

            public final ReusabilityState apply(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
                return this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$planReusabilitiy(executableQuery, transactionalContext);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.queryCache = new QueryCache(config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.org$neo4j$cypher$internal$ExecutionEngine$$masterCompiler = new MasterCompiler(queryService, kernelMonitors, config, logProvider, new CompilerLibrary(compatibilityFactory));
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

