/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import org.neo4j.cypher.internal.codegen.CompiledConversionUtils;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.values.storable.Values;

public final class CompiledIndexUtils {
    private CompiledIndexUtils() {
        throw new UnsupportedOperationException();
    }

    public static NodeValueIndexCursor indexSeek(Read read, CursorFactory cursors, IndexDescriptor index, Object value) throws KernelException {
        assert (index.schema().getPropertyIds().length == 1);
        if (value == Values.NO_VALUE || value == null) {
            return NodeValueIndexCursor.EMPTY;
        }
        NodeValueIndexCursor cursor = cursors.allocateNodeValueIndexCursor();
        IndexQuery.ExactPredicate query = IndexQuery.exact((int)index.schema().getPropertyIds()[0], (Object)CompiledConversionUtils.makeValueNeoSafe(value));
        IndexReadSession indexSession = read.indexReadSession(index);
        read.nodeIndexSeek(indexSession, cursor, IndexOrder.NONE, false, new IndexQuery[]{query});
        return cursor;
    }
}

