/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.codegen;

import java.lang.reflect.Array;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.exceptions.ArithmeticException;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CompiledMathHelper {
    private static final double EPSILON = Math.pow(1.0, -10.0);

    private CompiledMathHelper() {
    }

    public static Object add(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        boolean lhsIsListValue = lhs instanceof ListValue;
        if (lhsIsListValue && rhs instanceof ListValue) {
            return VirtualValues.concat((ListValue[])new ListValue[]{(ListValue)lhs, (ListValue)rhs});
        }
        if (lhsIsListValue) {
            if (rhs instanceof List) {
                return VirtualValues.concat((ListValue[])new ListValue[]{(ListValue)lhs, ValueUtils.asListValue((List)((List)rhs))});
            }
            if (rhs instanceof AnyValue) {
                return ((ListValue)lhs).append(new AnyValue[]{(AnyValue)rhs});
            }
            return ((ListValue)lhs).append(new AnyValue[]{ValueUtils.of((Object)rhs)});
        }
        if (rhs instanceof ListValue) {
            if (lhs instanceof List) {
                return VirtualValues.concat((ListValue[])new ListValue[]{ValueUtils.asListValue((List)((List)lhs)), (ListValue)rhs});
            }
            if (lhs instanceof AnyValue) {
                return ((ListValue)rhs).prepend(new AnyValue[]{(AnyValue)lhs});
            }
            return ((ListValue)rhs).prepend(new AnyValue[]{ValueUtils.of((Object)lhs)});
        }
        if (lhs instanceof List && rhs instanceof List) {
            List lhsList = (List)lhs;
            List rhsList = (List)rhs;
            ArrayList result = new ArrayList(lhsList.size() + rhsList.size());
            result.addAll(lhsList);
            result.addAll(rhsList);
            return result;
        }
        if (lhs instanceof List) {
            List lhsList = (List)lhs;
            ArrayList<Object> result = new ArrayList<Object>(lhsList.size() + 1);
            result.addAll(lhsList);
            result.add(rhs);
            return result;
        }
        if (rhs instanceof List) {
            List rhsList = (List)rhs;
            ArrayList<Object> result = new ArrayList<Object>(rhsList.size() + 1);
            result.add(lhs);
            result.addAll(rhsList);
            return result;
        }
        if (lhs instanceof TextValue) {
            lhs = ((TextValue)lhs).stringValue();
        }
        if (rhs instanceof TextValue) {
            rhs = ((TextValue)rhs).stringValue();
        }
        if (lhs instanceof String) {
            if (rhs instanceof Value) {
                if (!(rhs instanceof TemporalValue || rhs instanceof DurationValue || rhs instanceof PointValue)) {
                    return String.valueOf(lhs) + ((Value)rhs).prettyPrint();
                }
            } else {
                return String.valueOf(lhs) + String.valueOf(rhs);
            }
        }
        if (rhs instanceof String) {
            if (lhs instanceof Value) {
                if (!(lhs instanceof TemporalValue || lhs instanceof DurationValue || lhs instanceof PointValue)) {
                    return ((Value)lhs).prettyPrint() + String.valueOf(rhs);
                }
            } else {
                return lhs.toString() + String.valueOf(rhs);
            }
        }
        if (lhs instanceof ArrayValue) {
            lhs = ((ArrayValue)lhs).asObject();
        }
        if (rhs instanceof ArrayValue) {
            rhs = ((ArrayValue)rhs).asObject();
        }
        Class<?> lhsClass = lhs.getClass();
        Class<?> rhsClass = rhs.getClass();
        if (lhsClass.isArray() && rhsClass.isArray()) {
            return CompiledMathHelper.addArrays(lhs, rhs);
        }
        if (lhsClass.isArray()) {
            return CompiledMathHelper.addArrayWithObject(lhs, rhs);
        }
        if (rhsClass.isArray()) {
            return CompiledMathHelper.addObjectWithArray(lhs, rhs);
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return ((NumberValue)lhs).plus((NumberValue)rhs);
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                return Math.addExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
            }
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).plus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue) {
            if (rhs instanceof TemporalValue) {
                return ((TemporalValue)rhs).plus((TemporalAmount)((DurationValue)lhs));
            }
            if (rhs instanceof DurationValue) {
                return ((DurationValue)lhs).add((DurationValue)rhs);
            }
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot add `%s` and `%s`", lhsValue.getTypeName(), rhsValue.getTypeName()), null);
    }

    public static Object subtract(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return ((NumberValue)lhs).minus((NumberValue)rhs);
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() - ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                return Math.subtractExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
            }
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).minus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue && rhs instanceof DurationValue) {
            return ((DurationValue)lhs).sub((DurationValue)rhs);
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot subtract `%s` from `%s`", rhsValue.getTypeName(), lhsValue.getTypeName()), null);
    }

    public static Object multiply(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        if (lhs instanceof DurationValue) {
            if (rhs instanceof NumberValue) {
                return ((DurationValue)lhs).mul((NumberValue)rhs);
            }
            if (rhs instanceof Number) {
                return ((DurationValue)lhs).mul(Values.numberValue((Number)((Number)rhs)));
            }
        }
        if (rhs instanceof DurationValue) {
            if (lhs instanceof NumberValue) {
                return ((DurationValue)rhs).mul((NumberValue)lhs);
            }
            if (lhs instanceof Number) {
                return ((DurationValue)rhs).mul(Values.numberValue((Number)((Number)lhs)));
            }
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return ((NumberValue)lhs).times((NumberValue)rhs);
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                return ((Number)lhs).doubleValue() * ((Number)rhs).doubleValue();
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                return Math.multiplyExact(((Number)lhs).longValue(), ((Number)rhs).longValue());
            }
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot multiply `%s` and `%s`", lhsValue.getTypeName(), rhsValue.getTypeName()), null);
    }

    public static Object divide(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        if (lhs instanceof DurationValue) {
            if (rhs instanceof NumberValue) {
                return ((DurationValue)lhs).div((NumberValue)rhs);
            }
            if (rhs instanceof Number) {
                return ((DurationValue)lhs).div(Values.numberValue((Number)((Number)rhs)));
            }
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            long right;
            if (rhs instanceof IntegralValue && (right = ((IntegralValue)rhs).longValue()) == 0L) {
                throw new ArithmeticException("/ by zero", null);
            }
            return ((NumberValue)lhs).divideBy((NumberValue)rhs);
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                double left = ((Number)lhs).doubleValue();
                double right = ((Number)rhs).doubleValue();
                return left / right;
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                long left = ((Number)lhs).longValue();
                long right = ((Number)rhs).longValue();
                if (right == 0L) {
                    throw new ArithmeticException("/ by zero", null);
                }
                return left / right;
            }
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot divide `%s` by `%s`", lhsValue.getTypeName(), rhsValue.getTypeName()), null);
    }

    public static Object modulo(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            if (lhs instanceof Double || rhs instanceof Double || lhs instanceof Float || rhs instanceof Float) {
                double left = ((Number)lhs).doubleValue();
                double right = ((Number)rhs).doubleValue();
                return left % right;
            }
            if (lhs instanceof Long || rhs instanceof Long || lhs instanceof Integer || rhs instanceof Integer || lhs instanceof Short || rhs instanceof Short || lhs instanceof Byte || rhs instanceof Byte) {
                long left = ((Number)lhs).longValue();
                long right = ((Number)rhs).longValue();
                if (right == 0L) {
                    throw new ArithmeticException("/ by zero", null);
                }
                return left % right;
            }
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot calculate modulus of `%s` and `%s`", lhsValue.getTypeName(), rhsValue.getTypeName()), null);
    }

    public static Object pow(Object lhs, Object rhs) {
        if (lhs == null || rhs == null || lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return null;
        }
        if (lhs instanceof NumberValue) {
            lhs = ((NumberValue)lhs).asObject();
        }
        if (rhs instanceof NumberValue) {
            rhs = ((NumberValue)rhs).asObject();
        }
        if (lhs instanceof Number && rhs instanceof Number) {
            return Math.pow(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
        }
        AnyValue lhsValue = lhs instanceof AnyValue ? (AnyValue)lhs : ValueUtils.of((Object)lhs);
        AnyValue rhsValue = rhs instanceof AnyValue ? (AnyValue)rhs : ValueUtils.of((Object)rhs);
        throw new CypherTypeException(String.format("Cannot raise `%s` to the power of `%s`", lhsValue.getTypeName(), rhsValue.getTypeName()), null);
    }

    public static int transformToInt(Object value) {
        if (value == null) {
            throw new CypherTypeException("Expected a numeric value but got null", null);
        }
        if (value instanceof NumberValue) {
            value = ((NumberValue)value).asObject();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.longValue() > Integer.MAX_VALUE) {
                throw new CypherTypeException(value.toString() + " is too large to cast to an int32", null);
            }
            return number.intValue();
        }
        throw new CypherTypeException(String.format("Expected a numeric value but got %s", value.toString()), null);
    }

    public static long transformToLong(Object value) {
        if (value == null) {
            throw new CypherTypeException("Expected a numeric value but got null", null);
        }
        if (value instanceof NumberValue) {
            NumberValue number = (NumberValue)value;
            return number.longValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        throw new CypherTypeException(String.format("Expected a numeric value but got %s", value.toString()), null);
    }

    public static long transformToLongOrFail(Object value, String errorOnFloatingPoint) {
        if (value == null) {
            throw new CypherTypeException("Expected a numeric value but got null", null);
        }
        if (value instanceof NumberValue) {
            NumberValue number = (NumberValue)value;
            if (number instanceof FloatingPointValue) {
                throw new InvalidArgumentException(errorOnFloatingPoint, null);
            }
            return number.longValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number instanceof Float || number instanceof Double) {
                throw new InvalidArgumentException(errorOnFloatingPoint, null);
            }
            return number.longValue();
        }
        throw new CypherTypeException(String.format("Expected a numeric value but got %s", value.toString()), null);
    }

    private static Object addArrays(Object a1, Object a2) {
        int i;
        int l1 = Array.getLength(a1);
        int l2 = Array.getLength(a2);
        Object[] ret = new Object[l1 + l2];
        for (i = 0; i < l1; ++i) {
            ret[i] = Array.get(a1, i);
        }
        for (i = 0; i < l2; ++i) {
            ret[l1 + i] = Array.get(a2, i);
        }
        return ret;
    }

    private static Object addArrayWithObject(Object array, Object object) {
        int l = Array.getLength(array);
        Object[] ret = new Object[l + 1];
        for (int i = 0; i < l; ++i) {
            ret[i] = Array.get(array, i);
        }
        ret[i] = object;
        return ret;
    }

    private static Object addObjectWithArray(Object object, Object array) {
        int l = Array.getLength(array);
        Object[] ret = new Object[l + 1];
        ret[0] = object;
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = Array.get(array, i);
        }
        return ret;
    }
}

