/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.CypherExecutionMode$;
import org.neo4j.cypher.CypherExecutionMode$normal$;
import org.neo4j.cypher.CypherExpressionEngineOption;
import org.neo4j.cypher.CypherExpressionEngineOption$;
import org.neo4j.cypher.CypherExpressionEngineOption$compiled$;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption$;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption$allPossiblePlans$;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption$disabled$;
import org.neo4j.cypher.CypherInterpretedPipesFallbackOption$whitelistedPlansOnly$;
import org.neo4j.cypher.CypherOperatorEngineOption;
import org.neo4j.cypher.CypherOperatorEngineOption$;
import org.neo4j.cypher.CypherOperatorEngineOption$compiled$;
import org.neo4j.cypher.CypherOption;
import org.neo4j.cypher.CypherPlannerOption;
import org.neo4j.cypher.CypherPlannerOption$;
import org.neo4j.cypher.CypherRuntimeOption;
import org.neo4j.cypher.CypherRuntimeOption$;
import org.neo4j.cypher.CypherRuntimeOption$compiled$;
import org.neo4j.cypher.CypherRuntimeOption$interpreted$;
import org.neo4j.cypher.CypherRuntimeOption$slotted$;
import org.neo4j.cypher.CypherUpdateStrategy$;
import org.neo4j.cypher.CypherUpdateStrategy$default$;
import org.neo4j.cypher.CypherVersion;
import org.neo4j.cypher.CypherVersion$;
import org.neo4j.cypher.internal.ConfigurationOptions;
import org.neo4j.cypher.internal.DebugOption;
import org.neo4j.cypher.internal.ExecutionModePreParserOption;
import org.neo4j.cypher.internal.ExpressionEnginePreParserOption;
import org.neo4j.cypher.internal.GreedyPlannerOption$;
import org.neo4j.cypher.internal.InterpretedPipesFallbackPreParserOption;
import org.neo4j.cypher.internal.OperatorEnginePreParserOption;
import org.neo4j.cypher.internal.PlannerPreParserOption;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.PreParserOption;
import org.neo4j.cypher.internal.QueryOptions;
import org.neo4j.cypher.internal.QueryOptions$;
import org.neo4j.cypher.internal.RuntimePreParserOption;
import org.neo4j.cypher.internal.UpdateStrategyOption;
import org.neo4j.cypher.internal.VersionOption;
import org.neo4j.cypher.internal.v4_0.util.InputPosition;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class PreParser$ {
    public static PreParser$ MODULE$;
    private final Regex periodicCommitHintRegex;
    private final Set<Tuple2<CypherPlannerOption, CypherRuntimeOption>> ILLEGAL_PLANNER_RUNTIME_COMBINATIONS;
    private final Set<Tuple2<CypherPlannerOption, CypherVersion>> ILLEGAL_PLANNER_VERSION_COMBINATIONS;
    private final Set<Tuple2<CypherExpressionEngineOption, CypherRuntimeOption>> ILLEGAL_EXPRESSION_ENGINE_RUNTIME_COMBINATIONS;
    private final Set<Tuple2<CypherOperatorEngineOption, CypherRuntimeOption>> ILLEGAL_OPERATOR_ENGINE_RUNTIME_COMBINATIONS;
    private final Set<Tuple2<CypherInterpretedPipesFallbackOption, CypherRuntimeOption>> ILLEGAL_INTERPRETED_PIPES_FALLBACK_RUNTIME_COMBINATIONS;

    static {
        new PreParser$();
    }

    public Regex periodicCommitHintRegex() {
        return this.periodicCommitHintRegex;
    }

    private final Set<Tuple2<CypherPlannerOption, CypherRuntimeOption>> ILLEGAL_PLANNER_RUNTIME_COMBINATIONS() {
        return this.ILLEGAL_PLANNER_RUNTIME_COMBINATIONS;
    }

    private final Set<Tuple2<CypherPlannerOption, CypherVersion>> ILLEGAL_PLANNER_VERSION_COMBINATIONS() {
        return this.ILLEGAL_PLANNER_VERSION_COMBINATIONS;
    }

    private final Set<Tuple2<CypherExpressionEngineOption, CypherRuntimeOption>> ILLEGAL_EXPRESSION_ENGINE_RUNTIME_COMBINATIONS() {
        return this.ILLEGAL_EXPRESSION_ENGINE_RUNTIME_COMBINATIONS;
    }

    private final Set<Tuple2<CypherOperatorEngineOption, CypherRuntimeOption>> ILLEGAL_OPERATOR_ENGINE_RUNTIME_COMBINATIONS() {
        return this.ILLEGAL_OPERATOR_ENGINE_RUNTIME_COMBINATIONS;
    }

    private final Set<Tuple2<CypherInterpretedPipesFallbackOption, CypherRuntimeOption>> ILLEGAL_INTERPRETED_PIPES_FALLBACK_RUNTIME_COMBINATIONS() {
        return this.ILLEGAL_INTERPRETED_PIPES_FALLBACK_RUNTIME_COMBINATIONS;
    }

    public QueryOptions queryOptions(Seq<PreParserOption> options, InputPosition offset, boolean isPeriodicCommit, CypherVersion configuredVersion, CypherPlannerOption configuredPlanner, CypherRuntimeOption configuredRuntime, CypherExpressionEngineOption configuredExpressionEngine, CypherOperatorEngineOption configuredOperatorEngine, CypherInterpretedPipesFallbackOption configuredInterpretedPipesFallback) {
        PreParser.PPOption<CypherExecutionMode$normal$> executionMode = new PreParser.PPOption<CypherExecutionMode$normal$>(CypherExecutionMode$.MODULE$.default());
        PreParser.PPOption<CypherVersion> version = new PreParser.PPOption<CypherVersion>(configuredVersion);
        PreParser.PPOption<CypherPlannerOption> planner = new PreParser.PPOption<CypherPlannerOption>(configuredPlanner);
        PreParser.PPOption<CypherRuntimeOption> runtime = new PreParser.PPOption<CypherRuntimeOption>(configuredRuntime);
        PreParser.PPOption<CypherExpressionEngineOption> expressionEngine = new PreParser.PPOption<CypherExpressionEngineOption>(configuredExpressionEngine);
        PreParser.PPOption<CypherOperatorEngineOption> operatorEngine = new PreParser.PPOption<CypherOperatorEngineOption>(configuredOperatorEngine);
        PreParser.PPOption<CypherInterpretedPipesFallbackOption> interpretedPipesFallback = new PreParser.PPOption<CypherInterpretedPipesFallbackOption>(configuredInterpretedPipesFallback);
        PreParser.PPOption<CypherUpdateStrategy$default$> updateStrategy = new PreParser.PPOption<CypherUpdateStrategy$default$>(CypherUpdateStrategy$default$.MODULE$);
        ObjectRef debugOptions = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        PreParser$.parseOptions$1(options, executionMode, version, planner, runtime, expressionEngine, operatorEngine, interpretedPipesFallback, updateStrategy, debugOptions);
        if (this.ILLEGAL_PLANNER_RUNTIME_COMBINATIONS().apply((Object)new Tuple2((Object)planner.pick(), (Object)runtime.pick()))) {
            throw new PreParser.InvalidPreparserOption(new StringBuilder(46).append("Unsupported PLANNER - RUNTIME combination: ").append(((CypherOption)planner.pick()).name()).append(" - ").append(((CypherOption)runtime.pick()).name()).toString());
        }
        if (version.isSelected() && this.ILLEGAL_PLANNER_VERSION_COMBINATIONS().apply((Object)new Tuple2((Object)planner.pick(), (Object)version.pick()))) {
            throw new InvalidArgumentException(new StringBuilder(46).append("Unsupported PLANNER - VERSION combination: ").append(((CypherOption)planner.pick()).name()).append(" - ").append(((CypherOption)version.pick()).name()).toString());
        }
        if (runtime.isSelected() && expressionEngine.isSelected() && this.ILLEGAL_EXPRESSION_ENGINE_RUNTIME_COMBINATIONS().apply((Object)new Tuple2((Object)expressionEngine.pick(), (Object)runtime.pick()))) {
            throw new PreParser.InvalidPreparserOption(new StringBuilder(51).append("Cannot combine EXPRESSION ENGINE '").append(((CypherOption)expressionEngine.pick()).name()).append("' with RUNTIME '").append(((CypherOption)runtime.pick()).name()).append("'").toString());
        }
        if (runtime.isSelected() && operatorEngine.isSelected() && this.ILLEGAL_OPERATOR_ENGINE_RUNTIME_COMBINATIONS().apply((Object)new Tuple2((Object)operatorEngine.pick(), (Object)runtime.pick()))) {
            throw new PreParser.InvalidPreparserOption(new StringBuilder(49).append("Cannot combine OPERATOR ENGINE '").append(((CypherOption)operatorEngine.pick()).name()).append("' with RUNTIME '").append(((CypherOption)runtime.pick()).name()).append("'").toString());
        }
        if (runtime.isSelected() && interpretedPipesFallback.isSelected() && this.ILLEGAL_INTERPRETED_PIPES_FALLBACK_RUNTIME_COMBINATIONS().apply((Object)new Tuple2((Object)interpretedPipesFallback.pick(), (Object)runtime.pick()))) {
            throw new PreParser.InvalidPreparserOption(new StringBuilder(60).append("Cannot combine INTERPRETED PIPES FALLBACK '").append(((CypherOption)interpretedPipesFallback.pick()).name()).append("' with RUNTIME '").append(((CypherOption)runtime.pick()).name()).append("'").toString());
        }
        return new QueryOptions(offset, isPeriodicCommit, version.pick(), executionMode.pick(), planner.pick(), runtime.pick(), updateStrategy.pick(), expressionEngine.pick(), operatorEngine.pick(), interpretedPipesFallback.pick(), (Set<String>)((Set)debugOptions.elem), QueryOptions$.MODULE$.apply$default$12(), QueryOptions$.MODULE$.apply$default$13());
    }

    public static final /* synthetic */ void $anonfun$queryOptions$1(PreParser.PPOption executionMode$1, PreParser.PPOption version$1, PreParser.PPOption planner$1, PreParser.PPOption runtime$1, PreParser.PPOption expressionEngine$1, PreParser.PPOption operatorEngine$1, PreParser.PPOption interpretedPipesFallback$1, PreParser.PPOption updateStrategy$1, ObjectRef debugOptions$1, PreParserOption option) {
        boolean bl = false;
        PlannerPreParserOption plannerPreParserOption = null;
        PreParserOption preParserOption = option;
        if (preParserOption instanceof ExecutionModePreParserOption) {
            ExecutionModePreParserOption executionModePreParserOption = (ExecutionModePreParserOption)preParserOption;
            executionMode$1.selectOrThrow(CypherExecutionMode$.MODULE$.apply(executionModePreParserOption.name()), "Can't specify multiple conflicting Cypher execution modes");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (preParserOption instanceof VersionOption) {
            VersionOption versionOption = (VersionOption)preParserOption;
            String v2 = versionOption.version();
            version$1.selectOrThrow(CypherVersion$.MODULE$.apply(v2), "Can't specify multiple conflicting Cypher versions");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (preParserOption instanceof PlannerPreParserOption) {
                bl = true;
                plannerPreParserOption = (PlannerPreParserOption)preParserOption;
                String string = plannerPreParserOption.name();
                String string2 = GreedyPlannerOption$.MODULE$.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw new InvalidArgumentException("The greedy planner has been removed in Neo4j 3.1. Please use the cost planner instead.");
                }
            }
            if (bl) {
                planner$1.selectOrThrow(CypherPlannerOption$.MODULE$.apply(plannerPreParserOption.name()), "Can't specify multiple conflicting Cypher planners");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof RuntimePreParserOption) {
                RuntimePreParserOption runtimePreParserOption = (RuntimePreParserOption)preParserOption;
                runtime$1.selectOrThrow(CypherRuntimeOption$.MODULE$.apply(runtimePreParserOption.name()), "Can't specify multiple conflicting Cypher runtimes");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof UpdateStrategyOption) {
                UpdateStrategyOption updateStrategyOption = (UpdateStrategyOption)preParserOption;
                updateStrategy$1.selectOrThrow(CypherUpdateStrategy$.MODULE$.apply(updateStrategyOption.name()), "Can't specify multiple conflicting update strategies");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof DebugOption) {
                DebugOption debugOption = (DebugOption)preParserOption;
                String debug = debugOption.key();
                debugOptions$1.elem = (Set)((Set)debugOptions$1.elem).$plus((Object)debug.toLowerCase());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof ExpressionEnginePreParserOption) {
                ExpressionEnginePreParserOption expressionEnginePreParserOption = (ExpressionEnginePreParserOption)preParserOption;
                expressionEngine$1.selectOrThrow(CypherExpressionEngineOption$.MODULE$.apply(expressionEnginePreParserOption.name()), "Can't specify multiple conflicting expression engines");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof OperatorEnginePreParserOption) {
                OperatorEnginePreParserOption operatorEnginePreParserOption = (OperatorEnginePreParserOption)preParserOption;
                operatorEngine$1.selectOrThrow(CypherOperatorEngineOption$.MODULE$.apply(operatorEnginePreParserOption.name()), "Can't specify multiple conflicting operator execution modes");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof InterpretedPipesFallbackPreParserOption) {
                InterpretedPipesFallbackPreParserOption interpretedPipesFallbackPreParserOption = (InterpretedPipesFallbackPreParserOption)preParserOption;
                interpretedPipesFallback$1.selectOrThrow(CypherInterpretedPipesFallbackOption$.MODULE$.apply(interpretedPipesFallbackPreParserOption.name()), "Can't specify multiple conflicting interpreted pipes fallback modes");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (preParserOption instanceof ConfigurationOptions) {
                ConfigurationOptions configurationOptions = (ConfigurationOptions)preParserOption;
                Option<VersionOption> versionOpt = configurationOptions.version();
                Seq<PreParserOption> innerOptions = configurationOptions.options();
                versionOpt.foreach((Function1 & Serializable & scala.Serializable)v -> {
                    version$1.selectOrThrow(CypherVersion$.MODULE$.apply(v.version()), "Can't specify multiple conflicting Cypher versions");
                    return BoxedUnit.UNIT;
                });
                PreParser$.parseOptions$1(innerOptions, executionMode$1, version$1, planner$1, runtime$1, expressionEngine$1, operatorEngine$1, interpretedPipesFallback$1, updateStrategy$1, debugOptions$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)preParserOption);
            }
        }
    }

    private static final void parseOptions$1(Seq options, PreParser.PPOption executionMode$1, PreParser.PPOption version$1, PreParser.PPOption planner$1, PreParser.PPOption runtime$1, PreParser.PPOption expressionEngine$1, PreParser.PPOption operatorEngine$1, PreParser.PPOption interpretedPipesFallback$1, PreParser.PPOption updateStrategy$1, ObjectRef debugOptions$1) {
        options.foreach((Function1 & Serializable & scala.Serializable)option -> {
            PreParser$.$anonfun$queryOptions$1(executionMode$1, version$1, planner$1, runtime$1, expressionEngine$1, operatorEngine$1, interpretedPipesFallback$1, updateStrategy$1, debugOptions$1, option);
            return BoxedUnit.UNIT;
        });
    }

    private PreParser$() {
        MODULE$ = this;
        this.periodicCommitHintRegex = new StringOps(Predef$.MODULE$.augmentString("^\\s*USING\\s+PERIODIC\\s+COMMIT.*")).r();
        this.ILLEGAL_PLANNER_RUNTIME_COMBINATIONS = Predef$.MODULE$.Set().empty();
        this.ILLEGAL_PLANNER_VERSION_COMBINATIONS = Predef$.MODULE$.Set().empty();
        this.ILLEGAL_EXPRESSION_ENGINE_RUNTIME_COMBINATIONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)CypherExpressionEngineOption$compiled$.MODULE$, (Object)CypherRuntimeOption$compiled$.MODULE$), new Tuple2((Object)CypherExpressionEngineOption$compiled$.MODULE$, (Object)CypherRuntimeOption$interpreted$.MODULE$)}));
        this.ILLEGAL_OPERATOR_ENGINE_RUNTIME_COMBINATIONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)CypherOperatorEngineOption$compiled$.MODULE$, (Object)CypherRuntimeOption$compiled$.MODULE$), new Tuple2((Object)CypherOperatorEngineOption$compiled$.MODULE$, (Object)CypherRuntimeOption$slotted$.MODULE$), new Tuple2((Object)CypherOperatorEngineOption$compiled$.MODULE$, (Object)CypherRuntimeOption$interpreted$.MODULE$)}));
        this.ILLEGAL_INTERPRETED_PIPES_FALLBACK_RUNTIME_COMBINATIONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)CypherInterpretedPipesFallbackOption$disabled$.MODULE$, (Object)CypherRuntimeOption$compiled$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$disabled$.MODULE$, (Object)CypherRuntimeOption$slotted$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$disabled$.MODULE$, (Object)CypherRuntimeOption$interpreted$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$whitelistedPlansOnly$.MODULE$, (Object)CypherRuntimeOption$compiled$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$whitelistedPlansOnly$.MODULE$, (Object)CypherRuntimeOption$slotted$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$whitelistedPlansOnly$.MODULE$, (Object)CypherRuntimeOption$interpreted$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$allPossiblePlans$.MODULE$, (Object)CypherRuntimeOption$compiled$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$allPossiblePlans$.MODULE$, (Object)CypherRuntimeOption$slotted$.MODULE$), new Tuple2((Object)CypherInterpretedPipesFallbackOption$allPossiblePlans$.MODULE$, (Object)CypherRuntimeOption$interpreted$.MODULE$)}));
    }
}

