/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.javacompat.EagerResult;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.cypher.internal.javacompat.UnstableSnapshotException;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.LogProvider;
import org.neo4j.values.virtual.MapValue;

public class SnapshotExecutionEngine
extends ExecutionEngine {
    private final int maxQueryExecutionAttempts;

    SnapshotExecutionEngine(GraphDatabaseQueryService queryService, Config config, LogProvider logProvider, CompilerFactory compilerFactory) {
        super(queryService, logProvider, compilerFactory);
        this.maxQueryExecutionAttempts = (Integer)config.get(GraphDatabaseInternalSettings.snapshot_query_retries);
    }

    @Override
    public Result executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, querySubscriber);
        return (Result)this.executeWithRetries(query, context, queryExecutor).other();
    }

    @Override
    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, querySubscriber);
        Pair<QueryExecution, EagerResult> pair = this.executeWithRetries(query, context, queryExecutor);
        return ((EagerResult)pair.other()).streamToSubscriber(subscriber, (QueryExecution)pair.first());
    }

    @Override
    public QueryExecution executeQuery(FullyParsedQuery query, MapValue parameters, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, input, queryMonitor, querySubscriber);
        Pair<QueryExecution, EagerResult> pair = this.executeWithRetries(query.description(), context, queryExecutor);
        return ((EagerResult)pair.other()).streamToSubscriber(subscriber, (QueryExecution)pair.first());
    }

    protected Pair<QueryExecution, EagerResult> executeWithRetries(String query, TransactionalContext context, QueryExecutor executor) throws QueryExecutionKernelException {
        EagerResult eagerResult;
        QueryExecution queryExecution;
        boolean dirtySnapshot;
        VersionContext versionContext = SnapshotExecutionEngine.getCursorContext(context);
        int attempt = 0;
        do {
            if (attempt == this.maxQueryExecutionAttempts) {
                throw new QueryExecutionKernelException((Throwable)((Object)new UnstableSnapshotException("Unable to get clean data snapshot for query '%s' after %d attempts.", query, attempt)));
            }
            if (attempt > 0) {
                context.executingQuery().onRetryAttempted();
            }
            ++attempt;
            versionContext.initRead();
            ResultSubscriber resultSubscriber = this.getResultSubscriber(context);
            queryExecution = executor.execute(resultSubscriber);
            resultSubscriber.init(queryExecution);
            eagerResult = this.getEagerResult(versionContext, resultSubscriber);
            eagerResult.consume();
            dirtySnapshot = versionContext.isDirty();
            if (!dirtySnapshot || !resultSubscriber.getQueryStatistics().containsUpdates()) continue;
            throw new QueryExecutionKernelException((Throwable)((Object)new UnstableSnapshotException("Unable to get clean data snapshot for query '%s' that performs updates.", query, attempt)));
        } while (dirtySnapshot);
        return Pair.of((Object)queryExecution, (Object)eagerResult);
    }

    protected EagerResult getEagerResult(VersionContext versionContext, ResultSubscriber resultSubscriber) {
        return new EagerResult(resultSubscriber, versionContext);
    }

    protected ResultSubscriber getResultSubscriber(TransactionalContext context) {
        return new ResultSubscriber(context);
    }

    private static VersionContext getCursorContext(TransactionalContext context) {
        return ((KernelStatement)context.statement()).getVersionContext();
    }

    @FunctionalInterface
    protected static interface QueryExecutor {
        public QueryExecution execute(ResultSubscriber var1) throws QueryExecutionKernelException;
    }
}

