/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.cypher.result.EagerQuerySubscription;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class EagerQueryExecution
extends EagerQuerySubscription
implements QueryExecution {
    private final QueryExecution innerExecution;
    private final List<String> fieldNames;
    private final QueryStatistics queryStatistics;
    private final List<Map<String, Object>> queryResult;

    EagerQueryExecution(QuerySubscriber subscriber, QueryExecution innerExecution, QueryStatistics queryStatistics, List<Map<String, Object>> queryResult) {
        super(subscriber);
        this.innerExecution = innerExecution;
        this.fieldNames = Arrays.asList(innerExecution.fieldNames());
        this.queryStatistics = queryStatistics;
        this.queryResult = queryResult;
        try {
            subscriber.onResult(this.fieldNames.size());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public QueryExecutionType executionType() {
        return this.innerExecution.executionType();
    }

    public ExecutionPlanDescription executionPlanDescription() {
        return this.innerExecution.executionPlanDescription();
    }

    public Iterable<Notification> getNotifications() {
        return this.innerExecution.getNotifications();
    }

    public String[] fieldNames() {
        return this.innerExecution.fieldNames();
    }

    protected QueryStatistics queryStatistics() {
        return this.queryStatistics;
    }

    protected int resultSize() {
        return this.queryResult.size();
    }

    protected void materializeIfNecessary() {
    }

    protected void streamRecordToSubscriber(int servedRecords) throws Exception {
        Map<String, Object> currentRow = this.queryResult.get(servedRecords);
        int fieldNamesSize = this.fieldNames.size();
        for (int i = 0; i < fieldNamesSize; ++i) {
            this.subscriber.onField(i, (AnyValue)Values.of((Object)currentRow.get(this.fieldNames.get(i))));
        }
    }
}

