/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0002\u0004\u0001#!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003,\u0001\u0011\u0005C\u0006C\u0003,\u0001\u0011\u00053JA\u0011Fq\u0016\u001cW\u000f^8s\u0005\u0006\u001cX\rZ\"bM\u001a,\u0017N\\3DC\u000eDWMR1di>\u0014\u0018P\u0003\u0002\b\u0011\u0005)1-Y2iK*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033ii\u0011AB\u0005\u00037\u0019\u0011AcQ1gM\u0016Lg.Z\"bG\",g)Y2u_JL\u0018\u0001C3yK\u000e,Ho\u001c:\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013AC2p]\u000e,(O]3oi*\u0011!eI\u0001\u0005kRLGNC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019z\"\u0001C#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\tI#\u0006\u0005\u0002\u001a\u0001!)AD\u0001a\u0001;\u0005Y1M]3bi\u0016\u001c\u0015m\u00195f+\riS\b\u0012\u000b\u0003]\u0019\u0003BaL\u001d<\u00076\t\u0001G\u0003\u0002\bc)\u0011!gM\u0001\tG\u00064g-Z5oK*\u0011A'N\u0001\tE\u0016tW.\u00198fg*\u0011agN\u0001\u0007O&$\b.\u001e2\u000b\u0003a\n1aY8n\u0013\tQ\u0004GA\u0003DC\u000eDW\r\u0005\u0002={1\u0001A!\u0002 \u0004\u0005\u0004y$!A&\u0012\u0005\u0001\u0013\u0002CA\nB\u0013\t\u0011ECA\u0004O_RD\u0017N\\4\u0011\u0005q\"E!B#\u0004\u0005\u0004y$!\u0001,\t\u000b\u001d\u001b\u0001\u0019\u0001%\u0002\tML'0\u001a\t\u0003'%K!A\u0013\u000b\u0003\u0007%sG/F\u0002M\u001fF#B!\u0014*X9B!q&\u000f(Q!\tat\nB\u0003?\t\t\u0007q\b\u0005\u0002=#\u0012)Q\t\u0002b\u0001\u007f!)1\u000b\u0002a\u0001)\u00061A/[2lKJ\u0004\"aL+\n\u0005Y\u0003$A\u0002+jG.,'\u000fC\u0003Y\t\u0001\u0007\u0011,A\u0002ui2\u0004\"a\u0005.\n\u0005m#\"\u0001\u0002'p]\u001eDQa\u0012\u0003A\u0002!\u0003")
public class ExecutorBasedCaffeineCacheFactory
implements CaffeineCacheFactory {
    private final Executor executor;

    @Override
    public <K, V> Cache<K, V> createCache(int size) {
        return Caffeine.newBuilder().executor(this.executor).maximumSize((long)size).build();
    }

    @Override
    public <K, V> Cache<K, V> createCache(Ticker ticker, long ttl, int size) {
        return Caffeine.newBuilder().executor(this.executor).maximumSize((long)size).ticker(ticker).expireAfterWrite(ttl, TimeUnit.MILLISECONDS).build();
    }

    public ExecutorBasedCaffeineCacheFactory(Executor executor) {
        this.executor = executor;
    }
}

