/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Clock;
import java.util.List;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CompilerLibrary;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.DefaultPlanStalenessCaller;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.ReusabilityState;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator$;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CypherCacheFlushingMonitor;
import org.neo4j.cypher.internal.planning.CypherCacheHitMonitor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r\u001de\u0001\u0002\u001c8\u0001\u0001C\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0011\"a\u0006\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0015\u0005e\u0001A!b\u0001\n\u0003\tY\u0002\u0003\u0006\u0002(\u0001\u0011\t\u0011)A\u0005\u0003;A!\"!\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0016\u0011)\t\u0019\u0004\u0001B\u0001B\u0003%\u0011Q\u0006\u0005\u000b\u0003k\u0001!Q1A\u0005\u0002\u0005]\u0002BCA#\u0001\t\u0005\t\u0015!\u0003\u0002:!Q\u0011q\t\u0001\u0003\u0006\u0004%\t!!\u0013\t\u0015\u0005]\u0003A!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002Z\u0001\u0011)\u0019!C\u0001\u00037B!\"!\u001c\u0001\u0005\u0003\u0005\u000b\u0011BA/\u0011\u001d\ty\u0007\u0001C\u0001\u0003cB\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u0017C\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%I!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[Cq!!.\u0001\t\u0013\t9\fC\u0005\u0002T\u0002\u0011\r\u0011\"\u0003\u0002V\"A\u0011Q\u001c\u0001!\u0002\u0013\t9\u000eC\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002b\"A\u0011\u0011\u001e\u0001!\u0002\u0013\t\u0019\u000fC\u0005\u0002l\u0002\u0011\r\u0011\"\u0003\u0002n\"A\u0011Q\u001f\u0001!\u0002\u0013\ty\u000fC\u0005\u0002x\u0002\u0011\r\u0011\"\u0003\u0002z\"A!\u0011\u0001\u0001!\u0002\u0013\tY\u0010C\u0005\u0003\u0004\u0001\u0011\r\u0011\"\u0003\u0003\u0006!A!Q\u0002\u0001!\u0002\u0013\u00119\u0001C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\t=\u0001\u0001\"\u0001\u0003L!9!\u0011\u000f\u0001\u0005\u0002\tM\u0004b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005GDqA!>\u0001\t\u0013\u00119\u0010C\u0004\u0004\u0004\u0001!\ta!\u0002\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!911\u0003\u0001\u0005\u0002\rU\u0001bBB\u0015\u0001\u0011%11F\u0004\b\u00077:\u0004\u0012AB/\r\u00191t\u0007#\u0001\u0004`!9\u0011qN\u0019\u0005\u0002\r\u0005\u0004\"CB2c\t\u0007I\u0011AB3\u0011!\u0019i'\rQ\u0001\n\r\u001d\u0004\"CB8cE\u0005I\u0011AB9\u0005=)\u00050Z2vi&|g.\u00128hS:,'B\u0001\u001d:\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001e<\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A(P\u0001\u0006]\u0016|GG\u001b\u0006\u0002}\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u001e\u0002\r-,'O\\3m\u0013\tq5JA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!V\u001e\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002X)\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_o\u00059AO]1dS:<\u0017B\u00011^\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003-\u0019\u0017m\u00195f)J\f7-\u001a:\u0016\u0003\u0011\u00042!\u001a4i\u001b\u00059\u0014BA48\u0005-\u0019\u0015m\u00195f)J\f7-\u001a:\u0011\t%|\u0017\u000f`\u0007\u0002U*\u00111\u000e\\\u0001\u000bG>dG.Z2uS>t'BA7o\u0003\u001dAW\r\u001c9feNT!\u0001O\u001e\n\u0005AT'\u0001\u0002)bSJ\u0004\"A]=\u000f\u0005M<\bC\u0001;D\u001b\u0005)(B\u0001<@\u0003\u0019a$o\\8u}%\u0011\u0001pQ\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y\u0007B\u0019Q0!\u0005\u000f\u0007y\fiAD\u0002\u0000\u0003\u0017qA!!\u0001\u0002\n9!\u00111AA\u0004\u001d\r!\u0018QA\u0005\u0002}%\u0011A(P\u0005\u0003umJ!\u0001O\u001d\n\u0007\u0005=q'\u0001\u0006Rk\u0016\u0014\u0018pQ1dQ\u0016LA!a\u0005\u0002\u0016\t\u0001\u0002+\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r\u001d\u0006\u0004\u0003\u001f9\u0014\u0001D2bG\",GK]1dKJ\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002\u001eA!\u0011qDA\u0012\u001b\t\t\tCC\u0002\u0002\u001a]JA!!\n\u0002\"\t\u00192)\u001f9iKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8gS\u001e\u0004\u0013aD2p[BLG.\u001a:MS\n\u0014\u0018M]=\u0016\u0005\u00055\u0002cA3\u00020%\u0019\u0011\u0011G\u001c\u0003\u001f\r{W\u000e]5mKJd\u0015N\u0019:bef\f\u0001cY8na&dWM\u001d'jEJ\f'/\u001f\u0011\u0002\u0019\r\f7\r[3GC\u000e$xN]=\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}r'A\u0003dC\u000eDW-\u0003\u0003\u0002D\u0005u\"\u0001F\"bM\u001a,\u0017N\\3DC\u000eDWMR1di>\u0014\u00180A\u0007dC\u000eDWMR1di>\u0014\u0018\u0010I\u0001\fY><\u0007K]8wS\u0012,'/\u0006\u0002\u0002LA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Rm\nq\u0001\\8hO&tw-\u0003\u0003\u0002V\u0005=#a\u0003'pOB\u0013xN^5eKJ\fA\u0002\\8h!J|g/\u001b3fe\u0002\nQa\u00197pG.,\"!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005!A/[7f\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002t\u0005U\u0014qOA=\u0003w\ni(a \u0002\u0002\u0006\r\u0015Q\u0011\t\u0003K\u0002AQaR\nA\u0002%CQ\u0001U\nA\u0002ICQ!W\nA\u0002mCQAY\nA\u0002\u0011Dq!!\u0007\u0014\u0001\u0004\ti\u0002C\u0004\u0002*M\u0001\r!!\f\t\u000f\u0005U2\u00031\u0001\u0002:!9\u0011qI\nA\u0002\u0005-\u0003\"CA-'A\u0005\t\u0019AA/\u0003q!WMZ1vYR\fV/\u001a:z\u000bb,7-\u001e;j_:luN\\5u_J,\"!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006)\u0011/^3ss*\u0019\u0011QS&\u0002\t%l\u0007\u000f\\\u0005\u0005\u00033\u000byIA\u000bRk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:\u0002;\u0011,g-Y;miF+XM]=Fq\u0016\u001cW\u000f^5p]6{g.\u001b;pe\u0002\n\u0011\u0002\u001d:f!\u0006\u00148/\u001a:\u0016\u0005\u0005\u0005\u0006cA3\u0002$&\u0019\u0011QU\u001c\u0003\u0013A\u0013X\rU1sg\u0016\u0014\u0018A\u00039sKB\u000b'o]3sA\u0005IB.Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s+\t\ti\u000bE\u0002f\u0003_K1!!-8\u0005ea\u0015m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u000251\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM\u001d\u0011\u0002!Ad\u0017M\u001c*fkN\f'-\u001b7ji&LHCBA]\u0003\u007f\u000bI\rE\u0002f\u0003wK1!!08\u0005A\u0011V-^:bE&d\u0017\u000e^=Ti\u0006$X\rC\u0004\u0002Bj\u0001\r!a1\u0002\u001f\u0015DXmY;uC\ndW-U;fef\u00042!ZAc\u0013\r\t9m\u000e\u0002\u0010\u000bb,7-\u001e;bE2,\u0017+^3ss\"9\u00111\u001a\u000eA\u0002\u00055\u0017\u0001\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0006=\u0017\u0002BAi\u0003\u001f\u0013A\u0003\u0016:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\u0018a\u00017pOV\u0011\u0011q\u001b\t\u0005\u0003\u001b\nI.\u0003\u0003\u0002\\\u0006=#a\u0001'pO\u0006!An\\4!\u0003M\u0001H.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s+\t\t\u0019\u000fE\u0003f\u0003K\f\u0019-C\u0002\u0002h^\u0012!\u0004R3gCVdG\u000f\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\fA\u0003\u001d7b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\u0013AC9vKJL8)Y2iKV\u0011\u0011q\u001e\t\bK\u0006E\u0018\u000f[Ab\u0013\r\t\u0019p\u000e\u0002\u000b#V,'/_\"bG\",\u0017aC9vKJL8)Y2iK\u0002\na\"\\1ti\u0016\u00148i\\7qS2,'/\u0006\u0002\u0002|B\u0019Q-!@\n\u0007\u0005}xG\u0001\bNCN$XM]\"p[BLG.\u001a:\u0002\u001f5\f7\u000f^3s\u0007>l\u0007/\u001b7fe\u0002\nAb]2iK6\f\u0007*\u001a7qKJ,\"Aa\u0002\u0011\u0007\u0015\u0014I!C\u0002\u0003\f]\u0012AbU2iK6\f\u0007*\u001a7qKJ\fQb]2iK6\f\u0007*\u001a7qKJ\u0004\u0013aB3yK\u000e,H/\u001a\u000b\u000f\u0005'\u0011IBa\u0007\u00030\tM\"Q\bB!!\u0011\tiI!\u0006\n\t\t]\u0011q\u0012\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u0019\t\t*\na\u0001c\"9!QD\u0013A\u0002\t}\u0011A\u00029be\u0006l7\u000f\u0005\u0003\u0003\"\t-RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\u000fYL'\u000f^;bY*\u0019!\u0011F\u001e\u0002\rY\fG.^3t\u0013\u0011\u0011iCa\t\u0003\u00115\u000b\u0007OV1mk\u0016DqA!\r&\u0001\u0004\ti-A\u0004d_:$X\r\u001f;\t\u000f\tUR\u00051\u0001\u00038\u00059\u0001O]8gS2,\u0007c\u0001\"\u0003:%\u0019!1H\"\u0003\u000f\t{w\u000e\\3b]\"9!qH\u0013A\u0002\t]\u0012a\u00039sKB{\u0007/\u001e7bi\u0016DqAa\u0011&\u0001\u0004\u0011)%\u0001\u0006tk\n\u001c8M]5cKJ\u0004B!!$\u0003H%!!\u0011JAH\u0005=\tV/\u001a:z'V\u00147o\u0019:jE\u0016\u0014H\u0003\u0005B\n\u0005\u001b\u0012)Fa\u0016\u0003Z\tm#1\u000eB8\u0011\u001d\t\tJ\na\u0001\u0005\u001f\u00022!\u001aB)\u0013\r\u0011\u0019f\u000e\u0002\u0011\rVdG.\u001f)beN,G-U;fefDqA!\b'\u0001\u0004\u0011y\u0002C\u0004\u00032\u0019\u0002\r!!4\t\u000f\t}b\u00051\u0001\u00038!9!Q\f\u0014A\u0002\t}\u0013!B5oaV$\b\u0003\u0002B1\u0005Oj!Aa\u0019\u000b\u0007\t\u0015t'A\u0004sk:$\u0018.\\3\n\t\t%$1\r\u0002\u0010\u0013:\u0004X\u000f\u001e#bi\u0006\u001cFO]3b[\"9!Q\u000e\u0014A\u0002\u0005-\u0015\u0001D9vKJLXj\u001c8ji>\u0014\bb\u0002B\"M\u0001\u0007!QI\u0001\u0010Kb,7-\u001e;f'V\u0014\u0017+^3ssR\u0001\"1\u0003B;\u0005o\u0012IHa\u001f\u0003\u0000\t\u0005%1\u0011\u0005\u0007\u0003#;\u0003\u0019A9\t\u000f\tuq\u00051\u0001\u0003 !9!\u0011G\u0014A\u0002\u00055\u0007b\u0002B?O\u0001\u0007!qG\u0001\u0011SN|U\u000f^3s[>\u001cH/U;fefDqA!\u000e(\u0001\u0004\u00119\u0004C\u0004\u0003@\u001d\u0002\rAa\u000e\t\u000f\t\rs\u00051\u0001\u0003F\u000591\r\\8tS:<W\u0003\u0002BE\u0005##bAa#\u0003.\n=F\u0003\u0002BG\u0005G\u0003BAa$\u0003\u00122\u0001Aa\u0002BJQ\t\u0007!Q\u0013\u0002\u0002)F!!q\u0013BO!\r\u0011%\u0011T\u0005\u0004\u00057\u001b%a\u0002(pi\"Lgn\u001a\t\u0004\u0005\n}\u0015b\u0001BQ\u0007\n\u0019\u0011I\\=\t\u0011\t\u0015\u0006\u0006\"a\u0001\u0005O\u000bAaY8eKB)!I!+\u0003\u000e&\u0019!1V\"\u0003\u0011q\u0012\u0017P\\1nKzBqA!\r)\u0001\u0004\ti\rC\u0004\u00032\"\u0002\rAa-\u0002\u0015Q\u0014\u0018mY3Fm\u0016tG\u000f\u0005\u0003\u00036\n}f\u0002\u0002B\\\u0005ws1A B]\u0013\tqv'C\u0002\u0003>v\u000b\u0011cQ8na&d\u0017\r^5p]R\u0013\u0018mY3s\u0013\u0011\u0011\tMa1\u0003+E+XM]=D_6\u0004\u0018\u000e\\1uS>tWI^3oi*\u0019!QX/\u0002\u0013\u0011|W\t_3dkR,G\u0003\u0006B\n\u0005\u0013\u0014\tNa5\u0003V\n]'\u0011\u001cBn\u0005;\u0014y\u000eC\u0004\u0002\u0012&\u0002\rAa3\u0011\u0007\u0015\u0014i-C\u0002\u0003P^\u0012!\"\u00138qkR\fV/\u001a:z\u0011\u001d\u0011i\"\u000ba\u0001\u0005?AqA!\r*\u0001\u0004\ti\rC\u0004\u0003~%\u0002\rAa\u000e\t\u000f\t}\u0012\u00061\u0001\u00038!9!QL\u0015A\u0002\t}\u0003b\u0002B7S\u0001\u0007\u00111\u0012\u0005\u00073&\u0002\rAa-\t\u000f\t\r\u0013\u00061\u0001\u0003F\u0005\u00193m\\7qS2,'oV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+gn\u00149uS>tGC\u0003Bs\u0005W\u0014yO!=\u0003tB)QMa:\u0002D&\u0019!\u0011^\u001c\u0003G\r{W\u000e]5mKJ<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:|\u0005\u000f^5p]\"9!Q\u001e\u0016A\u0002\t-\u0017AC5oaV$\u0018+^3ss\"1\u0011L\u000ba\u0001\u0005gCq!a3+\u0001\u0004\ti\rC\u0004\u0003\u001e)\u0002\rAa\b\u0002\u0019\u001d,Go\u0014:D_6\u0004\u0018\u000e\\3\u0015\u0015\u0005\r'\u0011 B~\u0005\u007f\u001c\t\u0001C\u0004\u00032-\u0002\r!!4\t\u000f\tu8\u00061\u0001\u0003L\u0006\t\u0012N\\5uS\u0006d\u0017J\u001c9viF+XM]=\t\re[\u0003\u0019\u0001BZ\u0011\u001d\u0011ib\u000ba\u0001\u0005?\t\u0001c\u00197fCJ\fV/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0015\u0005\r\u001d\u0001c\u0001\"\u0004\n%\u001911B\"\u0003\t1{gnZ\u0001\u0011SN\u0004VM]5pI&\u001c7i\\7nSR$BAa\u000e\u0004\u0012!1\u0011\u0011S\u0017A\u0002E\f!cZ3u\u0007f\u0004\b.\u001a:Gk:\u001cG/[8ogV\u00111q\u0003\t\u0007\u00073\u0019yba\t\u000e\u0005\rm!\u0002BB\u000f\u0003K\nA!\u001e;jY&!1\u0011EB\u000e\u0005\u0011a\u0015n\u001d;\u0011\t\u000555QE\u0005\u0005\u0007O\tyIA\nGk:\u001cG/[8o\u0013:4wN]7bi&|g.A\bdQ\u0016\u001c7\u000eU1sC6,G/\u001a:t)!\u0019ica\r\u0004>\r\u0005\u0003c\u0001\"\u00040%\u00191\u0011G\"\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007ky\u0003\u0019AB\u001c\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\u0011\t\t\u001bI$]\u0005\u0004\u0007w\u0019%!B!se\u0006L\bbBB _\u0001\u0007!qD\u0001\fO&4XM\u001c)be\u0006l7\u000fC\u0004\u0004D=\u0002\rAa\b\u0002\u001f\u0015DHO]1di\u0016$\u0007+\u0019:b[NDSaLB$\u00073\u0002RAQB%\u0007\u001bJ1aa\u0013D\u0005\u0019!\bN]8xgB!1qJB+\u001b\t\u0019\tFC\u0002\u0004Tm\n!\"\u001a=dKB$\u0018n\u001c8t\u0013\u0011\u00199f!\u0015\u00035A\u000b'/Y7fi\u0016\u0014hj\u001c;G_VtG-\u0012=dKB$\u0018n\u001c8$\u0005\r5\u0013aD#yK\u000e,H/[8o\u000b:<\u0017N\\3\u0011\u0005\u0015\f4CA\u0019B)\t\u0019i&A\nQ\u0019\u0006suLQ+J\u0019\u0012KejR0U%&+5+\u0006\u0002\u0004hA\u0019!i!\u001b\n\u0007\r-4IA\u0002J]R\fA\u0003\u0015'B\u001d~\u0013U+\u0013'E\u0013:;u\f\u0016*J\u000bN\u0003\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004t)\"\u0011QLB;W\t\u00199\b\u0005\u0003\u0004z\r\rUBAB>\u0015\u0011\u0019iha \u0002\u0013Ut7\r[3dW\u0016$'bABA\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001551\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer;
    private final CypherConfiguration config;
    private final CompilerLibrary compilerLibrary;
    private final CaffeineCacheFactory cacheFactory;
    private final LogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final PreParser preParser;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;
    private final Log org$neo4j$cypher$internal$ExecutionEngine$$log;
    private final DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller;
    private final QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache;
    private final MasterCompiler masterCompiler;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$9() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$9();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer() {
        return this.cacheTracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public CompilerLibrary compilerLibrary() {
        return this.compilerLibrary;
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    private QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private PreParser preParser() {
        return this.preParser;
    }

    private LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    private ReusabilityState planReusabilitiy(ExecutableQuery executableQuery, TransactionalContext transactionalContext) {
        return executableQuery.reusabilityState((Function0<Object>)this.lastCommittedTxIdProvider(), transactionalContext);
    }

    public Log org$neo4j$cypher$internal$ExecutionEngine$$log() {
        return this.org$neo4j$cypher$internal$ExecutionEngine$$log;
    }

    private DefaultPlanStalenessCaller<ExecutableQuery> planStalenessCaller() {
        return this.planStalenessCaller;
    }

    private QueryCache<String, Pair<String, QueryCache.ParameterTypeMap>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        this.defaultQueryExecutionMonitor().startProcessing(context.executingQuery());
        return this.executeSubQuery(query, params, context, true, profile, prePopulate, subscriber);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber));
    }

    public QueryExecution executeSubQuery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable & scala.Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.compilerLibrary().supportsAdministrativeCommands();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, profile, couldContainSensitiveFields);
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, this.defaultQueryExecutionMonitor(), queryTracer, subscriber);
        });
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable t) {
                context.rollback();
                throw t;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block4: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params);
            }
            catch (Throwable up) {
                if (isOutermostQuery) {
                    queryMonitor.endFailure(context.executingQuery(), up.getMessage());
                }
                throw up;
            }
            executableQuery = executableQuery2;
            String string = query.options().queryOptions().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block4;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.queryType(), executableQuery.planDescriptionSupplier());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params) {
        Function0 & Serializable & scala.Serializable compiledExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params);
        Function0 & Serializable & scala.Serializable interpretedExpressionCompiler = (Function0 & Serializable & scala.Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0 ? (ExecutableQuery)this.compiledExpressionCompiler$1.apply() : (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount) {
                return this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() ? new Some(this.compiledExpressionCompiler$1.apply()) : None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                Pair cacheKey = Pair.of((Object)initialInputQuery.cacheKey(), (Object)QueryCache$.MODULE$.extractParameterTypeMap(params));
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params);
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale((Pair<String, QueryCache.ParameterTypeMap>)cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()})).max((Ordering)Ordering.Long$.MODULE$));
    }

    public boolean isPeriodicCommit(String query) {
        PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, this.preParser().preParseQuery$default$2(), this.preParser().preParseQuery$default$3());
        CypherExecutionMode cypherExecutionMode = preParsedQuery.options().queryOptions().executionMode();
        CypherExecutionMode.explain$ explain$2 = CypherExecutionMode.explain$.MODULE$;
        return (cypherExecutionMode == null ? explain$2 != null : !cypherExecutionMode.equals(explain$2)) && preParsedQuery.options().isPeriodicCommit();
    }

    public List<FunctionInformation> getCypherFunctions() {
        Seq informations = (Seq)Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, List$.MODULE$.canBuildFrom());
        Seq predicateInformations = (Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$, Seq$.MODULE$.canBuildFrom());
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)informations.$plus$plus((GenTraversableOnce)predicateInformations, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryParams)).filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key))))).distinct();
            throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missingKeys)).mkString(", ")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CacheTracer<Pair<String, QueryCache.ParameterTypeMap>> cacheTracer, CypherConfiguration config, CompilerLibrary compilerLibrary, CaffeineCacheFactory cacheFactory, LogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.cacheTracer = cacheTracer;
        this.config = config;
        this.compilerLibrary = compilerLibrary;
        this.cacheFactory = cacheFactory;
        this.logProvider = logProvider;
        this.clock = clock;
        Predef$.MODULE$.require(queryService != null, (Function0 & Serializable & scala.Serializable)() -> "Can't work with a null graph database");
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new PreParser(config, cacheFactory);
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(queryService);
        this.org$neo4j$cypher$internal$ExecutionEngine$$log = logProvider.getLog(this.getClass());
        kernelMonitors.addMonitorListener((Object)new ExecutionEngineQueryCacheMonitor(this){
            private final /* synthetic */ ExecutionEngine $outer;

            public void cacheFlushDetected(long sizeBeforeFlush) {
                CypherCacheFlushingMonitor.cacheFlushDetected$(this, sizeBeforeFlush);
            }

            public void cacheHit(Object key) {
                CypherCacheHitMonitor.cacheHit$(this, key);
            }

            public void cacheMiss(Object key) {
                CypherCacheHitMonitor.cacheMiss$(this, key);
            }

            public void cacheCompile(Object key) {
                CypherCacheHitMonitor.cacheCompile$(this, key);
            }

            public void cacheCompileWithExpressionCodeGen(Object key) {
                CypherCacheHitMonitor.cacheCompileWithExpressionCodeGen$(this, key);
            }

            public void cacheDiscard(Pair<String, QueryCache.ParameterTypeMap> ignored, String queryId, int secondsSinceReplan, Option<String> maybeReason) {
                this.$outer.org$neo4j$cypher$internal$ExecutionEngine$$log().info(new StringBuilder(69).append("Discarded stale query from the query cache after ").append(secondsSinceReplan).append(" seconds").append(maybeReason.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)r -> new StringBuilder(10).append(". Reason: ").append((String)r).toString())).append(". Query id: ").append(queryId).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                CypherCacheHitMonitor.$init$(this);
                CypherCacheFlushingMonitor.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cacheDiscard$1(), $anonfun$cacheDiscard$2(java.lang.String )}, serializedLambda);
            }
        }, new String[0]);
        this.planStalenessCaller = new DefaultPlanStalenessCaller(clock, StatsDivergenceCalculator$.MODULE$.divergenceCalculatorFor(config.statsDivergenceCalculator()), (Function0<Object>)this.lastCommittedTxIdProvider(), (Function2 & Serializable & scala.Serializable)(executableQuery, transactionalContext) -> this.planReusabilitiy((ExecutableQuery)executableQuery, (TransactionalContext)transactionalContext), this.org$neo4j$cypher$internal$ExecutionEngine$$log());
        this.queryCache = new QueryCache(cacheFactory, config.queryCacheSize(), this.planStalenessCaller(), cacheTracer);
        this.masterCompiler = new MasterCompiler(compilerLibrary);
        this.schemaHelper = new SchemaHelper(this.queryCache());
    }
}

