/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.CreateFulltextIndexOptions;
import org.neo4j.cypher.internal.IndexOptionsConverter;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CreateFulltextIndexOptionsConverter$
implements IndexOptionsConverter<CreateFulltextIndexOptions>,
Product,
scala.Serializable {
    public static CreateFulltextIndexOptionsConverter$ MODULE$;
    private final ExpressionEvaluator evaluator;

    static {
        new CreateFulltextIndexOptionsConverter$();
    }

    @Override
    public Tuple2<Option<AnyValue>, IndexConfig> getOptionsParts(MapValue options, String schemaType) {
        return IndexOptionsConverter.getOptionsParts$(this, options, schemaType);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) {
        return OptionsConverter.evaluate$(this, expression, params);
    }

    @Override
    public Option<CreateFulltextIndexOptions> convert(Options options, MapValue params) {
        return OptionsConverter.convert$(this, options, params);
    }

    @Override
    public ExpressionEvaluator evaluator() {
        return this.evaluator;
    }

    @Override
    public void org$neo4j$cypher$internal$OptionsConverter$_setter_$evaluator_$eq(ExpressionEvaluator x$1) {
        this.evaluator = x$1;
    }

    @Override
    public CreateFulltextIndexOptions convert(MapValue options) {
        Tuple2<Option<AnyValue>, IndexConfig> tuple2 = this.getOptionsParts(options, "fulltext index");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option maybeIndexProvider = (Option)tuple2._1();
        IndexConfig indexConfig = (IndexConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)indexConfig);
        Tuple2 tuple23 = tuple22;
        Option maybeIndexProvider2 = (Option)tuple23._1();
        IndexConfig indexConfig2 = (IndexConfig)tuple23._2();
        Option indexProvider2 = maybeIndexProvider2.map((Function1 & Serializable & scala.Serializable)indexProvider -> MODULE$.assertValidIndexProvider((AnyValue)indexProvider));
        return new CreateFulltextIndexOptions((Option<IndexProviderDescriptor>)indexProvider2, indexConfig2);
    }

    private IndexProviderDescriptor assertValidIndexProvider(AnyValue indexProvider) {
        AnyValue anyValue = indexProvider;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            String indexProviderString = textValue.stringValue();
            if (indexProviderString.equalsIgnoreCase(GenericNativeIndexProvider.DESCRIPTOR.name()) || indexProviderString.equalsIgnoreCase(NativeLuceneFusionIndexProviderFactory30.DESCRIPTOR.name())) {
                throw new InvalidArgumentsException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("Could not create fulltext index with specified index provider '").append(indexProviderString).append("'.\n             |To create btree index, please use 'CREATE INDEX ...'.").toString())).stripMargin());
            }
            if (!indexProviderString.equalsIgnoreCase(FulltextIndexProviderFactory.DESCRIPTOR.name())) {
                throw new InvalidArgumentsException(new StringBuilder(65).append("Could not create fulltext index with specified index provider '").append(indexProviderString).append("'.").toString());
            }
        } else {
            throw new InvalidArgumentsException(new StringBuilder(88).append("Could not create fulltext index with specified index provider '").append(indexProvider).append("'. Expected String value.").toString());
        }
        IndexProviderDescriptor indexProviderDescriptor = FulltextIndexProviderFactory.DESCRIPTOR;
        return indexProviderDescriptor;
    }

    @Override
    public Map<String, Object> assertValidAndTransformConfig(AnyValue config, String schemaType) {
        MapValue mapValue;
        AnyValue anyValue = config;
        if (anyValue instanceof MapValue) {
            mapValue = (MapValue)anyValue;
            if (MapValueOps$.MODULE$.Ops(mapValue).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CreateFulltextIndexOptionsConverter$.$anonfun$assertValidAndTransformConfig$4(x0$1)))) {
                PrettyPrinter pp = new PrettyPrinter();
                mapValue.writeTo((AnyValueWriter)pp);
                throw new InvalidArgumentsException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(164).append("Could not create fulltext index with specified index config '").append(pp.value()).append("', contains btree config options.\n               |To create btree index, please use 'CREATE INDEX ...'.").toString())).stripMargin());
            }
        } else {
            throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2(anyValue);
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        mapValue.foreach((x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                String p = (String)tuple2._1();
                AnyValue e = (AnyValue)tuple2._2();
                if (p != null) {
                    String string = p;
                    if (e instanceof TextValue) {
                        TextValue textValue = (TextValue)e;
                        hm.put(string, textValue.stringValue());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
            if (tuple2 == null) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue);
            String p = (String)tuple2._1();
            AnyValue e = (AnyValue)tuple2._2();
            if (p == null) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue);
            String string = p;
            if (!(e instanceof BooleanValue)) throw CreateFulltextIndexOptionsConverter$.exceptionWrongType$2((AnyValue)mapValue);
            BooleanValue booleanValue = (BooleanValue)e;
            hm.put(string, booleanValue.booleanValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        HashMap<String, Object> hashMap = hm;
        return hashMap;
    }

    @Override
    public String operation() {
        return "create fulltext index";
    }

    public String productPrefix() {
        return "CreateFulltextIndexOptionsConverter";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateFulltextIndexOptionsConverter$;
    }

    public int hashCode() {
        return -612267268;
    }

    public String toString() {
        return "CreateFulltextIndexOptionsConverter";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final InvalidArgumentsException exceptionWrongType$2(AnyValue suppliedValue) {
        PrettyPrinter pp = new PrettyPrinter();
        suppliedValue.writeTo((AnyValueWriter)pp);
        return new InvalidArgumentsException(new StringBuilder(115).append("Could not create fulltext index with specified index config '").append(pp.value()).append("'. Expected a map from String to Strings and Booleans.").toString());
    }

    public static final /* synthetic */ boolean $anonfun$assertValidAndTransformConfig$4(Tuple2 x0$1) {
        String p;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null || (p = (String)tuple2._1()) == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = p;
        boolean bl = string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MAX.getSettingName());
        return bl;
    }

    private CreateFulltextIndexOptionsConverter$() {
        MODULE$ = this;
        OptionsConverter.$init$(this);
        IndexOptionsConverter.$init$(this);
        Product.$init$((Product)this);
    }
}

