/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheTracer;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B+W\u0001}C\u0001b\u001a\u0001\u0003\u0006\u0004%\t\u0001\u001b\u0005\t_\u0002\u0011\t\u0011)A\u0005S\"A\u0001\u000f\u0001BC\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003s\u0011!1\bA!b\u0001\n\u00039\b\"CA\b\u0001\t\u0005\t\u0015!\u0003y\u0011)\t\t\u0002\u0001BC\u0002\u0013\u0005\u00111\u0003\u0005\u000b\u0003G\u0001!\u0011!Q\u0001\n\u0005U\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kA\u0001\"!+\u0001A\u0003%\u0011q\u0007\u0004\u0007\u0003+\u0002A!a\u0016\t\u0015\u0005eCB!b\u0001\n\u0003\tY\u0006C\u0005\u0002^1\u0011\t\u0011)A\u0005y\"Q\u0011q\f\u0007\u0003\u0006\u0004%\t!!\u0019\t\u0015\u0005%DB!A!\u0002\u0013\t\u0019\u0007C\u0004\u0002&1!\t!a\u001b\t\u0011\u0005ED\u00021A\u0005\nED\u0011\"a\u001d\r\u0001\u0004%I!!\u001e\t\u000f\u0005\u0005E\u0002)Q\u0005e\"9\u00111\u0012\u0007\u0005\u0002\u00055\u0005BBAH\u0019\u0011\u0005\u0011\u000fC\u0004\u0002\u00122!\t!a%\t\u000f\u0005}E\u0002\"\u0011\u0002\"\"9\u0011Q\u0015\u0007\u0005B\u0005\u001d\u0006bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\n\u0003\u007f\u0004\u0011\u0013!C\u0001\u0005\u0003AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003\"\u0001!IAa\t\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!1\t\u0001\u0005\n\t\u0015\u0003\"\u0003B)\u0001E\u0005I\u0011\u0002B*\u0011\u001d\u00119\u0006\u0001C\u0005\u00053B\u0011Ba\u0019\u0001#\u0003%IAa\u0015\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005#\u0003A\u0011\u0001BJ\u000f\u001d\u0011YJ\u0016E\u0001\u0005;3a!\u0016,\t\u0002\t}\u0005bBA\u0013Q\u0011\u0005!\u0011\u0015\u0004\u0007\u0005GC#I!*\t\u0015\tU&F!f\u0001\n\u0003\u00119\f\u0003\u0006\u0003B*\u0012\t\u0012)A\u0005\u0005sC!Ba1+\u0005+\u0007I\u0011\u0001Bc\u0011)\u0019iA\u000bB\tB\u0003%!q\u0019\u0005\u000b\u0007\u001fQ#Q3A\u0005\u0002\u0005\u0005\u0004BCB\tU\tE\t\u0015!\u0003\u0002d!9\u0011Q\u0005\u0016\u0005\u0002\rM\u0001\"CB\u000fU\u0005\u0005I\u0011AB\u0010\u0011%\u0019yCKI\u0001\n\u0003\u0019\t\u0004C\u0005\u0004:)\n\n\u0011\"\u0001\u0004<!I11\t\u0016\u0012\u0002\u0013\u00051Q\t\u0005\n\u0007\u0013R\u0013\u0011!C!\u0007\u0017B\u0001ba\u0016+\u0003\u0003%\t!\u001d\u0005\n\u00073R\u0013\u0011!C\u0001\u00077B\u0011ba\u0018+\u0003\u0003%\te!\u0019\t\u0013\u0005E%&!A\u0005\u0002\r=\u0004\"CASU\u0005\u0005I\u0011IAT\u0011%\u0019IAKA\u0001\n\u0003\u001a\u0019\bC\u0005\u0002 *\n\t\u0011\"\u0011\u0004v\u001dI1\u0011\u0010\u0015\u0002\u0002#\u000511\u0010\u0004\n\u0005GC\u0013\u0011!E\u0001\u0007{Bq!!\n@\t\u0003\u0019y\bC\u0005\u0004\n}\n\t\u0011\"\u0012\u0004t!I1\u0011Q \u0002\u0002\u0013\u000551\u0011\u0005\n\u0007'{\u0014\u0011!CA\u0007+C\u0011ba,@\u0003\u0003%Ia!-\t\u0013\re\u0006F1A\u0005\u0002\rm\u0006\u0002CBbQ\u0001\u0006Ia!0\u0007\r\t-\u0007\u0006\u0001Bg\u0011)\u0011ym\u0012BC\u0002\u0013%!\u0011\u001b\u0005\u000b\u0005_<%\u0011!Q\u0001\n\tM\u0007\"\u0003By\u000f\n\u0005\t\u0015!\u0003s\u0011!\t)c\u0012C\u0001Q\tM\bbBAS\u000f\u0012\u0005\u0013q\u0015\u0005\b\u0003?;E\u0011IB\u0002\u0011\u001d\u0019Ia\u0012C!\u0007\u00179qa!2)\u0011\u0003\u00199MB\u0004\u0003L\"B\ta!3\t\u000f\u0005\u0015\u0002\u000b\"\u0001\u0004L\"I1Q\u001a)C\u0002\u0013\u0015!Q\u0019\u0005\t\u0007\u001f\u0004\u0006\u0015!\u0004\u0003H\"91\u0011\u001b\u0015\u0005\u0002\rM'AC)vKJL8)Y2iK*\u0011q\u000bW\u0001\tS:$XM\u001d8bY*\u0011\u0011LW\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005mc\u0016!\u00028f_RR'\"A/\u0002\u0007=\u0014xm\u0001\u0001\u0016\t\u0001\fiB`\n\u0003\u0001\u0005\u0004\"AY3\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014a!\u00118z%\u00164\u0017\u0001D2bG\",g)Y2u_JLX#A5\u0011\u0005)lW\"A6\u000b\u000514\u0016!B2bG\",\u0017B\u00018l\u0005Q\u0019\u0015M\u001a4fS:,7)Y2iK\u001a\u000b7\r^8ss\u0006i1-Y2iK\u001a\u000b7\r^8ss\u0002\n1\"\\1yS6,XnU5{KV\t!\u000f\u0005\u0002cg&\u0011Ao\u0019\u0002\u0004\u0013:$\u0018\u0001D7bq&lW/\\*ju\u0016\u0004\u0013aD:uC2,g.Z:t\u0007\u0006dG.\u001a:\u0016\u0003a\u00042!\u001f>}\u001b\u00051\u0016BA>W\u0005M\u0001F.\u00198Ti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s!\tih\u0010\u0004\u0001\u0005\r}\u0004!\u0019AA\u0001\u0005A)\u0005,R\"V)\u0006\u0013E*R0R+\u0016\u0013\u0016,\u0005\u0003\u0002\u0004\u0005%\u0001c\u00012\u0002\u0006%\u0019\u0011qA2\u0003\u000f9{G\u000f[5oOB\u0019\u00110a\u0003\n\u0007\u00055aK\u0001\tDC\u000eDW-\u00192jY&$\u00180\u00138g_\u0006\u00012\u000f^1mK:,7o]\"bY2,'\u000fI\u0001\u0007iJ\f7-\u001a:\u0016\u0005\u0005U\u0001#B=\u0002\u0018\u0005m\u0011bAA\r-\nY1)Y2iKR\u0013\u0018mY3s!\ri\u0018Q\u0004\u0003\b\u0003?\u0001!\u0019AA\u0011\u0005%\tV+\u0012*Z?.+\u0015,E\u0002\u0002\u0004\u0005\fq\u0001\u001e:bG\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003S\tY#!\f\u00020\u0005E\u0002#B=\u0001\u00037a\b\"B4\n\u0001\u0004I\u0007\"\u00029\n\u0001\u0004\u0011\b\"\u0002<\n\u0001\u0004A\bbBA\t\u0013\u0001\u0007\u0011QC\u0001\u0006S:tWM]\u000b\u0003\u0003o\u0001\u0002\"!\u000f\u0002N\u0005m\u0011\u0011K\u0007\u0003\u0003wQ1\u0001\\A\u001f\u0015\u0011\ty$!\u0011\u0002\u0011\r\fgMZ3j]\u0016TA!a\u0011\u0002F\u0005A!-\u001a8nC:,7O\u0003\u0003\u0002H\u0005%\u0013AB4ji\",(M\u0003\u0002\u0002L\u0005\u00191m\\7\n\t\u0005=\u00131\b\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0004\u0003'bQ\"\u0001\u0001\u0003\u0017\r\u000b7\r[3e-\u0006dW/Z\n\u0003\u0019\u0005\fQA^1mk\u0016,\u0012\u0001`\u0001\u0007m\u0006dW/\u001a\u0011\u0002?I,7m\\7qS2,GmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g.\u0006\u0002\u0002dA\u0019!-!\u001a\n\u0007\u0005\u001d4MA\u0004C_>dW-\u00198\u0002AI,7m\\7qS2,GmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g\u000e\t\u000b\u0007\u0003#\ni'a\u001c\t\r\u0005e\u0013\u00031\u0001}\u0011\u001d\ty&\u0005a\u0001\u0003G\nQb\u00188v[\n,'o\u00144ISR\u001c\u0018!E0ok6\u0014WM](g\u0011&$8o\u0018\u0013fcR!\u0011qOA?!\r\u0011\u0017\u0011P\u0005\u0004\u0003w\u001a'\u0001B+oSRD\u0001\"a \u0014\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0014AD0ok6\u0014WM](g\u0011&$8\u000f\t\u0015\u0004)\u0005\u0015\u0005c\u00012\u0002\b&\u0019\u0011\u0011R2\u0003\u0011Y|G.\u0019;jY\u0016\fq!\\1sW\"KG\u000f\u0006\u0002\u0002x\u0005aa.^7cKJ|e\rS5ug\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002d\u0005U\u0005bBAL/\u0001\u0007\u0011\u0011T\u0001\u0006_RDWM\u001d\t\u0004E\u0006m\u0015bAAOG\n\u0019\u0011I\\=\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019'a)\t\u000f\u0005]\u0005\u00041\u0001\u0002\u001a\u0006A\u0001.Y:i\u0007>$W\rF\u0001s\u0003\u0019IgN\\3sA\u000512m\\7qkR,\u0017JZ!cg\u0016tGo\u0014:Ti\u0006dW\rF\u0006}\u0003_\u000b\u0019,a3\u0002V\u0006\u0015\bbBAY5\u0001\u0007\u00111D\u0001\tcV,'/_&fs\"9\u0011Q\u0017\u000eA\u0002\u0005]\u0016A\u0001;d!\u0011\tI,a2\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bQ!];fefTA!!1\u0002D\u0006!\u0011.\u001c9m\u0015\r\t)MW\u0001\u0007W\u0016\u0014h.\u001a7\n\t\u0005%\u00171\u0018\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000f\u00055'\u00041\u0001\u0002P\u0006A1m\\7qS2,'\u000f\u0005\u0003z\u0003#d\u0018bAAj-\n\u00193i\\7qS2,'oV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+gn\u00149uS>t\u0007bBAl5\u0001\u0007\u0011\u0011\\\u0001\u000fe\u0016\u0004H.\u00198TiJ\fG/Z4z!\u0011\tY.!9\u000e\u0005\u0005u'bAAp-\u00069q\u000e\u001d;j_:\u001c\u0018\u0002BAr\u0003;\u0014!cQ=qQ\u0016\u0014(+\u001a9mC:|\u0005\u000f^5p]\"I\u0011q\u001d\u000e\u0011\u0002\u0003\u0007\u0011\u0011^\u0001\t[\u0016$\u0018\rR1uCB!\u00111^A}\u001d\u0011\ti/!>\u0011\u0007\u0005=8-\u0004\u0002\u0002r*\u0019\u00111\u001f0\u0002\rq\u0012xn\u001c;?\u0013\r\t9pY\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0018Q \u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]8-\u0001\u0011d_6\u0004X\u000f^3JM\u0006\u00137/\u001a8u\u001fJ\u001cF/\u00197fI\u0011,g-Y;mi\u0012*TC\u0001B\u0002U\u0011\tIO!\u0002,\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005'i!Aa\u0003\u000b\t\t5!qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0005d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0011YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1$\u001b8wC2LGMT8uS\u001aL7-\u0019;j_:,\u00050[:uS:<GCBA2\u00057\u0011y\u0002C\u0004\u0003\u001eq\u0001\r!!\u0015\u0002\u0017\r\f7\r[3e-\u0006dW/\u001a\u0005\b\u0003kc\u0002\u0019AA\\\u0003UI7/\u00138wC2LGMT8uS\u001aL7-\u0019;j_:$b!a\u0019\u0003&\tU\u0002b\u0002B\u0014;\u0001\u0007!\u0011F\u0001\r]>$\u0018NZ5dCRLwN\u001c\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)\u0019!q\u0006,\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005g\u0011iC\u0001\u000bJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\u001c\u0005\b\u0003kk\u0002\u0019AA\\\u00039\u0011XmY8na&dWm\u0014:HKR$\u0012\u0002 B\u001e\u0005{\u0011yD!\u0011\t\u000f\tua\u00041\u0001\u0002R!9\u0011Q\u001a\u0010A\u0002\u0005=\u0007bBAY=\u0001\u0007\u00111\u0004\u0005\b\u0003Ot\u0002\u0019AAu\u0003=\u0019w.\u001c9jY\u0016\fe\u000eZ\"bG\",G#\u0003?\u0003H\t%#1\nB'\u0011\u001d\t\tl\ba\u0001\u00037Aq!!4 \u0001\u0004\ty\rC\u0004\u0002h~\u0001\r!!;\t\u0013\t=s\u0004%AA\u0002\u0005\r\u0014\u0001\u00035ji\u000e\u000b7\r[3\u00023\r|W\u000e]5mK\u0006sGmQ1dQ\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005+RC!a\u0019\u0003\u0006\u0005!3m\\7qS2,w+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016t\u0017I\u001c3DC\u000eDW\rF\u0005}\u00057\u0012iFa\u0018\u0003b!9\u0011\u0011W\u0011A\u0002\u0005m\u0001bBAgC\u0001\u0007\u0011q\u001a\u0005\b\u0003O\f\u0003\u0019AAu\u0011%\u0011y%\tI\u0001\u0002\u0004\t\u0019'\u0001\u0018d_6\u0004\u0018\u000e\\3XSRDW\t\u001f9sKN\u001c\u0018n\u001c8D_\u0012,w)\u001a8B]\u0012\u001c\u0015m\u00195fI\u0011,g-Y;mi\u0012\"\u0014!L2p[BLG.Z(s\u0007>l\u0007/\u001b7f/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u0003:$7)Y2iKRIAP!\u001b\u0003l\tU$q\u000f\u0005\b\u0003c\u001b\u0003\u0019AA\u000e\u0011\u001d\u0011ig\ta\u0001\u0005_\nqaY8na&dW\r\u0005\u0003c\u0005cb\u0018b\u0001B:G\nIa)\u001e8di&|g\u000e\r\u0005\b\u0003O\u001c\u0003\u0019AAu\u0011\u001d\u0011ye\ta\u0001\u0003G\n1\u0001[5u)\u001da(Q\u0010B@\u0005\u0007Cq!!-%\u0001\u0004\tY\u0002C\u0004\u0003\u0002\u0012\u0002\r!!\u0015\u0002\u001f\u0015DXmY;uC\ndW-U;fefDq!a:%\u0001\u0004\tI/\u0001\u0003nSN\u001cHc\u0002?\u0003\n\n-%q\u0012\u0005\b\u0003c+\u0003\u0019AA\u000e\u0011\u0019\u0011i)\na\u0001y\u0006\u0011b.Z<Fq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z\u0011\u001d\t9/\na\u0001\u0003S\fQa\u00197fCJ$\"A!&\u0011\u0007\t\u00149*C\u0002\u0003\u001a\u000e\u0014A\u0001T8oO\u0006Q\u0011+^3ss\u000e\u000b7\r[3\u0011\u0005eD3C\u0001\u0015b)\t\u0011iJ\u0001\u0005DC\u000eDWmS3z+\u0011\u00119Ka/\u0014\r)\n'\u0011\u0016BX!\r\u0011'1V\u0005\u0004\u0005[\u001b'a\u0002)s_\u0012,8\r\u001e\t\u0004E\nE\u0016b\u0001BZG\na1+\u001a:jC2L'0\u00192mK\u0006A\u0011/^3ssJ+\u0007/\u0006\u0002\u0003:B\u0019QPa/\u0005\u000f\tu&F1\u0001\u0003@\nI\u0011+V#S3~\u0013V\tU\t\u0005\u0003\u0007\tI*A\u0005rk\u0016\u0014\u0018PU3qA\u0005\u0001\u0002/\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r]\u000b\u0003\u0005\u000f\u00042A!3H\u001b\u0005A#\u0001\u0005)be\u0006lW\r^3s)f\u0004X-T1q'\t9\u0015-A\u0005sKN,H\u000e^'baV\u0011!1\u001b\t\t\u0005+\u0014i.!;\u0003b6\u0011!q\u001b\u0006\u0005\u0005_\u0011IN\u0003\u0002\u0003\\\u0006!!.\u0019<b\u0013\u0011\u0011yNa6\u0003\u00075\u000b\u0007\u000f\r\u0003\u0003d\n-\bCBAv\u0005K\u0014I/\u0003\u0003\u0003h\u0006u(!B\"mCN\u001c\bcA?\u0003l\u0012Y!Q^%\u0002\u0002\u0003\u0005)\u0011\u0001B`\u0005\ryF%M\u0001\u000be\u0016\u001cX\u000f\u001c;NCB\u0004\u0013!C0iCND7i\u001c3f)\u0019\u00119M!>\u0004\u0002!9!qZ&A\u0002\t]\b\u0003\u0003Bk\u0005;\fIO!?1\t\tm(q \t\u0007\u0003W\u0014)O!@\u0011\u0007u\u0014y\u0010\u0002\u0007\u0003n\nU\u0018\u0011!A\u0001\u0006\u0003\u0011y\f\u0003\u0004\u0003r.\u0003\rA\u001d\u000b\u0005\u0003G\u001a)\u0001C\u0004\u0004\b5\u0003\r!!'\u0002\u0007=\u0014'.\u0001\u0005u_N#(/\u001b8h)\t\tI/A\tqCJ\fW.\u001a;feRK\b/Z'ba\u0002\n\u0011\u0003\u001e=Ti\u0006$X\rS1t\u0007\"\fgnZ3t\u0003I!\bp\u0015;bi\u0016D\u0015m]\"iC:<Wm\u001d\u0011\u0015\u0011\rU1qCB\r\u00077\u0001RA!3+\u0005sCqA!.2\u0001\u0004\u0011I\fC\u0004\u0003DF\u0002\rAa2\t\u000f\r=\u0011\u00071\u0001\u0002d\u0005!1m\u001c9z+\u0011\u0019\tca\n\u0015\u0011\r\r2\u0011FB\u0016\u0007[\u0001RA!3+\u0007K\u00012!`B\u0014\t\u001d\u0011iL\rb\u0001\u0005\u007fC\u0011B!.3!\u0003\u0005\ra!\n\t\u0013\t\r'\u0007%AA\u0002\t\u001d\u0007\"CB\beA\u0005\t\u0019AA2\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*Baa\r\u00048U\u00111Q\u0007\u0016\u0005\u0005s\u0013)\u0001B\u0004\u0003>N\u0012\rAa0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!1QHB!+\t\u0019yD\u000b\u0003\u0003H\n\u0015Aa\u0002B_i\t\u0007!qX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011\u0019fa\u0012\u0005\u000f\tuVG1\u0001\u0003@\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u0014\u0011\t\r=3QK\u0007\u0003\u0007#RAaa\u0015\u0003Z\u0006!A.\u00198h\u0013\u0011\tYp!\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011TB/\u0011!\ty\bOA\u0001\u0002\u0004\u0011\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r\r\u0004CBB3\u0007W\nI*\u0004\u0002\u0004h)\u00191\u0011N2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004n\r\u001d$\u0001C%uKJ\fGo\u001c:\u0015\t\u0005\r4\u0011\u000f\u0005\n\u0003\u007fR\u0014\u0011!a\u0001\u00033#\"a!\u0014\u0015\t\u0005\r4q\u000f\u0005\n\u0003\u007fj\u0014\u0011!a\u0001\u00033\u000b\u0001bQ1dQ\u0016\\U-\u001f\t\u0004\u0005\u0013|4\u0003B b\u0005_#\"aa\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\r\u001551\u0012\u000b\t\u0007\u000f\u001biia$\u0004\u0012B)!\u0011\u001a\u0016\u0004\nB\u0019Qpa#\u0005\u000f\tu&I1\u0001\u0003@\"9!Q\u0017\"A\u0002\r%\u0005b\u0002Bb\u0005\u0002\u0007!q\u0019\u0005\b\u0007\u001f\u0011\u0005\u0019AA2\u0003\u001d)h.\u00199qYf,Baa&\u0004(R!1\u0011TBU!\u0015\u001171TBP\u0013\r\u0019ij\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013\t\u001c\tk!*\u0003H\u0006\r\u0014bABRG\n1A+\u001e9mKN\u00022!`BT\t\u001d\u0011il\u0011b\u0001\u0005\u007fC\u0011ba+D\u0003\u0003\u0005\ra!,\u0002\u0007a$\u0003\u0007E\u0003\u0003J*\u001a)+A\u0006sK\u0006$'+Z:pYZ,GCABZ!\u0011\u0019ye!.\n\t\r]6\u0011\u000b\u0002\u0007\u001f\nTWm\u0019;\u0002\u00179{Ek\u0018)S\u000bN+e\nV\u000b\u0003\u0007{\u00032!_B`\u0013\r\u0019\tM\u0016\u0002\u0010\u000bb,7-\u001e;bE2,\u0017+^3ss\u0006aaj\u0014+`!J+5+\u0012(UA\u0005\u0001\u0002+\u0019:b[\u0016$XM\u001d+za\u0016l\u0015\r\u001d\t\u0004\u0005\u0013\u00046C\u0001)b)\t\u00199-A\u0003f[B$\u00180\u0001\u0004f[B$\u0018\u0010I\u0001\u0018Kb$(/Y2u!\u0006\u0014\u0018-\\3uKJ$\u0016\u0010]3NCB$BAa2\u0004V\"91q\u001b+A\u0002\re\u0017\u0001C7baZ\u000bG.^3\u0011\t\rm7Q]\u0007\u0003\u0007;TAaa8\u0004b\u00069a/\u001b:uk\u0006d'bABr5\u00061a/\u00197vKNLAaa:\u0004^\nAQ*\u00199WC2,X\r")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final int maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public int maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        CacheabilityInfo cacheabilityInfo;
        if (this.maximumSize() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().queryCompile(queryKey, metaData);
            cacheabilityInfo = result;
        } else {
            EXECUTABLE_QUERY EXECUTABLE_QUERY;
            CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
            ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
            CachedValue cachedValue2 = cachedValue;
            if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
                CypherReplanOption cypherReplanOption = replanStrategy;
                CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
                EXECUTABLE_QUERY = !(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null) ? this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4()) : this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
            } else {
                EXECUTABLE_QUERY EXECUTABLE_QUERY2;
                cachedValue.markHit();
                CypherReplanOption cypherReplanOption = replanStrategy;
                if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY2 = this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4());
                } else if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY2 = this.hit(queryKey, cachedValue, metaData);
                } else if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
                    EXECUTABLE_QUERY EXECUTABLE_QUERY3;
                    Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
                    if (NotStale$.MODULE$.equals(staleness)) {
                        EXECUTABLE_QUERY3 = this.invalidNotificationExisting(cachedValue, tc) ? this.compileAndCache(queryKey, compiler, metaData, true) : this.recompileOrGet(cachedValue, compiler, queryKey, metaData);
                    } else if (staleness instanceof Stale) {
                        Stale stale = (Stale)staleness;
                        int secondsSincePlan = stale.secondsSincePlan();
                        Option<String> maybeReason = stale.maybeReason();
                        this.tracer().queryCacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                        EXECUTABLE_QUERY3 = cachedValue.recompiledWithExpressionCodeGen() ? this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4()) : this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
                    } else {
                        throw new MatchError((Object)staleness);
                    }
                    EXECUTABLE_QUERY2 = EXECUTABLE_QUERY3;
                } else {
                    throw new MatchError((Object)cypherReplanOption);
                }
                EXECUTABLE_QUERY = EXECUTABLE_QUERY2;
            }
            cacheabilityInfo = EXECUTABLE_QUERY;
        }
        return (EXECUTABLE_QUERY)cacheabilityInfo;
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        boolean bl;
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        } else if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        } else if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            bl = tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        } else {
            bl = false;
        }
        return bl;
    }

    private EXECUTABLE_QUERY recompileOrGet(CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().queryCacheHit(queryKey, metaData);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            CachedValue cachedValue3;
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().queryCompileWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue3 = recompiled;
            } else if (None$.MODULE$.equals(option)) {
                cachedValue3 = cachedValue;
            } else {
                throw new MatchError(option);
            }
            cachedValue2 = cachedValue3;
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable & scala.Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().queryCompile(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable & scala.Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().queryCompileWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo cacheabilityInfo;
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            cacheabilityInfo = hitCache ? this.hit(queryKey, cachedValue, metaData) : this.miss(queryKey, newExecutableQuery, metaData);
        } else {
            cacheabilityInfo = this.miss(queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)cacheabilityInfo;
    }

    private EXECUTABLE_QUERY hit(QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().queryCacheHit(queryKey, metaData);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().queryCacheMiss(queryKey, metaData);
        return newExecutableQuery;
    }

    /*
     * WARNING - void declaration
     */
    public long clear() {
        void var1_1;
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().queryCacheFlush(priorSize);
        return (long)var1_1;
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, int maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.inner = cacheFactory.createCache(maximumSize);
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    scala.Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.queryRep();
                    break;
                }
                case 1: {
                    object = this.parameterTypeMap();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap == null) {
                if (parameterTypeMap2 != null) {
                    return false;
                }
            } else if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            return true;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    private class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            block0: {
                if (this.recompiledWithExpressionCodeGen()) break block0;
                this._numberOfHits_$eq(this._numberOfHits() + 1);
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            Seq state = (Seq)new .colon.colon(this.value(), (List)Nil$.MODULE$);
            return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, Class<?>> resultMap;
        private final int _hashCode;

        private Map<String, Class<?>> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            boolean bl;
            Object object = new Object();
            try {
                boolean bl2;
                Object object2 = obj;
                if (object2 instanceof ParameterTypeMap) {
                    ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object2;
                    Map<String, Class<?>> otherMap = parameterTypeMap.resultMap();
                    if (this.resultMap().size() == otherMap.size()) {
                        otherMap.forEach((otherKey, otherValue) -> {
                            Class<?> value = this.resultMap().get(otherKey);
                            if (!otherValue.equals(value)) {
                                throw new NonLocalReturnControl.mcZ.sp(object, false);
                            }
                        });
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                } else {
                    throw new MatchError(object2);
                }
                boolean bl3 = bl2;
                bl = bl3;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    bl = ex.value$mcZ$sp();
                }
                throw ex;
            }
            return bl;
        }

        public String toString() {
            return JavaConverters$.MODULE$.mapAsScalaMap(this.resultMap()).toString();
        }

        public ParameterTypeMap(Map<String, Class<?>> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

