/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CreateBtreeIndexOptions;
import org.neo4j.cypher.internal.CreateBtreeIndexOptionsConverter;
import org.neo4j.cypher.internal.CreateFulltextIndexOptions;
import org.neo4j.cypher.internal.CreateFulltextIndexOptionsConverter$;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.compiler.phases.LogicalPlanState;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.logical.plans.ConstraintType;
import org.neo4j.cypher.internal.logical.plans.CreateBtreeIndex;
import org.neo4j.cypher.internal.logical.plans.CreateFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.CreateLookupIndex;
import org.neo4j.cypher.internal.logical.plans.CreateNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.CreateUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForBtreeIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex;
import org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex;
import org.neo4j.cypher.internal.logical.plans.DropConstraintOnName;
import org.neo4j.cypher.internal.logical.plans.DropIndex;
import org.neo4j.cypher.internal.logical.plans.DropIndexOnName;
import org.neo4j.cypher.internal.logical.plans.DropNodeKeyConstraint;
import org.neo4j.cypher.internal.logical.plans.DropNodePropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropRelationshipPropertyExistenceConstraint;
import org.neo4j.cypher.internal.logical.plans.DropUniquePropertyConstraint;
import org.neo4j.cypher.internal.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.logical.plans.NodeKey$;
import org.neo4j.cypher.internal.logical.plans.NodePropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.logical.plans.Uniqueness$;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.procs.IgnoredResult$;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan;
import org.neo4j.cypher.internal.procs.SchemaExecutionPlan$;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.InternalQueryType;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.SCHEMA_WRITE$;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class SchemaCommandRuntime$
implements CypherRuntime<RuntimeContext> {
    public static SchemaCommandRuntime$ MODULE$;
    private final PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable;

    static {
        new SchemaCommandRuntime$();
    }

    @Override
    public String name() {
        return "schema";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return None$.MODULE$;
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery state, RuntimeContext context) {
        return (ExecutionPlan)((Function1)this.logicalToExecutable().applyOrElse((Object)state.logicalPlan(), (Function1 & Serializable & scala.Serializable)unknownPlan -> MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply((Object)context);
    }

    public Nothing$ throwCantCompile(LogicalPlan unknownPlan) {
        throw new CantCompileQueryException(new StringBuilder(30).append("Plan is not a schema command: ").append(unknownPlan.getClass().getSimpleName()).toString());
    }

    public Option<InternalQueryType> queryType(LogicalPlan logicalPlan) {
        return this.logicalToExecutable().isDefinedAt((Object)logicalPlan) ? new Some((Object)SCHEMA_WRITE$.MODULE$) : None$.MODULE$;
    }

    public PartialFunction<LogicalPlan, Function1<RuntimeContext, ExecutionPlan>> logicalToExecutable() {
        return this.logicalToExecutable;
    }

    public Tuple2<Object, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo(Either<LabelName, RelTypeName> entityName, QueryContext ctx) {
        Tuple2 tuple2;
        Either<LabelName, RelTypeName> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            LabelName label = (LabelName)left.value();
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)EntityType.NODE);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            RelTypeName relType = (RelTypeName)right.value();
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)EntityType.RELATIONSHIP);
        } else {
            throw new MatchError(either);
        }
        return tuple2;
    }

    public Tuple2<List<Object>, EntityType> org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo(Either<List<LabelName>, List<RelTypeName>> entityName, QueryContext ctx) {
        Tuple2 tuple2;
        Either<List<LabelName>, List<RelTypeName>> either = entityName;
        if (either instanceof Left) {
            Left left = (Left)either;
            List labels = (List)left.value();
            tuple2 = new Tuple2(labels.map((Function1 & Serializable & scala.Serializable)label -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), List$.MODULE$.canBuildFrom()), (Object)EntityType.NODE);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            List relTypes = (List)right.value();
            tuple2 = new Tuple2(relTypes.map((Function1 & Serializable & scala.Serializable)relType -> BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), List$.MODULE$.canBuildFrom()), (Object)EntityType.RELATIONSHIP);
        } else {
            throw new MatchError(either);
        }
        return tuple2;
    }

    public boolean isApplicable(LogicalPlanState logicalPlanState) {
        return this.logicalToExecutable().isDefinedAt(logicalPlanState.maybeLogicalPlan().get());
    }

    public Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(ConstraintType assertion) {
        Function1 & Serializable & scala.Serializable intersect;
        ConstraintType constraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        } else if (RelationshipPropertyExistence$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        } else if (Uniqueness$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isUniquenessConstraint());
        } else if (NodeKey$.MODULE$.equals(constraintType)) {
            intersect = (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        } else {
            throw new MatchError((Object)constraintType);
        }
        return intersect;
    }

    public LabelId org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId(QueryContext ctx, LabelName label) {
        return new LabelId(ctx.getOrCreateLabelId(label.name()));
    }

    public PropertyKeyId org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp(QueryContext ctx, LabelName label, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateLabelId(label.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    public Tuple2<Object, Object> org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp(QueryContext ctx, RelTypeName relType, PropertyKeyName prop) {
        return new Tuple2.mcII.sp(ctx.getOrCreateRelTypeId(relType.name()), ctx.getOrCreatePropertyKeyId(prop.name()));
    }

    public Tuple3<Object, Object, Option<String>> org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    private SchemaCommandRuntime$() {
        MODULE$ = this;
        this.logicalToExecutable = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Function1 & Serializable & scala.Serializable intersect;
                A1 A1 = x1;
                if (A1 instanceof CreateNodeKeyConstraint) {
                    CreateNodeKeyConstraint createNodeKeyConstraint = (CreateNodeKeyConstraint)A1;
                    Option source = createNodeKeyConstraint.source();
                    LabelName label = createNodeKeyConstraint.label();
                    Seq props = createNodeKeyConstraint.props();
                    Option name = createNodeKeyConstraint.name();
                    Options options = createNodeKeyConstraint.options();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateNodeKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, params) -> {
                        Some some;
                        CreateBtreeIndexOptions createBtreeIndexOptions;
                        Tuple2 tuple2;
                        Option<CreateBtreeIndexOptions> option = new CreateBtreeIndexOptionsConverter("node key constraint").convert(options, (MapValue)params);
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createBtreeIndexOptions = (CreateBtreeIndexOptions)(some = (Some)option).value()) != null) {
                            Option<String> provider = createBtreeIndexOptions.provider();
                            IndexConfig config = createBtreeIndexOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Option indexProvider = (Option)tuple22._1();
                        IndexConfig indexConfig = (IndexConfig)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple24 = tuple23;
                        Option indexProvider2 = (Option)tuple24._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple24._2();
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$3(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createNodeKeyConstraint(labelId, propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$2 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$2, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof DropNodeKeyConstraint) {
                    DropNodeKeyConstraint dropNodeKeyConstraint = (DropNodeKeyConstraint)A1;
                    LabelName label = dropNodeKeyConstraint.label();
                    Seq props = dropNodeKeyConstraint.props();
                    intersect = (Function1 & Serializable & scala.Serializable)x$3 -> new SchemaExecutionPlan("DropNodeKeyConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$4) -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$8(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropNodeKeyConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateUniquePropertyConstraint) {
                    CreateUniquePropertyConstraint createUniquePropertyConstraint = (CreateUniquePropertyConstraint)A1;
                    Option source = createUniquePropertyConstraint.source();
                    LabelName label = createUniquePropertyConstraint.label();
                    Seq props = createUniquePropertyConstraint.props();
                    Option name = createUniquePropertyConstraint.name();
                    Options options = createUniquePropertyConstraint.options();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateUniqueConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, params) -> {
                        Some some;
                        CreateBtreeIndexOptions createBtreeIndexOptions;
                        Tuple2 tuple2;
                        Option<CreateBtreeIndexOptions> option = new CreateBtreeIndexOptionsConverter("uniqueness constraint").convert(options, (MapValue)params);
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createBtreeIndexOptions = (CreateBtreeIndexOptions)(some = (Some)option).value()) != null) {
                            Option<String> provider = createBtreeIndexOptions.provider();
                            IndexConfig config = createBtreeIndexOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Option indexProvider = (Option)tuple22._1();
                        IndexConfig indexConfig = (IndexConfig)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple24 = tuple23;
                        Option indexProvider2 = (Option)tuple24._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple24._2();
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$11(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.createUniqueConstraint(labelId, propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$6 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$6, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof DropUniquePropertyConstraint) {
                    DropUniquePropertyConstraint dropUniquePropertyConstraint = (DropUniquePropertyConstraint)A1;
                    LabelName label = dropUniquePropertyConstraint.label();
                    Seq props = dropUniquePropertyConstraint.props();
                    intersect = (Function1 & Serializable & scala.Serializable)x$7 -> new SchemaExecutionPlan("DropUniqueConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$8) -> {
                        int labelId = ctx.getOrCreateLabelId(label.name());
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$16(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        ctx.dropUniqueConstraint(labelId, propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateNodePropertyExistenceConstraint) {
                    CreateNodePropertyExistenceConstraint createNodePropertyExistenceConstraint = (CreateNodePropertyExistenceConstraint)A1;
                    Option source = createNodePropertyExistenceConstraint.source();
                    LabelName label = createNodePropertyExistenceConstraint.label();
                    Property prop = createNodePropertyExistenceConstraint.prop();
                    Option name = createNodePropertyExistenceConstraint.name();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateNodePropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$9) -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(labelId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$19(ctx, BoxesRunTime.unboxToInt((Object)labelId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelPropWithName((QueryContext)ctx, label, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$10 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$10, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof DropNodePropertyExistenceConstraint) {
                    DropNodePropertyExistenceConstraint dropNodePropertyExistenceConstraint = (DropNodePropertyExistenceConstraint)A1;
                    LabelName label = dropNodePropertyExistenceConstraint.label();
                    Property prop = dropNodePropertyExistenceConstraint.prop();
                    intersect = (Function1 & Serializable & scala.Serializable)x$11 -> new SchemaExecutionPlan("DropNodePropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$12) -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(labelId, propertyKeyId) -> ctx.dropNodePropertyExistenceConstraint(labelId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelProp((QueryContext)ctx, label, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateRelationshipPropertyExistenceConstraint) {
                    CreateRelationshipPropertyExistenceConstraint createRelationshipPropertyExistenceConstraint = (CreateRelationshipPropertyExistenceConstraint)A1;
                    Option source = createRelationshipPropertyExistenceConstraint.source();
                    RelTypeName relType = createRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = createRelationshipPropertyExistenceConstraint.prop();
                    Option name = createRelationshipPropertyExistenceConstraint.name();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateRelationshipPropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$13) -> {
                        ((Function3 & Serializable & scala.Serializable)(Function3 & Serializable & scala.Serializable)(relTypeId, propertyKeyId, name) -> {
                            anonfun.1.$anonfun$applyOrElse$27(ctx, BoxesRunTime.unboxToInt((Object)relTypeId), BoxesRunTime.unboxToInt((Object)propertyKeyId), name);
                            return BoxedUnit.UNIT;
                        }).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typePropWithName((QueryContext)ctx, relType, prop.propertyKey(), (Option<String>)name));
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$14 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$14, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof DropRelationshipPropertyExistenceConstraint) {
                    DropRelationshipPropertyExistenceConstraint dropRelationshipPropertyExistenceConstraint = (DropRelationshipPropertyExistenceConstraint)A1;
                    RelTypeName relType = dropRelationshipPropertyExistenceConstraint.typeName();
                    Property prop = dropRelationshipPropertyExistenceConstraint.prop();
                    intersect = (Function1 & Serializable & scala.Serializable)x$15 -> new SchemaExecutionPlan("DropRelationshipPropertyExistenceConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$16) -> {
                        ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(relTypeId, propertyKeyId) -> ctx.dropRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId)).tupled().apply(SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$typeProp((QueryContext)ctx, relType, prop.propertyKey()));
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropConstraintOnName) {
                    DropConstraintOnName dropConstraintOnName = (DropConstraintOnName)A1;
                    String name = dropConstraintOnName.name();
                    boolean ifExists = dropConstraintOnName.ifExists();
                    intersect = (Function1 & Serializable & scala.Serializable)x$17 -> new SchemaExecutionPlan("DropConstraint", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$18) -> {
                        block0: {
                            if (ifExists && !ctx.constraintExists(name)) break block0;
                            ctx.dropNamedConstraint(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof CreateBtreeIndex) {
                    CreateBtreeIndex createBtreeIndex = (CreateBtreeIndex)A1;
                    Option source = createBtreeIndex.source();
                    Either entityName = createBtreeIndex.entityName();
                    List props = createBtreeIndex.propertyKeyNames();
                    Option name = createBtreeIndex.name();
                    Options options = createBtreeIndex.options();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, params) -> {
                        Some some;
                        CreateBtreeIndexOptions createBtreeIndexOptions;
                        Tuple2 tuple2;
                        String string;
                        EntityType entityType;
                        Tuple2<Object, EntityType> tuple22 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        int entityId = tuple22._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType2);
                        Tuple2 tuple24 = tuple23;
                        int entityId2 = tuple24._1$mcI$sp();
                        EntityType entityType3 = entityType = (EntityType)tuple24._2();
                        if (EntityType.NODE.equals(entityType3)) {
                            string = "btree node index";
                        } else if (EntityType.RELATIONSHIP.equals(entityType3)) {
                            string = "btree relationship index";
                        } else {
                            throw new MatchError((Object)entityType3);
                        }
                        String schemaType = string;
                        Option<CreateBtreeIndexOptions> option = new CreateBtreeIndexOptionsConverter(schemaType).convert(options, (MapValue)params);
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createBtreeIndexOptions = (CreateBtreeIndexOptions)(some = (Some)option).value()) != null) {
                            Option<String> provider = createBtreeIndexOptions.provider();
                            IndexConfig config = createBtreeIndexOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple25 = tuple2;
                        if (tuple25 == null) {
                            throw new MatchError((Object)tuple25);
                        }
                        Option indexProvider = (Option)tuple25._1();
                        IndexConfig indexConfig = (IndexConfig)tuple25._2();
                        Tuple2 tuple26 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple27 = tuple26;
                        Option indexProvider2 = (Option)tuple27._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple27._2();
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$37(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.addBtreeIndexRule(entityId2, entityType, (Seq)propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$21 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$21, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof CreateLookupIndex) {
                    CreateLookupIndex createLookupIndex = (CreateLookupIndex)A1;
                    Option source = createLookupIndex.source();
                    EntityType entityType = createLookupIndex.entityType();
                    Option name = createLookupIndex.name();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$22) -> {
                        ctx.addLookupIndexRule(entityType, name);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$23 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$23, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof CreateFulltextIndex) {
                    CreateFulltextIndex createFulltextIndex = (CreateFulltextIndex)A1;
                    Option source = createFulltextIndex.source();
                    Either entityNames = createFulltextIndex.entityNames();
                    List props = createFulltextIndex.propertyKeyNames();
                    Option name = createFulltextIndex.name();
                    Options options = createFulltextIndex.options();
                    intersect = (Function1 & Serializable & scala.Serializable)context -> new SchemaExecutionPlan("CreateIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, params) -> {
                        Some some;
                        CreateFulltextIndexOptions createFulltextIndexOptions;
                        Tuple2 tuple2;
                        Option<CreateFulltextIndexOptions> option = CreateFulltextIndexOptionsConverter$.MODULE$.convert(options, (MapValue)params);
                        if (None$.MODULE$.equals(option)) {
                            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)IndexConfig.empty());
                        } else if (option instanceof Some && (createFulltextIndexOptions = (CreateFulltextIndexOptions)(some = (Some)option).value()) != null) {
                            Option<IndexProviderDescriptor> provider = createFulltextIndexOptions.provider();
                            IndexConfig config = createFulltextIndexOptions.config();
                            tuple2 = new Tuple2(provider, (Object)config);
                        } else {
                            throw new MatchError(option);
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Option indexProvider = (Option)tuple22._1();
                        IndexConfig indexConfig = (IndexConfig)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)indexProvider, (Object)indexConfig);
                        Tuple2 tuple24 = tuple23;
                        Option indexProvider2 = (Option)tuple24._1();
                        IndexConfig indexConfig2 = (IndexConfig)tuple24._2();
                        Tuple2<List<Object>, EntityType> tuple25 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                        if (tuple25 == null) {
                            throw new MatchError(tuple25);
                        }
                        List entityIds = (List)tuple25._1();
                        EntityType entityType = (EntityType)tuple25._2();
                        Tuple2 tuple26 = new Tuple2((Object)entityIds, (Object)entityType);
                        Tuple2 tuple27 = tuple26;
                        List entityIds2 = (List)tuple27._1();
                        EntityType entityType2 = (EntityType)tuple27._2();
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$46(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.addFulltextIndexRule(entityIds2, entityType2, (Seq)propertyKeyIds, name, indexProvider2, indexConfig2);
                        return SuccessResult$.MODULE$;
                    }, (Option<ExecutionPlan>)source.map((Function1 & Serializable & scala.Serializable)x$26 -> (ExecutionPlan)((Function1)SchemaCommandRuntime$.MODULE$.logicalToExecutable().applyOrElse(x$26, (Function1 & Serializable & scala.Serializable)unknownPlan -> SchemaCommandRuntime$.MODULE$.throwCantCompile((LogicalPlan)unknownPlan))).apply(context)));
                } else if (A1 instanceof DropIndex) {
                    DropIndex dropIndex = (DropIndex)A1;
                    LabelName label = dropIndex.label();
                    List props = dropIndex.propertyKeyNames();
                    intersect = (Function1 & Serializable & scala.Serializable)x$27 -> new SchemaExecutionPlan("DropIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$28) -> {
                        LabelId labelId = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$labelToId((QueryContext)ctx, label);
                        List propertyKeyIds = (List)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$51(ctx, p)), List$.MODULE$.canBuildFrom());
                        ctx.dropIndexRule(NameId$.MODULE$.toKernelEncode((NameId)labelId), (Seq)propertyKeyIds);
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DropIndexOnName) {
                    DropIndexOnName dropIndexOnName = (DropIndexOnName)A1;
                    String name = dropIndexOnName.name();
                    boolean ifExists = dropIndexOnName.ifExists();
                    intersect = (Function1 & Serializable & scala.Serializable)x$29 -> new SchemaExecutionPlan("DropIndex", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$30) -> {
                        block0: {
                            if (ifExists && !ctx.indexExists(name)) break block0;
                            ctx.dropIndexRule(name);
                        }
                        return SuccessResult$.MODULE$;
                    }, SchemaExecutionPlan$.MODULE$.apply$default$3());
                } else if (A1 instanceof DoNothingIfExistsForBtreeIndex) {
                    DoNothingIfExistsForBtreeIndex doNothingIfExistsForBtreeIndex = (DoNothingIfExistsForBtreeIndex)A1;
                    Either entityName = doNothingIfExistsForBtreeIndex.entityName();
                    List propertyKeyNames = doNothingIfExistsForBtreeIndex.propertyKeyNames();
                    Option name = doNothingIfExistsForBtreeIndex.name();
                    intersect = (Function1 & Serializable & scala.Serializable)x$31 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$32) -> {
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int entityId = tuple2._1$mcI$sp();
                        EntityType entityType = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)entityId), (Object)entityType);
                        Tuple2 tuple23 = tuple22;
                        int entityId2 = tuple23._1$mcI$sp();
                        EntityType entityType2 = (EntityType)tuple23._2();
                        List propertyKeyIds = (List)propertyKeyNames.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$56(ctx, p)), List$.MODULE$.canBuildFrom());
                        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ctx.btreeIndexReference(entityId2, entityType2, (Seq)propertyKeyIds).getName()).isSuccess() ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$58(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else if (A1 instanceof DoNothingIfExistsForLookupIndex) {
                    DoNothingIfExistsForLookupIndex doNothingIfExistsForLookupIndex = (DoNothingIfExistsForLookupIndex)A1;
                    EntityType entityType = doNothingIfExistsForLookupIndex.entityType();
                    Option name = doNothingIfExistsForLookupIndex.name();
                    intersect = (Function1 & Serializable & scala.Serializable)x$34 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$35) -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ctx.lookupIndexReference(entityType).getName()).isSuccess() ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$62(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$), (Option<ExecutionPlan>)None$.MODULE$);
                } else if (A1 instanceof DoNothingIfExistsForFulltextIndex) {
                    DoNothingIfExistsForFulltextIndex doNothingIfExistsForFulltextIndex = (DoNothingIfExistsForFulltextIndex)A1;
                    Either entityNames = doNothingIfExistsForFulltextIndex.entityNames();
                    List propertyKeyNames = doNothingIfExistsForFulltextIndex.propertyKeyNames();
                    Option name = doNothingIfExistsForFulltextIndex.name();
                    intersect = (Function1 & Serializable & scala.Serializable)x$36 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$37) -> {
                        Tuple2<List<Object>, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getMultipleEntityInfo((Either<List<LabelName>, List<RelTypeName>>)entityNames, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        List entityIds = (List)tuple2._1();
                        EntityType entityType = (EntityType)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)entityIds, (Object)entityType);
                        Tuple2 tuple23 = tuple22;
                        List entityIds2 = (List)tuple23._1();
                        EntityType entityType2 = (EntityType)tuple23._2();
                        List propertyKeyIds = (List)propertyKeyNames.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$65(ctx, p)), List$.MODULE$.canBuildFrom());
                        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ctx.fulltextIndexReference(entityIds2, entityType2, (Seq)propertyKeyIds).getName()).isSuccess() ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$67(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else if (A1 instanceof DoNothingIfExistsForConstraint) {
                    DoNothingIfExistsForConstraint doNothingIfExistsForConstraint = (DoNothingIfExistsForConstraint)A1;
                    Either entityName = doNothingIfExistsForConstraint.entityName();
                    Seq props = doNothingIfExistsForConstraint.props();
                    ConstraintType assertion = doNothingIfExistsForConstraint.assertion();
                    Option name = doNothingIfExistsForConstraint.name();
                    intersect = (Function1 & Serializable & scala.Serializable)x$39 -> new SchemaExecutionPlan("DoNothingIfExist", (Function2<QueryContext, MapValue, SchemaExecutionResult>)(Function2 & Serializable & scala.Serializable)(ctx, x$40) -> {
                        int entityId;
                        Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$getEntityInfo((Either<LabelName, RelTypeName>)entityName, (QueryContext)ctx);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        int n = entityId = tuple2._1$mcI$sp();
                        int entityId2 = n;
                        Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)anonfun.1.$anonfun$applyOrElse$70(ctx, p)), Seq$.MODULE$.canBuildFrom());
                        return ctx.constraintExists(SchemaCommandRuntime$.MODULE$.convertConstraintTypeToConstraintMatcher(assertion), entityId2, propertyKeyIds) ? IgnoredResult$.MODULE$ : (name.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)anonfun.1.$anonfun$applyOrElse$71(ctx, name))) ? IgnoredResult$.MODULE$ : SuccessResult$.MODULE$);
                    }, (Option<ExecutionPlan>)None$.MODULE$);
                } else {
                    intersect = function1.apply(x1);
                }
                return (B1)intersect;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof CreateNodeKeyConstraint ? true : (logicalPlan instanceof DropNodeKeyConstraint ? true : (logicalPlan instanceof CreateUniquePropertyConstraint ? true : (logicalPlan instanceof DropUniquePropertyConstraint ? true : (logicalPlan instanceof CreateNodePropertyExistenceConstraint ? true : (logicalPlan instanceof DropNodePropertyExistenceConstraint ? true : (logicalPlan instanceof CreateRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropRelationshipPropertyExistenceConstraint ? true : (logicalPlan instanceof DropConstraintOnName ? true : (logicalPlan instanceof CreateBtreeIndex ? true : (logicalPlan instanceof CreateLookupIndex ? true : (logicalPlan instanceof CreateFulltextIndex ? true : (logicalPlan instanceof DropIndex ? true : (logicalPlan instanceof DropIndexOnName ? true : (logicalPlan instanceof DoNothingIfExistsForBtreeIndex ? true : (logicalPlan instanceof DoNothingIfExistsForLookupIndex ? true : (logicalPlan instanceof DoNothingIfExistsForFulltextIndex ? true : logicalPlan instanceof DoNothingIfExistsForConstraint))))))))))))))));
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$3(QueryContext ctx$1, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$1, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$8(QueryContext ctx$2, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$2, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$11(QueryContext ctx$3, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$3, p.propertyKey()).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$16(QueryContext ctx$4, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$4, p.propertyKey()).id();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$19(QueryContext ctx$5, int labelId, int propertyKeyId, Option name) {
                ctx$5.createNodePropertyExistenceConstraint(labelId, propertyKeyId, name);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$27(QueryContext ctx$7, int relTypeId, int propertyKeyId, Option name) {
                ctx$7.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId, name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$37(QueryContext ctx$9, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$9, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$46(QueryContext ctx$10, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$10, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$51(QueryContext ctx$11, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$11, p).id();
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$56(QueryContext ctx$12, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$12, p).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$58(QueryContext ctx$12, String name) {
                return ctx$12.indexExists(name);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$62(QueryContext ctx$13, String name) {
                return ctx$13.indexExists(name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$65(QueryContext ctx$14, PropertyKeyName p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$14, p).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$67(QueryContext ctx$14, String name) {
                return ctx$14.indexExists(name);
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$70(QueryContext ctx$15, Property p) {
                return SchemaCommandRuntime$.MODULE$.org$neo4j$cypher$internal$SchemaCommandRuntime$$propertyToId(ctx$15, p.propertyKey()).id();
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$71(QueryContext ctx$15, String name) {
                return ctx$15.constraintExists(name);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$6(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$9(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$14(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$17(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$22(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$25(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$30(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$33(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$35(scala.util.Either org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$40(org.neo4j.common.EntityType scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$44(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$49(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$52(boolean java.lang.String org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$54(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$59(org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$63(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$68(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.RuntimeContext ), $anonfun$applyOrElse$3$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$5(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$2(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$4(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$8$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$7(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$11$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$13(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$10(org.neo4j.cypher.internal.ast.Options org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$12(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$16$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$15(org.neo4j.cypher.internal.expressions.LabelName scala.collection.Seq org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$19$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$21(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$18(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$20(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$24(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$23(org.neo4j.cypher.internal.expressions.LabelName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$27$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.Object java.lang.Object scala.Option ), $anonfun$applyOrElse$29(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$26(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$28(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForConstraint ), $anonfun$applyOrElse$32(org.neo4j.cypher.internal.runtime.QueryContext int int ), $anonfun$applyOrElse$31(org.neo4j.cypher.internal.expressions.RelTypeName org.neo4j.cypher.internal.expressions.Property org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$34(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$37$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$39(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$36(scala.util.Either org.neo4j.cypher.internal.ast.Options scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$38(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForBtreeIndex ), $anonfun$applyOrElse$43(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$41(org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$42(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForLookupIndex ), $anonfun$applyOrElse$46$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$48(org.neo4j.cypher.internal.logical.plans.LogicalPlan ), $anonfun$applyOrElse$45(org.neo4j.cypher.internal.ast.Options scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$47(org.neo4j.cypher.internal.RuntimeContext org.neo4j.cypher.internal.logical.plans.DoNothingIfExistsForFulltextIndex ), $anonfun$applyOrElse$51$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$50(org.neo4j.cypher.internal.expressions.LabelName scala.collection.immutable.List org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$53(boolean java.lang.String org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$56$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$57(org.neo4j.cypher.internal.runtime.QueryContext int org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$58$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$55(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$61(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.common.EntityType ), $anonfun$applyOrElse$62$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$60(org.neo4j.common.EntityType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$65$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.PropertyKeyName ), $anonfun$applyOrElse$66(org.neo4j.cypher.internal.runtime.QueryContext scala.collection.immutable.List org.neo4j.common.EntityType scala.collection.immutable.List ), $anonfun$applyOrElse$67$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$64(scala.util.Either scala.collection.immutable.List scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue ), $anonfun$applyOrElse$70$adapted(org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.cypher.internal.expressions.Property ), $anonfun$applyOrElse$71$adapted(org.neo4j.cypher.internal.runtime.QueryContext java.lang.String ), $anonfun$applyOrElse$69(scala.util.Either scala.collection.Seq org.neo4j.cypher.internal.logical.plans.ConstraintType scala.Option org.neo4j.cypher.internal.runtime.QueryContext org.neo4j.values.virtual.MapValue )}, serializedLambda);
            }
        };
    }
}

