/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.SkipAndLimit$;
import org.neo4j.cypher.internal.planner.spi.SlowContains$;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundTokenContext;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4qAB\u0004\u0011\u0002\u0007\u0005!\u0003C\u0003\u001a\u0001\u0011\u0005!\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003a\u0001\u0011\u0005\u0011M\u0001\u000fJ]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=\u000b\u0005!I\u0011aA:qS*\u0011!bC\u0001\tS:$XM\u001d8bY*\u0011A\"D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00059y\u0011!\u00028f_RR'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u00027A\u0011A\u0003H\u0005\u0003;U\u0011A!\u00168ji\u0006q1.\u001a:oK2$vnQ=qQ\u0016\u0014HC\u0001\u0011(!\t\tS%D\u0001#\u0015\tA1E\u0003\u0002%\u0013\u00059\u0001\u000f\\1o]\u0016\u0014\u0018B\u0001\u0014#\u00059Ie\u000eZ3y\u0005\u0016D\u0017M^5pkJDQ\u0001\u000b\u0002A\u0002%\n\u0011BY3iCZLw.\u001e:\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013AB:dQ\u0016l\u0017M\u0003\u0002\u000b\u001b%\u0011aeK\u0001\u0015Gf\u0004\b.\u001a:U_.+'O\\3m'\u000eDW-\\1\u0015\u0005E\"\u0004C\u0001\u00163\u0013\t\u00194F\u0001\tTG\",W.\u0019#fg\u000e\u0014\u0018\u000e\u001d;pe\")Qg\u0001a\u0001m\u0005)\u0011N\u001c3fqB\u0011\u0011eN\u0005\u0003q\t\u0012q\"\u00138eKb$Um]2sSB$xN]\u0001\u0018i>d\u0015MY3m'\u000eDW-\\1EKN\u001c'/\u001b9u_J$Ba\u000f I+B\u0011!\u0006P\u0005\u0003{-\u0012Q\u0003T1cK2\u001c6\r[3nC\u0012+7o\u0019:jaR|'\u000fC\u0003@\t\u0001\u0007\u0001)\u0001\u0002uGB\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002F\u0013\u00059!/\u001e8uS6,\u0017BA$C\u0005q!&/\u00198tC\u000e$\u0018n\u001c8C_VtG\rV8lK:\u001cuN\u001c;fqRDQ!\u0013\u0003A\u0002)\u000b\u0011\u0002\\1cK2t\u0015-\\3\u0011\u0005-\u0013fB\u0001'Q!\tiU#D\u0001O\u0015\ty\u0015#\u0001\u0004=e>|GOP\u0005\u0003#V\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011+\u0006\u0005\u0006-\u0012\u0001\raV\u0001\raJ|\u0007/\u001a:us.+\u0017p\u001d\t\u00041vSeBA-\\\u001d\ti%,C\u0001\u0017\u0013\taV#A\u0004qC\u000e\\\u0017mZ3\n\u0005y{&aA*fc*\u0011A,F\u0001\u001ai>\u0014V\r\u001c+za\u0016\u001c6\r[3nC\u0012+7o\u0019:jaR|'\u000f\u0006\u0003cK\u001aD\u0007C\u0001\u0016d\u0013\t!7F\u0001\u000fSK2\fG/[8o)f\u0004XmU2iK6\fG)Z:de&\u0004Ho\u001c:\t\u000b}*\u0001\u0019\u0001!\t\u000b\u001d,\u0001\u0019\u0001&\u0002\u0017I,G\u000eV=qK:\u000bW.\u001a\u0005\u0006-\u0016\u0001\ra\u0016")
public interface IndexDescriptorCompatibility {
    public static /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher$(IndexDescriptorCompatibility $this, IndexBehaviour behaviour) {
        return $this.kernelToCypher(behaviour);
    }

    default public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        SlowContains$ slowContains$;
        IndexBehaviour indexBehaviour = behaviour;
        if (IndexBehaviour.SLOW_CONTAINS.equals(indexBehaviour)) {
            slowContains$ = SlowContains$.MODULE$;
        } else if (IndexBehaviour.SKIP_AND_LIMIT.equals(indexBehaviour)) {
            slowContains$ = SkipAndLimit$.MODULE$;
        } else if (IndexBehaviour.EVENTUALLY_CONSISTENT.equals(indexBehaviour)) {
            slowContains$ = EventuallyConsistent$.MODULE$;
        } else {
            throw new IllegalStateException(new StringBuilder(54).append("Missing kernel to cypher mapping for index behaviour: ").append(behaviour).toString());
        }
        return slowContains$;
    }

    public static /* synthetic */ SchemaDescriptor cypherToKernelSchema$(IndexDescriptorCompatibility $this, IndexDescriptor index) {
        return $this.cypherToKernelSchema(index);
    }

    default public SchemaDescriptor cypherToKernelSchema(IndexDescriptor index) {
        LabelSchemaDescriptor labelSchemaDescriptor;
        IndexDescriptor.EntityType entityType = index.entityType();
        if (entityType instanceof IndexDescriptor.EntityType$.Node) {
            IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
            LabelId label = node.label();
            labelSchemaDescriptor = SchemaDescriptor.forLabel((int)label.id(), (int[])((int[])((TraversableOnce)index.properties().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())));
        } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
            IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
            RelTypeId relType = relationship.relType();
            labelSchemaDescriptor = SchemaDescriptor.forRelType((int)relType.id(), (int[])((int[])((TraversableOnce)index.properties().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())));
        } else {
            throw new MatchError((Object)entityType);
        }
        return labelSchemaDescriptor;
    }

    public static /* synthetic */ LabelSchemaDescriptor toLabelSchemaDescriptor$(IndexDescriptorCompatibility $this, TransactionBoundTokenContext tc, String labelName, Seq propertyKeys) {
        return $this.toLabelSchemaDescriptor(tc, labelName, (Seq<String>)propertyKeys);
    }

    default public LabelSchemaDescriptor toLabelSchemaDescriptor(TransactionBoundTokenContext tc, String labelName, Seq<String> propertyKeys) {
        int labelId = tc.getLabelId(labelName);
        Seq propertyKeyIds = (Seq)propertyKeys.map((Function1 & Serializable & scala.Serializable)propertyKeyName -> BoxesRunTime.boxToInteger((int)tc.getPropertyKeyId(propertyKeyName)), Seq$.MODULE$.canBuildFrom());
        return SchemaDescriptor.forLabel((int)labelId, (int[])((int[])propertyKeyIds.toArray(ClassTag$.MODULE$.Int())));
    }

    public static /* synthetic */ RelationTypeSchemaDescriptor toRelTypeSchemaDescriptor$(IndexDescriptorCompatibility $this, TransactionBoundTokenContext tc, String relTypeName, Seq propertyKeys) {
        return $this.toRelTypeSchemaDescriptor(tc, relTypeName, (Seq<String>)propertyKeys);
    }

    default public RelationTypeSchemaDescriptor toRelTypeSchemaDescriptor(TransactionBoundTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        int relTypeId = tc.getRelTypeId(relTypeName);
        Seq propertyKeyIds = (Seq)propertyKeys.map((Function1 & Serializable & scala.Serializable)propertyKeyName -> BoxesRunTime.boxToInteger((int)tc.getPropertyKeyId(propertyKeyName)), Seq$.MODULE$.canBuildFrom());
        return SchemaDescriptor.forRelType((int)relTypeId, (int[])((int[])propertyKeyIds.toArray(ClassTag$.MODULE$.Int())));
    }

    public static void $init$(IndexDescriptorCompatibility $this) {
    }
}

