/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import org.neo4j.common.DependencyResolver;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime;
import org.neo4j.cypher.internal.CommunityAdministrationCommandRuntime$;
import org.neo4j.cypher.internal.CommunityRuntimeContext;
import org.neo4j.cypher.internal.CommunityRuntimeContextManager;
import org.neo4j.cypher.internal.CommunityRuntimeFactory$;
import org.neo4j.cypher.internal.Compiler;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.CypherCurrentCompiler;
import org.neo4j.cypher.internal.CypherRuntimeConfiguration;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.MasterCompiler$;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.compiler.phases.Compatibility3_5$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_3$;
import org.neo4j.cypher.internal.compiler.phases.Compatibility4_4$;
import org.neo4j.cypher.internal.compiler.phases.CypherCompatibilityVersion;
import org.neo4j.cypher.internal.options.CypherPlannerOption;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.options.CypherVersion;
import org.neo4j.cypher.internal.planning.CypherPlanner;
import org.neo4j.cypher.internal.util.InternalNotificationStats;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m4A\u0001D\u0007\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u00191\u0006\u0001)A\u0005'\")q\u000b\u0001C!1\")A\f\u0001C!;\nA2i\\7nk:LG/_\"p[BLG.\u001a:GC\u000e$xN]=\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012AB2za\",'O\u0003\u0002\u0013'\u0005)a.Z85U*\tA#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005=\u0019u.\u001c9jY\u0016\u0014h)Y2u_JL\u0018!B4sCBD\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0012\u0003\u0019YWM\u001d8fY&\u0011q\u0005\n\u0002\u001a\u000fJ\f\u0007\u000f\u001b#bi\u0006\u0014\u0017m]3Rk\u0016\u0014\u0018pU3sm&\u001cW-\u0001\blKJtW\r\\'p]&$xN]:\u0011\u0005)jS\"A\u0016\u000b\u00051\n\u0012AC7p]&$xN]5oO&\u0011af\u000b\u0002\t\u001b>t\u0017\u000e^8sg\u0006a1-Y2iK\u001a\u000b7\r^8ssB\u0011\u0011\u0007N\u0007\u0002e)\u00111'D\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0003kI\u0012AcQ1gM\u0016Lg.Z\"bG\",g)Y2u_JL\u0018a\u00037pOB\u0013xN^5eKJ\u0004\"\u0001O\u001e\u000e\u0003eR!AO\t\u0002\u000f1|wmZ5oO&\u0011A(\u000f\u0002\f\u0019><\u0007K]8wS\u0012,'/A\u0007qY\u0006tg.\u001a:D_:4\u0017n\u001a\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u00036\t\u0001bY8na&dWM]\u0005\u0003\u0007\u0002\u0013!dQ=qQ\u0016\u0014\b\u000b\\1o]\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\fQB];oi&lWmQ8oM&<\u0007C\u0001\u0010G\u0013\t9UB\u0001\u000eDsBDWM\u001d*v]RLW.Z\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\b\u0015.cUJT(Q!\tq\u0002\u0001C\u0003\"\u000f\u0001\u0007!\u0005C\u0003)\u000f\u0001\u0007\u0011\u0006C\u00030\u000f\u0001\u0007\u0001\u0007C\u00037\u000f\u0001\u0007q\u0007C\u0003>\u000f\u0001\u0007a\bC\u0003E\u000f\u0001\u0007Q)A\u0002m_\u001e,\u0012a\u0015\t\u0003qQK!!V\u001d\u0003\u00071{w-\u0001\u0003m_\u001e\u0004\u0013AH:vaB|'\u000f^:BI6Lg.[:ue\u0006$\u0018N^3D_6l\u0017M\u001c3t)\u0005I\u0006C\u0001\r[\u0013\tY\u0016DA\u0004C_>dW-\u00198\u0002\u001d\r\u0014X-\u0019;f\u0007>l\u0007/\u001b7feR)a,Y5ogB\u0011adX\u0005\u0003A6\u0011\u0001bQ8na&dWM\u001d\u0005\u0006E.\u0001\raY\u0001\u000eGf\u0004\b.\u001a:WKJ\u001c\u0018n\u001c8\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019l\u0011aB8qi&|gn]\u0005\u0003Q\u0016\u0014QbQ=qQ\u0016\u0014h+\u001a:tS>t\u0007\"\u00026\f\u0001\u0004Y\u0017!D2za\",'\u000f\u00157b]:,'\u000f\u0005\u0002eY&\u0011Q.\u001a\u0002\u0014\u0007f\u0004\b.\u001a:QY\u0006tg.\u001a:PaRLwN\u001c\u0005\u0006_.\u0001\r\u0001]\u0001\u000eGf\u0004\b.\u001a:Sk:$\u0018.\\3\u0011\u0005\u0011\f\u0018B\u0001:f\u0005M\u0019\u0015\u0010\u001d5feJ+h\u000e^5nK>\u0003H/[8o\u0011\u0015!8\u00021\u0001v\u0003])\u00070Z2vi&|g.\u00128hS:,\u0007K]8wS\u0012,'\u000fE\u0002\u0019mbL!a^\r\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u0010z\u0013\tQXBA\bFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0001")
public class CommunityCompilerFactory
implements CompilerFactory {
    private final GraphDatabaseQueryService graph;
    private final Monitors kernelMonitors;
    private final CaffeineCacheFactory cacheFactory;
    private final CypherPlannerConfiguration plannerConfig;
    private final CypherRuntimeConfiguration runtimeConfig;
    private final Log log;

    private Log log() {
        return this.log;
    }

    @Override
    public boolean supportsAdministrativeCommands() {
        return this.plannerConfig.planSystemCommands();
    }

    @Override
    public Compiler createCompiler(CypherVersion cypherVersion, CypherPlannerOption cypherPlanner, CypherRuntimeOption cypherRuntime, Function0<ExecutionEngine> executionEngineProvider) {
        CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime;
        Compatibility3_5$ compatibility3_5$;
        CypherVersion cypherVersion2 = cypherVersion;
        if (CypherVersion.v3_5$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility3_5$.MODULE$;
        } else if (CypherVersion.v4_3$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_3$.MODULE$;
        } else if (CypherVersion.v4_4$.MODULE$.equals(cypherVersion2)) {
            compatibility3_5$ = Compatibility4_4$.MODULE$;
        } else {
            throw new MatchError((Object)cypherVersion2);
        }
        Compatibility3_5$ compatibilityMode = compatibility3_5$;
        DependencyResolver dependencies = this.graph.getDependencyResolver();
        CypherPlanner planner = new CypherPlanner(this.plannerConfig, MasterCompiler$.MODULE$.CLOCK(), this.kernelMonitors, this.log(), this.cacheFactory, cypherPlanner, (Function0<Object>)new LastCommittedTxIdProvider(this.graph), (CypherCompatibilityVersion)compatibilityMode, (InternalNotificationStats)dependencies.resolveDependency(InternalNotificationStats.class));
        if (this.plannerConfig.planSystemCommands()) {
            CommunityAdministrationCommandRuntime communityAdministrationCommandRuntime2;
            CypherVersion cypherVersion3 = cypherVersion;
            if (CypherVersion.v3_5$.MODULE$.equals(cypherVersion3)) {
                throw new SyntaxException("Commands towards system database are not supported in this Cypher version.");
            }
            communityAdministrationCommandRuntime = communityAdministrationCommandRuntime2 = new CommunityAdministrationCommandRuntime((ExecutionEngine)executionEngineProvider.apply(), this.graph.getDependencyResolver(), CommunityAdministrationCommandRuntime$.MODULE$.apply$default$3());
        } else {
            communityAdministrationCommandRuntime = CommunityRuntimeFactory$.MODULE$.getRuntime(cypherRuntime, this.plannerConfig.useErrorsOverWarnings());
        }
        CommunityAdministrationCommandRuntime runtime = communityAdministrationCommandRuntime;
        return new CypherCurrentCompiler<CommunityRuntimeContext>(planner, runtime, new CommunityRuntimeContextManager(this.log(), this.runtimeConfig), this.kernelMonitors);
    }

    public CommunityCompilerFactory(GraphDatabaseQueryService graph, Monitors kernelMonitors, CaffeineCacheFactory cacheFactory, LogProvider logProvider, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig) {
        this.graph = graph;
        this.kernelMonitors = kernelMonitors;
        this.cacheFactory = cacheFactory;
        this.plannerConfig = plannerConfig;
        this.runtimeConfig = runtimeConfig;
        this.log = logProvider.getLog(this.getClass());
    }
}

