/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.UUID;
import org.neo4j.cypher.internal.AdministrationCommandRuntime;
import org.neo4j.cypher.internal.AdministrationCommandRuntime$IdentityConverter$;
import org.neo4j.cypher.internal.ExecutionEngine;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ast.HomeDatabaseAction;
import org.neo4j.cypher.internal.ast.RemoveHomeDatabaseAction$;
import org.neo4j.cypher.internal.ast.SetHomeDatabaseAction;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.logical.plans.NameValidator$;
import org.neo4j.cypher.internal.procs.QueryHandler$;
import org.neo4j.cypher.internal.procs.QueryHandlerBuilder;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan;
import org.neo4j.cypher.internal.procs.UpdatingSystemCommandExecutionPlan$;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.exceptions.DatabaseAdministrationOnFollowerException;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.string.UTF8;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class AdministrationCommandRuntime$ {
    public static AdministrationCommandRuntime$ MODULE$;
    private final String followerError;
    private final SecureHasher secureHasher;
    private final String internalPrefix;

    static {
        new AdministrationCommandRuntime$();
    }

    public String followerError() {
        return this.followerError;
    }

    private SecureHasher secureHasher() {
        return this.secureHasher;
    }

    private String internalPrefix() {
        return this.internalPrefix;
    }

    public String internalKey(String name) {
        return new StringBuilder(0).append(this.internalPrefix()).append(name).toString();
    }

    public byte[] validatePassword(byte[] password) {
        if (password == null || password.length == 0) {
            throw new InvalidArgumentException("A password cannot be empty.");
        }
        return password;
    }

    public TextValue hashPassword(byte[] initialPassword) {
        TextValue textValue = Values.utf8Value((String)SystemGraphCredential.createCredentialForPassword(initialPassword, this.secureHasher()).serialize());
        return textValue;
    }

    public TextValue validateAndFormatEncryptedPassword(byte[] password) {
        TextValue textValue;
        try {
            textValue = Values.utf8Value((String)SystemGraphCredential.serialize(password));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidArgumentException(e.getMessage(), (Throwable)e);
        }
        return textValue;
    }

    public AdministrationCommandRuntime.PasswordExpression getPasswordExpression(Option<Expression> userNameParameter, Expression password, boolean isEncryptedPassword, String[] otherParams) {
        Expression expression = password;
        if (!(expression instanceof Parameter)) {
            throw new MatchError((Object)expression);
        }
        Parameter parameter = (Parameter)expression;
        this.validateStringParameterType(parameter);
        String hashedPwKey = this.ensureUniqueParamName(new StringBuilder(7).append(this.internalKey(parameter.name())).append("_hashed").toString(), otherParams);
        String passwordByteKey = this.ensureUniqueParamName(new StringBuilder(6).append(this.internalKey(parameter.name())).append("_bytes").toString(), otherParams);
        AdministrationCommandRuntime.PasswordExpression passwordExpression = new AdministrationCommandRuntime.PasswordExpression(hashedPwKey, Values.NO_VALUE, passwordByteKey, Values.NO_VALUE, (Function2<Transaction, MapValue, MapValue>)(Function2 & Serializable & scala.Serializable)(transaction, params) -> this.convertPasswordParameters$1((Transaction)transaction, (MapValue)params, parameter, isEncryptedPassword, hashedPwKey, passwordByteKey));
        return passwordExpression;
    }

    public byte[] getValidPasswordParameter(MapValue params, String passwordParameter) {
        byte[] byArray;
        AnyValue anyValue = params.get(passwordParameter);
        if (anyValue instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)anyValue;
            byArray = byteArray.asObject();
        } else if (anyValue instanceof StringValue) {
            StringValue stringValue = (StringValue)anyValue;
            byArray = UTF8.encode((String)stringValue.stringValue());
        } else {
            Value value = Values.NO_VALUE;
            AnyValue anyValue2 = anyValue;
            if (!(value != null ? !value.equals(anyValue2) : anyValue2 != null)) {
                throw new ParameterNotFoundException(new StringBuilder(23).append("Expected parameter(s): ").append(passwordParameter).toString());
            }
            throw new ParameterWrongTypeException(new StringBuilder(58).append("Expected password parameter $").append(passwordParameter).append(" to have type String but was ").append(anyValue.getTypeName()).toString());
        }
        return byArray;
    }

    public String ensureUniqueParamName(String originalName, String[] otherParams) {
        ObjectRef uniqueName = ObjectRef.create((Object)originalName);
        WrappedArray params = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherParams)).sorted((Ordering)Ordering.String$.MODULE$));
        params.foreach((Function1 & Serializable & scala.Serializable)otherParamName -> {
            AdministrationCommandRuntime$.$anonfun$ensureUniqueParamName$1(uniqueName, otherParamName);
            return BoxedUnit.UNIT;
        });
        return (String)uniqueName.elem;
    }

    public void validateStringParameterType(Parameter param) {
        CypherType cypherType = param.parameterType();
        if (!(cypherType instanceof StringType)) {
            throw new ParameterWrongTypeException(new StringBuilder(44).append("Only ").append(package$.MODULE$.CTString()).append(" values are accepted as password, got: ").append(param.parameterType()).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ExecutionPlan makeCreateUserExecutionPlan(Either<String, Parameter> userName, boolean isEncryptedPassword, Expression password, boolean requirePasswordChange, boolean suspended, Option<HomeDatabaseAction> defaultDatabase, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        String passwordChangeRequiredKey = this.internalKey("passwordChangeRequired");
        String suspendedKey = this.internalKey("suspended");
        String uuidKey = this.internalKey("uuid");
        Option homeDatabaseFields = defaultDatabase.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdministrationCommandRuntime.NameFields nameFields;
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                nameFields = new AdministrationCommandRuntime.NameFields(new StringBuilder(12).append(MODULE$.internalPrefix()).append("homeDatabase").toString(), Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            } else if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                Either name = setHomeDatabaseAction.name();
                nameFields = MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)s -> new NormalizedDatabaseName(s).name());
            } else {
                throw new MatchError((Object)homeDatabaseAction);
            }
            return nameFields;
        });
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        String[] nonPasswordParameterNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey(), uuidKey, passwordChangeRequiredKey, suspendedKey})).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.nameKey())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        AdministrationCommandRuntime.PasswordExpression credentials = this.getPasswordExpression((Option<Expression>)userName.toOption(), password, isEncryptedPassword, nonPasswordParameterNames);
        String homeDatabaseCypher = (String)homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)ddf -> new StringBuilder(19).append(", homeDatabase: $`").append(ddf.nameKey()).append("`").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Function2 & Serializable & scala.Serializable mapValueConverter = (Function2 & Serializable & scala.Serializable)(tx, p) -> {
            Option newHomeDatabaseFields = homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)x$2 -> (MapValue)x$2.nameConverter().apply(tx, userNameFields.nameConverter().apply(tx, p)));
            return (MapValue)credentials.mapValueConverter().apply(tx, newHomeDatabaseFields.getOrElse((Function0 & Serializable & scala.Serializable)() -> (MapValue)userNameFields.nameConverter().apply(tx, p)));
        };
        String x$12 = "CreateUser";
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$32 = securityAuthorizationHandler;
        String x$4 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("CREATE (u:User {name: $`").append(userNameFields.nameKey()).append("`, id: $`").append(uuidKey).append("`, credentials: $`").append(credentials.key()).append("`,\n         |passwordChangeRequired: $`").append(passwordChangeRequiredKey).append("`, suspended: $`").append(suspendedKey).append("`\n         |").append(homeDatabaseCypher).append(" })\n         |RETURN u.name").toString())).stripMargin();
        MapValue x$5 = VirtualValues.map((String[])((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{credentials.key(), credentials.bytesKey()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonPasswordParameterNames)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (AnyValue[])((AnyValue[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new AnyValue[]{credentials.value(), credentials.bytesValue(), userNameFields.nameValue(), Values.utf8Value((String)UUID.randomUUID().toString()), Values.booleanValue((boolean)requirePasswordChange), Values.booleanValue((boolean)suspended)})).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.nameValue())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AnyValue.class)))));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable & scala.Serializable)params -> new Some((Object)new IllegalStateException(new StringBuilder(39).append("Failed to create the specified user '").append(MODULE$.runtimeStringValue(userName, (MapValue)params)).append("'.").toString()))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable & scala.Serializable)(error, params) -> {
            Throwable e;
            void var3_7;
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                InvalidArgumentException invalidArgumentException = new InvalidArgumentException(new StringBuilder(60).append("Failed to create the specified user '").append(MODULE$.runtimeStringValue(userName, (MapValue)params)).append("': User already exists.").toString(), error);
                return var3_7;
            }
            if (tuple2 != null && (e = (Throwable)tuple2._1()) instanceof Status.HasStatus) {
                Throwable throwable = e;
                Status status = ((Status.HasStatus)throwable).status();
                Status.Cluster cluster = Status.Cluster.NotALeader;
                if (!(status != null ? !status.equals(cluster) : cluster != null)) {
                    DatabaseAdministrationOnFollowerException databaseAdministrationOnFollowerException = new DatabaseAdministrationOnFollowerException(new StringBuilder(40).append("Failed to create the specified user '").append(MODULE$.runtimeStringValue(userName, (MapValue)params)).append("': ").append(MODULE$.followerError()).toString(), error);
                    return var3_7;
                }
            }
            IllegalStateException illegalStateException = new IllegalStateException(new StringBuilder(39).append("Failed to create the specified user '").append(MODULE$.runtimeStringValue(userName, (MapValue)params)).append("'.").toString(), (Throwable)error);
            return var3_7;
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)p -> {
            AdministrationCommandRuntime$.$anonfun$makeCreateUserExecutionPlan$12(credentials, p);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)params -> BoxesRunTime.boxToBoolean((boolean)NameValidator$.MODULE$.assertValidUsername(AdministrationCommandRuntime$.MODULE$.runtimeStringValue((Either<String, Parameter>)userName, params)));
        Function2 & Serializable & scala.Serializable x$10 = mapValueConverter;
        boolean x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function2<Transaction, SecurityContext, MapValue> x$122 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        Function1<MapValue, MapValue> x$14 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$14();
        return new UpdatingSystemCommandExecutionPlan(x$12, x$2, x$32, x$4, x$5, x$6, x$7, x$11, (Function1<MapValue, Object>)x$9, (Function1<MapValue, BoxedUnit>)x$8, x$122, (Function2<Transaction, MapValue, MapValue>)x$10, x$13, x$14);
    }

    public Option<HomeDatabaseAction> makeCreateUserExecutionPlan$default$6() {
        return None$.MODULE$;
    }

    public ExecutionPlan makeAlterUserExecutionPlan(Either<String, Parameter> userName, Option<Object> isEncryptedPassword, Option<Expression> password, Option<Object> requirePasswordChange, Option<Object> suspended, Option<HomeDatabaseAction> defaultDatabase, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        AdministrationCommandRuntime.NameFields userNameFields = this.getNameFields("username", userName, this.getNameFields$default$3());
        Option homeDatabaseFields = defaultDatabase.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdministrationCommandRuntime.NameFields nameFields;
            HomeDatabaseAction homeDatabaseAction = x0$1;
            if (RemoveHomeDatabaseAction$.MODULE$.equals(homeDatabaseAction)) {
                nameFields = new AdministrationCommandRuntime.NameFields(new StringBuilder(12).append(MODULE$.internalPrefix()).append("homeDatabase").toString(), Values.NO_VALUE, AdministrationCommandRuntime$IdentityConverter$.MODULE$);
            } else if (homeDatabaseAction instanceof SetHomeDatabaseAction) {
                SetHomeDatabaseAction setHomeDatabaseAction = (SetHomeDatabaseAction)homeDatabaseAction;
                Either name = setHomeDatabaseAction.name();
                nameFields = MODULE$.getNameFields("homeDatabase", (Either<String, Parameter>)name, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)s -> new NormalizedDatabaseName(s).name());
            } else {
                throw new MatchError((Object)homeDatabaseAction);
            }
            return nameFields;
        });
        String[] nonPasswordParameterNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{userNameFields.nameKey()})).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.nameKey())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Option maybePw = password.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.getPasswordExpression((Option<Expression>)userName.toOption(), (Expression)p, BoxesRunTime.unboxToBoolean((Object)isEncryptedPassword.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), nonPasswordParameterNames));
        Seq params = (Seq)((TraversableLike)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)maybePw), (Object)"credentials"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(requirePasswordChange), (Object)"passwordChangeRequired"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(suspended), (Object)"suspended"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)homeDatabaseFields), (Object)"homeDatabase"), (List)Nil$.MODULE$))))).flatMap((Function1 & Serializable & scala.Serializable)param -> {
            Object nameFields;
            Object passwordExpression;
            boolean bl = false;
            Some some = null;
            Option option = (Option)param._1();
            if (None$.MODULE$.equals(option)) {
                return (Seq)Nil$.MODULE$;
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Object boolExpr = some.value();
                if (boolExpr instanceof Boolean) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)boolExpr);
                    return (Seq)new .colon.colon((Object)new Tuple3(param._2(), (Object)MODULE$.internalKey((String)param._2()), (Object)Values.booleanValue((boolean)bl2)), (List)Nil$.MODULE$);
                }
            }
            if (bl && (passwordExpression = some.value()) instanceof AdministrationCommandRuntime.PasswordExpression) {
                AdministrationCommandRuntime.PasswordExpression passwordExpression2 = (AdministrationCommandRuntime.PasswordExpression)passwordExpression;
                return (Seq)new .colon.colon((Object)new Tuple3(param._2(), (Object)passwordExpression2.key(), (Object)passwordExpression2.value()), (List)Nil$.MODULE$);
            }
            if (bl && (nameFields = some.value()) instanceof AdministrationCommandRuntime.NameFields) {
                AdministrationCommandRuntime.NameFields nameFields2 = (AdministrationCommandRuntime.NameFields)nameFields;
                return (Seq)new .colon.colon((Object)new Tuple3(param._2(), (Object)nameFields2.nameKey(), (Object)nameFields2.nameValue()), (List)Nil$.MODULE$);
            }
            if (!bl) throw new MatchError((Object)option);
            Object p = some.value();
            throw new InvalidArgumentException(new StringBuilder(103).append("Invalid option type for ALTER USER, expected PasswordExpression, Boolean, String or Parameter but got: ").append(p.getClass().getSimpleName()).toString());
        }, Seq$.MODULE$.canBuildFrom());
        Tuple3 tuple3 = (Tuple3)params.foldLeft((Object)new Tuple3((Object)new StringBuilder(75).append("MATCH (user:User {name: $`").append(userNameFields.nameKey()).append("`}) WITH user, user.credentials AS oldCredentials").toString(), (Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, param) -> {
            String propertyName = (String)param._1();
            String key = (String)param._2();
            Value value = (Value)param._3();
            return new Tuple3((Object)new StringBuilder(16).append((String)acc._1()).append(" SET user.").append(propertyName).append(" = $`").append(key).append("`").toString(), ((SeqLike)acc._2()).$colon$plus((Object)key, Seq$.MODULE$.canBuildFrom()), ((SeqLike)acc._3()).$colon$plus((Object)value, Seq$.MODULE$.canBuildFrom()));
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        String query = (String)tuple3._1();
        Seq keys = (Seq)tuple3._2();
        Seq values = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)query, (Object)keys, (Object)values);
        Tuple3 tuple33 = tuple32;
        String query2 = (String)tuple33._1();
        Seq keys2 = (Seq)tuple33._2();
        Seq values2 = (Seq)tuple33._3();
        Seq parameterKeys = (Seq)((SeqLike)keys2.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.bytesKey())).toSeq(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)userNameFields.nameKey(), Seq$.MODULE$.canBuildFrom());
        Seq parameterValues = (Seq)((SeqLike)values2.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maybePw.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.bytesValue())).toSeq(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)userNameFields.nameValue(), Seq$.MODULE$.canBuildFrom());
        Function2 & Serializable & scala.Serializable mapper = (Function2 & Serializable & scala.Serializable)(tx, p) -> {
            Option newHomeDatabaseFields = homeDatabaseFields.map((Function1 & Serializable & scala.Serializable)x$8 -> (MapValue)x$8.nameConverter().apply(tx, userNameFields.nameConverter().apply(tx, p)));
            return (MapValue)((Function2)maybePw.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.mapValueConverter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AdministrationCommandRuntime$IdentityConverter$.MODULE$)).apply(tx, newHomeDatabaseFields.getOrElse((Function0 & Serializable & scala.Serializable)() -> (MapValue)userNameFields.nameConverter().apply(tx, p)));
        };
        String x$1 = "AlterUser";
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$42 = new StringBuilder(22).append(query2).append(" RETURN oldCredentials").toString();
        MapValue x$5 = VirtualValues.map((String[])((String[])parameterKeys.toArray(ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])parameterValues.toArray(ClassTag$.MODULE$.apply(AnyValue.class))));
        QueryHandlerBuilder x$62 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable & scala.Serializable)p -> new Some((Object)new InvalidArgumentException(new StringBuilder(59).append("Failed to alter the specified user '").append(MODULE$.runtimeStringValue(userName, (MapValue)p)).append("': User does not exist.").toString()))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 != null) {
                Throwable error = (Throwable)tuple2._1();
                MapValue p = (MapValue)tuple2._2();
                if (error instanceof Status.HasStatus) {
                    Throwable throwable = error;
                    Status status = ((Status.HasStatus)throwable).status();
                    Status.Cluster cluster = Status.Cluster.NotALeader;
                    if (status == null) {
                        if (cluster == null) return new DatabaseAdministrationOnFollowerException(new StringBuilder(39).append("Failed to alter the specified user '").append(MODULE$.runtimeStringValue(userName, p)).append("': ").append(MODULE$.followerError()).toString(), throwable);
                    } else if (status.equals(cluster)) {
                        return new DatabaseAdministrationOnFollowerException(new StringBuilder(39).append("Failed to alter the specified user '").append(MODULE$.runtimeStringValue(userName, p)).append("': ").append(MODULE$.followerError()).toString(), throwable);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Throwable error = (Throwable)tuple2._1();
            MapValue p = (MapValue)tuple2._2();
            return new IllegalStateException(new StringBuilder(38).append("Failed to alter the specified user '").append(MODULE$.runtimeStringValue(userName, p)).append("'.").toString(), error);
        }).handleResult((Function3<Object, AnyValue, MapValue, Option<Throwable>>)(Function3 & Serializable & scala.Serializable)(x$10, value, p) -> maybePw.flatMap((Function1 & Serializable & scala.Serializable)newPw -> {
            byte[] newValue;
            SystemGraphCredential oldCredentials = SystemGraphCredential.deserialize(((TextValue)value).stringValue(), AdministrationCommandRuntime$.MODULE$.secureHasher());
            return oldCredentials.matchesPassword(newValue = ((ByteArray)p.get(newPw.bytesKey())).asObject()) ? new Some((Object)new InvalidArgumentException(new StringBuilder(88).append("Failed to alter the specified user '").append(AdministrationCommandRuntime$.MODULE$.runtimeStringValue((Either<String, Parameter>)userName$2, p)).append("': Old password and new password cannot be the same.").toString())) : None$.MODULE$;
        }));
        Option<ExecutionPlan> x$72 = sourcePlan;
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)p -> {
            maybePw.foreach((Function1 & Serializable & scala.Serializable)newPw -> {
                AdministrationCommandRuntime$.$anonfun$makeAlterUserExecutionPlan$20(p, newPw);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable x$9 = mapper;
        boolean x$102 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<MapValue, Object> x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$9();
        Function2<Transaction, SecurityContext, MapValue> x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        Function1<MapValue, MapValue> x$14 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$14();
        return new UpdatingSystemCommandExecutionPlan(x$1, x$2, x$3, x$42, x$5, x$62, x$72, x$102, x$11, (Function1<MapValue, BoxedUnit>)x$8, x$12, (Function2<Transaction, MapValue, MapValue>)x$9, x$13, x$14);
    }

    public Option<HomeDatabaseAction> makeAlterUserExecutionPlan$default$6() {
        return None$.MODULE$;
    }

    public ExecutionPlan makeRenameExecutionPlan(String entity, Either<String, Parameter> fromName, Either<String, Parameter> toName, Function1<MapValue, Object> initFunction, Option<ExecutionPlan> sourcePlan, ExecutionEngine normalExecutionEngine, SecurityAuthorizationHandler securityAuthorizationHandler) {
        AdministrationCommandRuntime.NameFields fromNameFields = this.getNameFields("fromName", fromName, this.getNameFields$default$3());
        AdministrationCommandRuntime.NameFields toNameFields = this.getNameFields("toName", toName, this.getNameFields$default$3());
        Function2 & Serializable & scala.Serializable mapValueConverter = (Function2 & Serializable & scala.Serializable)(tx, p) -> (MapValue)toNameFields.nameConverter().apply(tx, fromNameFields.nameConverter().apply(tx, p));
        String x$1 = new StringBuilder(6).append("Create").append(entity).toString();
        ExecutionEngine x$2 = normalExecutionEngine;
        SecurityAuthorizationHandler x$3 = securityAuthorizationHandler;
        String x$4 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(88).append("MATCH (old:").append(entity).append(" {name: $`").append(fromNameFields.nameKey()).append("`})\n         |SET old.name = $`").append(toNameFields.nameKey()).append("`\n         |RETURN old.name\n        ").toString())).stripMargin();
        MapValue x$5 = VirtualValues.map((String[])((String[])((Object[])new String[]{fromNameFields.nameKey(), toNameFields.nameKey()})), (AnyValue[])((AnyValue[])((Object[])new AnyValue[]{fromNameFields.nameValue(), toNameFields.nameValue()})));
        QueryHandlerBuilder x$6 = QueryHandler$.MODULE$.handleNoResult((Function1<MapValue, Option<Throwable>>)(Function1 & Serializable & scala.Serializable)p -> new Some((Object)new InvalidArgumentException(new StringBuilder(65).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to ").append("'").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("': The ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' does not exist.").toString()))).handleError((Function2<Throwable, MapValue, Throwable>)(Function2 & Serializable & scala.Serializable)(error, p) -> {
            Tuple2 tuple2 = new Tuple2(error, (Object)error.getCause());
            if (tuple2 != null && tuple2._2() instanceof UniquePropertyValueValidationException) {
                return new InvalidArgumentException(new StringBuilder(61).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to ").append("'").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("': ").append(entity).append(" '").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("' already exists.").toString(), error);
            }
            if (tuple2 == null) return new IllegalStateException(new StringBuilder(41).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to '").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("'.").toString(), (Throwable)error);
            Throwable e = (Throwable)tuple2._1();
            if (!(e instanceof Status.HasStatus)) return new IllegalStateException(new StringBuilder(41).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to '").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("'.").toString(), (Throwable)error);
            Throwable throwable = e;
            Status status = ((Status.HasStatus)throwable).status();
            Status.Cluster cluster = Status.Cluster.NotALeader;
            if (status != null) {
                if (!status.equals(cluster)) return new IllegalStateException(new StringBuilder(41).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to '").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("'.").toString(), (Throwable)error);
                return new DatabaseAdministrationOnFollowerException(new StringBuilder(36).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("': ").append(MODULE$.followerError()).toString(), error);
            }
            if (cluster == null) return new DatabaseAdministrationOnFollowerException(new StringBuilder(36).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("': ").append(MODULE$.followerError()).toString(), error);
            return new IllegalStateException(new StringBuilder(41).append("Failed to rename the specified ").append(entity.toLowerCase()).append(" '").append(MODULE$.runtimeStringValue(fromName, (MapValue)p)).append("' to '").append(MODULE$.runtimeStringValue(toName, (MapValue)p)).append("'.").toString(), (Throwable)error);
        });
        Option<ExecutionPlan> x$7 = sourcePlan;
        Function1<MapValue, Object> x$8 = initFunction;
        Function2 & Serializable & scala.Serializable x$9 = mapValueConverter;
        boolean x$10 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$8();
        Function1<MapValue, BoxedUnit> x$11 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$10();
        Function2<Transaction, SecurityContext, MapValue> x$12 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$11();
        Function1<Transaction, BoxedUnit> x$13 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$13();
        Function1<MapValue, MapValue> x$14 = UpdatingSystemCommandExecutionPlan$.MODULE$.apply$default$14();
        return new UpdatingSystemCommandExecutionPlan(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$10, x$8, x$11, x$12, (Function2<Transaction, MapValue, MapValue>)x$9, x$13, x$14);
    }

    public AdministrationCommandRuntime.NameFields getNameFields(String key, Either<String, Parameter> name, Function1<String, String> valueMapper) {
        AdministrationCommandRuntime.NameFields nameFields;
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String u = (String)left.value();
            nameFields = new AdministrationCommandRuntime.NameFields(new StringBuilder(0).append(this.internalPrefix()).append(key).toString(), (Value)Values.utf8Value((String)((String)valueMapper.apply((Object)u))), AdministrationCommandRuntime$IdentityConverter$.MODULE$);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Parameter parameter = (Parameter)right.value();
            nameFields = new AdministrationCommandRuntime.NameFields((String)AdministrationCommandRuntime$.rename$1().apply((Object)parameter.name()), Values.NO_VALUE, new AdministrationCommandRuntime.RenamingStringParameterConverter(parameter.name(), (Function1<String, String>)AdministrationCommandRuntime$.rename$1(), (Function1<TextValue, TextValue>)(Function1 & Serializable & scala.Serializable)v -> Values.utf8Value((String)((String)valueMapper.apply((Object)v.stringValue())))));
        } else {
            throw new MatchError(either);
        }
        return nameFields;
    }

    public Function1<String, String> getNameFields$default$3() {
        return (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public String runtimeStringValue(Either<String, Parameter> field, MapValue params) {
        String string;
        Either<String, Parameter> either = field;
        if (either instanceof Left) {
            String u;
            Left left = (Left)either;
            string = u = (String)left.value();
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Parameter p = (Parameter)right.value();
            string = this.runtimeStringValue(p.name(), params);
        } else {
            throw new MatchError(either);
        }
        return string;
    }

    private String runtimeStringValue(String parameter, MapValue params) {
        AnyValue value = params.containsKey(parameter) ? params.get(parameter) : params.get(this.internalKey(parameter));
        AnyValue anyValue = value;
        if (!(anyValue instanceof TextValue)) {
            throw new ParameterWrongTypeException(new StringBuilder(49).append("Expected parameter $").append(parameter).append(" to have type String but was ").append(value).toString());
        }
        TextValue textValue = (TextValue)anyValue;
        String string = textValue.stringValue();
        return string;
    }

    private final MapValue convertPasswordParameters$1(Transaction transaction, MapValue params, Parameter x2$1, boolean isEncryptedPassword$1, String hashedPwKey$1, String passwordByteKey$1) {
        byte[] encodedPassword = this.getValidPasswordParameter(params, x2$1.name());
        TextValue hashedPassword = isEncryptedPassword$1 ? this.validateAndFormatEncryptedPassword(encodedPassword) : this.hashPassword(this.validatePassword(encodedPassword));
        return params.updatedWith(hashedPwKey$1, (AnyValue)hashedPassword).updatedWith(passwordByteKey$1, (AnyValue)Values.byteArray((byte[])encodedPassword));
    }

    public static final /* synthetic */ void $anonfun$ensureUniqueParamName$1(ObjectRef uniqueName$1, String otherParamName) {
        block0: {
            if (!otherParamName.equals((String)uniqueName$1.elem)) break block0;
            uniqueName$1.elem = new StringBuilder(1).append((String)uniqueName$1.elem).append("_").toString();
        }
    }

    public static final /* synthetic */ void $anonfun$makeCreateUserExecutionPlan$12(AdministrationCommandRuntime.PasswordExpression credentials$1, MapValue p) {
        ((ByteArray)p.get(credentials$1.bytesKey())).zero();
    }

    public static final /* synthetic */ void $anonfun$makeAlterUserExecutionPlan$20(MapValue p$4, AdministrationCommandRuntime.PasswordExpression newPw) {
        ((ByteArray)p$4.get(newPw.bytesKey())).zero();
    }

    private static final Function1 rename$1() {
        return (Function1 & Serializable & scala.Serializable)paramName -> MODULE$.internalKey((String)paramName);
    }

    private AdministrationCommandRuntime$() {
        MODULE$ = this;
        this.followerError = "Administration commands must be executed on the LEADER server.";
        this.secureHasher = new SecureHasher();
        this.internalPrefix = "__internal_";
    }
}

