/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.preparser.javacc;

import java.util.List;
import java.util.Objects;
import org.neo4j.cypher.internal.PreParserOption;
import org.neo4j.cypher.internal.util.InputPosition;

public class PreParserResult {
    private final List<PreParserOption> options;
    private final InputPosition position;
    private static final String EMPTY_QUERY_PARSER_EXCEPTION_MSG = "Unexpected end of input: expected CYPHER, EXPLAIN, PROFILE or Query";

    public PreParserResult(List<PreParserOption> options, InputPosition position) {
        this.options = options;
        this.position = position;
    }

    public List<PreParserOption> options() {
        return this.options;
    }

    public InputPosition position() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreParserResult that = (PreParserResult)o;
        return Objects.equals(this.options, that.options) && Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.position);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PreParserResult(List(");
        this.options.forEach(o -> sb.append(o.toString()).append(','));
        sb.append("))");
        return sb.toString();
    }

    public static String getEmptyQueryExceptionMsg() {
        return EMPTY_QUERY_PARSER_EXCEPTION_MSG;
    }
}

