/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005MbaB\u0005\u000b!\u0003\r\ta\u0005\u0005\u0006U\u0001!\ta\u000b\u0005\u0006_\u00011\t\u0002\r\u0005\u0006o\u0001!\t\u0002\u000f\u0005\u0006K\u00021\tB\u001a\u0005\u0006y\u0002!I! \u0005\b\u0003\u000b\u0001A\u0011CA\u0004\u0011\u001d\ty\u0002\u0001C\t\u0003CAq!!\u000b\u0001\t#\tYCA\u000bJ]\u0012,\u0007p\u00149uS>t7oQ8om\u0016\u0014H/\u001a:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0015CM\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\raRdH\u0007\u0002\u0015%\u0011aD\u0003\u0002\u0011\u001fB$\u0018n\u001c8t\u0007>tg/\u001a:uKJ\u0004\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\tA+\u0005\u0002%OA\u0011a#J\u0005\u0003M]\u0011qAT8uQ&tw\r\u0005\u0002\u0017Q%\u0011\u0011f\u0006\u0002\u0004\u0003:L\u0018A\u0002\u0013j]&$H\u0005F\u0001-!\t1R&\u0003\u0002//\t!QK\\5u\u0003\u001d\u0019wN\u001c;fqR,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i)\tqA];oi&lW-\u0003\u00027g\ta\u0011+^3ss\u000e{g\u000e^3yi\u0006yq-\u001a;PaRLwN\\:QCJ$8\u000f\u0006\u0003:\u0013N\u0003\u0007\u0003\u0002\f;y\u0019K!aO\f\u0003\rQ+\b\u000f\\33!\r1RhP\u0005\u0003}]\u0011aa\u00149uS>t\u0007C\u0001!E\u001b\u0005\t%B\u0001\"D\u0003\u0019\u00198\r[3nC*\u00111BD\u0005\u0003\u000b\u0006\u0013q#\u00138eKb\u0004&o\u001c<jI\u0016\u0014H)Z:de&\u0004Ho\u001c:\u0011\u0005\u0001;\u0015B\u0001%B\u0005-Ie\u000eZ3y\u0007>tg-[4\t\u000b)\u001b\u0001\u0019A&\u0002\u000f=\u0004H/[8ogB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\bm&\u0014H/^1m\u0015\t\u0001f\"\u0001\u0004wC2,Xm]\u0005\u0003%6\u0013\u0001\"T1q-\u0006dW/\u001a\u0005\u0006)\u000e\u0001\r!V\u0001\u000bg\u000eDW-\\1UsB,\u0007C\u0001,^\u001d\t96\f\u0005\u0002Y/5\t\u0011L\u0003\u0002[%\u00051AH]8pizJ!\u0001X\f\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039^AQ!Y\u0002A\u0002\t\f\u0011\"\u001b8eKb$\u0016\u0010]3\u0011\u0005\u0001\u001b\u0017B\u00013B\u0005%Ie\u000eZ3y)f\u0004X-A\u000fbgN,'\u000f\u001e,bY&$\u0017I\u001c3Ue\u0006t7OZ8s[\u000e{gNZ5h)\r9Wo\u001f\t\u0005Q6,v.D\u0001j\u0015\tQ7.\u0001\u0003vi&d'\"\u00017\u0002\t)\fg/Y\u0005\u0003]&\u00141!T1q!\t\u00018/D\u0001r\u0015\t\u00118.\u0001\u0003mC:<\u0017B\u0001;r\u0005\u0019y%M[3di\")a\u000f\u0002a\u0001o\u000611m\u001c8gS\u001e\u0004\"\u0001_=\u000e\u0003=K!A_(\u0003\u0011\u0005s\u0017PV1mk\u0016DQ\u0001\u0016\u0003A\u0002U\u000b\u0001$Y:tKJ$h+\u00197jI&sG-\u001a=Qe>4\u0018\u000eZ3s)\u0019yd0!\u0001\u0002\u0004!)q0\u0002a\u0001o\u0006i\u0011N\u001c3fqB\u0013xN^5eKJDQ\u0001V\u0003A\u0002UCQ!Y\u0003A\u0002\t\f\u0011d\u00195fG.4uN\u001d)pS:$8i\u001c8gS\u001e4\u0016\r\\;fgR9A&!\u0003\u0002\u001a\u0005u\u0001bBA\u0006\r\u0001\u0007\u0011QB\u0001\u0003aB\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'y\u0015!B;uS2\u001c\u0018\u0002BA\f\u0003#\u0011Q\u0002\u0015:fiRL\bK]5oi\u0016\u0014\bBBA\u000e\r\u0001\u00071*\u0001\u0005ji\u0016l7/T1q\u0011\u0015!f\u00011\u0001V\u0003q\u0019\u0007.Z2l\r>\u0014h)\u001e7mi\u0016DHoQ8oM&<g+\u00197vKN$r\u0001LA\u0012\u0003K\t9\u0003C\u0004\u0002\f\u001d\u0001\r!!\u0004\t\r\u0005mq\u00011\u0001L\u0011\u0015!v\u00011\u0001V\u0003E\t7o]3si\u0016k\u0007\u000f^=D_:4\u0017n\u001a\u000b\bO\u00065\u0012qFA\u0019\u0011\u00151\b\u00021\u0001x\u0011\u0015!\u0006\u00021\u0001V\u0011\u0015\t\u0007\u00021\u0001V\u0001")
public interface IndexOptionsConverter<T>
extends OptionsConverter<T> {
    public QueryContext context();

    public static /* synthetic */ Tuple2 getOptionsParts$(IndexOptionsConverter $this, MapValue options, String schemaType, IndexType indexType) {
        return $this.getOptionsParts(options, schemaType, indexType);
    }

    default public Tuple2<Option<IndexProviderDescriptor>, IndexConfig> getOptionsParts(MapValue options, String schemaType, IndexType indexType) {
        if (MapValueOps$.MODULE$.Ops(options).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$getOptionsParts$1(x0$1)))) {
            throw new InvalidArgumentsException("Failed to create " + schemaType + ": Invalid option provided, valid options are `indexProvider` and `indexConfig`.");
        }
        Option<AnyValue> maybeIndexProvider = MapValueOps$.MODULE$.Ops(options).getOption("indexprovider");
        Option<AnyValue> maybeConfig = MapValueOps$.MODULE$.Ops(options).getOption("indexconfig");
        Option indexProvider = maybeIndexProvider.map((Function1 & Serializable)p -> this.assertValidIndexProvider((AnyValue)p, schemaType, indexType));
        Map configMap = (Map)maybeConfig.map((Function1 & Serializable)x$12 -> this.assertValidAndTransformConfig((AnyValue)x$12, schemaType)).getOrElse((Function0 & Serializable)() -> Collections.emptyMap());
        IndexConfig indexConfig = IndexSettingUtil.toIndexConfigFromStringObjectMap((Map)configMap);
        return new Tuple2((Object)indexProvider, (Object)indexConfig);
    }

    public Map<String, Object> assertValidAndTransformConfig(AnyValue var1, String var2);

    private IndexProviderDescriptor assertValidIndexProvider(AnyValue indexProvider, String schemaType, IndexType indexType) {
        AnyValue anyValue = indexProvider;
        if (anyValue instanceof TextValue) {
            TextValue textValue = (TextValue)anyValue;
            return this.context().validateIndexProvider(schemaType, textValue.stringValue(), indexType);
        }
        throw new InvalidArgumentsException("Could not create " + schemaType + " with specified index provider '" + indexProvider + "'. Expected String value.");
    }

    public static /* synthetic */ void checkForPointConfigValues$(IndexOptionsConverter $this, PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        $this.checkForPointConfigValues(pp, itemsMap, schemaType);
    }

    default public void checkForPointConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        if (MapValueOps$.MODULE$.Ops(itemsMap).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$checkForPointConfigValues$1(x0$1)))) {
            itemsMap.writeTo((AnyValueWriter)pp);
            throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "', contains spatial config settings options.\n           |To create point index, please use 'CREATE POINT INDEX ...'.")));
        }
    }

    public static /* synthetic */ void checkForFulltextConfigValues$(IndexOptionsConverter $this, PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        $this.checkForFulltextConfigValues(pp, itemsMap, schemaType);
    }

    default public void checkForFulltextConfigValues(PrettyPrinter pp, MapValue itemsMap, String schemaType) {
        if (MapValueOps$.MODULE$.Ops(itemsMap).exists((Function1<Tuple2<String, AnyValue>, Object>)(Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexOptionsConverter.$anonfun$checkForFulltextConfigValues$1(x0$1)))) {
            itemsMap.writeTo((AnyValueWriter)pp);
            throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "', contains fulltext config options.\n           |To create fulltext index, please use 'CREATE FULLTEXT INDEX ...'.")));
        }
    }

    public static /* synthetic */ Map assertEmptyConfig$(IndexOptionsConverter $this, AnyValue config, String schemaType, String indexType) {
        return $this.assertEmptyConfig(config, schemaType, indexType);
    }

    default public Map<String, Object> assertEmptyConfig(AnyValue config, String schemaType, String indexType) {
        PrettyPrinter pp = new PrettyPrinter();
        AnyValue anyValue = config;
        if (anyValue instanceof MapValue) {
            MapValue mapValue = (MapValue)anyValue;
            this.checkForFulltextConfigValues(pp, mapValue, schemaType);
            this.checkForPointConfigValues(pp, mapValue, schemaType);
            if (!mapValue.isEmpty()) {
                mapValue.writeTo((AnyValueWriter)pp);
                throw new InvalidArgumentsException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Could not create " + schemaType + " with specified index config '" + pp.value() + "': " + indexType + " indexes have no valid config values.")));
            }
            return Collections.emptyMap();
        }
        anyValue.writeTo((AnyValueWriter)pp);
        throw new InvalidArgumentsException("Could not create " + schemaType + " with specified index config '" + pp.value() + "'. Expected a map.");
    }

    public static /* synthetic */ boolean $anonfun$getOptionsParts$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !k.equalsIgnoreCase("indexProvider") && !k.equalsIgnoreCase("indexConfig");
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$checkForPointConfigValues$1(Tuple2 x0$1) {
        String p;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (p = (String)tuple2._1()) != null) {
            String string = p;
            return string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_CARTESIAN_3D_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_MAX.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MIN.getSettingName()) || string.equalsIgnoreCase(IndexSettingImpl.SPATIAL_WGS84_3D_MAX.getSettingName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$checkForFulltextConfigValues$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String p = (String)tuple2._1();
            return p.equalsIgnoreCase(IndexSettingImpl.FULLTEXT_ANALYZER.getSettingName()) || p.equalsIgnoreCase(IndexSettingImpl.FULLTEXT_EVENTUALLY_CONSISTENT.getSettingName());
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(IndexOptionsConverter $this) {
    }
}

