/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.cypher.internal.CacheabilityInfo;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.NotStale$;
import org.neo4j.cypher.internal.PlanStalenessCaller;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.Stale;
import org.neo4j.cypher.internal.Staleness;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.MissingLabelNotification;
import org.neo4j.cypher.internal.compiler.MissingPropertyNameNotification;
import org.neo4j.cypher.internal.compiler.MissingRelTypeNotification;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.symbols.ParameterTypeInfo;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0011Ma\u0001B-[\u0001\rD\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005[\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!b\u0001\n\u0003Y\b\"CA\f\u0001\t\u0005\t\u0015!\u0003}\u0011)\tI\u0002\u0001BC\u0002\u0013\u0005\u00111\u0004\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005u\u0001bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003{A\u0001\"!-\u0001A\u0003%\u0011q\b\u0005\n\u0003g\u0003!\u0019!C\u0005\u0003kC\u0001\"!0\u0001A\u0003%\u0011q\u0017\u0005\b\u0003\u007f\u0003A\u0011AAa\r\u0019\ti\u0006\u0001\u0001\u0002`!Q\u0011\u0011M\b\u0003\u0006\u0004%\t!a\u0019\t\u0015\u0005\u0015tB!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002h=\u0011)\u0019!C\u0001\u0003SB!\"!\u001d\u0010\u0005\u0003\u0005\u000b\u0011BA6\u0011\u001d\tic\u0004C\u0001\u0003gB\u0001\"!\u001f\u0010\u0001\u0004%I!\u001e\u0005\n\u0003wz\u0001\u0019!C\u0005\u0003{Bq!!#\u0010A\u0003&a\u000fC\u0004\u0002\u0014>!\t!!&\t\r\u0005]u\u0002\"\u0001v\u0011\u001d\tIj\u0004C\u0001\u00037Cq!a*\u0010\t\u0003\nI\u000bC\u0004\u0002.>!\t%a,\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"I!Q\u0004\u0001\u0012\u0002\u0013\u0005!q\u0004\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003b\u0001!IAa\u0019\t\u0013\t=\u0004!%A\u0005\n\tE\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\n\u0005\u0003\u0003\u0011\u0013!C\u0005\u0005cBqAa!\u0001\t\u0013\u0011)\tC\u0004\u0003\u0018\u0002!IA!'\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"9!q\u0016\u0001\u0005\u0002\u0005\u0005wa\u0002BY5\"\u0005!1\u0017\u0004\u00073jC\tA!.\t\u000f\u000552\u0006\"\u0001\u00038\u001a1!\u0011X\u0016C\u0005wC!Ba6.\u0005+\u0007I\u0011\u0001Bm\u0011)\u0011\u0019/\fB\tB\u0003%!1\u001c\u0005\u000b\u0005Kl#Q3A\u0005\u0002\t\u001d\bBCB\u0012[\tE\t\u0015!\u0003\u0003j\"Q1QE\u0017\u0003\u0016\u0004%\t!!\u001b\t\u0015\r\u001dRF!E!\u0002\u0013\tY\u0007C\u0004\u0002.5\"\ta!\u000b\t\u0013\rMR&!A\u0005\u0002\rU\u0002\"CB#[E\u0005I\u0011AB$\u0011%\u0019y%LI\u0001\n\u0003\u0019\t\u0006C\u0005\u0004Z5\n\n\u0011\"\u0001\u0004\\!I1qL\u0017\u0002\u0002\u0013\u00053\u0011\r\u0005\t\u0007[j\u0013\u0011!C\u0001k\"I1qN\u0017\u0002\u0002\u0013\u00051\u0011\u000f\u0005\n\u0007kj\u0013\u0011!C!\u0007oB\u0011\"!'.\u0003\u0003%\ta!\"\t\u0013\r%U&!A\u0005B\r-\u0005\"CAW[\u0005\u0005I\u0011IAX\u0011%\u0019y\"LA\u0001\n\u0003\u001ay\tC\u0005\u0002(6\n\t\u0011\"\u0011\u0004\u0012\u001eI1QS\u0016\u0002\u0002#\u00051q\u0013\u0004\n\u0005s[\u0013\u0011!E\u0001\u00073Cq!!\fD\t\u0003\u0019)\u000bC\u0005\u0004 \r\u000b\t\u0011\"\u0012\u0004\u0010\"I1qU\"\u0002\u0002\u0013\u00055\u0011\u0016\u0005\n\u0007s\u001b\u0015\u0011!CA\u0007wC\u0011b!6D\u0003\u0003%Iaa6\t\u0013\r}7F1A\u0005\u0002\r\u0005\b\u0002CBuW\u0001\u0006Iaa9\u0007\r\t58\u0006\u0001Bx\u0011)\u0011\tp\u0013BC\u0002\u0013%!1\u001f\u0005\u000b\u0007\u001fY%\u0011!Q\u0001\n\tU\b\"CB\t\u0017\n\u0005\t\u0015!\u0003w\u0011!\tic\u0013C\u0001W\rM\u0001bBAW\u0017\u0012\u0005\u0013q\u0016\u0005\b\u0003O[E\u0011IB\r\u0011\u001d\u0019yb\u0013C!\u0007C9qaa;,\u0011\u0003\u0019iOB\u0004\u0003n.B\taa<\t\u000f\u00055B\u000b\"\u0001\u0004r\"I11\u001f+C\u0002\u0013\u0015!q\u001d\u0005\t\u0007k$\u0006\u0015!\u0004\u0003j\"91q_\u0016\u0005\u0002\re(AC)vKJL8)Y2iK*\u00111\fX\u0001\tS:$XM\u001d8bY*\u0011QLX\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005}\u0003\u0017!\u00028f_RR'\"A1\u0002\u0007=\u0014xm\u0001\u0001\u0016\u000b\u0011\f)#!\u0002\u0014\u0005\u0001)\u0007C\u00014j\u001b\u00059'\"\u00015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)<'AB!osJ+g-\u0001\u0007dC\u000eDWMR1di>\u0014\u00180F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001(,A\u0003dC\u000eDW-\u0003\u0002s_\n!2)\u00194gK&tWmQ1dQ\u00164\u0015m\u0019;pef\fQbY1dQ\u00164\u0015m\u0019;pef\u0004\u0013aC7bq&lW/\\*ju\u0016,\u0012A\u001e\t\u0003M^L!\u0001_4\u0003\u0007%sG/\u0001\u0007nCbLW.^7TSj,\u0007%A\bti\u0006dWM\\3tg\u000e\u000bG\u000e\\3s+\u0005a\b\u0003B?\u007f\u0003\u0003i\u0011AW\u0005\u0003\u007fj\u00131\u0003\u00157b]N#\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004B!a\u0001\u0002\u00061\u0001AaBA\u0004\u0001\t\u0007\u0011\u0011\u0002\u0002\u0011\u000bb+5)\u0016+B\u00052+u,U+F%f\u000bB!a\u0003\u0002\u0012A\u0019a-!\u0004\n\u0007\u0005=qMA\u0004O_RD\u0017N\\4\u0011\u0007u\f\u0019\"C\u0002\u0002\u0016i\u0013\u0001cQ1dQ\u0016\f'-\u001b7jifLeNZ8\u0002!M$\u0018\r\\3oKN\u001c8)\u00197mKJ\u0004\u0013A\u0002;sC\u000e,'/\u0006\u0002\u0002\u001eA)a.a\b\u0002$%\u0019\u0011\u0011E8\u0003\u0017\r\u000b7\r[3Ue\u0006\u001cWM\u001d\t\u0005\u0003\u0007\t)\u0003B\u0004\u0002(\u0001\u0011\r!!\u000b\u0003\u0013E+VIU-`\u0017\u0016K\u0016cAA\u0006K\u00069AO]1dKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u00022\u0005M\u0012QGA\u001c\u0003s\u0001b! \u0001\u0002$\u0005\u0005\u0001\"B6\n\u0001\u0004i\u0007\"\u0002;\n\u0001\u00041\b\"\u0002>\n\u0001\u0004a\bbBA\r\u0013\u0001\u0007\u0011QD\u0001\u0010e\u0016lwN^1m\u0019&\u001cH/\u001a8feV\u0011\u0011q\b\t\t\u0003\u0003\n)&a\t\u0002Z5\u0011\u00111\t\u0006\u0004a\u0006\u0015#\u0002BA$\u0003\u0013\n\u0001bY1gM\u0016Lg.\u001a\u0006\u0005\u0003\u0017\ni%\u0001\u0005cK:l\u0017M\\3t\u0015\u0011\ty%!\u0015\u0002\r\u001dLG\u000f[;c\u0015\t\t\u0019&A\u0002d_6LA!a\u0016\u0002D\ty!+Z7pm\u0006dG*[:uK:,'\u000fE\u0002\u0002\\=i\u0011\u0001\u0001\u0002\f\u0007\u0006\u001c\u0007.\u001a3WC2,Xm\u0005\u0002\u0010K\u0006)a/\u00197vKV\u0011\u0011\u0011A\u0001\u0007m\u0006dW/\u001a\u0011\u0002?I,7m\\7qS2,GmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g.\u0006\u0002\u0002lA\u0019a-!\u001c\n\u0007\u0005=tMA\u0004C_>dW-\u00198\u0002AI,7m\\7qS2,GmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g\u000e\t\u000b\u0007\u00033\n)(a\u001e\t\u000f\u0005\u0005D\u00031\u0001\u0002\u0002!9\u0011q\r\u000bA\u0002\u0005-\u0014!D0ok6\u0014WM](g\u0011&$8/A\t`]Vl'-\u001a:PM\"KGo]0%KF$B!a \u0002\u0006B\u0019a-!!\n\u0007\u0005\ruM\u0001\u0003V]&$\b\u0002CAD-\u0005\u0005\t\u0019\u0001<\u0002\u0007a$\u0013'\u0001\b`]Vl'-\u001a:PM\"KGo\u001d\u0011)\u0007]\ti\tE\u0002g\u0003\u001fK1!!%h\u0005!1x\u000e\\1uS2,\u0017aB7be.D\u0015\u000e\u001e\u000b\u0003\u0003\u007f\nAB\\;nE\u0016\u0014xJ\u001a%jiN\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\ni\nC\u0004\u0002 j\u0001\r!!)\u0002\u000b=$\b.\u001a:\u0011\u0007\u0019\f\u0019+C\u0002\u0002&\u001e\u00141!\u00118z\u0003\u0019)\u0017/^1mgR!\u00111NAV\u0011\u001d\tyj\u0007a\u0001\u0003C\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002m\u0006\u0001\"/Z7pm\u0006dG*[:uK:,'\u000fI\u0001\u0006S:tWM]\u000b\u0003\u0003o\u0003\u0002\"!\u0011\u0002:\u0006\r\u0012\u0011L\u0005\u0005\u0003w\u000b\u0019EA\u0003DC\u000eDW-\u0001\u0004j]:,'\u000fI\u0001\u000eKN$\u0018.\\1uK\u0012\u001c\u0016N_3\u0015\u0005\u0005\r\u0007c\u00014\u0002F&\u0019\u0011qY4\u0003\t1{gnZ\u0001\u0017G>l\u0007/\u001e;f\u0013\u001a\f%m]3oi>\u00138\u000b^1mKRa\u0011\u0011AAg\u0003#\fI/a=\u0003\u0004!9\u0011qZ\u000fA\u0002\u0005\r\u0012\u0001C9vKJL8*Z=\t\u000f\u0005MW\u00041\u0001\u0002V\u0006\u0011Ao\u0019\t\u0005\u0003/\f)/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u0015\tX/\u001a:z\u0015\u0011\ty.!9\u0002\t%l\u0007\u000f\u001c\u0006\u0004\u0003Gt\u0016AB6fe:,G.\u0003\u0003\u0002h\u0006e'\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0002lv\u0001\r!!<\u0002\u0011\r|W\u000e]5mKJ\u0004R!`Ax\u0003\u0003I1!!=[\u0005\r\u001au.\u001c9jY\u0016\u0014x+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016tw\n\u001d;j_:Dq!!>\u001e\u0001\u0004\t90\u0001\bsKBd\u0017M\\*ue\u0006$XmZ=\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@[\u0003\u001dy\u0007\u000f^5p]NLAA!\u0001\u0002|\n\u00112)\u001f9iKJ\u0014V\r\u001d7b]>\u0003H/[8o\u0011%\u0011)!\bI\u0001\u0002\u0004\u00119!\u0001\u0005nKR\fG)\u0019;b!\u0011\u0011IAa\u0006\u000f\t\t-!1\u0003\t\u0004\u0005\u001b9WB\u0001B\b\u0015\r\u0011\tBY\u0001\u0007yI|w\u000e\u001e \n\u0007\tUq-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00053\u0011YB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005+9\u0017\u0001I2p[B,H/Z%g\u0003\n\u001cXM\u001c;PeN#\u0018\r\\3%I\u00164\u0017-\u001e7uIU*\"A!\t+\t\t\u001d!1E\u0016\u0003\u0005K\u0001BAa\n\u000325\u0011!\u0011\u0006\u0006\u0005\u0005W\u0011i#A\u0005v]\u000eDWmY6fI*\u0019!qF4\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00034\t%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y\u0012N\u001c<bY&$gj\u001c;jM&\u001c\u0017\r^5p]\u0016C\u0018n\u001d;j]\u001e$b!a\u001b\u0003:\tu\u0002b\u0002B\u001e?\u0001\u0007\u0011\u0011L\u0001\fG\u0006\u001c\u0007.\u001a3WC2,X\rC\u0004\u0002T~\u0001\r!!6\u0002+%\u001c\u0018J\u001c<bY&$gj\u001c;jM&\u001c\u0017\r^5p]R1\u00111\u000eB\"\u0005'BqA!\u0012!\u0001\u0004\u00119%\u0001\u0007o_RLg-[2bi&|g\u000e\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011iEW\u0001\u0005kRLG.\u0003\u0003\u0003R\t-#\u0001F%oi\u0016\u0014h.\u00197O_RLg-[2bi&|g\u000eC\u0004\u0002T\u0002\u0002\r!!6\u0002\u001dI,7m\\7qS2,wJ]$fiRQ\u0011\u0011\u0001B-\u00057\u0012iFa\u0018\t\u000f\tm\u0012\u00051\u0001\u0002Z!9\u00111^\u0011A\u0002\u00055\bbBAhC\u0001\u0007\u00111\u0005\u0005\b\u0005\u000b\t\u0003\u0019\u0001B\u0004\u0003=\u0019w.\u001c9jY\u0016\fe\u000eZ\"bG\",GCCA\u0001\u0005K\u00129G!\u001b\u0003l!9\u0011q\u001a\u0012A\u0002\u0005\r\u0002bBAvE\u0001\u0007\u0011Q\u001e\u0005\b\u0005\u000b\u0011\u0003\u0019\u0001B\u0004\u0011%\u0011iG\tI\u0001\u0002\u0004\tY'\u0001\u0005iSR\u001c\u0015m\u00195f\u0003e\u0019w.\u001c9jY\u0016\fe\u000eZ\"bG\",G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM$\u0006BA6\u0005G\tAeY8na&dWmV5uQ\u0016C\bO]3tg&|gnQ8eK\u001e+g.\u00118e\u0007\u0006\u001c\u0007.\u001a\u000b\u000b\u0003\u0003\u0011IHa\u001f\u0003~\t}\u0004bBAhI\u0001\u0007\u00111\u0005\u0005\b\u0003W$\u0003\u0019AAw\u0011\u001d\u0011)\u0001\na\u0001\u0005\u000fA\u0011B!\u001c%!\u0003\u0005\r!a\u001b\u0002]\r|W\u000e]5mK^KG\u000f[#yaJ,7o]5p]\u000e{G-Z$f]\u0006sGmQ1dQ\u0016$C-\u001a4bk2$H\u0005N\u0001.G>l\u0007/\u001b7f\u001fJ\u001cu.\u001c9jY\u0016<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:\fe\u000eZ\"bG\",GCCA\u0001\u0005\u000f\u0013IIa%\u0003\u0016\"9\u0011q\u001a\u0014A\u0002\u0005\r\u0002b\u0002BFM\u0001\u0007!QR\u0001\bG>l\u0007/\u001b7f!\u00151'qRA\u0001\u0013\r\u0011\tj\u001a\u0002\n\rVt7\r^5p]BBqA!\u0002'\u0001\u0004\u00119\u0001C\u0004\u0003n\u0019\u0002\r!a\u001b\u0002\u0007!LG\u000f\u0006\u0005\u0002\u0002\tm%Q\u0014BQ\u0011\u001d\tym\na\u0001\u0003GAqAa((\u0001\u0004\tI&A\bfq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z\u0011\u001d\u0011)a\na\u0001\u0005\u000f\tA!\\5tgRA\u0011\u0011\u0001BT\u0005S\u0013i\u000bC\u0004\u0002P\"\u0002\r!a\t\t\u000f\t-\u0006\u00061\u0001\u0002\u0002\u0005\u0011b.Z<Fq\u0016\u001cW\u000f^1cY\u0016\fV/\u001a:z\u0011\u001d\u0011)\u0001\u000ba\u0001\u0005\u000f\tQa\u00197fCJ\f!\"U;fef\u001c\u0015m\u00195f!\ti8f\u0005\u0002,KR\u0011!1\u0017\u0002\t\u0007\u0006\u001c\u0007.Z&fsV!!Q\u0018Bo'\u0019iSMa0\u0003FB\u0019aM!1\n\u0007\t\rwMA\u0004Qe>$Wo\u0019;\u0011\t\t\u001d'\u0011\u001b\b\u0005\u0005\u0013\u0014iM\u0004\u0003\u0003\u000e\t-\u0017\"\u00015\n\u0007\t=w-A\u0004qC\u000e\\\u0017mZ3\n\t\tM'Q\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0005\u001f<\u0017\u0001C9vKJL(+\u001a9\u0016\u0005\tm\u0007\u0003BA\u0002\u0005;$qAa8.\u0005\u0004\u0011\tOA\u0005R+\u0016\u0013\u0016l\u0018*F!F!\u00111BAQ\u0003%\tX/\u001a:z%\u0016\u0004\b%\u0001\tqCJ\fW.\u001a;feRK\b/Z'baV\u0011!\u0011\u001e\t\u0004\u0005W\\U\"A\u0016\u0003!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u00048CA&f\u0003%\u0011Xm];mi6\u000b\u0007/\u0006\u0002\u0003vBA!q\u001fB\u0000\u0005\u000f\u0019\u0019!\u0004\u0002\u0003z*!!Q\nB~\u0015\t\u0011i0\u0001\u0003kCZ\f\u0017\u0002BB\u0001\u0005s\u00141!T1q!\u0011\u0019)aa\u0003\u000e\u0005\r\u001d!\u0002BB\u0005\u0005\u0017\nqa]=nE>d7/\u0003\u0003\u0004\u000e\r\u001d!!\u0005)be\u0006lW\r^3s)f\u0004X-\u00138g_\u0006Q!/Z:vYRl\u0015\r\u001d\u0011\u0002\u0013}C\u0017m\u001d5D_\u0012,GC\u0002Bu\u0007+\u00199\u0002C\u0004\u0003r>\u0003\rA!>\t\r\rEq\n1\u0001w)\u0011\tYga\u0007\t\u000f\ru\u0011\u000b1\u0001\u0002\"\u0006\u0019qN\u00196\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0002\u0002#A\f'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004\b%A\tuqN#\u0018\r^3ICN\u001c\u0005.\u00198hKN\f!\u0003\u001e=Ti\u0006$X\rS1t\u0007\"\fgnZ3tAQA11FB\u0017\u0007_\u0019\t\u0004E\u0003\u0003l6\u0012Y\u000eC\u0004\u0003XR\u0002\rAa7\t\u000f\t\u0015H\u00071\u0001\u0003j\"91Q\u0005\u001bA\u0002\u0005-\u0014\u0001B2paf,Baa\u000e\u0004>QA1\u0011HB \u0007\u0003\u001a\u0019\u0005E\u0003\u0003l6\u001aY\u0004\u0005\u0003\u0002\u0004\ruBa\u0002Bpk\t\u0007!\u0011\u001d\u0005\n\u0005/,\u0004\u0013!a\u0001\u0007wA\u0011B!:6!\u0003\u0005\rA!;\t\u0013\r\u0015R\u0007%AA\u0002\u0005-\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0007\u0013\u001ai%\u0006\u0002\u0004L)\"!1\u001cB\u0012\t\u001d\u0011yN\u000eb\u0001\u0005C\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0004T\r]SCAB+U\u0011\u0011IOa\t\u0005\u000f\t}wG1\u0001\u0003b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002B9\u0007;\"qAa89\u0005\u0004\u0011\t/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007G\u0002Ba!\u001a\u0004l5\u00111q\r\u0006\u0005\u0007S\u0012Y0\u0001\u0003mC:<\u0017\u0002\u0002B\r\u0007O\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\"\u000eM\u0004\u0002CADw\u0005\u0005\t\u0019\u0001<\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u001f\u0011\r\rm4\u0011QAQ\u001b\t\u0019iHC\u0002\u0004\u0000\u001d\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019i! \u0003\u0011%#XM]1u_J$B!a\u001b\u0004\b\"I\u0011qQ\u001f\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0004d\r5\u0005\u0002CAD}\u0005\u0005\t\u0019\u0001<\u0015\u0005\r\rD\u0003BA6\u0007'C\u0011\"a\"B\u0003\u0003\u0005\r!!)\u0002\u0011\r\u000b7\r[3LKf\u00042Aa;D'\u0011\u0019Uma'\u0011\t\ru51U\u0007\u0003\u0007?SAa!)\u0003|\u0006\u0011\u0011n\\\u0005\u0005\u0005'\u001cy\n\u0006\u0002\u0004\u0018\u0006)\u0011\r\u001d9msV!11VBY)!\u0019ika-\u00046\u000e]\u0006#\u0002Bv[\r=\u0006\u0003BA\u0002\u0007c#qAa8G\u0005\u0004\u0011\t\u000fC\u0004\u0003X\u001a\u0003\raa,\t\u000f\t\u0015h\t1\u0001\u0003j\"91Q\u0005$A\u0002\u0005-\u0014aB;oCB\u0004H._\u000b\u0005\u0007{\u001bi\r\u0006\u0003\u0004@\u000e=\u0007#\u00024\u0004B\u000e\u0015\u0017bABbO\n1q\n\u001d;j_:\u0004\u0012BZBd\u0007\u0017\u0014I/a\u001b\n\u0007\r%wM\u0001\u0004UkBdWm\r\t\u0005\u0003\u0007\u0019i\rB\u0004\u0003`\u001e\u0013\rA!9\t\u0013\rEw)!AA\u0002\rM\u0017a\u0001=%aA)!1^\u0017\u0004L\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u001c\t\u0005\u0007K\u001aY.\u0003\u0003\u0004^\u000e\u001d$AB(cU\u0016\u001cG/A\u0006O\u001fR{\u0006KU#T\u000b:#VCABr!\ri8Q]\u0005\u0004\u0007OT&aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u00199{Ek\u0018)S\u000bN+e\n\u0016\u0011\u0002!A\u000b'/Y7fi\u0016\u0014H+\u001f9f\u001b\u0006\u0004\bc\u0001Bv)N\u0011A+\u001a\u000b\u0003\u0007[\fQ!Z7qif\fa!Z7qif\u0004\u0013aF3yiJ\f7\r\u001e)be\u0006lW\r^3s)f\u0004X-T1q)\u0019\u0011Ioa?\u0005\u0010!91Q -A\u0002\r}\u0018\u0001C7baZ\u000bG.^3\u0011\t\u0011\u0005A1B\u0007\u0003\t\u0007QA\u0001\"\u0002\u0005\b\u00059a/\u001b:uk\u0006d'b\u0001C\u0005=\u00061a/\u00197vKNLA\u0001\"\u0004\u0005\u0004\tAQ*\u00199WC2,X\rC\u0004\u0005\u0012a\u0003\r!a\u001b\u0002\u0017U\u001cXmU5{K\"Kg\u000e\u001e")
public class QueryCache<QUERY_KEY, EXECUTABLE_QUERY extends CacheabilityInfo> {
    private final CaffeineCacheFactory cacheFactory;
    private final int maximumSize;
    private final PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller;
    private final CacheTracer<QUERY_KEY> tracer;
    private final RemovalListener<QUERY_KEY, CachedValue> removalListener;
    private final Cache<QUERY_KEY, CachedValue> inner;

    public static ParameterTypeMap extractParameterTypeMap(MapValue mapValue, boolean useSizeHint) {
        return QueryCache$.MODULE$.extractParameterTypeMap(mapValue, useSizeHint);
    }

    public static ExecutableQuery NOT_PRESENT() {
        return QueryCache$.MODULE$.NOT_PRESENT();
    }

    public CaffeineCacheFactory cacheFactory() {
        return this.cacheFactory;
    }

    public int maximumSize() {
        return this.maximumSize;
    }

    public PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller() {
        return this.stalenessCaller;
    }

    public CacheTracer<QUERY_KEY> tracer() {
        return this.tracer;
    }

    public RemovalListener<QUERY_KEY, CachedValue> removalListener() {
        return this.removalListener;
    }

    private Cache<QUERY_KEY, CachedValue> inner() {
        return this.inner;
    }

    public long estimatedSize() {
        return this.inner().estimatedSize();
    }

    public EXECUTABLE_QUERY computeIfAbsentOrStale(QUERY_KEY queryKey, TransactionalContext tc, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, CypherReplanOption replanStrategy, String metaData) {
        if (this.maximumSize() == 0) {
            CacheabilityInfo result = (CacheabilityInfo)compiler.compile();
            this.tracer().compute(queryKey, metaData);
            return (EXECUTABLE_QUERY)result;
        }
        CachedValue cachedValue = (CachedValue)this.inner().getIfPresent(queryKey);
        ExecutableQuery executableQuery = QueryCache$.MODULE$.NOT_PRESENT();
        CachedValue cachedValue2 = cachedValue;
        if (!(executableQuery != null ? !executableQuery.equals(cachedValue2) : cachedValue2 != null)) {
            CypherReplanOption cypherReplanOption = replanStrategy;
            CypherReplanOption.force$ force$2 = CypherReplanOption.force$.MODULE$;
            if (!(cypherReplanOption != null ? !cypherReplanOption.equals(force$2) : force$2 != null)) {
                return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, this.compileWithExpressionCodeGenAndCache$default$4());
            }
            return this.compileAndCache(queryKey, compiler, metaData, this.compileAndCache$default$4());
        }
        cachedValue.markHit();
        CypherReplanOption cypherReplanOption = replanStrategy;
        if (CypherReplanOption.force$.MODULE$.equals(cypherReplanOption)) {
            return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, true);
        }
        if (CypherReplanOption.skip$.MODULE$.equals(cypherReplanOption)) {
            return this.hit(queryKey, cachedValue, metaData);
        }
        if (CypherReplanOption.default$.MODULE$.equals(cypherReplanOption)) {
            Staleness staleness = this.stalenessCaller().staleness(tc, cachedValue.value());
            if (NotStale$.MODULE$.equals(staleness)) {
                if (this.invalidNotificationExisting(cachedValue, tc)) {
                    return this.compileAndCache(queryKey, compiler, metaData, true);
                }
                return this.recompileOrGet(cachedValue, compiler, queryKey, metaData);
            }
            if (staleness instanceof Stale) {
                Stale stale = (Stale)staleness;
                int secondsSincePlan = stale.secondsSincePlan();
                Option<String> maybeReason = stale.maybeReason();
                this.tracer().cacheStale(queryKey, secondsSincePlan, metaData, maybeReason);
                if (cachedValue.recompiledWithExpressionCodeGen()) {
                    return this.compileWithExpressionCodeGenAndCache(queryKey, compiler, metaData, true);
                }
                return this.compileAndCache(queryKey, compiler, metaData, true);
            }
            throw new MatchError((Object)staleness);
        }
        throw new MatchError((Object)cypherReplanOption);
    }

    public String computeIfAbsentOrStale$default$5() {
        return "";
    }

    private boolean invalidNotificationExisting(CachedValue cachedValue, TransactionalContext tc) {
        IndexedSeq<InternalNotification> notifications = cachedValue.value().notifications();
        for (int i = 0; i < notifications.length(); ++i) {
            if (!this.isInvalidNotification((InternalNotification)notifications.apply(i), tc)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidNotification(InternalNotification notification, TransactionalContext tc) {
        InternalNotification internalNotification = notification;
        if (internalNotification instanceof MissingLabelNotification) {
            MissingLabelNotification missingLabelNotification = (MissingLabelNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().nodeLabel(missingLabelNotification.label()) != -1;
        }
        if (internalNotification instanceof MissingRelTypeNotification) {
            MissingRelTypeNotification missingRelTypeNotification = (MissingRelTypeNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().relationshipType(missingRelTypeNotification.relType()) != -1;
        }
        if (internalNotification instanceof MissingPropertyNameNotification) {
            MissingPropertyNameNotification missingPropertyNameNotification = (MissingPropertyNameNotification)internalNotification;
            return tc.kernelTransaction().tokenRead().propertyKey(missingPropertyNameNotification.name()) != -1;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EXECUTABLE_QUERY recompileOrGet(CachedValue cachedValue, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, QUERY_KEY queryKey, String metaData) {
        CachedValue cachedValue2;
        this.tracer().cacheHit(queryKey, metaData);
        if (!cachedValue.recompiledWithExpressionCodeGen()) {
            Option<EXECUTABLE_QUERY> option = compiler.maybeCompileWithExpressionCodeGen(cachedValue.numberOfHits());
            if (option instanceof Some) {
                Some some = (Some)option;
                CacheabilityInfo recompiledQuery = (CacheabilityInfo)some.value();
                this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
                CachedValue recompiled = new CachedValue(this, recompiledQuery, true);
                this.inner().put(queryKey, (Object)recompiled);
                cachedValue2 = recompiled;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cachedValue2 = cachedValue;
            }
        } else {
            cachedValue2 = cachedValue;
        }
        CachedValue newCachedValue = cachedValue2;
        return newCachedValue.value();
    }

    private EXECUTABLE_QUERY compileAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compile(), metaData, hitCache);
        this.tracer().compute(queryKey, metaData);
        return result;
    }

    private boolean compileAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, CompilerWithExpressionCodeGenOption<EXECUTABLE_QUERY> compiler, String metaData, boolean hitCache) {
        EXECUTABLE_QUERY result = this.compileOrCompileWithExpressionCodeGenAndCache(queryKey, (Function0 & Serializable)() -> (CacheabilityInfo)compiler.compileWithExpressionCodeGen(), metaData, hitCache);
        this.tracer().computeWithExpressionCodeGen(queryKey, metaData);
        return result;
    }

    private boolean compileWithExpressionCodeGenAndCache$default$4() {
        return false;
    }

    private EXECUTABLE_QUERY compileOrCompileWithExpressionCodeGenAndCache(QUERY_KEY queryKey, Function0<EXECUTABLE_QUERY> compile, String metaData, boolean hitCache) {
        CacheabilityInfo newExecutableQuery = (CacheabilityInfo)compile.apply();
        if (newExecutableQuery.shouldBeCached()) {
            CachedValue cachedValue = new CachedValue(this, newExecutableQuery, false);
            this.inner().put(queryKey, (Object)cachedValue);
            if (hitCache) {
                return this.hit(queryKey, cachedValue, metaData);
            }
            return (EXECUTABLE_QUERY)this.miss(queryKey, newExecutableQuery, metaData);
        }
        return (EXECUTABLE_QUERY)this.miss(queryKey, newExecutableQuery, metaData);
    }

    private EXECUTABLE_QUERY hit(QUERY_KEY queryKey, CachedValue executableQuery, String metaData) {
        this.tracer().cacheHit(queryKey, metaData);
        return executableQuery.value();
    }

    private EXECUTABLE_QUERY miss(QUERY_KEY queryKey, EXECUTABLE_QUERY newExecutableQuery, String metaData) {
        this.tracer().cacheMiss(queryKey, metaData);
        return newExecutableQuery;
    }

    public long clear() {
        long priorSize = this.inner().estimatedSize();
        this.inner().invalidateAll();
        this.inner().cleanUp();
        this.tracer().cacheFlush(priorSize);
        return priorSize;
    }

    public QueryCache(CaffeineCacheFactory cacheFactory, int maximumSize, PlanStalenessCaller<EXECUTABLE_QUERY> stalenessCaller, CacheTracer<QUERY_KEY> tracer) {
        this.cacheFactory = cacheFactory;
        this.maximumSize = maximumSize;
        this.stalenessCaller = stalenessCaller;
        this.tracer = tracer;
        this.removalListener = (key, value, cause) -> this.tracer().discard(key, "");
        this.inner = cacheFactory.createCache(maximumSize, this.removalListener());
    }

    public static final class CacheKey<QUERY_REP>
    implements Product,
    Serializable {
        private final QUERY_REP queryRep;
        private final ParameterTypeMap parameterTypeMap;
        private final boolean txStateHasChanges;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public QUERY_REP queryRep() {
            return this.queryRep;
        }

        public ParameterTypeMap parameterTypeMap() {
            return this.parameterTypeMap;
        }

        public boolean txStateHasChanges() {
            return this.txStateHasChanges;
        }

        public <QUERY_REP> CacheKey<QUERY_REP> copy(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            return new CacheKey<QUERY_REP>(queryRep, parameterTypeMap, txStateHasChanges);
        }

        public <QUERY_REP> QUERY_REP copy$default$1() {
            return this.queryRep();
        }

        public <QUERY_REP> ParameterTypeMap copy$default$2() {
            return this.parameterTypeMap();
        }

        public <QUERY_REP> boolean copy$default$3() {
            return this.txStateHasChanges();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.queryRep();
                }
                case 1: {
                    return this.parameterTypeMap();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.txStateHasChanges());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "queryRep";
                }
                case 1: {
                    return "parameterTypeMap";
                }
                case 2: {
                    return "txStateHasChanges";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryRep()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.parameterTypeMap()));
            n = Statics.mix((int)n, (int)(this.txStateHasChanges() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            if (this.txStateHasChanges() != cacheKey.txStateHasChanges()) return false;
            if (!BoxesRunTime.equals(this.queryRep(), cacheKey.queryRep())) return false;
            ParameterTypeMap parameterTypeMap = this.parameterTypeMap();
            ParameterTypeMap parameterTypeMap2 = cacheKey.parameterTypeMap();
            if (parameterTypeMap != null) {
                if (!((Object)parameterTypeMap).equals(parameterTypeMap2)) return false;
                return true;
            }
            if (parameterTypeMap2 == null) return true;
            return false;
        }

        public CacheKey(QUERY_REP queryRep, ParameterTypeMap parameterTypeMap, boolean txStateHasChanges) {
            this.queryRep = queryRep;
            this.parameterTypeMap = parameterTypeMap;
            this.txStateHasChanges = txStateHasChanges;
            Product.$init$((Product)this);
        }
    }

    public class CachedValue {
        private final EXECUTABLE_QUERY value;
        private final boolean recompiledWithExpressionCodeGen;
        private volatile int _numberOfHits;
        public final /* synthetic */ QueryCache $outer;

        public EXECUTABLE_QUERY value() {
            return this.value;
        }

        public boolean recompiledWithExpressionCodeGen() {
            return this.recompiledWithExpressionCodeGen;
        }

        private int _numberOfHits() {
            return this._numberOfHits;
        }

        private void _numberOfHits_$eq(int x$1) {
            this._numberOfHits = x$1;
        }

        public void markHit() {
            if (!this.recompiledWithExpressionCodeGen()) {
                this._numberOfHits_$eq(this._numberOfHits() + 1);
                return;
            }
        }

        public int numberOfHits() {
            return this._numberOfHits();
        }

        public boolean canEqual(Object other) {
            return other instanceof CachedValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CachedValue)) return false;
            if (((CachedValue)object).org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() != this.org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer()) return false;
            CachedValue cachedValue = (CachedValue)object;
            if (!cachedValue.canEqual(this)) return false;
            Object EXECUTABLE_QUERY = this.value();
            Object EXECUTABLE_QUERY2 = cachedValue.value();
            if (EXECUTABLE_QUERY != null) {
                if (!EXECUTABLE_QUERY.equals(EXECUTABLE_QUERY2)) return false;
                return true;
            }
            if (EXECUTABLE_QUERY2 == null) return true;
            return false;
        }

        public int hashCode() {
            .colon.colon state = new .colon.colon(this.value(), (List)Nil$.MODULE$);
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public /* synthetic */ QueryCache org$neo4j$cypher$internal$QueryCache$CachedValue$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public CachedValue(EXECUTABLE_QUERY value, boolean recompiledWithExpressionCodeGen) {
            this.value = value;
            this.recompiledWithExpressionCodeGen = recompiledWithExpressionCodeGen;
            if ($outer == null) {
                throw null;
            }
            this.$outer = (QueryCache)$outer;
            this._numberOfHits = 0;
        }
    }

    public static class ParameterTypeMap {
        private final Map<String, ParameterTypeInfo> resultMap;
        private final int _hashCode;

        private Map<String, ParameterTypeInfo> resultMap() {
            return this.resultMap;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ParameterTypeMap) {
                ParameterTypeMap parameterTypeMap = (ParameterTypeMap)object;
                if (this.resultMap().size() == parameterTypeMap.resultMap().size()) {
                    Map<String, ParameterTypeInfo> otherMap = parameterTypeMap.resultMap();
                    java.util.Iterator<Map.Entry<String, ParameterTypeInfo>> entries = otherMap.entrySet().iterator();
                    boolean stillEqual = true;
                    while (entries.hasNext() && stillEqual) {
                        Map.Entry<String, ParameterTypeInfo> entry = entries.next();
                        String otherKey = entry.getKey();
                        ParameterTypeInfo otherValue = entry.getValue();
                        ParameterTypeInfo value = this.resultMap().get(otherKey);
                        stillEqual = otherValue.equals((Object)value);
                    }
                    return stillEqual;
                }
            }
            return false;
        }

        public String toString() {
            return CollectionConverters$.MODULE$.MapHasAsScala(this.resultMap()).asScala().toString();
        }

        public ParameterTypeMap(Map<String, ParameterTypeInfo> resultMap, int _hashCode) {
            this.resultMap = resultMap;
            this._hashCode = _hashCode;
        }
    }
}

