/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.Locale;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.cypher.internal.OptionsConverter;
import org.neo4j.cypher.internal.ServerOptions;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ServerOptionsConverter$
implements OptionsConverter<ServerOptions>,
Product,
Serializable {
    public static final ServerOptionsConverter$ MODULE$ = new ServerOptionsConverter$();
    private static final String ALLOWED_DATABASES;
    private static final String DENIED_DATABASES;
    private static final String MODE_CONSTRAINT;
    private static final String TAGS;
    private static final String VISIBLE_PERMITTED_OPTIONS;
    private static ExpressionEvaluator evaluator;

    static {
        OptionsConverter.$init$(MODULE$);
        Product.$init$((Product)MODULE$);
        ALLOWED_DATABASES = "allowedDatabases";
        DENIED_DATABASES = "deniedDatabases";
        MODE_CONSTRAINT = "modeConstraint";
        TAGS = "tags";
        VISIBLE_PERMITTED_OPTIONS = "'" + MODULE$.ALLOWED_DATABASES() + "', '" + MODULE$.DENIED_DATABASES() + "', '" + MODULE$.MODE_CONSTRAINT() + "'";
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public AnyValue evaluate(Expression expression, MapValue params) {
        return OptionsConverter.evaluate$(this, expression, params);
    }

    @Override
    public Option<ServerOptions> convert(Options options, MapValue params, Option<Config> config) {
        return OptionsConverter.convert$(this, options, params, config);
    }

    @Override
    public Option<Config> convert$default$3() {
        return OptionsConverter.convert$default$3$(this);
    }

    @Override
    public ExpressionEvaluator evaluator() {
        return evaluator;
    }

    @Override
    public void org$neo4j$cypher$internal$OptionsConverter$_setter_$evaluator_$eq(ExpressionEvaluator x$1) {
        evaluator = x$1;
    }

    private String ALLOWED_DATABASES() {
        return ALLOWED_DATABASES;
    }

    private String DENIED_DATABASES() {
        return DENIED_DATABASES;
    }

    private String MODE_CONSTRAINT() {
        return MODE_CONSTRAINT;
    }

    private String TAGS() {
        return TAGS;
    }

    public String VISIBLE_PERMITTED_OPTIONS() {
        return VISIBLE_PERMITTED_OPTIONS;
    }

    @Override
    public String operation() {
        return "enable server";
    }

    @Override
    public ServerOptions convert(MapValue map, Option<Config> config) {
        return MapValueOps$.MODULE$.Ops(map).foldLeft(new ServerOptions((Option<Set<NormalizedDatabaseName>>)None$.MODULE$, (Option<Set<NormalizedDatabaseName>>)None$.MODULE$, (Option<InstanceModeConstraint>)None$.MODULE$, (Option<List<String>>)None$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                ServerOptions ops = (ServerOptions)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    AnyValue value = (AnyValue)tuple22._2();
                    if (key.equalsIgnoreCase(MODULE$.ALLOWED_DATABASES())) {
                        AnyValue anyValue = value;
                        if (anyValue instanceof ListValue) {
                            ListValue listValue = (ListValue)anyValue;
                            Set databases = CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$2 -> {
                                AnyValue anyValue = x0$2;
                                if (anyValue instanceof TextValue) {
                                    TextValue textValue = (TextValue)anyValue;
                                    return new NormalizedDatabaseName(textValue.stringValue());
                                }
                                throw new InvalidArgumentsException(MODULE$.ALLOWED_DATABASES() + " expects a list of database names but got '" + listValue + "'.");
                            }).toSet();
                            return ops.copy((Option<Set<NormalizedDatabaseName>>)new Some((Object)databases), ops.copy$default$2(), ops.copy$default$3(), ops.copy$default$4());
                        }
                        if (anyValue instanceof TextValue) {
                            TextValue textValue = (TextValue)anyValue;
                            return ops.copy((Option<Set<NormalizedDatabaseName>>)new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NormalizedDatabaseName[]{new NormalizedDatabaseName(textValue.stringValue())}))), ops.copy$default$2(), ops.copy$default$3(), ops.copy$default$4());
                        }
                        if (anyValue != null) {
                            AnyValue anyValue2 = anyValue;
                            throw new InvalidArgumentsException(MODULE$.ALLOWED_DATABASES() + " expects a list of database names but got '" + anyValue2 + "'.");
                        }
                        throw new MatchError((Object)anyValue);
                    }
                    if (key.equalsIgnoreCase(MODULE$.DENIED_DATABASES())) {
                        AnyValue anyValue = value;
                        if (anyValue instanceof ListValue) {
                            ListValue listValue = (ListValue)anyValue;
                            Set databases = CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$3 -> {
                                AnyValue anyValue = x0$3;
                                if (anyValue instanceof TextValue) {
                                    TextValue textValue = (TextValue)anyValue;
                                    return new NormalizedDatabaseName(textValue.stringValue());
                                }
                                throw new InvalidArgumentsException(MODULE$.DENIED_DATABASES() + " expects a list of database names but got '" + listValue + "'.");
                            }).toSet();
                            Some x$1 = new Some((Object)databases);
                            Option<Set<NormalizedDatabaseName>> x$2 = ops.copy$default$1();
                            Option<InstanceModeConstraint> x$3 = ops.copy$default$3();
                            Option<List<String>> x$4 = ops.copy$default$4();
                            return ops.copy(x$2, (Option<Set<NormalizedDatabaseName>>)x$1, x$3, x$4);
                        }
                        if (anyValue instanceof TextValue) {
                            TextValue textValue = (TextValue)anyValue;
                            Some x$5 = new Some(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NormalizedDatabaseName[]{new NormalizedDatabaseName(textValue.stringValue())})));
                            Option<Set<NormalizedDatabaseName>> x$6 = ops.copy$default$1();
                            Option<InstanceModeConstraint> x$7 = ops.copy$default$3();
                            Option<List<String>> x$8 = ops.copy$default$4();
                            return ops.copy(x$6, (Option<Set<NormalizedDatabaseName>>)x$5, x$7, x$8);
                        }
                        if (anyValue != null) {
                            AnyValue anyValue3 = anyValue;
                            throw new InvalidArgumentsException(MODULE$.DENIED_DATABASES() + " expects a list of database names but got '" + anyValue3 + "'.");
                        }
                        throw new MatchError((Object)anyValue);
                    }
                    if (key.equalsIgnoreCase(MODULE$.MODE_CONSTRAINT())) {
                        AnyValue anyValue = value;
                        if (anyValue instanceof TextValue) {
                            InstanceModeConstraint instanceModeConstraint;
                            TextValue textValue = (TextValue)anyValue;
                            try {
                                instanceModeConstraint = InstanceModeConstraint.valueOf((String)textValue.stringValue().toUpperCase(Locale.ROOT));
                            }
                            catch (Exception exception) {
                                throw new InvalidArgumentsException(MODULE$.MODE_CONSTRAINT() + " expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '" + value + "'.");
                            }
                            InstanceModeConstraint mode = instanceModeConstraint;
                            Some x$9 = new Some((Object)mode);
                            Option<Set<NormalizedDatabaseName>> x$10 = ops.copy$default$1();
                            Option<Set<NormalizedDatabaseName>> x$11 = ops.copy$default$2();
                            Option<List<String>> x$12 = ops.copy$default$4();
                            return ops.copy(x$10, x$11, (Option<InstanceModeConstraint>)x$9, x$12);
                        }
                        if (anyValue != null) {
                            AnyValue anyValue4 = anyValue;
                            throw new InvalidArgumentsException(MODULE$.MODE_CONSTRAINT() + " expects 'NONE', 'PRIMARY' or 'SECONDARY' but got '" + anyValue4 + "'.");
                        }
                        throw new MatchError((Object)anyValue);
                    }
                    if (key.equalsIgnoreCase(MODULE$.TAGS())) {
                        AnyValue anyValue = value;
                        if (anyValue instanceof ListValue) {
                            ListValue listValue = (ListValue)anyValue;
                            List tags = CollectionConverters$.MODULE$.IteratorHasAsScala(listValue.iterator()).asScala().map((Function1 & Serializable)x0$4 -> {
                                AnyValue anyValue = x0$4;
                                if (anyValue instanceof TextValue) {
                                    TextValue textValue = (TextValue)anyValue;
                                    return textValue.stringValue();
                                }
                                throw new InvalidArgumentsException(MODULE$.TAGS() + " expects a list of tags but got '" + listValue + "'.");
                            }).toList();
                            Some x$13 = new Some((Object)tags);
                            Option<Set<NormalizedDatabaseName>> x$14 = ops.copy$default$1();
                            Option<Set<NormalizedDatabaseName>> x$15 = ops.copy$default$2();
                            Option<InstanceModeConstraint> x$16 = ops.copy$default$3();
                            return ops.copy(x$14, x$15, x$16, (Option<List<String>>)x$13);
                        }
                        if (anyValue instanceof TextValue) {
                            TextValue textValue = (TextValue)anyValue;
                            Some x$17 = new Some((Object)new .colon.colon((Object)textValue.stringValue(), (List)Nil$.MODULE$));
                            Option<Set<NormalizedDatabaseName>> x$18 = ops.copy$default$1();
                            Option<Set<NormalizedDatabaseName>> x$19 = ops.copy$default$2();
                            Option<InstanceModeConstraint> x$20 = ops.copy$default$3();
                            return ops.copy(x$18, x$19, x$20, (Option<List<String>>)x$17);
                        }
                        if (anyValue != null) {
                            AnyValue anyValue5 = anyValue;
                            throw new InvalidArgumentsException(MODULE$.TAGS() + " expects a list of tags names but got '" + anyValue5 + "'.");
                        }
                        throw new MatchError((Object)anyValue);
                    }
                    throw new InvalidArgumentsException("Unrecognised option '" + key + "', expected " + MODULE$.VISIBLE_PERMITTED_OPTIONS() + ".");
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String productPrefix() {
        return "ServerOptionsConverter";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ServerOptionsConverter$;
    }

    public int hashCode() {
        return -1985745371;
    }

    public String toString() {
        return "ServerOptionsConverter";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ServerOptionsConverter$.class);
    }

    private ServerOptionsConverter$() {
    }
}

