/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade.lucene;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.upgrade.loader.JarLoaderSupplier;
import org.neo4j.upgrade.lucene.ExplicitIndexMigrationException;
import org.neo4j.upgrade.lucene.IndexUpgraderWrapper;

public class LuceneExplicitIndexUpgrader {
    public static final Monitor NO_MONITOR = new Monitor(){};
    private static final String LIBRARY_DIRECTORY = "lib";
    private static final String RESOURCE_SEPARATOR = "/";
    private static final String LUCENE4_CORE_JAR_NAME = "lucene-core-4.10.4.jar";
    private static final String LUCENE5_CORE_JAR_NAME = "lucene-core-5.5.0.jar";
    private static final String LUCENE5_BACKWARD_CODECS_NAME = "lucene-backward-codecs-5.5.0.jar";
    private static final String SEGMENTS_FILE_NAME_PREFIX = "segments";
    private final Path indexRootPath;
    private final Monitor monitor;

    public LuceneExplicitIndexUpgrader(Path indexRootPath, Monitor monitor) {
        this.monitor = monitor;
        if (Files.exists(indexRootPath, new LinkOption[0]) && !Files.isDirectory(indexRootPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Index path should be a directory");
        }
        this.indexRootPath = indexRootPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upgradeIndexes() throws ExplicitIndexMigrationException {
        try {
            if (!Files.exists(this.indexRootPath, new LinkOption[0])) {
                return;
            }
            this.monitor.starting((int)Files.walk(this.indexRootPath, new FileVisitOption[0]).count());
            try (Stream<Path> pathStream = Files.walk(this.indexRootPath, new FileVisitOption[0]);
                 IndexUpgraderWrapper lucene4Upgrader = this.createIndexUpgrader(LuceneExplicitIndexUpgrader.getLucene4JarPaths());
                 IndexUpgraderWrapper lucene5Upgrader = this.createIndexUpgrader(LuceneExplicitIndexUpgrader.getLucene5JarPaths());){
                List indexPaths = pathStream.filter(LuceneExplicitIndexUpgrader.getIndexPathFilter()).collect(Collectors.toList());
                for (Path indexPath : indexPaths) {
                    try {
                        lucene4Upgrader.upgradeIndex(indexPath);
                        lucene5Upgrader.upgradeIndex(indexPath);
                        this.monitor.migrated(indexPath.toFile().getName());
                    }
                    catch (Throwable e) {
                        throw new ExplicitIndexMigrationException(indexPath.getFileName().toString(), "Migration of explicit index at path:" + indexPath + " failed.", e);
                        return;
                    }
                }
            }
        }
        catch (ExplicitIndexMigrationException ime) {
            throw ime;
        }
        catch (Exception e) {
            throw new RuntimeException("Lucene explicit indexes migration failed.", e);
        }
    }

    IndexUpgraderWrapper createIndexUpgrader(String[] jars) {
        return new IndexUpgraderWrapper(JarLoaderSupplier.of(jars));
    }

    private static String[] getLucene5JarPaths() {
        return LuceneExplicitIndexUpgrader.getJarsFullPaths(LUCENE5_CORE_JAR_NAME, LUCENE5_BACKWARD_CODECS_NAME);
    }

    private static String[] getLucene4JarPaths() {
        return LuceneExplicitIndexUpgrader.getJarsFullPaths(LUCENE4_CORE_JAR_NAME);
    }

    private static String[] getJarsFullPaths(String ... jars) {
        return (String[])Stream.of(jars).map(LuceneExplicitIndexUpgrader::getJarPath).toArray(String[]::new);
    }

    private static String getJarPath(String library) {
        return "lib/" + library;
    }

    private static Predicate<Path> getIndexPathFilter() {
        return path -> {
            try {
                return Files.isDirectory(path, new LinkOption[0]) && LuceneExplicitIndexUpgrader.isIndexDirectory(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static boolean isIndexDirectory(Path path) throws IOException {
        try (Stream<Path> pathStream = Files.list(path);){
            boolean bl = pathStream.anyMatch(child -> child.getFileName().toString().startsWith(SEGMENTS_FILE_NAME_PREFIX));
            return bl;
        }
    }

    public static interface Monitor {
        default public void starting(int count) {
        }

        default public void migrated(String name) {
        }
    }
}

