/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.response;

import org.neo4j.graphdb.Result;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmbeddedResponse<T>
implements Response {
    protected final Result result;
    private final Logger logger = LoggerFactory.getLogger(EmbeddedResponse.class);
    private final TransactionManager transactionManager;

    public EmbeddedResponse(Result result, TransactionManager transactionManager) {
        this.logger.debug("Response opened: {}", (Object)this);
        this.transactionManager = transactionManager;
        this.result = result;
    }

    public abstract T next();

    public void close() {
        if (this.transactionManager.getCurrentTransaction() != null) {
            this.result.close();
            this.logger.debug("Response closed: {}", (Object)this);
        }
    }

    public String[] columns() {
        return this.result.columns().toArray(new String[this.result.columns().size()]);
    }
}

