/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.util.ArrayList;
import java.util.List;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class ArrayPropertyValueMapping
extends InstancePropertyValueMapping {
    public static void addArrayPropertyValueToDoc(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument.Builder builder, PropertyKeywords keywords, ArrayPropertyValue value) {
        builder.put(keywords.getSearchablePath(), ArrayPropertyValueMapping.getArrayPropertyValueForComparison(xtdbConnector, value));
    }

    public static IPersistentMap addArrayPropertyValueToDoc(IPersistentMap doc, Keyword propertyKeyword, ArrayPropertyValue value) throws InvalidParameterException {
        return doc.assoc((Object)propertyKeyword, ArrayPropertyValueMapping.getArrayPropertyValueForComparison(value));
    }

    public static List<Object> getArrayPropertyValueForComparison(XtdbOMRSRepositoryConnector xtdbConnector, ArrayPropertyValue apv) {
        InstanceProperties values = apv.getArrayValues();
        if (values != null) {
            ArrayList<Object> results = new ArrayList<Object>();
            int total = apv.getArrayCount();
            for (int i = 0; i < total; ++i) {
                InstancePropertyValue value = values.getPropertyValue("" + i);
                Object toCompare = ArrayPropertyValueMapping.getValueForComparison(xtdbConnector, value);
                if (toCompare == null) continue;
                results.add(toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public static List<Object> getArrayPropertyValueForComparison(ArrayPropertyValue apv) throws InvalidParameterException {
        InstanceProperties values = apv.getArrayValues();
        if (values != null) {
            ArrayList<Object> results = new ArrayList<Object>();
            int total = apv.getArrayCount();
            for (int i = 0; i < total; ++i) {
                InstancePropertyValue value = values.getPropertyValue("" + i);
                Object toCompare = ArrayPropertyValueMapping.getValueForComparison(value);
                if (toCompare == null) continue;
                results.add(toCompare);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }
}

