/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.Constants;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class InstanceHeaderMapping
extends InstanceAuditHeaderMapping {
    private static final String INSTANCE_HEADER = "InstanceHeader";
    private static final String INSTANCE_URL = "instanceURL";
    private static final String N_RE_IDENTIFIED_FROM_GUID = "reIdentifiedFromGUID";
    public static final String RE_IDENTIFIED_FROM_GUID = InstanceHeaderMapping.getKeyword("reIdentifiedFromGUID");
    private static final Set<String> KNOWN_PROPERTIES = InstanceHeaderMapping.createKnownProperties();
    protected InstanceHeader instanceHeader;
    protected XtdbDocument xtdbDoc;

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(INSTANCE_URL);
        set.add(RE_IDENTIFIED_FROM_GUID);
        return set;
    }

    protected InstanceHeaderMapping(XtdbOMRSRepositoryConnector xtdbConnector, InstanceHeader instanceHeader) {
        super(xtdbConnector);
        this.instanceHeader = instanceHeader;
    }

    protected InstanceHeaderMapping(XtdbOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc) {
        super(xtdbConnector);
        this.xtdbDoc = xtdbDoc;
    }

    public XtdbDocument toXTDB() {
        if (this.xtdbDoc == null && this.instanceHeader != null) {
            this.xtdbDoc = this.toDoc().build();
        }
        return this.xtdbDoc;
    }

    protected XtdbDocument.Builder toDoc() {
        XtdbDocument.Builder builder = XtdbDocument.builder((Object)InstanceHeaderMapping.getGuidReference(this.xtdbConnector, this.instanceHeader));
        try {
            InstanceAuditHeaderMapping.buildDoc(builder, (InstanceAuditHeader)this.instanceHeader);
        }
        catch (IOException e) {
            this.xtdbConnector.logProblem(ClassificationMapping.class.getName(), "addToXtdbDoc", XtdbOMRSAuditCode.SERIALIZATION_FAILURE, e, "<unknown>", this.instanceHeader.getType().getTypeDefName(), e.getClass().getName());
        }
        builder.put(INSTANCE_URL, (Object)this.instanceHeader.getInstanceURL());
        builder.put(RE_IDENTIFIED_FROM_GUID, (Object)this.instanceHeader.getReIdentifiedFromGUID());
        return builder;
    }

    public static IPersistentMap toMap(InstanceHeader header) throws InvalidParameterException, IOException {
        PersistentHashMap doc = PersistentHashMap.EMPTY;
        IPersistentVector tuple = InstanceAuditHeaderMapping.addToMap((IPersistentMap)doc, (InstanceAuditHeader)header, null);
        doc = (IPersistentMap)tuple.nth(1);
        return doc.assoc((Object)Constants.XTDB_PK, (Object)InstanceHeaderMapping.getGuidReference(header)).assoc((Object)Keyword.intern((String)INSTANCE_URL), (Object)header.getInstanceURL()).assoc((Object)Keyword.intern((String)RE_IDENTIFIED_FROM_GUID), (Object)header.getReIdentifiedFromGUID());
    }

    protected void fromDoc() {
        super.fromDoc((InstanceAuditHeader)this.instanceHeader, this.xtdbDoc);
        String methodName = "fromDoc";
        String guid = (String)this.xtdbDoc.getId();
        this.instanceHeader.setGUID(guid == null ? null : InstanceHeaderMapping.trimGuidFromReference(guid));
        for (String property : KNOWN_PROPERTIES) {
            String value;
            Object objValue = this.xtdbDoc.get(property);
            String string = value = objValue == null ? null : objValue.toString();
            if (INSTANCE_URL.equals(property)) {
                this.instanceHeader.setInstanceURL(value);
                continue;
            }
            if (RE_IDENTIFIED_FROM_GUID.equals(property)) {
                this.instanceHeader.setReIdentifiedFromGUID(value);
                continue;
            }
            this.xtdbConnector.logProblem(this.getClass().getName(), "fromDoc", XtdbOMRSAuditCode.UNMAPPED_PROPERTY, null, property, INSTANCE_HEADER);
        }
    }

    protected static void fromMap(InstanceHeader ih, IPersistentMap doc) throws IOException, InvalidParameterException {
        InstanceAuditHeaderMapping.fromMap((InstanceAuditHeader)ih, doc, null);
        String methodName = "fromMap";
        String guid = AbstractTransactionFunction.getGUID(doc);
        ih.setGUID(guid == null ? null : InstanceHeaderMapping.trimGuidFromReference(guid));
        for (String property : KNOWN_PROPERTIES) {
            String value;
            Object objValue = doc.valAt((Object)Keyword.intern((String)property));
            String string = value = objValue == null ? null : objValue.toString();
            if (INSTANCE_URL.equals(property)) {
                ih.setInstanceURL(value);
                continue;
            }
            if (RE_IDENTIFIED_FROM_GUID.equals(property)) {
                ih.setReIdentifiedFromGUID(value);
                continue;
            }
            throw new InvalidParameterException(XtdbOMRSErrorCode.UNMAPPABLE_PROPERTY.getMessageDefinition(property), InstanceHeader.class.getName(), "fromMap", "property");
        }
    }

    public static String getGuidReference(XtdbOMRSRepositoryConnector xtdbConnector, InstanceHeader ih) {
        String methodName = "getGuidReference";
        TypeDefCategory type = ih.getType().getTypeDefCategory();
        if (type.equals((Object)TypeDefCategory.ENTITY_DEF)) {
            return InstanceHeaderMapping.getReference("e", ih.getGUID());
        }
        if (type.equals((Object)TypeDefCategory.RELATIONSHIP_DEF)) {
            return InstanceHeaderMapping.getReference("r", ih.getGUID());
        }
        xtdbConnector.logProblem(InstanceHeaderMapping.class.getName(), "getGuidReference", XtdbOMRSAuditCode.NON_INSTANCE_RETRIEVAL, null, type.name());
        return null;
    }

    public static String getGuidReference(InstanceHeader ih) throws InvalidParameterException {
        String methodName = "getGuidReference";
        TypeDefCategory type = ih.getType().getTypeDefCategory();
        if (type.equals((Object)TypeDefCategory.ENTITY_DEF)) {
            return InstanceHeaderMapping.getReference("e", ih.getGUID());
        }
        if (type.equals((Object)TypeDefCategory.RELATIONSHIP_DEF)) {
            return InstanceHeaderMapping.getReference("r", ih.getGUID());
        }
        throw new InvalidParameterException(XtdbOMRSErrorCode.BAD_CATEGORY_FOR_TYPEDEF_ATTRIBUTE.getMessageDefinition(type.getName()), InstancePropertyValueMapping.class.getName(), "getGuidReference", "type");
    }

    public static String trimGuidFromReference(String reference) {
        return reference.substring(reference.indexOf("_") + 1);
    }

    protected static String getReference(String instanceType, String guid) {
        return instanceType + "_" + guid;
    }
}

