/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.model;

import xtdb.api.IXtdb;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class PersistenceLayer {
    public static final long LATEST_VERSION = 3L;
    private static final String PERSISTENCE_DOC = "egeria-connector-xtdb/persistence-layer";
    private static final String VERSION = "egeria-connector-xtdb/persistence-layer.version";

    private PersistenceLayer() {
    }

    public static long getVersion(IXtdb xtdbAPI) {
        Object version;
        XtdbDocument doc = PersistenceLayer.getPersistenceDetails(xtdbAPI);
        if (doc != null && (version = doc.get(VERSION)) instanceof Long) {
            return (Long)version;
        }
        return -1L;
    }

    public static void setVersion(IXtdb xtdbAPI, long version) {
        XtdbDocument.Builder builder = XtdbDocument.builder((Object)PERSISTENCE_DOC);
        builder.put(VERSION, (Object)version);
        Transaction.Builder tx = Transaction.builder();
        tx.put(builder.build());
        TransactionInstant instant = xtdbAPI.submitTx(tx.build());
        xtdbAPI.awaitTx(instant, null);
    }

    public static boolean isLatestVersion(IXtdb xtdbAPI) {
        return PersistenceLayer.getVersion(xtdbAPI) == 3L;
    }

    protected static XtdbDocument getPersistenceDetails(IXtdb xtdbAPI) {
        return xtdbAPI.db().entity((Object)PERSISTENCE_DOC);
    }
}

