/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeleteInstance;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.DeleteRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.PurgeRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class DeleteEntity
extends DeleteInstance {
    private static final Logger log = LoggerFactory.getLogger(DeleteEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"deleteEntity");
    private static final String CLASS_NAME = DeleteEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String RELN_QUERY = "{:find [(quote r)]  :where [[(quote r) :" + RelationshipMapping.ENTITY_PROXIES + " eid]          [(quote r) :" + InstanceAuditHeaderMapping.TYPE_DEF_CATEGORY + " " + TypeDefCategory.RELATIONSHIP_DEF.getOrdinal() + "]          [(quote r) :" + InstanceAuditHeaderMapping.CURRENT_STATUS + " (quote s)]          [(quote (not= s " + InstanceStatus.DELETED.getOrdinal() + "))]]}";
    private static final String FN = "(fn [ctx eid user]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          relationships (xtdb.api/q db " + RELN_QUERY + ")          existing (xtdb.api/entity db eid)          deleted (.doc (" + DeleteEntity.class.getCanonicalName() + ". tx-id existing user eid))" + DeleteEntity.getTxnTimeCalculation("deleted") + "]         (conj (vec (for [[rid] relationships]                     (let [home (get existing :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + ")                           mid (xtdb.api/pull db [:" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + "] rid)]                          (if (= home (:" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + " mid))                              [:xtdb.api/fn " + DeleteRelationship.FUNCTION_NAME + " rid user]                              [:xtdb.api/fn " + PurgeRelationship.FUNCTION_NAME + " rid true]))))               [:xtdb.api/put deleted txt])))";
    private final IPersistentMap xtdbDoc;

    public DeleteEntity(Long txId, PersistentHashMap existing, String userId, String obsoleteEntityGUID) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(obsoleteEntityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, obsoleteEntityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(obsoleteEntityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)existing, obsoleteEntityGUID, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = DeleteEntity.deleteInstance(userId, (IPersistentMap)existing);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XtdbOMRSRepositoryConnector xtdb, String userId, String entityGUID) throws EntityNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("deleteEntity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        DeleteEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

