/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstancePropertiesMapping;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.AbstractTransactionFunction;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public abstract class ReTypeInstance
extends AbstractTransactionFunction {
    protected static IPersistentMap reTypeInstance(String userId, IPersistentMap existing, TypeDef newTypeDef) throws TypeErrorException, IOException {
        InstanceType newInstanceType = TypeDefCache.getInstanceType(newTypeDef.getCategory(), newTypeDef.getName());
        IPersistentMap doc = ReTypeInstance.incrementVersion(userId, existing);
        return InstanceAuditHeaderMapping.addTypeDetailsToMap(doc, newInstanceType, null);
    }

    protected static void validate(IPersistentMap existing, String instanceGUID, TypeDef newTypeDef, String metadataCollectionId, String className, String methodName) throws InvalidParameterException, RepositoryErrorException, IOException, PropertyErrorException {
        TxnValidations.instanceCanBeUpdated(existing, instanceGUID, metadataCollectionId, className, methodName);
        TxnValidations.instanceType(existing, className, methodName);
        InstanceType instanceType = InstanceAuditHeaderMapping.getTypeFromInstance(existing, null);
        InstanceProperties properties = InstancePropertiesMapping.getFromMap(instanceType, existing);
        TxnValidations.propertiesForType(newTypeDef, properties, className, methodName);
    }
}

