/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.UpdateInstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UpdateEntityClassification
extends UpdateInstanceProperties {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityClassification.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"updateEntityClassification");
    public static final String CLASS_NAME = UpdateEntityClassification.class.getName();
    public static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user cname properties mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + UpdateEntityClassification.class.getCanonicalName() + ". tx-id existing user eid mid cname properties))" + UpdateEntityClassification.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public UpdateEntityClassification(Long txId, PersistentHashMap existing, String userId, String entityGUID, String metadataCollectionId, String classificationName, InstanceProperties properties) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), this.getClass().getName(), METHOD_NAME);
            }
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.instanceCanBeUpdated((IPersistentMap)existing, entityGUID, metadataCollectionId, classificationName, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = UpdateEntityClassification.updateInstanceProperties(userId, (IPersistentMap)existing, properties, classificationName);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XtdbOMRSRepositoryConnector xtdb, String userId, String entityGUID, String classificationName, InstanceProperties properties) throws EntityNotKnownException, ClassificationErrorException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, classificationName, properties, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (ClassificationErrorException | EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), UpdateEntityClassification.class.getName(), METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UpdateEntityClassification.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

