/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReHomeInstance;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class ReHomeRelationship
extends ReHomeInstance {
    private static final Logger log = LoggerFactory.getLogger(ReHomeRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"reHomeRelationship");
    private static final String CLASS_NAME = ReHomeRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user mid nmid nmname]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + ReHomeRelationship.class.getCanonicalName() + ". tx-id existing user eid mid nmid nmname))" + ReHomeRelationship.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public ReHomeRelationship(Long txId, PersistentHashMap existing, String userId, String relationshipGUID, String metadataCollectionId, String newMetadataCollectionId, String newMetadataCollectionName) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XtdbOMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.relationshipFromStore(relationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            ReHomeRelationship.validate((IPersistentMap)existing, metadataCollectionId, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = ReHomeRelationship.reHomeInstance(userId, (IPersistentMap)existing, newMetadataCollectionId, newMetadataCollectionName);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XtdbOMRSRepositoryConnector xtdb, String userId, String relationshipGUID, String newMetadataCollectionId, String newMetadataCollectionName) throws RelationshipNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, xtdb.getMetadataCollectionId(), newMetadataCollectionId, newMetadataCollectionName});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingRelationship(docId, results, METHOD_NAME);
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        ReHomeRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

