/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.ErrorMessageCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.InstanceAuditHeaderMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.RelationshipMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReIdentifyInstance;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.ReLinkRelationship;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class ReIdentifyEntity
extends ReIdentifyInstance {
    private static final Logger log = LoggerFactory.getLogger(ReIdentifyEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"reIdentifyEntity");
    private static final String CLASS_NAME = ReIdentifyEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String RELN_QUERY = "{:find [(quote r)] :where [[(quote r) :" + RelationshipMapping.ENTITY_PROXIES + " eid]         [(quote r) :" + InstanceAuditHeaderMapping.TYPE_DEF_CATEGORY + " " + TypeDefCategory.RELATIONSHIP_DEF.getOrdinal() + "]         [(quote r) :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + " mid]]}";
    private static final String FN = "(fn [ctx eid user nid mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          relationships (xtdb.api/q db " + RELN_QUERY + ")          existing (xtdb.api/entity db eid)          updates (.tuple (" + ReIdentifyEntity.class.getCanonicalName() + ". tx-id existing user eid nid mid))]         (vec (concat (vec (for [[rid] relationships]                                 [:xtdb.api/fn " + ReLinkRelationship.FUNCTION_NAME + " rid eid nid]))                      (vec (for [doc updates]                                (let [" + ReIdentifyEntity.getTxnTimeCalculation("doc") + "]                                     [:xtdb.api/put doc txt])))))))";
    private final IPersistentVector xtdbTuple;

    public ReIdentifyEntity(Long txId, PersistentHashMap existing, String userId, String entityGUID, String newEntityGUID, String metadataCollectionId) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XtdbOMRSErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            ReIdentifyEntity.validate((IPersistentMap)existing, entityGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
            this.xtdbTuple = ReIdentifyEntity.reIdentifyInstance(userId, (IPersistentMap)existing, entityGUID, newEntityGUID);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XtdbOMRSRepositoryConnector xtdb, String userId, String entityGUID, String newEntityGUID) throws EntityNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        String newId = EntityDetailMapping.getReference(newEntityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, newId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(newId, results, METHOD_NAME);
        }
        catch (EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentVector tuple() {
        log.debug("Re-identification being persisted: {}", (Object)this.xtdbTuple);
        return this.xtdbTuple;
    }

    public static void create(Transaction.Builder tx) {
        ReIdentifyEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

