/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.PropertyKeywords;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.ClassificationMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class TypeDefCache {
    private static final ConcurrentMap<String, TypeDef> knownTypeDefs = new ConcurrentHashMap<String, TypeDef>();
    private static final ConcurrentMap<String, Map<String, PropertyKeywords>> typeDefToPropertyKeywords = new ConcurrentHashMap<String, Map<String, PropertyKeywords>>();
    private static final ConcurrentMap<String, AttributeTypeDef> knownAttributeTypeDefs = new ConcurrentHashMap<String, AttributeTypeDef>();
    private static final ConcurrentMap<String, Set<String>> knownPropertyToTypeDefNames = new ConcurrentHashMap<String, Set<String>>();
    private static final ConcurrentMap<String, String> nameToGUID = new ConcurrentHashMap<String, String>();
    private static final ConcurrentMap<String, InstanceType> knownInstanceTypes = new ConcurrentHashMap<String, InstanceType>();

    public static void addTypeDef(TypeDef typeDef) throws InvalidParameterException {
        knownTypeDefs.put(typeDef.getGUID(), typeDef);
        nameToGUID.put(typeDef.getName(), typeDef.getGUID());
        TypeDefCache.cacheTypeDefDetails(typeDef);
    }

    public static TypeDef getTypeDef(String typeDefGUID) {
        return (TypeDef)knownTypeDefs.get(typeDefGUID);
    }

    public static TypeDef getTypeDefByName(String typeDefName) {
        String typeDefGUID = (String)nameToGUID.get(typeDefName);
        if (typeDefGUID != null) {
            return (TypeDef)knownTypeDefs.get(typeDefGUID);
        }
        return null;
    }

    public static void removeTypeDef(String typeDefGUID) {
        TypeDef removed = (TypeDef)knownTypeDefs.remove(typeDefGUID);
        if (removed != null) {
            nameToGUID.remove(removed.getName());
            TypeDefCache.uncacheTypeDefDetails(removed);
        }
    }

    public static void addAttributeTypeDef(AttributeTypeDef typeDef) {
        knownAttributeTypeDefs.put(typeDef.getGUID(), typeDef);
    }

    public static AttributeTypeDef getAttributeTypeDef(String typeDefGUID) {
        return (AttributeTypeDef)knownAttributeTypeDefs.get(typeDefGUID);
    }

    public static void removeAttributeTypeDef(String typeDefGUID) {
        knownAttributeTypeDefs.remove(typeDefGUID);
    }

    private static Map<String, PropertyKeywords> getPropertyKeywords(String typeDefGUID) {
        return (Map)typeDefToPropertyKeywords.get(typeDefGUID);
    }

    public static List<TypeDefLink> getAllSuperTypes(String typeDefGUID) {
        ArrayList<TypeDefLink> supers = new ArrayList<TypeDefLink>();
        TypeDef start = TypeDefCache.getTypeDef(typeDefGUID);
        if (start != null) {
            TypeDefLink superTypeLink = start.getSuperType();
            while (superTypeLink != null) {
                TypeDef superType = TypeDefCache.getTypeDef(superTypeLink.getGUID());
                supers.add(superTypeLink);
                superTypeLink = superType.getSuperType();
            }
        }
        return Collections.unmodifiableList(supers);
    }

    public static Map<String, PropertyKeywords> getAllPropertyKeywordsForTypeDef(String typeDefGUID) {
        LinkedHashMap<String, PropertyKeywords> map = new LinkedHashMap<String, PropertyKeywords>();
        List<TypeDefLink> supers = TypeDefCache.getAllSuperTypes(typeDefGUID);
        for (int i = supers.size(); i > 0; --i) {
            TypeDefLink typeDefLink = supers.get(i - 1);
            Map<String, PropertyKeywords> superMap = TypeDefCache.getPropertyKeywords(typeDefLink.getGUID());
            if (superMap == null) continue;
            map.putAll(superMap);
        }
        Map<String, PropertyKeywords> direct = TypeDefCache.getPropertyKeywords(typeDefGUID);
        if (direct != null) {
            map.putAll(direct);
        }
        return Collections.unmodifiableMap(map);
    }

    public static PropertyKeywords getPropertyKeywords(String typeDefGUID, String propertyName) {
        Map<String, PropertyKeywords> map = TypeDefCache.getAllPropertyKeywordsForTypeDef(typeDefGUID);
        return map.get(propertyName);
    }

    public static boolean isTypeOf(String actualTypeName, String expectedTypeName) {
        if (expectedTypeName == null) {
            return true;
        }
        if (actualTypeName == null) {
            return false;
        }
        if (actualTypeName.equals(expectedTypeName)) {
            return true;
        }
        String typeDefGUID = (String)nameToGUID.get(actualTypeName);
        TypeDef typeDef = (TypeDef)knownTypeDefs.get(typeDefGUID);
        TypeDefLink superTypeLink = typeDef.getSuperType();
        while (superTypeLink != null) {
            TypeDef superTypeDef = (TypeDef)knownTypeDefs.get(superTypeLink.getGUID());
            if (expectedTypeName.equals(superTypeLink.getName())) {
                return true;
            }
            superTypeLink = superTypeDef.getSuperType();
        }
        return false;
    }

    public static Set<String> getAllTypeDefsForProperty(String propertyName) {
        if (propertyName == null) {
            return Collections.emptySet();
        }
        return knownPropertyToTypeDefNames.getOrDefault(propertyName, null);
    }

    public static String getPropertyNamespaceForType(String typeDefGUID) {
        TypeDef type = TypeDefCache.getTypeDef(typeDefGUID);
        return TypeDefCache.getPropertyNamespaceForType(type);
    }

    public static InstanceType getInstanceType(TypeDefCategory category, String typeName) throws TypeErrorException {
        String methodName = "getInstanceType";
        InstanceType instanceType = (InstanceType)knownInstanceTypes.get(typeName);
        if (instanceType != null) {
            return instanceType;
        }
        TypeDef typeDef = TypeDefCache.getTypeDefByName(typeName);
        if (typeDef == null) {
            throw new TypeErrorException(XtdbOMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE.getMessageDefinition(typeName, category.getName()), TypeDefCache.class.getName(), "getInstanceType");
        }
        if (TypeDefCache.isValidTypeCategory(category, typeDef)) {
            String typeDefGUID = typeDef.getGUID();
            instanceType = new InstanceType();
            instanceType.setTypeDefCategory(category);
            instanceType.setTypeDefGUID(typeDefGUID);
            instanceType.setTypeDefName(typeDef.getName());
            instanceType.setTypeDefVersion(typeDef.getVersion());
            knownInstanceTypes.put(typeName, instanceType);
            return instanceType;
        }
        throw new TypeErrorException(XtdbOMRSErrorCode.BAD_CATEGORY_FOR_TYPEDEF_ATTRIBUTE.getMessageDefinition(typeName, category.getName()), TypeDefCache.class.getName(), "getInstanceType");
    }

    public static InstanceStatus getInitialStatus(String typeName) {
        TypeDef typeDef = TypeDefCache.getTypeDefByName(typeName);
        return typeDef == null ? null : typeDef.getInitialStatus();
    }

    public static boolean isValidClassificationForEntity(String classificationTypeName, String entityTypeName) {
        TypeDef candidate = TypeDefCache.getTypeDefByName(classificationTypeName);
        if (candidate instanceof ClassificationDef) {
            ClassificationDef classificationTypeDef = (ClassificationDef)candidate;
            List validEntityDefs = classificationTypeDef.getValidEntityDefs();
            if (validEntityDefs == null || validEntityDefs.isEmpty()) {
                return true;
            }
            Set validEntityNames = validEntityDefs.stream().map(TypeDefLink::getName).collect(Collectors.toSet());
            TypeDef entityDef = TypeDefCache.getTypeDefByName(entityTypeName);
            if (entityDef == null) {
                return false;
            }
            ArrayList<TypeDefLink> actualEntityDefs = new ArrayList<TypeDefLink>(TypeDefCache.getAllSuperTypes(entityDef.getGUID()));
            actualEntityDefs.add((TypeDefLink)entityDef);
            Set actualEntityNames = actualEntityDefs.stream().map(TypeDefLink::getName).collect(Collectors.toSet());
            return !Collections.disjoint(validEntityNames, actualEntityNames);
        }
        return false;
    }

    private static boolean isValidTypeCategory(TypeDefCategory category, TypeDef typeDef) {
        if (category == null || typeDef == null) {
            return false;
        }
        TypeDefCategory retrievedTypeDefCategory = typeDef.getCategory();
        if (retrievedTypeDefCategory != null) {
            return category.getOrdinal() == retrievedTypeDefCategory.getOrdinal();
        }
        return false;
    }

    private static String getPropertyNamespaceForType(TypeDef type) {
        TypeDefCategory category = type.getCategory();
        return switch (category) {
            case TypeDefCategory.ENTITY_DEF -> "entityProperties";
            case TypeDefCategory.RELATIONSHIP_DEF -> "relationshipProperties";
            case TypeDefCategory.CLASSIFICATION_DEF -> ClassificationMapping.getNamespaceForProperties(ClassificationMapping.getNamespaceForClassification("classifications", type.getName()));
            default -> null;
        };
    }

    private static void cacheTypeDefDetails(TypeDef type) throws InvalidParameterException {
        String namespace = TypeDefCache.getPropertyNamespaceForType(type);
        TypeDefCache.cachePropertiesInType(type, namespace);
        knownInstanceTypes.remove(type.getName());
    }

    private static void uncacheTypeDefDetails(TypeDef type) {
        String typeDefGUID = type.getGUID();
        String typeDefName = type.getName();
        typeDefToPropertyKeywords.remove(typeDefGUID);
        for (String propertyName : knownPropertyToTypeDefNames.keySet()) {
            ((Set)knownPropertyToTypeDefNames.get(propertyName)).remove(typeDefName);
        }
        knownInstanceTypes.remove(typeDefName);
    }

    private static void cachePropertiesInType(TypeDef type, String namespace) throws InvalidParameterException {
        String methodName = "cachePropertiesInType";
        LinkedHashMap<String, PropertyKeywords> propertyMap = new LinkedHashMap<String, PropertyKeywords>();
        String typeDefName = type.getName();
        List properties = type.getPropertiesDefinition();
        if (properties != null) {
            for (TypeDefAttribute property : properties) {
                PropertyKeywords propertyMapping;
                String simpleName = property.getAttributeName();
                PropertyKeywords previous = propertyMap.put(simpleName, propertyMapping = new PropertyKeywords(namespace, typeDefName, simpleName, property));
                if (previous != null) {
                    throw new InvalidParameterException(XtdbOMRSErrorCode.DUPLICATE_PROPERTIES.getMessageDefinition(typeDefName, previous.toString()), TypeDefCache.class.getName(), "cachePropertiesInType", simpleName);
                }
                knownPropertyToTypeDefNames.computeIfAbsent(simpleName, k -> new HashSet());
                ((Set)knownPropertyToTypeDefNames.get(simpleName)).add(typeDefName);
            }
        }
        typeDefToPropertyKeywords.put(type.getGUID(), Collections.unmodifiableMap(propertyMap));
    }
}

