/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.Tuple;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.cache.TypeDefCache;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.AbstractMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EnumPropertyValueMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public abstract class InstanceAuditHeaderMapping
extends AbstractMapping {
    private static final String INSTANCE_AUDIT_HEADER = "InstanceAuditHeader";
    private static final String N_HEADER_VERSION = "headerVersion";
    private static final String N_TYPE = "type";
    private static final String N_INSTANCE_PROVENANCE_TYPE = "instanceProvenanceType";
    private static final String N_METADATA_COLLECTION_ID = "metadataCollectionId";
    private static final String N_METADATA_COLLECTION_NAME = "metadataCollectionName";
    private static final String N_REPLICATED_BY = "replicatedBy";
    private static final String N_INSTANCE_LICENSE = "instanceLicense";
    private static final String N_CREATED_BY = "createdBy";
    private static final String N_UPDATED_BY = "updatedBy";
    private static final String N_MAINTAINED_BY = "maintainedBy";
    private static final String N_CREATE_TIME = "createTime";
    private static final String N_UPDATE_TIME = "updateTime";
    private static final String N_VERSION = "version";
    private static final String N_CURRENT_STATUS = "currentStatus";
    private static final String N_STATUS_ON_DELETE = "statusOnDelete";
    private static final String N_MAPPING_PROPERTIES = "mappingProperties";
    public static final String METADATA_COLLECTION_ID = InstanceAuditHeaderMapping.getKeyword("metadataCollectionId");
    public static final String METADATA_COLLECTION_NAME = InstanceAuditHeaderMapping.getKeyword("metadataCollectionName");
    public static final String CREATE_TIME = InstanceAuditHeaderMapping.getKeyword("createTime");
    public static final String UPDATE_TIME = InstanceAuditHeaderMapping.getKeyword("updateTime");
    public static final String CURRENT_STATUS = InstanceAuditHeaderMapping.getKeyword("currentStatus");
    public static final String STATUS_ON_DELETE = InstanceAuditHeaderMapping.getKeyword("statusOnDelete");
    public static final String TYPE_DEF_GUIDS = InstanceAuditHeaderMapping.getKeyword("type.guids");
    public static final String TYPE_DEF_CATEGORY = InstanceAuditHeaderMapping.getKeyword("type.category");
    public static final String VERSION = InstanceAuditHeaderMapping.getKeyword("version");
    public static final String MAINTAINED_BY = InstanceAuditHeaderMapping.getKeyword("maintainedBy");
    public static final String UPDATED_BY = InstanceAuditHeaderMapping.getKeyword("updatedBy");
    public static final String REPLICATED_BY = InstanceAuditHeaderMapping.getKeyword("replicatedBy");
    public static final String INSTANCE_PROVENANCE_TYPE = InstanceAuditHeaderMapping.getKeyword("instanceProvenanceType");
    private static final Set<String> KNOWN_PROPERTIES = InstanceAuditHeaderMapping.createKnownProperties();

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(N_HEADER_VERSION);
        set.add(N_TYPE);
        set.add(N_INSTANCE_PROVENANCE_TYPE);
        set.add(N_METADATA_COLLECTION_ID);
        set.add(N_METADATA_COLLECTION_NAME);
        set.add(N_REPLICATED_BY);
        set.add(N_INSTANCE_LICENSE);
        set.add(N_CREATED_BY);
        set.add(N_UPDATED_BY);
        set.add(N_MAINTAINED_BY);
        set.add(N_CREATE_TIME);
        set.add(N_UPDATE_TIME);
        set.add(N_VERSION);
        set.add(N_CURRENT_STATUS);
        set.add(N_STATUS_ON_DELETE);
        set.add(N_MAPPING_PROPERTIES);
        return set;
    }

    protected InstanceAuditHeaderMapping(XtdbOMRSRepositoryConnector xtdbConnector) {
        super(xtdbConnector);
    }

    public static boolean isKnownBaseProperty(String property) {
        return KNOWN_PROPERTIES.contains(property);
    }

    protected static void buildDoc(XtdbDocument.Builder builder, InstanceAuditHeader iah) throws IOException {
        InstanceAuditHeaderMapping.buildDoc(builder, iah, null);
    }

    public static Date buildDoc(XtdbDocument.Builder builder, InstanceAuditHeader iah, String namespace) throws IOException {
        Date updateTime = iah.getUpdateTime();
        Date createTime = iah.getCreateTime();
        List maintainers = iah.getMaintainedBy();
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_HEADER_VERSION), (Object)iah.getHeaderVersion());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_ID), (Object)iah.getMetadataCollectionId());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_NAME), (Object)iah.getMetadataCollectionName());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_REPLICATED_BY), (Object)iah.getReplicatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_LICENSE), (Object)iah.getInstanceLicense());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATED_BY), (Object)iah.getCreatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATED_BY), (Object)iah.getUpdatedBy());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_MAINTAINED_BY), (Object)(maintainers == null ? null : PersistentVector.create((List)maintainers)));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATE_TIME), (Object)createTime);
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATE_TIME), (Object)updateTime);
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_VERSION), (Object)iah.getVersion());
        ArrayList<String> typeList = new ArrayList<String>();
        InstanceType type = iah.getType();
        typeList.add(type.getTypeDefGUID());
        List<TypeDefLink> superTypes = TypeDefCache.getAllSuperTypes(type.getTypeDefGUID());
        for (TypeDefLink superType : superTypes) {
            typeList.add(superType.getGUID());
        }
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, "type.guids"), (Object)PersistentVector.create(typeList));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, "type.category"), (Object)type.getTypeDefCategory().getOrdinal());
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(type));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_PROVENANCE_TYPE), (Object)EnumPropertyValueMapping.getOrdinalForInstanceProvenanceType(iah.getInstanceProvenanceType()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_CURRENT_STATUS), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatus()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_STATUS_ON_DELETE), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatusOnDelete()));
        builder.put(InstanceAuditHeaderMapping.getKeyword(namespace, N_MAPPING_PROPERTIES), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(iah.getMappingProperties()));
        return updateTime == null ? createTime : updateTime;
    }

    public static IPersistentVector addToMap(IPersistentMap doc, InstanceAuditHeader iah, String namespace) throws IOException {
        Date updateTime = iah.getUpdateTime();
        Date createTime = iah.getCreateTime();
        List maintainers = iah.getMaintainedBy();
        doc = InstanceAuditHeaderMapping.addTypeDetailsToMap(doc, iah.getType(), namespace);
        doc = doc.assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_HEADER_VERSION)), (Object)iah.getHeaderVersion()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_ID)), (Object)iah.getMetadataCollectionId()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_METADATA_COLLECTION_NAME)), (Object)iah.getMetadataCollectionName()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_REPLICATED_BY)), (Object)iah.getReplicatedBy()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_LICENSE)), (Object)iah.getInstanceLicense()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATED_BY)), (Object)iah.getCreatedBy()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATED_BY)), (Object)iah.getUpdatedBy()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_MAINTAINED_BY)), (Object)(maintainers == null ? null : PersistentVector.create((List)maintainers))).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_CREATE_TIME)), (Object)createTime).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_UPDATE_TIME)), (Object)updateTime).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_VERSION)), (Object)iah.getVersion()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_INSTANCE_PROVENANCE_TYPE)), (Object)EnumPropertyValueMapping.getOrdinalForInstanceProvenanceType(iah.getInstanceProvenanceType())).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_CURRENT_STATUS)), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatus())).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_STATUS_ON_DELETE)), (Object)EnumPropertyValueMapping.getOrdinalForInstanceStatus(iah.getStatusOnDelete())).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_MAPPING_PROPERTIES)), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(iah.getMappingProperties()));
        return Tuple.create((Object)(updateTime == null ? createTime : updateTime), (Object)doc);
    }

    public static IPersistentMap addTypeDetailsToMap(IPersistentMap doc, InstanceType type, String namespace) throws IOException {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(type.getTypeDefGUID());
        List<TypeDefLink> superTypes = TypeDefCache.getAllSuperTypes(type.getTypeDefGUID());
        for (TypeDefLink superType : superTypes) {
            typeList.add(superType.getGUID());
        }
        return doc.assoc((Object)Keyword.intern((String)(InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE) + ".guids")), (Object)PersistentVector.create(typeList)).assoc((Object)Keyword.intern((String)(InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE) + ".category")), (Object)type.getTypeDefCategory().getOrdinal()).assoc((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE)), (Object)InstanceAuditHeaderMapping.getEmbeddedSerializedForm(type));
    }

    public static InstanceType getTypeFromInstance(IPersistentMap doc, String namespace) throws IOException {
        IPersistentMap typeValue = (IPersistentMap)doc.valAt((Object)Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, N_TYPE)));
        return (InstanceType)InstanceAuditHeaderMapping.getDeserializedValue(typeValue, mapper.getTypeFactory().constructType(InstanceType.class));
    }

    protected void fromDoc(InstanceAuditHeader iah, XtdbDocument doc) {
        this.fromDoc(iah, doc, null);
    }

    protected void fromDoc(InstanceAuditHeader iah, XtdbDocument doc, String namespace) {
        String methodName = "fromDoc";
        block36: for (String propertyName : KNOWN_PROPERTIES) {
            String property = InstanceAuditHeaderMapping.getKeyword(namespace, propertyName);
            Object objValue = doc.get(property);
            String value = objValue == null ? null : objValue.toString();
            switch (propertyName) {
                case "headerVersion": {
                    iah.setHeaderVersion(objValue == null ? 0L : (Long)objValue);
                    continue block36;
                }
                case "type": {
                    iah.setType((InstanceType)InstanceAuditHeaderMapping.getDeserializedValue(this.xtdbConnector, INSTANCE_AUDIT_HEADER, N_TYPE, (IPersistentMap)objValue, mapper.getTypeFactory().constructType(InstanceType.class)));
                    continue block36;
                }
                case "instanceProvenanceType": {
                    iah.setInstanceProvenanceType(EnumPropertyValueMapping.getInstanceProvenanceTypeFromOrdinal(this.xtdbConnector, (Integer)objValue));
                    continue block36;
                }
                case "metadataCollectionId": {
                    iah.setMetadataCollectionId(value);
                    continue block36;
                }
                case "metadataCollectionName": {
                    iah.setMetadataCollectionName(value);
                    continue block36;
                }
                case "replicatedBy": {
                    iah.setReplicatedBy(value);
                    continue block36;
                }
                case "instanceLicense": {
                    iah.setInstanceLicense(value);
                    continue block36;
                }
                case "createdBy": {
                    iah.setCreatedBy(value);
                    continue block36;
                }
                case "updatedBy": {
                    iah.setUpdatedBy(value);
                    continue block36;
                }
                case "maintainedBy": {
                    if (objValue != null) {
                        IPersistentVector maintainers = (IPersistentVector)objValue;
                        ArrayList<String> maintainerList = new ArrayList<String>();
                        for (ISeq maintainerSeq = maintainers.seq(); maintainerSeq != null; maintainerSeq = maintainerSeq.next()) {
                            Object maintainer = maintainerSeq.first();
                            if (maintainer == null) continue;
                            maintainerList.add(maintainer.toString());
                        }
                        iah.setMaintainedBy(maintainerList);
                        continue block36;
                    }
                    iah.setMaintainedBy(null);
                    continue block36;
                }
                case "createTime": {
                    iah.setCreateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "updateTime": {
                    iah.setUpdateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "version": {
                    iah.setVersion(objValue == null ? -1L : (Long)objValue);
                    continue block36;
                }
                case "currentStatus": {
                    iah.setStatus(EnumPropertyValueMapping.getInstanceStatusFromOrdinal(this.xtdbConnector, (Integer)objValue));
                    continue block36;
                }
                case "statusOnDelete": {
                    iah.setStatusOnDelete(EnumPropertyValueMapping.getInstanceStatusFromOrdinal(this.xtdbConnector, (Integer)objValue));
                    continue block36;
                }
                case "mappingProperties": {
                    iah.setMappingProperties((Map)InstanceAuditHeaderMapping.getDeserializedValue(this.xtdbConnector, INSTANCE_AUDIT_HEADER, N_MAPPING_PROPERTIES, (IPersistentMap)objValue, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Serializable.class)));
                    continue block36;
                }
            }
            this.xtdbConnector.logProblem(this.getClass().getName(), "fromDoc", XtdbOMRSAuditCode.UNMAPPED_PROPERTY, null, property, INSTANCE_AUDIT_HEADER);
        }
    }

    protected static void fromMap(InstanceAuditHeader iah, IPersistentMap doc, String namespace) throws IOException, InvalidParameterException {
        String methodName = "fromMap";
        block36: for (String propertyName : KNOWN_PROPERTIES) {
            Keyword property = Keyword.intern((String)InstanceAuditHeaderMapping.getKeyword(namespace, propertyName));
            Object objValue = doc.valAt((Object)property);
            String value = objValue == null ? null : objValue.toString();
            switch (propertyName) {
                case "headerVersion": {
                    iah.setHeaderVersion(objValue == null ? 0L : (Long)objValue);
                    continue block36;
                }
                case "type": {
                    iah.setType((InstanceType)InstanceAuditHeaderMapping.getDeserializedValue((IPersistentMap)objValue, mapper.getTypeFactory().constructType(InstanceType.class)));
                    continue block36;
                }
                case "instanceProvenanceType": {
                    iah.setInstanceProvenanceType(EnumPropertyValueMapping.getInstanceProvenanceTypeFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "metadataCollectionId": {
                    iah.setMetadataCollectionId(value);
                    continue block36;
                }
                case "metadataCollectionName": {
                    iah.setMetadataCollectionName(value);
                    continue block36;
                }
                case "replicatedBy": {
                    iah.setReplicatedBy(value);
                    continue block36;
                }
                case "instanceLicense": {
                    iah.setInstanceLicense(value);
                    continue block36;
                }
                case "createdBy": {
                    iah.setCreatedBy(value);
                    continue block36;
                }
                case "updatedBy": {
                    iah.setUpdatedBy(value);
                    continue block36;
                }
                case "maintainedBy": {
                    if (objValue != null) {
                        IPersistentVector maintainers = (IPersistentVector)objValue;
                        ArrayList<String> maintainerList = new ArrayList<String>();
                        for (ISeq maintainerSeq = maintainers.seq(); maintainerSeq != null; maintainerSeq = maintainerSeq.next()) {
                            Object maintainer = maintainerSeq.first();
                            if (maintainer == null) continue;
                            maintainerList.add(maintainer.toString());
                        }
                        iah.setMaintainedBy(maintainerList);
                        continue block36;
                    }
                    iah.setMaintainedBy(null);
                    continue block36;
                }
                case "createTime": {
                    iah.setCreateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "updateTime": {
                    iah.setUpdateTime(objValue == null ? null : (Date)objValue);
                    continue block36;
                }
                case "version": {
                    iah.setVersion(objValue == null ? -1L : (Long)objValue);
                    continue block36;
                }
                case "currentStatus": {
                    iah.setStatus(EnumPropertyValueMapping.getInstanceStatusFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "statusOnDelete": {
                    iah.setStatusOnDelete(EnumPropertyValueMapping.getInstanceStatusFromOrdinal((Integer)objValue));
                    continue block36;
                }
                case "mappingProperties": {
                    iah.setMappingProperties((Map)InstanceAuditHeaderMapping.getDeserializedValue((IPersistentMap)objValue, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Serializable.class)));
                    continue block36;
                }
            }
            throw new InvalidParameterException(XtdbOMRSErrorCode.UNMAPPABLE_PROPERTY.getMessageDefinition(propertyName), InstanceAuditHeaderMapping.class.getName(), "fromMap", "property");
        }
    }
}

