/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import clojure.lang.IPersistentMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSAuditCode;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.TextConditionBuilder;
import org.odpi.egeria.connectors.juxt.xtdb.model.search.XtdbQuery;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractReadOperation;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.ICursor;
import xtdb.api.IXtdbDatasource;

public abstract class AbstractSearchOperation
extends AbstractReadOperation {
    private static final Logger log = LoggerFactory.getLogger(AbstractSearchOperation.class);
    private final OMRSRepositoryHelper repositoryHelper;
    protected final String typeGUID;
    protected final int fromElement;
    protected final List<InstanceStatus> limitResultsByStatus;
    protected final SearchClassifications matchClassifications;
    protected final String sequencingProperty;
    protected final SequencingOrder sequencingOrder;
    protected final int pageSize;
    protected final String userId;

    protected AbstractSearchOperation(XtdbOMRSRepositoryConnector xtdb, String typeGUID, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, asOfTime);
        this.repositoryHelper = xtdb.getRepositoryHelper();
        this.typeGUID = typeGUID;
        this.fromElement = fromElement;
        this.limitResultsByStatus = limitResultsByStatus;
        this.matchClassifications = matchClassifications;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
        this.pageSize = pageSize;
        this.userId = userId;
    }

    protected AbstractSearchOperation(XtdbOMRSRepositoryConnector xtdb, String typeGUID, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, IXtdbDatasource existingDB, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, existingDB);
        this.repositoryHelper = xtdb.getRepositoryHelper();
        this.typeGUID = typeGUID;
        this.fromElement = fromElement;
        this.limitResultsByStatus = limitResultsByStatus;
        this.matchClassifications = matchClassifications;
        this.sequencingProperty = sequencingProperty;
        this.sequencingOrder = sequencingOrder;
        this.pageSize = pageSize;
        this.userId = userId;
    }

    protected abstract Collection<List<?>> runQuery(IXtdbDatasource var1) throws TypeErrorException, TimeoutException, RepositoryErrorException;

    protected Collection<List<?>> searchXtdb(IXtdbDatasource db, TypeDefCategory category, String typeGuid, List<String> subtypeGuids, SearchProperties matchProperties, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, RepositoryErrorException {
        Collection<List<?>> results;
        XtdbQuery query = new XtdbQuery();
        this.updateQuery(query, category, typeGuid, subtypeGuids, matchProperties, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        try (ICursor searchCursor = db.openQuery((Object)q, new Object[0]);){
            results = this.deduplicateAndPage(searchCursor, fromElement, pageSize);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        return results;
    }

    protected void updateQuery(XtdbQuery query, TypeDefCategory category, String typeGuid, List<String> subtypeGuids, SearchProperties matchProperties, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, String namespace, String userId) throws TypeErrorException {
        Set<String> completeTypeSet = this.getCompleteSetOfTypeNamesForSearch(userId, typeGuid, subtypeGuids, namespace);
        query.addPropertyConditions(matchProperties, namespace, completeTypeSet, this.xtdb, this.xtdb.isLuceneConfigured(), this.xtdb.expectsLuceneRegexes());
        query.addTypeCondition(category, typeGuid, subtypeGuids);
        query.addClassificationConditions(matchClassifications, completeTypeSet, this.xtdb, this.xtdb.isLuceneConfigured(), this.xtdb.expectsLuceneRegexes());
        query.addSequencing(sequencingOrder, sequencingProperty, namespace, completeTypeSet, this.xtdb);
        query.addStatusLimiters(limitResultsByStatus, XtdbQuery.DOC_ID);
    }

    protected Collection<List<?>> searchXtdbText(IXtdbDatasource db, TypeDefCategory category, String typeGuid, String searchCriteria, int fromElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String namespace, String userId) throws TypeErrorException, RepositoryErrorException {
        Collection<List<?>> results;
        XtdbQuery query = new XtdbQuery();
        this.updateTextQuery(query, category, typeGuid, searchCriteria, limitResultsByStatus, matchClassifications, sequencingProperty, sequencingOrder, namespace, userId);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        try (ICursor searchCursor = db.openQuery((Object)q, new Object[0]);){
            results = this.deduplicateAndPage(searchCursor, fromElement, pageSize);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        return results;
    }

    private void updateTextQuery(XtdbQuery query, TypeDefCategory category, String typeGuid, String searchCriteria, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, String sequencingProperty, SequencingOrder sequencingOrder, String namespace, String userId) throws TypeErrorException {
        Set<String> completeTypeSet = this.getCompleteSetOfTypeNamesForSearch(userId, typeGuid, null, namespace);
        if (this.xtdb.isLuceneConfigured()) {
            query.addConditions(TextConditionBuilder.buildWildcardLuceneCondition(searchCriteria, this.xtdb, completeTypeSet, namespace, this.xtdb.expectsLuceneRegexes()));
        } else {
            query.addConditions(TextConditionBuilder.buildWildcardTextCondition(searchCriteria, this.xtdb, completeTypeSet, namespace, false, this.xtdb.expectsLuceneRegexes()));
        }
        query.addTypeCondition(category, typeGuid, null);
        query.addClassificationConditions(matchClassifications, completeTypeSet, this.xtdb, this.xtdb.isLuceneConfigured(), this.xtdb.expectsLuceneRegexes());
        query.addSequencing(sequencingOrder, sequencingProperty, namespace, completeTypeSet, this.xtdb);
        query.addStatusLimiters(limitResultsByStatus, XtdbQuery.DOC_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getCompleteSetOfTypeNamesForSearch(String userId, String typeGuid, List<String> subtypeGuids, String namespace) throws TypeErrorException {
        String methodName = "getCompleteListOfTypeNamesForSearch";
        HashSet<String> complete = new HashSet<String>();
        if (namespace == null) return complete;
        if (subtypeGuids != null && !subtypeGuids.isEmpty()) {
            for (String subtypeGuid : subtypeGuids) {
                String typeDefName = this.repositoryHelper.getTypeDef(this.xtdb.getRepositoryName(), "subtypeGuids", subtypeGuid, "getCompleteListOfTypeNamesForSearch").getName();
                this.addAllSubtypesToSet(complete, typeDefName);
            }
            return complete;
        } else if (typeGuid != null) {
            String typeDefName = this.repositoryHelper.getTypeDef(this.xtdb.getRepositoryName(), "typeGuid", typeGuid, "getCompleteListOfTypeNamesForSearch").getName();
            this.addAllSubtypesToSet(complete, typeDefName);
            return complete;
        } else if ("relationshipProperties".equals(namespace)) {
            try {
                List typeDefinitions = this.xtdb.getMetadataCollection().findTypeDefsByCategory(userId, TypeDefCategory.RELATIONSHIP_DEF);
                if (typeDefinitions == null) return complete;
                for (TypeDef typeDef : typeDefinitions) {
                    String typeDefName = typeDef.getName();
                    this.addAllSubtypesToSet(complete, typeDefName);
                }
                return complete;
            }
            catch (InvalidParameterException | RepositoryErrorException | UserNotAuthorizedException e) {
                this.xtdb.logProblem(this.getClass().getName(), "getCompleteListOfTypeNamesForSearch", XtdbOMRSAuditCode.UNEXPECTED_RUNTIME_ERROR, e, "unable to retrieve relationship typedefs", e.getClass().getName());
                return complete;
            }
        } else {
            String typeDefName = "OpenMetadataRoot";
            this.addAllSubtypesToSet(complete, typeDefName);
        }
        return complete;
    }

    private void addAllSubtypesToSet(Set<String> subtypes, String typeDefName) {
        subtypes.add(typeDefName);
        List subtypesList = this.repositoryHelper.getSubTypesOf(this.xtdb.getRepositoryName(), typeDefName);
        if (subtypesList != null) {
            subtypes.addAll(subtypesList);
        }
    }

    protected Collection<List<?>> deduplicateAndPage(ICursor<List<?>> results, int fromElement, int pageSize) {
        ArrayList pageOfResults = new ArrayList();
        if (results != null && results.hasNext()) {
            HashSet<List> skippedResults = new HashSet<List>();
            int currentIndex = 0;
            pageSize = pageSize > 0 ? pageSize : this.xtdb.getMaxPageSize();
            int lastResultIndex = fromElement + pageSize;
            while (results.hasNext()) {
                List next = (List)results.next();
                if (currentIndex >= lastResultIndex) break;
                if (currentIndex >= fromElement) {
                    if (pageOfResults.contains(next)) continue;
                    pageOfResults.add(next);
                    ++currentIndex;
                    continue;
                }
                if (skippedResults.contains(next)) continue;
                skippedResults.add(next);
                ++currentIndex;
            }
        }
        return pageOfResults;
    }
}

