/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.readops;

import java.io.IOException;
import java.util.Date;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityDetailMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntitySummaryMapping;
import org.odpi.egeria.connectors.juxt.xtdb.readops.AbstractReadOperation;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public class GetEntity
extends AbstractReadOperation {
    private static final Logger log = LoggerFactory.getLogger(GetEntity.class);
    private final String guid;

    public GetEntity(XtdbOMRSRepositoryConnector xtdb, String guid, Date asOfTime) {
        super(xtdb, asOfTime);
        this.guid = guid;
    }

    public EntitySummary asSummary() throws RepositoryErrorException {
        EntitySummary es;
        String methodName = "getEntitySummary";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            es = GetEntity.summaryByGuid(this.xtdb, db, this.guid);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getEntitySummary", (Throwable)e);
        }
        return es;
    }

    public EntityProxy asProxy() throws RepositoryErrorException {
        EntityProxy ep;
        String methodName = "getEntityProxy";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            ep = GetEntity.proxyByGuid(this.xtdb, db, this.guid);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getEntityProxy", (Throwable)e);
        }
        return ep;
    }

    public EntityDetail asDetail() throws RepositoryErrorException, EntityProxyOnlyException {
        EntityDetail ed;
        String methodName = "getEntityDetail";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            ed = GetEntity.detailByGuid(this.xtdb, db, this.guid);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getEntityDetail", (Throwable)e);
        }
        return ed;
    }

    public static EntitySummary summaryByGuid(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String guid) {
        return GetEntity.summaryByRef(xtdb, db, EntitySummaryMapping.getReference(guid));
    }

    public static EntitySummary summaryByRef(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String ref) {
        XtdbDocument xtdbDoc = GetEntity.getXtdbObjectByReference(db, ref);
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(xtdbDoc == null ? null : xtdbDoc.toMap()));
        }
        if (xtdbDoc != null) {
            EntitySummaryMapping esm = new EntitySummaryMapping(xtdb, xtdbDoc);
            return esm.toEgeria();
        }
        return null;
    }

    public static EntityProxy proxyByGuid(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String guid) {
        return GetEntity.proxyByRef(xtdb, db, EntityProxyMapping.getReference(guid));
    }

    public static EntityProxy proxyByRef(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String ref) {
        XtdbDocument xtdbDoc = GetEntity.getXtdbObjectByReference(db, ref);
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(xtdbDoc == null ? null : xtdbDoc.toMap()));
        }
        if (xtdbDoc != null) {
            return EntityProxyMapping.getFromDoc(xtdb, xtdbDoc);
        }
        return null;
    }

    public static EntityDetail detailByGuid(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String guid) throws EntityProxyOnlyException {
        return GetEntity.detailByRef(xtdb, db, EntityDetailMapping.getReference(guid));
    }

    public static EntityDetail detailByRef(XtdbOMRSRepositoryConnector xtdb, IXtdbDatasource db, String ref) throws EntityProxyOnlyException {
        String methodName = "detailByRef";
        XtdbDocument xtdbDoc = GetEntity.getXtdbObjectByReference(db, ref);
        if (log.isDebugEnabled()) {
            log.debug("Found results: {}", (Object)(xtdbDoc == null ? null : xtdbDoc.toMap()));
        }
        if (xtdbDoc != null) {
            if (EntityProxyMapping.isOnlyAProxy(xtdbDoc)) {
                throw new EntityProxyOnlyException(XtdbOMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(ref, xtdb.getRepositoryName()), GetEntity.class.getName(), "detailByRef");
            }
            EntityDetailMapping edm = new EntityDetailMapping(xtdb, xtdbDoc);
            return edm.toEgeria();
        }
        return null;
    }
}

