/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.egeria.connectors.juxt.xtdb.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.egeria.connectors.juxt.xtdb.auditlog.XtdbOMRSErrorCode;
import org.odpi.egeria.connectors.juxt.xtdb.mapping.EntityProxyMapping;
import org.odpi.egeria.connectors.juxt.xtdb.repositoryconnector.XtdbOMRSRepositoryConnector;
import org.odpi.egeria.connectors.juxt.xtdb.txnfn.SaveClassificationReferenceCopy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class SaveClassificationReferenceCopyEntityProxy
extends SaveClassificationReferenceCopy {
    private static final Logger log = LoggerFactory.getLogger(SaveClassificationReferenceCopyEntityProxy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"saveClassificationReferenceCopyEntityProxy");
    private static final String CLASS_NAME = SaveClassificationReferenceCopyEntityProxy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();

    public SaveClassificationReferenceCopyEntityProxy(Long txId, String entityGUID, PersistentHashMap existing, PersistentHashMap proxy, Classification classification, String homeMetadataCollectionId) throws Exception {
        super(CLASS_NAME, METHOD_NAME, txId, entityGUID, existing, proxy, classification, homeMetadataCollectionId);
    }

    public static void transact(XtdbOMRSRepositoryConnector xtdb, EntityProxy toStoreAgainst, Classification classification) throws EntityConflictException, TypeErrorException, PropertyErrorException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityProxyMapping.getReference(toStoreAgainst.getGUID());
        EntityProxyMapping edm = new EntityProxyMapping(xtdb, toStoreAgainst);
        XtdbDocument toStoreAgainstXT = edm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, toStoreAgainstXT.toMap(), classification, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityConflictException | InvalidParameterException | PropertyErrorException | RepositoryErrorException | TypeErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XtdbOMRSErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, (Throwable)e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        SaveClassificationReferenceCopyEntityProxy.createTransactionFunction(tx, FUNCTION_NAME, SaveClassificationReferenceCopyEntityProxy.getTxFn(CLASS_NAME));
    }
}

