/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.util.Arrays;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCppCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCppCodegen.class);

    public AbstractCppCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "linux", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toApiName(String type) {
        return this.sanitizeName(this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api");
    }

    @Override
    public String toModelName(String type) {
        if (type == null) {
            LOGGER.warn("Model name can't be null. Default to 'UnknownModel'.");
            type = "UnknownModel";
        }
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.sanitizeName(this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1));
    }

    @Override
    public String toVarName(String name) {
        if (this.typeMapping.keySet().contains(name) || this.typeMapping.values().contains(name) || this.importMapping.values().contains(name) || this.defaultIncludes.contains(name) || this.languageSpecificPrimitives.contains(name)) {
            return this.sanitizeName(name);
        }
        if (this.isReservedWord(name)) {
            return this.escapeReservedWord(name);
        }
        if (name.length() > 1) {
            return this.sanitizeName(Character.toUpperCase(name.charAt(0)) + name.substring(1));
        }
        return this.sanitizeName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return this.sanitizeName("_" + name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + this.escapeReservedWord(operationId));
            return this.escapeReservedWord(operationId);
        }
        return this.sanitizeName(super.toOperationId(operationId));
    }

    @Override
    public String toParamName(String name) {
        return this.sanitizeName(super.toParamName(name));
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        String nameInCamelCase = property.nameInCamelCase;
        nameInCamelCase = nameInCamelCase.length() > 1 ? this.sanitizeName(Character.toLowerCase(nameInCamelCase.charAt(0)) + nameInCamelCase.substring(1)) : this.sanitizeName(nameInCamelCase);
        property.nameInCamelCase = nameInCamelCase;
        return property;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return "std::shared_ptr<" + this.toModelName(str) + ">";
    }
}

