/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.languages.CSharpClientCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpNetCoreClientCodegen
extends AbstractCSharpCodegen {
    protected static final String MCS_NET_VERSION_KEY = "x-mcs-sdk";
    protected static final String SUPPORTS_UWP = "supportsUWP";
    protected static final String NET_STANDARD = "netStandard";
    protected static final String TARGET_FRAMEWORK_IDENTIFIER = "targetFrameworkIdentifier";
    protected static final String TARGET_FRAMEWORK_VERSION = "targetFrameworkVersion";
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpClientCodegen.class);
    private static final List<FrameworkStrategy> frameworkStrategies = Arrays.asList(FrameworkStrategy.NETSTANDARD_1_3, FrameworkStrategy.NETSTANDARD_1_4, FrameworkStrategy.NETSTANDARD_1_5, FrameworkStrategy.NETSTANDARD_1_6, FrameworkStrategy.NETSTANDARD_2_0, FrameworkStrategy.NETCOREAPP_2_0);
    private static FrameworkStrategy defaultFramework = FrameworkStrategy.NETSTANDARD_2_0;
    protected final Map<String, String> frameworks;
    protected String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected String clientPackage = "Org.OpenAPITools.Client";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String targetFramework;
    protected String targetFrameworkNuget;
    protected boolean supportsAsync;
    protected boolean netStandard;
    protected boolean validatable;
    protected Map<Character, String> regexModifiers;
    protected boolean nonPublicApi;

    public CSharpNetCoreClientCodegen() {
        this.targetFrameworkNuget = this.targetFramework = CSharpNetCoreClientCodegen.defaultFramework.dotNetFrameworkVersion;
        this.supportsAsync = Boolean.TRUE;
        this.netStandard = Boolean.FALSE;
        this.validatable = Boolean.TRUE;
        this.nonPublicApi = Boolean.FALSE;
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.setSupportNullable(Boolean.TRUE);
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "csharp-netcore";
        this.embeddedTemplateDir = "csharp-netcore";
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("interfacePrefix", "Prefix interfaces with a community standard or widely accepted prefix.", this.interfacePrefix);
        CliOption framework = new CliOption("targetFramework", "The target .NET framework version.");
        ImmutableMap.Builder frameworkBuilder = new ImmutableMap.Builder();
        for (FrameworkStrategy frameworkStrategy : frameworkStrategies) {
            frameworkBuilder.put((Object)frameworkStrategy.name, (Object)frameworkStrategy.description);
        }
        this.frameworks = frameworkBuilder.build();
        framework.defaultValue(this.targetFramework);
        framework.setEnum(this.frameworks);
        this.cliOptions.add(framework);
        CliOption modelPropertyNaming = new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name");
        this.cliOptions.add(modelPropertyNaming.defaultValue("PascalCase"));
        this.addSwitch("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.hideGenerationTimestamp);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch("optionalMethodArgument", "C# Optional method argument, e.g. void square(int x=10) (.net 4.0+ only).", this.optionalMethodArgumentFlag);
        this.addSwitch("optionalAssemblyInfo", "Generate AssemblyInfo.cs.", this.optionalAssemblyInfoFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("nonPublicApi", "Generates code with reduced access modifiers; allows embedding elsewhere without exposing non-public API calls to consumers.", this.nonPublicApi);
        this.addSwitch("allowUnicodeIdentifiers", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false", this.allowUnicodeIdentifiers);
        this.addSwitch("netCoreProjectFile", "Use the new format (.NET Core) for .NET project files (.csproj).", this.netCoreProjectFileFlag);
        this.addSwitch("validatable", "Generates self-validatable models.", this.validatable);
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IgnoreCase");
        this.regexModifiers.put(Character.valueOf('m'), "Multiline");
        this.regexModifiers.put(Character.valueOf('s'), "Singleline");
        this.regexModifiers.put(Character.valueOf('x'), "IgnorePatternWhitespace");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.apiPackage();
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Schema parentModel;
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && (parentModel = allDefinitions.get(this.toModelName(codegenModel.parent))) != null) {
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            if (codegenModel.hasEnums) {
                codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
            }
            HashMap<String, CodegenProperty> propertyHash = new HashMap<String, CodegenProperty>(codegenModel.vars.size());
            for (CodegenProperty property : codegenModel.vars) {
                propertyHash.put(property.name, property);
            }
            for (CodegenProperty property : codegenModel.readWriteVars) {
                if (property.defaultValue != null || !property.baseName.equals(parentCodegenModel.discriminator.getPropertyName())) continue;
                property.defaultValue = "\"" + name + "\"";
            }
            CodegenProperty last = null;
            for (CodegenProperty property : parentCodegenModel.vars) {
                if (propertyHash.containsKey(property.name)) continue;
                CodegenProperty parentVar = property.clone();
                parentVar.isInherited = true;
                parentVar.hasMore = true;
                last = parentVar;
                LOGGER.debug("adding parent variable {}", (Object)property.name);
                codegenModel.parentVars.add(parentVar);
            }
            if (last != null) {
                last.hasMore = false;
            }
        }
        if (codegenModel != null && codegenModel.readWriteVars != null && codegenModel.readWriteVars.size() > 1) {
            int length;
            for (int i = length = codegenModel.readWriteVars.size() - 1; i > length / 2; --i) {
                CodegenProperty codegenProperty = codegenModel.readWriteVars.get(i);
                if (codegenModel.readWriteVars.indexOf(codegenProperty) >= i) continue;
                codegenModel.readWriteVars.remove(i);
            }
        }
        return codegenModel;
    }

    @Override
    public String getHelp() {
        return "Generates a C# client library (.NET Standard, .NET Core).";
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    @Override
    public String getName() {
        return "csharp-netcore";
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && this.nullableType.contains(type)) {
                return type + "?";
            }
            return type;
        }
        return null;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public boolean isNonPublicApi() {
        return this.nonPublicApi;
    }

    public void setNonPublicApi(boolean nonPublicApi) {
        this.nonPublicApi = nonPublicApi;
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder + File.separator + this.testPackageName() + File.separator + this.modelPackage();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        this.postProcessPattern(property.pattern, property.vendorExtensions);
        super.postProcessModelProperty(model, property);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int genericStart;
                if (operation.returnType == null) continue;
                operation.returnContainer = operation.returnType;
                if (!this.returnICollection || !operation.returnType.startsWith("List") && !operation.returnType.startsWith("Collection") || (genericStart = operation.returnType.indexOf("<")) <= 0) continue;
                operation.returnType = "ICollection" + operation.returnType.substring(genericStart);
            }
        }
        return objs;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        this.postProcessPattern(parameter.pattern, parameter.vendorExtensions);
        super.postProcessParameter(parameter);
        if (!parameter.required && this.nullableType.contains(parameter.dataType)) {
            parameter.dataType = parameter.dataType + "?";
        }
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "'");
            ArrayList<String> modifiers = new ArrayList<String>();
            modifiers.add("CultureInvariant");
            for (char c : pattern.substring(i).toCharArray()) {
                if (this.regexModifiers.containsKey(Character.valueOf(c))) {
                    String modifier = this.regexModifiers.get(Character.valueOf(c));
                    modifiers.add(modifier);
                    continue;
                }
                if (c != 'l') continue;
                modifiers.remove("CultureInvariant");
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.apiPackage)) {
            this.setApiPackage("Api");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelPackage)) {
            this.setModelPackage("Model");
        }
        this.clientPackage = "Client";
        String framework = this.additionalProperties.getOrDefault("targetFramework", CSharpNetCoreClientCodegen.defaultFramework.dotNetFrameworkVersion);
        FrameworkStrategy strategy = defaultFramework;
        for (FrameworkStrategy frameworkStrategy : frameworkStrategies) {
            if (!framework.equals(frameworkStrategy.name)) continue;
            strategy = frameworkStrategy;
        }
        strategy.configureAdditionalProperties(this.additionalProperties);
        this.setTargetFrameworkNuget(strategy.getNugetFrameworkIdentifier());
        this.setTargetFramework(strategy.dotNetFrameworkVersion);
        if (strategy != FrameworkStrategy.NETSTANDARD_2_0) {
            LOGGER.warn("If using built-in templates-RestSharp only supports netstandard 2.0 or later.");
        }
        this.setSupportsAsync(Boolean.TRUE);
        this.setNetStandard(strategy.isNetStandard);
        this.setNetCoreProjectFileFlag(strategy.isNetStandard == false);
        if (this.additionalProperties.containsKey("generatePropertyChanged")) {
            LOGGER.warn("generatePropertyChanged is not supported in the .NET Standard generator.");
            this.additionalProperties.remove("generatePropertyChanged");
        }
        AtomicReference excludeTests = new AtomicReference();
        this.syncBooleanProperty(this.additionalProperties, "excludeTests", excludeTests::set, false);
        this.syncStringProperty(this.additionalProperties, "clientPackage", s -> {}, this.clientPackage);
        this.syncStringProperty(this.additionalProperties, "apiPackage", this::setApiPackage, this.apiPackage);
        this.syncStringProperty(this.additionalProperties, "modelPackage", this::setModelPackage, this.modelPackage);
        this.syncStringProperty(this.additionalProperties, "packageGuid", this::setPackageGuid, this.packageGuid);
        this.syncStringProperty(this.additionalProperties, "targetFrameworkNuget", this::setTargetFrameworkNuget, this.targetFrameworkNuget);
        this.syncBooleanProperty(this.additionalProperties, NET_STANDARD, this::setNetStandard, this.netStandard);
        this.syncBooleanProperty(this.additionalProperties, "validatable", this::setValidatable, this.validatable);
        this.syncBooleanProperty(this.additionalProperties, "supportsAsync", this::setSupportsAsync, this.supportsAsync);
        this.syncBooleanProperty(this.additionalProperties, "optionalProjectFile", this::setOptionalProjectFileFlag, this.optionalProjectFileFlag);
        this.syncBooleanProperty(this.additionalProperties, "optionalMethodArgument", this::setOptionalMethodArgumentFlag, this.optionalMethodArgumentFlag);
        this.syncBooleanProperty(this.additionalProperties, "optionalAssemblyInfo", this::setOptionalAssemblyInfoFlag, this.optionalAssemblyInfoFlag);
        this.syncBooleanProperty(this.additionalProperties, "nonPublicApi", this::setNonPublicApi, this.isNonPublicApi());
        String testPackageName = this.testPackageName();
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        String clientPackageDir = packageFolder + File.separator + this.clientPackage;
        String testPackageFolder = this.testFolder + File.separator + testPackageName;
        this.additionalProperties.put("testPackageName", testPackageName);
        int packageDepth = packageFolder.length() - packageFolder.replace(File.separator, "").length();
        String binRelativePath = "..\\";
        for (int i = 0; i < packageDepth; ++i) {
            binRelativePath = binRelativePath + "..\\";
        }
        binRelativePath = binRelativePath + "vendor";
        this.additionalProperties.put("binRelativePath", binRelativePath);
        this.supportingFiles.add(new SupportingFile("IApiAccessor.mustache", clientPackageDir, "IApiAccessor.cs"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("ExceptionFactory.mustache", clientPackageDir, "ExceptionFactory.cs"));
        this.supportingFiles.add(new SupportingFile("OpenAPIDateConverter.mustache", clientPackageDir, "OpenAPIDateConverter.cs"));
        this.supportingFiles.add(new SupportingFile("ClientUtils.mustache", clientPackageDir, "ClientUtils.cs"));
        this.supportingFiles.add(new SupportingFile("HttpMethod.mustache", clientPackageDir, "HttpMethod.cs"));
        this.supportingFiles.add(new SupportingFile("IAsynchronousClient.mustache", clientPackageDir, "IAsynchronousClient.cs"));
        this.supportingFiles.add(new SupportingFile("ISynchronousClient.mustache", clientPackageDir, "ISynchronousClient.cs"));
        this.supportingFiles.add(new SupportingFile("RequestOptions.mustache", clientPackageDir, "RequestOptions.cs"));
        this.supportingFiles.add(new SupportingFile("Multimap.mustache", clientPackageDir, "Multimap.cs"));
        if (Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
            this.supportingFiles.add(new SupportingFile("project.json.mustache", packageFolder + File.separator, "project.json"));
        }
        this.supportingFiles.add(new SupportingFile("IReadableConfiguration.mustache", clientPackageDir, "IReadableConfiguration.cs"));
        this.supportingFiles.add(new SupportingFile("GlobalConfiguration.mustache", clientPackageDir, "GlobalConfiguration.cs"));
        if (Boolean.FALSE.equals(excludeTests.get())) {
            this.modelTestTemplateFiles.put("model_test.mustache", ".cs");
            this.apiTestTemplateFiles.put("api_test.mustache", ".cs");
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.optionalAssemblyInfoFlag && Boolean.FALSE.equals(this.netCoreProjectFileFlag)) {
            this.supportingFiles.add(new SupportingFile("AssemblyInfo.mustache", packageFolder + File.separator + "Properties", "AssemblyInfo.cs"));
        }
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
            if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                this.supportingFiles.add(new SupportingFile("netcore_project.mustache", packageFolder, this.packageName + ".csproj"));
            } else {
                this.supportingFiles.add(new SupportingFile("Project.mustache", packageFolder, this.packageName + ".csproj"));
                if (Boolean.FALSE.equals(this.netStandard)) {
                    this.supportingFiles.add(new SupportingFile("nuspec.mustache", packageFolder, this.packageName + ".nuspec"));
                }
            }
            if (Boolean.FALSE.equals(excludeTests.get())) {
                if (Boolean.TRUE.equals(this.netCoreProjectFileFlag)) {
                    this.supportingFiles.add(new SupportingFile("netcore_testproject.mustache", testPackageFolder, testPackageName + ".csproj"));
                } else {
                    this.supportingFiles.add(new SupportingFile("TestProject.mustache", testPackageFolder, testPackageName + ".csproj"));
                }
            }
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
    }

    public void setNetStandard(Boolean netStandard) {
        this.netStandard = netStandard;
    }

    public void setOptionalAssemblyInfoFlag(boolean flag) {
        this.optionalAssemblyInfoFlag = flag;
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setSupportsAsync(Boolean supportsAsync) {
        this.supportsAsync = supportsAsync;
    }

    public void setTargetFramework(String dotnetFramework) {
        if (!this.frameworks.containsKey(dotnetFramework)) {
            LOGGER.warn("Invalid .NET framework version, defaulting to " + this.targetFramework);
        } else {
            this.targetFramework = dotnetFramework;
        }
        LOGGER.info("Generating code for .NET Framework " + this.targetFramework);
    }

    public void setTargetFrameworkNuget(String targetFrameworkNuget) {
        this.targetFrameworkNuget = targetFrameworkNuget;
    }

    public void setValidatable(boolean validatable) {
        this.validatable = validatable;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(value) != null) {
            return StringUtils.camelize(this.getSymbolName(value));
        }
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("double") || datatype.startsWith("float")) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("_", " ");
        var = StringUtils.camelize(var);
        if ((var = var.replaceAll("\\W+", "")).matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                if (!parentModelCodegenPropery.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                int count = 0;
                int numVars = codegenProperties.size();
                for (CodegenProperty codegenProperty : codegenProperties) {
                    codegenProperty.hasMore = ++count < numVars;
                }
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    private void syncBooleanProperty(Map<String, Object> additionalProperties, String key, Consumer<Boolean> setter, Boolean defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept(this.convertPropertyToBooleanAndWriteBack(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    private void syncStringProperty(Map<String, Object> additionalProperties, String key, Consumer<String> setter, String defaultValue) {
        if (additionalProperties.containsKey(key)) {
            setter.accept((String)additionalProperties.get(key));
        } else {
            additionalProperties.put(key, defaultValue);
            setter.accept(defaultValue);
        }
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            Schema additionalProperties = ModelUtils.getAdditionalProperties(schema);
            String inner = this.getSchemaType(additionalProperties);
            if (ModelUtils.isMapSchema(additionalProperties)) {
                inner = this.toInstantiationType(additionalProperties);
            }
            return (String)this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            String inner = this.getSchemaType(arraySchema.getItems());
            return (String)this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    private static abstract class FrameworkStrategy {
        static FrameworkStrategy NETSTANDARD_1_3 = new FrameworkStrategy("netstandard1.3", ".NET Standard 1.3 compatible", "v4.6.1"){};
        static FrameworkStrategy NETSTANDARD_1_4 = new FrameworkStrategy("netstandard1.4", ".NET Standard 1.4 compatible", "v4.6.1"){};
        static FrameworkStrategy NETSTANDARD_1_5 = new FrameworkStrategy("netstandard1.5", ".NET Standard 1.5 compatible", "v4.6.1"){};
        static FrameworkStrategy NETSTANDARD_1_6 = new FrameworkStrategy("netstandard1.6", ".NET Standard 1.6 compatible", "v4.6.1"){};
        static FrameworkStrategy NETSTANDARD_2_0 = new FrameworkStrategy("netstandard2.0", ".NET Standard 2.0 compatible", "v4.6.1"){};
        static FrameworkStrategy NETCOREAPP_2_0 = new FrameworkStrategy("netcoreapp2.0", ".NET Core 2.0 compatible", "v4.6.1", Boolean.FALSE){};
        protected String name;
        protected String description;
        protected String dotNetFrameworkVersion;
        private Boolean isNetStandard = Boolean.TRUE;

        FrameworkStrategy(String name, String description, String dotNetFrameworkVersion) {
            this.name = name;
            this.description = description;
            this.dotNetFrameworkVersion = dotNetFrameworkVersion;
        }

        FrameworkStrategy(String name, String description, String dotNetFrameworkVersion, Boolean isNetStandard) {
            this.name = name;
            this.description = description;
            this.dotNetFrameworkVersion = dotNetFrameworkVersion;
            this.isNetStandard = isNetStandard;
        }

        protected void configureAdditionalProperties(Map<String, Object> properties) {
            properties.putIfAbsent("targetFramework", this.dotNetFrameworkVersion);
            properties.put(CSharpNetCoreClientCodegen.TARGET_FRAMEWORK_IDENTIFIER, this.getTargetFrameworkIdentifier());
            properties.put(CSharpNetCoreClientCodegen.TARGET_FRAMEWORK_VERSION, this.getTargetFrameworkVersion());
            properties.putIfAbsent(CSharpNetCoreClientCodegen.MCS_NET_VERSION_KEY, "4.6-api");
            properties.put(CSharpNetCoreClientCodegen.NET_STANDARD, this.isNetStandard);
            if (properties.containsKey(CSharpNetCoreClientCodegen.SUPPORTS_UWP)) {
                LOGGER.warn(".NET " + this.name + " generator does not support the UWP option. Use the csharp generator instead.");
                properties.remove(CSharpNetCoreClientCodegen.SUPPORTS_UWP);
            }
        }

        protected String getNugetFrameworkIdentifier() {
            return this.name.toLowerCase(Locale.ROOT);
        }

        protected String getTargetFrameworkIdentifier() {
            if (this.isNetStandard.booleanValue()) {
                return ".NETStandard";
            }
            return ".NETCoreApp";
        }

        protected String getTargetFrameworkVersion() {
            if (this.isNetStandard.booleanValue()) {
                return "v" + this.name.replace("netstandard", "");
            }
            return "v" + this.name.replace("netcoreapp", "");
        }
    }
}

