/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaskellHttpClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaskellHttpClientCodegen.class);
    protected String sourceFolder = "lib";
    protected String defaultDateFormat = "%Y-%m-%d";
    protected String defaultCabalVersion = "0.1.0.0";
    protected String modulePath = null;
    protected Boolean useKatip = true;
    protected Boolean allowNonUniqueOperationIds = false;
    protected Boolean genEnums = true;
    public static final String PROP_ALLOW_FROMJSON_NULLS = "allowFromJsonNulls";
    public static final String PROP_ALLOW_NONUNIQUE_OPERATION_IDS = "allowNonUniqueOperationIds";
    public static final String PROP_ALLOW_TOJSON_NULLS = "allowToJsonNulls";
    public static final String PROP_BASE_MODULE = "baseModule";
    public static final String PROP_CABAL_PACKAGE = "cabalPackage";
    public static final String PROP_CABAL_VERSION = "cabalVersion";
    public static final String PROP_CONFIG_TYPE = "configType";
    public static final String PROP_DATETIME_FORMAT = "dateTimeFormat";
    public static final String PROP_DATETIME_PARSE_FORMAT = "dateTimeParseFormat";
    public static final String PROP_CUSTOM_TEST_INSTANCE_MODULE = "customTestInstanceModule";
    public static final String PROP_DATE_FORMAT = "dateFormat";
    public static final String PROP_GENERATE_ENUMS = "generateEnums";
    public static final String PROP_GENERATE_FORM_URLENCODED_INSTANCES = "generateFormUrlEncodedInstances";
    public static final String PROP_GENERATE_LENSES = "generateLenses";
    public static final String PROP_GENERATE_MODEL_CONSTRUCTORS = "generateModelConstructors";
    public static final String PROP_INLINE_MIME_TYPES = "inlineMimeTypes";
    public static final String PROP_MODEL_DERIVING = "modelDeriving";
    public static final String PROP_REQUEST_TYPE = "requestType";
    public static final String PROP_STRICT_FIELDS = "strictFields";
    public static final String PROP_USE_KATIP = "useKatip";
    private static final Pattern LEADING_UNDERSCORE = Pattern.compile("^_+");
    static final String MEDIA_TYPE = "mediaType";
    static final String MIME_NO_CONTENT = "MimeNoContent";
    static final String MIME_ANY = "MimeAny";
    static final String X_ALL_UNIQUE_PARAMS = "x-allUniqueParams";
    static final String X_ALL_IMPORT_MAPPINGS = "x-allImportMappings";
    static final String X_ALL_UNIQUE_IMPORT_PATHS = "x-allUniqueImportPaths";
    static final String X_COLLECTION_FORMAT = "x-collectionFormat";
    static final String X_HADDOCK_PATH = "x-haddockPath";
    static final String X_HAS_BODY_OR_FORM_PARAM = "x-hasBodyOrFormParam";
    static final String X_HAS_ENUM_SECTION = "x-hasEnumSection";
    static final String X_HAS_IMPORT_MAPPINGS = "x-hasImportMappings";
    static final String X_HAS_MIME_FORM_URL_ENCODED = "x-hasMimeFormUrlEncoded";
    static final String X_HAS_NEW_TAG = "x-hasNewTag";
    static final String X_HAS_OPTIONAL_PARAMS = "x-hasOptionalParams";
    static final String X_HAS_UNKNOWN_MIME_TYPES = "x-hasUnknownMimeTypes";
    static final String X_HAS_UNKNOWN_RETURN = "x-hasUnknownReturn";
    static final String X_INLINE_CONTENT_TYPE = "x-inlineContentType";
    static final String X_INLINE_ACCEPT = "x-inlineAccept";
    static final String X_IS_BODY_OR_FORM_PARAM = "x-isBodyOrFormParam";
    static final String X_IS_BODY_PARAM = "x-isBodyParam";
    static final String X_IS_MAYBE_VALUE = "x-isMaybeValue";
    static final String X_MEDIA_DATA_TYPE = "x-mediaDataType";
    static final String X_DATA_TYPE = "x-dataType";
    static final String X_ENUM_VALUES = "x-enumValues";
    static final String X_MEDIA_IS_JSON = "x-mediaIsJson";
    static final String X_MEDIA_IS_WILDCARD = "x-mediaIsWildcard";
    static final String X_MIME_TYPES = "x-mimeTypes";
    static final String X_OPERATION_TYPE = "x-operationType";
    static final String X_PARAM_NAME_TYPE = "x-paramNameType";
    static final String X_PATH = "x-path";
    static final String X_RETURN_TYPE = "x-returnType";
    static final String X_STRICT_FIELDS = "x-strictFields";
    static final String X_UNKNOWN_MIME_TYPES = "x-unknownMimeTypes";
    static final String X_USE_KATIP = "x-useKatip";
    static final String X_ALLOW_NONUNIQUE_OPERATION_IDS = "x-allowNonUniqueOperationIds";
    static final String X_NEWTYPE = "x-newtype";
    static final String X_ENUM = "x-enum";
    protected ArrayList<Map<String, String>> unknownMimeTypes = new ArrayList();
    protected Map<String, Map<String, Object>> uniqueParamNameTypes = new HashMap<String, Map<String, Object>>();
    protected Map<String, Set<String>> modelMimeTypes = new HashMap<String, Set<String>>();
    protected Map<String, String> knownMimeDataTypes = new HashMap<String, String>();
    protected Set<String> typeNames = new HashSet<String>();
    protected Set<String> modelTypeNames = new HashSet<String>();
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application/.*json(;.*)?");

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "haskell-http-client";
    }

    @Override
    public String getHelp() {
        return "Generates a Haskell http-client library.";
    }

    public HaskellHttpClientCodegen() {
        this.prependFormOrBodyParameters = true;
        this.specialCharReplacements.put("-", "Dash");
        this.specialCharReplacements.put(">", "GreaterThan");
        this.specialCharReplacements.put("<", "LessThan");
        this.specialCharReplacements.remove("\\");
        this.specialCharReplacements.remove("\"");
        this.specialCharReplacements.put("\\\\", "Back_Slash");
        this.specialCharReplacements.put("\\\"", "Double_Quote");
        this.outputFolder = "generated-code/haskell-http-client";
        this.templateDir = "haskell-http-client";
        this.embeddedTemplateDir = "haskell-http-client";
        this.apiPackage = "API";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "family", "default", "deriving", "do", "forall", "foreign", "hiding", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where", "pure", "return", "Accept", "ContentType"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("stack.mustache", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("Setup.mustache", "", "Setup.hs"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("tests/ApproxEq.mustache", "tests", "ApproxEq.hs"));
        this.supportingFiles.add(new SupportingFile("tests/Instances.mustache", "tests", "Instances.hs"));
        this.supportingFiles.add(new SupportingFile("tests/PropMime.mustache", "tests", "PropMime.hs"));
        this.supportingFiles.add(new SupportingFile("tests/Test.mustache", "tests", "Test.hs"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "String", "Int", "Integer", "Float", "Char", "Double", "List", "FilePath", "Text"));
        this.typeMapping.clear();
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("BigDecimal", "Double");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("file", "FilePath");
        this.typeMapping.put("string", "Text");
        this.typeMapping.put("UUID", "Text");
        this.typeMapping.put("URI", "Text");
        this.typeMapping.put("any", "A.Value");
        this.typeMapping.put("set", "Set.Set");
        this.typeMapping.put("binary", "Binary");
        this.typeMapping.put("ByteArray", "ByteArray");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "DateTime");
        this.knownMimeDataTypes.put("application/json", "MimeJSON");
        this.knownMimeDataTypes.put("application/xml", "MimeXML");
        this.knownMimeDataTypes.put("application/x-www-form-urlencoded", "MimeFormUrlEncoded");
        this.knownMimeDataTypes.put("application/octet-stream", "MimeOctetStream");
        this.knownMimeDataTypes.put("multipart/form-data", "MimeMultipartFormData");
        this.knownMimeDataTypes.put("text/plain", "MimePlainText");
        this.knownMimeDataTypes.put("*/*", MIME_ANY);
        this.importMapping.clear();
        this.cliOptions.add(CliOption.newString(PROP_CABAL_PACKAGE, "Set the cabal package name, which consists of one or more alphanumeric words separated by hyphens"));
        this.cliOptions.add(CliOption.newString(PROP_CABAL_VERSION, "Set the cabal version number, consisting of a sequence of one or more integers separated by dots"));
        this.cliOptions.add(CliOption.newString(PROP_BASE_MODULE, "Set the base module namespace"));
        this.cliOptions.add(CliOption.newString(PROP_REQUEST_TYPE, "Set the name of the type used to generate requests"));
        this.cliOptions.add(CliOption.newString(PROP_CONFIG_TYPE, "Set the name of the type used for configuration"));
        this.cliOptions.add(CliOption.newBoolean(PROP_ALLOW_FROMJSON_NULLS, "allow JSON Null during model decoding from JSON").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_ALLOW_TOJSON_NULLS, "allow emitting JSON Null during model encoding to JSON").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_ALLOW_NONUNIQUE_OPERATION_IDS, "allow different API modules to contain the same operationId. Each API must be imported qualified").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_LENSES, "Generate Lens optics for Models").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_MODEL_CONSTRUCTORS, "Generate smart constructors (only supply required fields) for models").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_ENUMS, "Generate specific datatypes for OpenAPI enums").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_GENERATE_FORM_URLENCODED_INSTANCES, "Generate FromForm/ToForm instances for models that are used by operations that produce or consume application/x-www-form-urlencoded").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_INLINE_MIME_TYPES, "Inline (hardcode) the content-type and accept parameters on operations, when there is only 1 option").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newString(PROP_MODEL_DERIVING, "Additional classes to include in the deriving() clause of Models"));
        this.cliOptions.add(CliOption.newBoolean(PROP_STRICT_FIELDS, "Add strictness annotations to all model fields").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newBoolean(PROP_USE_KATIP, "Sets the default value for the UseKatip cabal flag. If true, the katip package provides logging instead of monad-logger").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(CliOption.newString(PROP_DATETIME_FORMAT, "format string used to parse/render a datetime"));
        this.cliOptions.add(CliOption.newString(PROP_DATETIME_PARSE_FORMAT, "overrides the format string used to parse a datetime"));
        this.cliOptions.add(CliOption.newString(PROP_DATE_FORMAT, "format string used to parse/render a date").defaultValue(this.defaultDateFormat));
        this.cliOptions.add(CliOption.newString(PROP_CUSTOM_TEST_INSTANCE_MODULE, "test module used to provide typeclass instances for types not known by the generator"));
        this.cliOptions.add(CliOption.newBoolean("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    public void setAllowNonUniqueOperationIds(Boolean value) {
        this.additionalProperties.put(X_ALLOW_NONUNIQUE_OPERATION_IDS, value);
        this.allowNonUniqueOperationIds = value;
    }

    public void setAllowFromJsonNulls(Boolean value) {
        this.additionalProperties.put(PROP_ALLOW_FROMJSON_NULLS, value);
    }

    public void setAllowToJsonNulls(Boolean value) {
        this.additionalProperties.put(PROP_ALLOW_TOJSON_NULLS, value);
    }

    public void setGenerateModelConstructors(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_MODEL_CONSTRUCTORS, value);
    }

    public void setGenerateEnums(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_ENUMS, value);
        this.genEnums = value;
    }

    public void setGenerateFormUrlEncodedInstances(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_FORM_URLENCODED_INSTANCES, value);
    }

    public void setInlineMimeTypes(Boolean value) {
        this.additionalProperties.put(PROP_INLINE_MIME_TYPES, value);
    }

    public void setGenerateLenses(Boolean value) {
        this.additionalProperties.put(PROP_GENERATE_LENSES, value);
    }

    public void setModelDeriving(String value) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            this.additionalProperties.remove(PROP_MODEL_DERIVING);
        } else {
            this.additionalProperties.put(PROP_MODEL_DERIVING, org.apache.commons.lang3.StringUtils.join((Object[])value.split(" "), (String)","));
        }
    }

    public void setDateTimeFormat(String value) {
        this.setStringProp(PROP_DATETIME_FORMAT, value);
    }

    public void setDateTimeParseFormat(String value) {
        this.setStringProp(PROP_DATETIME_PARSE_FORMAT, value);
    }

    public void setDateFormat(String value) {
        this.setStringProp(PROP_DATE_FORMAT, value);
    }

    public void setCabalPackage(String value) {
        this.setStringProp(PROP_CABAL_PACKAGE, value);
    }

    public void setCabalVersion(String value) {
        this.setStringProp(PROP_CABAL_VERSION, value);
    }

    public void setBaseModule(String value) {
        this.setStringProp(PROP_BASE_MODULE, value);
    }

    public void setRequestType(String value) {
        this.setStringProp(PROP_REQUEST_TYPE, value);
    }

    public void setConfigType(String value) {
        this.setStringProp(PROP_CONFIG_TYPE, value);
    }

    public void setStrictFields(Boolean value) {
        this.additionalProperties.put(X_STRICT_FIELDS, value);
    }

    public void setUseKatip(Boolean value) {
        this.additionalProperties.put(X_USE_KATIP, value);
        this.useKatip = value;
    }

    public void setCustomTestInstanceModule(String value) {
        this.setStringProp(PROP_CUSTOM_TEST_INSTANCE_MODULE, value);
    }

    private void setStringProp(String key, String value) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value)) {
            this.additionalProperties.remove(key);
        } else {
            this.additionalProperties.put(key, value);
        }
    }

    private String getStringProp(String key) {
        return (String)this.additionalProperties.get(key);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("HASKELL_POST_PROCESS_FILE"))) {
            LOGGER.info("Hint: Environment variable HASKELL_POST_PROCESS_FILE not defined so the Haskell code may not be properly formatted. To define it, try 'export HASKELL_POST_PROCESS_FILE=\"$HOME/.local/bin/hfmt -w\"' (Linux/Mac)");
        }
        if (this.additionalProperties.containsKey(PROP_ALLOW_FROMJSON_NULLS)) {
            this.setAllowFromJsonNulls(this.convertPropertyToBoolean(PROP_ALLOW_FROMJSON_NULLS));
        } else {
            this.setAllowFromJsonNulls(true);
        }
        if (this.additionalProperties.containsKey(PROP_ALLOW_TOJSON_NULLS)) {
            this.setAllowToJsonNulls(this.convertPropertyToBoolean(PROP_ALLOW_TOJSON_NULLS));
        } else {
            this.setAllowToJsonNulls(false);
        }
        if (this.additionalProperties.containsKey(PROP_ALLOW_NONUNIQUE_OPERATION_IDS)) {
            this.setAllowNonUniqueOperationIds(this.convertPropertyToBoolean(PROP_ALLOW_NONUNIQUE_OPERATION_IDS));
        } else {
            this.setAllowNonUniqueOperationIds(false);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_MODEL_CONSTRUCTORS)) {
            this.setGenerateModelConstructors(this.convertPropertyToBoolean(PROP_GENERATE_MODEL_CONSTRUCTORS));
        } else {
            this.setGenerateModelConstructors(true);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_ENUMS)) {
            this.setGenerateEnums(this.convertPropertyToBoolean(PROP_GENERATE_ENUMS));
        } else {
            this.setGenerateEnums(true);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_FORM_URLENCODED_INSTANCES)) {
            this.setGenerateFormUrlEncodedInstances(this.convertPropertyToBoolean(PROP_GENERATE_FORM_URLENCODED_INSTANCES));
        } else {
            this.setGenerateFormUrlEncodedInstances(true);
        }
        if (this.additionalProperties.containsKey(PROP_INLINE_MIME_TYPES)) {
            this.setInlineMimeTypes(this.convertPropertyToBoolean(PROP_INLINE_MIME_TYPES));
        } else {
            this.setInlineMimeTypes(true);
        }
        if (this.additionalProperties.containsKey(PROP_GENERATE_LENSES)) {
            this.setGenerateLenses(this.convertPropertyToBoolean(PROP_GENERATE_LENSES));
        } else {
            this.setGenerateLenses(true);
        }
        if (this.additionalProperties.containsKey(PROP_MODEL_DERIVING)) {
            this.setModelDeriving(this.additionalProperties.get(PROP_MODEL_DERIVING).toString());
        } else {
            this.setModelDeriving("");
        }
        if (this.additionalProperties.containsKey(PROP_DATETIME_FORMAT)) {
            this.setDateTimeFormat(this.additionalProperties.get(PROP_DATETIME_FORMAT).toString());
        } else {
            this.setDateTimeFormat(null);
        }
        if (this.additionalProperties.containsKey(PROP_DATETIME_PARSE_FORMAT)) {
            this.setDateTimeParseFormat(this.additionalProperties.get(PROP_DATETIME_PARSE_FORMAT).toString());
        } else {
            this.setDateTimeParseFormat(null);
        }
        if (this.additionalProperties.containsKey(PROP_DATE_FORMAT)) {
            this.setDateFormat(this.additionalProperties.get(PROP_DATE_FORMAT).toString());
        } else {
            this.setDateFormat(this.defaultDateFormat);
        }
        if (this.additionalProperties.containsKey(PROP_STRICT_FIELDS)) {
            this.setStrictFields(this.convertPropertyToBoolean(PROP_STRICT_FIELDS));
        } else {
            this.setStrictFields(true);
        }
        if (this.additionalProperties.containsKey(PROP_USE_KATIP)) {
            this.setUseKatip(this.convertPropertyToBoolean(PROP_USE_KATIP));
        } else {
            this.setUseKatip(true);
        }
        if (this.additionalProperties.containsKey(PROP_CABAL_PACKAGE)) {
            this.setCabalPackage(this.additionalProperties.get(PROP_CABAL_PACKAGE).toString());
        }
        if (this.additionalProperties.containsKey(PROP_CABAL_VERSION)) {
            this.setCabalVersion(this.additionalProperties.get(PROP_CABAL_VERSION).toString());
        } else {
            this.setCabalVersion(this.defaultCabalVersion);
        }
        if (this.additionalProperties.containsKey(PROP_BASE_MODULE)) {
            this.setBaseModule(this.additionalProperties.get(PROP_BASE_MODULE).toString());
        }
        if (this.additionalProperties.containsKey(PROP_REQUEST_TYPE)) {
            this.setRequestType(this.additionalProperties.get(PROP_REQUEST_TYPE).toString());
        }
        if (this.additionalProperties.containsKey(PROP_CONFIG_TYPE)) {
            this.setConfigType(this.additionalProperties.get(PROP_CONFIG_TYPE).toString());
        }
        if (this.additionalProperties.containsKey(PROP_CUSTOM_TEST_INSTANCE_MODULE)) {
            this.setCustomTestInstanceModule(this.additionalProperties.get(PROP_CUSTOM_TEST_INSTANCE_MODULE).toString());
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String baseTitle = openAPI.getInfo().getTitle();
        if (baseTitle == null) {
            baseTitle = "OpenAPI";
        } else if ((baseTitle = baseTitle.trim()).toUpperCase(Locale.ROOT).endsWith("API")) {
            baseTitle = baseTitle.substring(0, baseTitle.length() - 3);
        }
        if (!this.additionalProperties.containsKey(PROP_CABAL_PACKAGE)) {
            ArrayList<String> words = new ArrayList<String>();
            for (String word : baseTitle.split(" ")) {
                words.add(word.toLowerCase(Locale.ROOT));
            }
            this.setCabalPackage(org.apache.commons.lang3.StringUtils.join(words, (String)"-"));
        }
        if (!this.additionalProperties.containsKey(PROP_BASE_MODULE)) {
            ArrayList<String> wordsCaps = new ArrayList<String>();
            for (String word : baseTitle.split(" ")) {
                wordsCaps.add(this.firstLetterToUpper(word));
            }
            this.setBaseModule(org.apache.commons.lang3.StringUtils.join(wordsCaps, (String)""));
        }
        this.modulePath = this.sourceFolder + File.separator + this.getStringProp(PROP_BASE_MODULE).replace('.', File.separatorChar);
        String topLevelPath = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)this.modulePath, (String)String.valueOf(File.separatorChar));
        String lastPath = org.apache.commons.lang3.StringUtils.substringAfterLast((String)this.modulePath, (String)String.valueOf(File.separatorChar));
        if (!this.additionalProperties.containsKey(PROP_REQUEST_TYPE)) {
            this.setRequestType(lastPath + "Request");
        }
        if (!this.additionalProperties.containsKey(PROP_CONFIG_TYPE)) {
            this.setConfigType(lastPath + "Config");
        }
        this.supportingFiles.add(new SupportingFile("haskell-http-client.cabal.mustache", "", this.getStringProp(PROP_CABAL_PACKAGE) + ".cabal"));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("TopLevel.mustache", topLevelPath, lastPath + ".hs"));
        this.supportingFiles.add(new SupportingFile("Client.mustache", this.modulePath, "Client.hs"));
        if (!this.allowNonUniqueOperationIds.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("APIS.mustache", this.modulePath, "API.hs"));
        }
        this.supportingFiles.add(new SupportingFile("Core.mustache", this.modulePath, "Core.hs"));
        this.supportingFiles.add(new SupportingFile("Model.mustache", this.modulePath, "Model.hs"));
        this.supportingFiles.add(new SupportingFile("MimeTypes.mustache", this.modulePath, "MimeTypes.hs"));
        this.supportingFiles.add(new SupportingFile("Logging.mustache", this.modulePath, "Logging.hs"));
        this.supportingFiles.add(new SupportingFile("LoggingMonadLogger.mustache", this.modulePath, "LoggingMonadLogger.hs"));
        this.supportingFiles.add(new SupportingFile("LoggingKatip.mustache", this.modulePath, "LoggingKatip.hs"));
        this.apiTemplateFiles.put("API.mustache", ".hs");
        if (((Boolean)this.additionalProperties.get(PROP_GENERATE_LENSES)).booleanValue()) {
            this.supportingFiles.add(new SupportingFile("ModelLens.mustache", this.modulePath, "ModelLens.hs"));
        }
        this.additionalProperties.put("cabalName", this.getStringProp(PROP_CABAL_PACKAGE));
        this.additionalProperties.put("pathsName", this.getStringProp(PROP_CABAL_PACKAGE).replace('-', '_'));
        this.additionalProperties.put(PROP_REQUEST_TYPE, this.getStringProp(PROP_REQUEST_TYPE));
        this.additionalProperties.put(PROP_CONFIG_TYPE, this.getStringProp(PROP_CONFIG_TYPE));
        this.additionalProperties.put("openApiVersion", openAPI.getOpenapi());
        List allUniqueImportPaths = this.importMapping.values().stream().distinct().collect(Collectors.toList());
        if (allUniqueImportPaths.size() > 0) {
            this.additionalProperties.put(X_ALL_UNIQUE_IMPORT_PATHS, allUniqueImportPaths);
            this.supportingFiles.add(new SupportingFile("ImportMappings.mustache", this.modulePath, "ImportMappings.hs"));
            ArrayList allImportMappings = new ArrayList();
            for (Map.Entry entry : this.importMapping.entrySet()) {
                HashMap<String, Object> importMappingEntry = new HashMap<String, Object>();
                importMappingEntry.put("dataType", entry.getKey());
                importMappingEntry.put("importPath", entry.getValue());
                allImportMappings.add(importMappingEntry);
            }
            this.additionalProperties.put(X_ALL_IMPORT_MAPPINGS, allImportMappings);
            this.additionalProperties.put(X_HAS_IMPORT_MAPPINGS, true);
        }
        super.preprocessOpenAPI(openAPI);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "(Map.Map String " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if ("object".equals(openAPIType)) {
            return "A.Value";
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            Schema additionalProperties2 = ModelUtils.getAdditionalProperties(p);
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Schema " + additionalProperties2 + "\n\tIn Schema: " + p);
            }
            String inner = this.getSchemaType(additionalProperties2);
            return "(Map.Map Text " + inner + ")";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            return this.getSchemaType(ap.getItems());
        }
        return null;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation op, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null || opList.isEmpty()) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        String uniqueName = op.operationId;
        String uniqueNameType = this.toTypeName("Op", uniqueName);
        int counter = 0;
        HashSet<String> opIds = new HashSet<String>();
        for (CodegenOperation o : opList) {
            opIds.add(o.operationId);
        }
        while (opIds.contains(uniqueName) || (this.allowNonUniqueOperationIds != false ? this.modelTypeNames.contains(uniqueNameType) : this.typeNames.contains(uniqueNameType))) {
            uniqueName = op.operationId + counter;
            uniqueNameType = this.toTypeName("Op", uniqueName);
            ++counter;
        }
        if (!op.operationId.equals(uniqueName)) {
            LOGGER.warn("generated unique operationId `" + uniqueName + "`");
        }
        op.operationId = uniqueName;
        op.operationIdLowerCase = uniqueName.toLowerCase(Locale.ROOT);
        op.operationIdCamelCase = StringUtils.camelize(uniqueName);
        op.operationIdSnakeCase = StringUtils.underscore(uniqueName);
        opList.add(op);
        op.baseName = tag;
        op.vendorExtensions = new LinkedHashMap<String, Object>();
        String operationType = this.toTypeName("Op", op.operationId);
        op.vendorExtensions.put(X_OPERATION_TYPE, operationType);
        this.typeNames.add(operationType);
        op.vendorExtensions.put(X_HADDOCK_PATH, String.format(Locale.ROOT, "%s %s", op.httpMethod, op.path.replace("/", "\\/")));
        op.vendorExtensions.put(X_HAS_BODY_OR_FORM_PARAM, op.getHasBodyParam() || op.getHasFormParams());
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions = new LinkedHashMap<String, Object>();
            param.vendorExtensions.put(X_OPERATION_TYPE, operationType);
            param.vendorExtensions.put(X_IS_BODY_OR_FORM_PARAM, param.isBodyParam || param.isFormParam);
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.collectionFormat)) {
                param.vendorExtensions.put(X_COLLECTION_FORMAT, this.mapCollectionFormat(param.collectionFormat));
            } else if (!param.isBodyParam && (param.isListContainer || param.dataType.startsWith("["))) {
                param.collectionFormat = "csv";
                param.vendorExtensions.put(X_COLLECTION_FORMAT, this.mapCollectionFormat(param.collectionFormat));
            }
            if (!param.required) {
                op.vendorExtensions.put(X_HAS_OPTIONAL_PARAMS, true);
            }
            if (!this.typeMapping.containsKey(param.dataType) && !param.isMapContainer && !param.isListContainer && !param.isPrimitiveType && !param.isFile && !param.isEnum) continue;
            String dataType = this.genEnums != false && param.isEnum ? param.datatypeWithEnum : param.dataType;
            String paramNameType = this.toDedupedModelName(this.toTypeName("Param", param.paramName), dataType, !param.isEnum);
            param.vendorExtensions.put(X_PARAM_NAME_TYPE, paramNameType);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put(X_IS_BODY_PARAM, param.isBodyParam);
            this.addToUniques(X_NEWTYPE, paramNameType, dataType, props);
        }
        this.processPathExpr(op);
        this.processProducesConsumes(op);
        this.processReturnType(op);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> schemes) {
        List<CodegenSecurity> secs = super.fromSecurity(schemes);
        for (CodegenSecurity sec : secs) {
            String prefix = "";
            if (sec.isBasic.booleanValue()) {
                prefix = "AuthBasic";
            }
            if (sec.isApiKey.booleanValue()) {
                prefix = "AuthApiKey";
            }
            if (sec.isOAuth.booleanValue()) {
                prefix = "AuthOAuth";
            }
            sec.name = prefix + this.toTypeName("", sec.name);
        }
        return secs;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        this.updateGlobalAdditionalProps();
        return super.postProcessAllModels(objs);
    }

    public void updateGlobalAdditionalProps() {
        this.additionalProperties.put(X_HAS_UNKNOWN_MIME_TYPES, !this.unknownMimeTypes.isEmpty());
        Collections.sort(this.unknownMimeTypes, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                return o1.get(HaskellHttpClientCodegen.MEDIA_TYPE).compareTo(o2.get(HaskellHttpClientCodegen.MEDIA_TYPE));
            }
        });
        this.additionalProperties.put(X_UNKNOWN_MIME_TYPES, this.unknownMimeTypes);
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(this.uniqueParamNameTypes.values());
        Collections.sort(params, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return ((String)o1.get(HaskellHttpClientCodegen.X_PARAM_NAME_TYPE)).compareTo((String)o2.get(HaskellHttpClientCodegen.X_PARAM_NAME_TYPE));
            }
        });
        this.additionalProperties.put(X_ALL_UNIQUE_PARAMS, params);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map<String, Object> ret = super.postProcessOperationsWithModels(objs, allModels);
        HashMap pathOps = (HashMap)ret.get("operations");
        ArrayList ops = (ArrayList)pathOps.get("operation");
        if (ops.size() > 0) {
            ((CodegenOperation)ops.get((int)0)).vendorExtensions.put(X_HAS_NEW_TAG, true);
        }
        this.updateGlobalAdditionalProps();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            if (!this.modelMimeTypes.containsKey(m.classname)) continue;
            Set<String> mimeTypes = this.modelMimeTypes.get(m.classname);
            m.vendorExtensions.put(X_MIME_TYPES, mimeTypes);
            if (!((Boolean)this.additionalProperties.get(PROP_GENERATE_FORM_URLENCODED_INSTANCES)).booleanValue() || !mimeTypes.contains("MimeFormUrlEncoded")) continue;
            Boolean hasMimeFormUrlEncoded = true;
            for (CodegenProperty v : m.vars) {
                if (v.isPrimitiveType || v.isString || v.isDate || v.isDateTime) continue;
                hasMimeFormUrlEncoded = false;
            }
            if (!hasMimeFormUrlEncoded.booleanValue()) continue;
            m.vendorExtensions.put(X_HAS_MIME_FORM_URL_ENCODED, true);
        }
        return ret;
    }

    @Override
    public CodegenModel fromModel(String name, Schema mod) {
        CodegenModel model = super.fromModel(name, mod);
        this.typeNames.add(model.classname);
        this.modelTypeNames.add(model.classname);
        String prefix = org.apache.commons.lang3.StringUtils.uncapitalize((String)model.classname);
        for (CodegenProperty prop : model.vars) {
            prop.name = this.toVarName(prefix, prop.name);
        }
        return model;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("{-", "{_-").replace("-}", "-_}");
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals("FilePath");
    }

    @Override
    public boolean isDataTypeBinary(String dataType) {
        return dataType != null && dataType.equals("B.ByteString");
    }

    private void processReturnType(CodegenOperation op) {
        String returnType = op.returnType;
        if (returnType == null || returnType.equals("null")) {
            if (op.hasProduces) {
                returnType = "res";
                op.vendorExtensions.put(X_HAS_UNKNOWN_RETURN, true);
            } else {
                returnType = "NoContent";
                if (!op.vendorExtensions.containsKey(X_INLINE_ACCEPT)) {
                    this.SetNoContent(op, X_INLINE_ACCEPT);
                }
            }
        }
        if (returnType.contains(" ")) {
            returnType = "(" + returnType + ")";
        }
        op.vendorExtensions.put(X_RETURN_TYPE, returnType);
    }

    private void processProducesConsumes(CodegenOperation op) {
        if (!((Boolean)op.vendorExtensions.get(X_HAS_BODY_OR_FORM_PARAM)).booleanValue()) {
            this.SetNoContent(op, X_INLINE_CONTENT_TYPE);
        }
        if (op.hasConsumes) {
            HashMap<String, Map<String, String>> consumes = new HashMap<String, Map<String, String>>();
            for (Map<String, String> m : op.consumes) {
                consumes.put(m.get(MEDIA_TYPE), m);
            }
            op.consumes = new ArrayList(consumes.values());
            for (Map<String, String> m : op.consumes) {
                this.processMediaType(op, m);
                this.processInlineConsumesContentType(op, m);
            }
            if (HaskellHttpClientCodegen.isMultipartOperation(op.consumes)) {
                op.isMultipart = Boolean.TRUE;
            }
        }
        if (op.hasProduces) {
            HashMap<String, Map<String, String>> produces = new HashMap<String, Map<String, String>>();
            for (Map<String, String> m : op.produces) {
                produces.put(m.get(MEDIA_TYPE), m);
            }
            op.produces = new ArrayList(produces.values());
            for (Map<String, String> m : op.produces) {
                this.processMediaType(op, m);
                this.processInlineProducesContentType(op, m);
            }
        }
    }

    private void processInlineConsumesContentType(CodegenOperation op, Map<String, String> m) {
        if (op.vendorExtensions.containsKey(X_INLINE_CONTENT_TYPE)) {
            return;
        }
        if (((Boolean)this.additionalProperties.get(PROP_INLINE_MIME_TYPES)).booleanValue() && op.consumes.size() == 1 && !MIME_ANY.equals(op.consumes.get(0).get(X_MEDIA_DATA_TYPE)) && !MIME_NO_CONTENT.equals(op.consumes.get(0).get(X_MEDIA_DATA_TYPE))) {
            op.vendorExtensions.put(X_INLINE_CONTENT_TYPE, m);
            for (CodegenParameter param : op.allParams) {
                if (!param.isBodyParam || !param.required) continue;
                param.vendorExtensions.put(X_INLINE_CONTENT_TYPE, m);
            }
        }
    }

    private void processInlineProducesContentType(CodegenOperation op, Map<String, String> m) {
        if (((Boolean)this.additionalProperties.get(PROP_INLINE_MIME_TYPES)).booleanValue() && op.produces.size() == 1 && !MIME_ANY.equals(op.produces.get(0).get(X_MEDIA_DATA_TYPE)) && !MIME_NO_CONTENT.equals(op.produces.get(0).get(X_MEDIA_DATA_TYPE))) {
            op.vendorExtensions.put(X_INLINE_ACCEPT, m);
        }
    }

    private void SetNoContent(CodegenOperation op, String inlineExtentionName) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(X_MEDIA_DATA_TYPE, MIME_NO_CONTENT);
        op.vendorExtensions.put(inlineExtentionName, m);
    }

    private String toDedupedModelName(String paramNameType, String dataType, Boolean appendDataType) {
        if (appendDataType.booleanValue() && this.uniqueParamNameTypes.containsKey(paramNameType) && !this.isDuplicate(paramNameType, dataType).booleanValue()) {
            paramNameType = this.toTypeName("", paramNameType + dataType);
        }
        while (this.typeNames.contains(paramNameType) && !this.isDuplicate(paramNameType, dataType).booleanValue()) {
            paramNameType = HaskellHttpClientCodegen.generateNextName(paramNameType);
        }
        this.typeNames.add(paramNameType);
        this.modelTypeNames.add(paramNameType);
        return paramNameType;
    }

    public Boolean isDuplicate(String paramNameType, String dataType) {
        String comparisonKey;
        String lastParamDataType;
        Map<String, Object> lastParam = this.uniqueParamNameTypes.get(paramNameType);
        if (lastParam != null && (lastParamDataType = (String)lastParam.get(comparisonKey = lastParam.containsKey(X_ENUM) ? X_ENUM_VALUES : X_DATA_TYPE)) != null && lastParamDataType.equals(dataType)) {
            return true;
        }
        return false;
    }

    private Pair<Boolean, String> isDuplicateEnumValues(String enumValues) {
        for (Map<String, Object> vs : this.uniqueParamNameTypes.values()) {
            if (!enumValues.equals(vs.get(X_ENUM_VALUES))) continue;
            return Pair.of((Object)true, (Object)((String)vs.get(X_PARAM_NAME_TYPE)));
        }
        return Pair.of((Object)false, null);
    }

    private void addToUniques(String xGroup, String paramNameType, String dataType, Map<String, Object> props) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(X_PARAM_NAME_TYPE, paramNameType);
        m.put(X_DATA_TYPE, dataType);
        m.put(xGroup, true);
        m.putAll(props);
        this.uniqueParamNameTypes.put(paramNameType, m);
    }

    private void addEnumToUniques(String paramNameType, String datatype, String enumValues, Map<String, Object> allowableValues, String description) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("allowableValues", allowableValues);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)description)) {
            props.put("description", description);
        }
        props.put(X_ENUM_VALUES, enumValues);
        this.addToUniques(X_ENUM, paramNameType, datatype, props);
        this.additionalProperties.put(X_HAS_ENUM_SECTION, true);
    }

    private void processPathExpr(CodegenOperation op) {
        String xPath = "[\"" + this.escapeText(op.path) + "\"]";
        if (op.getHasPathParams()) {
            for (CodegenParameter param : op.allParams) {
                if (!param.isPathParam) continue;
                xPath = xPath.replaceAll("\\{" + param.baseName + "\\}", "\",toPath " + param.paramName + ",\"");
            }
            xPath = xPath.replaceAll(",\"\",", ",");
            xPath = xPath.replaceAll("\"\",", ",");
            xPath = xPath.replaceAll(",\"\"", ",");
            xPath = xPath.replaceAll("^\\[,", "[");
            xPath = xPath.replaceAll(",\\]$", "]");
        }
        op.vendorExtensions.put(X_PATH, xPath);
    }

    private void processMediaType(CodegenOperation op, Map<String, String> m) {
        String mediaType = m.get(MEDIA_TYPE);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mediaType)) {
            return;
        }
        String mimeType = this.getMimeDataType(mediaType);
        this.typeNames.add(mimeType);
        m.put(X_MEDIA_DATA_TYPE, mimeType);
        if (HaskellHttpClientCodegen.isJsonMimeType(mediaType)) {
            m.put(X_MEDIA_IS_JSON, "true");
        }
        if (HaskellHttpClientCodegen.isWildcardMimeType(mediaType)) {
            m.put(X_MEDIA_IS_WILDCARD, "true");
        }
        if (!this.knownMimeDataTypes.containsValue(mimeType) && !this.unknownMimeTypesContainsType(mimeType).booleanValue()) {
            this.unknownMimeTypes.add(m);
        }
        for (CodegenParameter param : op.allParams) {
            if (!param.isBodyParam && (!param.isFormParam || param.isPrimitiveType || param.isListContainer || param.isMapContainer)) continue;
            HashSet<String> mimeTypes = this.modelMimeTypes.containsKey(param.dataType) ? this.modelMimeTypes.get(param.dataType) : new HashSet<String>();
            mimeTypes.add(mimeType);
            this.modelMimeTypes.put(param.dataType, mimeTypes);
        }
    }

    private Boolean unknownMimeTypesContainsType(String mimeType) {
        for (Map<String, String> m : this.unknownMimeTypes) {
            String mimeType0 = m.get(X_MEDIA_DATA_TYPE);
            if (mimeType0 == null || !mimeType0.equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String firstLetterToUpper(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toUpperCase(Locale.ROOT);
        }
        return word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1);
    }

    public String firstLetterToLower(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toLowerCase(Locale.ROOT);
        }
        return word.substring(0, 1).toLowerCase(Locale.ROOT) + word.substring(1);
    }

    private String mapCollectionFormat(String collectionFormat) {
        switch (collectionFormat) {
            case "csv": {
                return "CommaSeparated";
            }
            case "tsv": {
                return "TabSeparated";
            }
            case "ssv": 
            case "space": {
                return "SpaceSeparated";
            }
            case "pipes": {
                return "PipeSeparated";
            }
            case "multi": {
                return "MultiParamArray";
            }
        }
        throw new UnsupportedOperationException(collectionFormat + " (collection format) not supported");
    }

    private String getMimeDataType(String mimeType) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mimeType)) {
            return MIME_NO_CONTENT;
        }
        if (this.knownMimeDataTypes.containsKey(mimeType)) {
            return this.knownMimeDataTypes.get(mimeType);
        }
        String shortenedName = mimeType.replaceFirst("application/", "");
        return "Mime" + this.toTypeName("", shortenedName);
    }

    private static String generateNextName(String name) {
        Pattern pattern = Pattern.compile("\\d+\\z");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            String numStr = matcher.group();
            int num = Integer.parseInt(numStr) + 1;
            return name.substring(0, name.length() - numStr.length()) + num;
        }
        return name + "2";
    }

    private static boolean isMultipartOperation(List<Map<String, String>> consumes) {
        for (Map<String, String> consume : consumes) {
            if (consume == null || !"multipart/form-data".equals(consume.get(MEDIA_TYPE))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toVarName(String name) {
        return this.toVarName("", name);
    }

    public String toVarName(String prefix, String name) {
        Boolean hasPrefix = !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)prefix);
        name = StringUtils.underscore(this.sanitizeName(name.replaceAll("-", "_")));
        name = StringUtils.camelize(name, hasPrefix == false);
        if (hasPrefix.booleanValue()) {
            return prefix + name;
        }
        if (name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.toTypeName("Model", name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toTypeName("Model", name);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return this.toTypeName("Api", name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toTypeName("Api", name);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.modulePath + File.separator + "API";
    }

    public String toTypeName(String prefix, String name) {
        name = this.escapeIdentifier(prefix, StringUtils.camelize(this.sanitizeName(name)));
        return name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        operationId = this.escapeIdentifier("op", StringUtils.camelize(this.sanitizeName(operationId), true));
        return operationId;
    }

    public String escapeIdentifier(String prefix, String name) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)prefix)) {
            return name;
        }
        if (this.isReservedWord(name)) {
            name = prefix + name;
        }
        if (name.matches("^\\d.*")) {
            name = prefix + name;
        }
        if (this.languageSpecificPrimitives.contains(name)) {
            name = prefix + name;
        }
        if (this.typeMapping.containsValue(name)) {
            name = prefix + name;
        }
        return name;
    }

    static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    static boolean isWildcardMimeType(String mime) {
        return mime != null && mime.equals("*/*");
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + this.escapeText((String)p.getDefault()) + "\"";
            }
        } else if (ModelUtils.isBooleanSchema(p) && p.getDefault() != null) {
            if (p.getDefault().toString().equalsIgnoreCase("false")) {
                return "False";
            }
            return "True";
        }
        return null;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean bl = cm.isEnum = this.genEnums != false && cm.isEnum;
            if (cm.isAlias) {
                String dataType = cm.dataType;
                if (dataType == null && cm.isArrayModel) {
                    dataType = "[" + cm.arrayModelType + "]";
                }
                cm.vendorExtensions.put(X_DATA_TYPE, dataType);
                if (dataType.equals("Maybe A.Value")) {
                    cm.vendorExtensions.put(X_IS_MAYBE_VALUE, true);
                }
            }
            for (CodegenProperty var : cm.vars) {
                String datatype = this.genEnums != false && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)var.datatypeWithEnum) ? var.datatypeWithEnum : var.dataType;
                var.vendorExtensions.put(X_DATA_TYPE, datatype);
                if ((var.required || !datatype.equals("A.Value")) && (!var.required || !datatype.equals("Maybe A.Value"))) continue;
                var.vendorExtensions.put(X_IS_MAYBE_VALUE, true);
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        Map<String, Object> objsEnum = super.postProcessModelsEnum(objs);
        if (this.genEnums.booleanValue()) {
            List models = (List)objsEnum.get("models");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (!cm.isEnum || cm.allowableValues == null) continue;
                this.updateAllowableValuesNames(cm.classname, cm.allowableValues);
                this.addEnumToUniques(cm.classname, cm.dataType, cm.allowableValues.values().toString(), cm.allowableValues, cm.description);
            }
        }
        return objsEnum;
    }

    @Override
    protected void updateDataTypeWithEnumForMap(CodegenProperty property) {
        CodegenProperty baseItem = property.items;
        while (baseItem != null && (Boolean.TRUE.equals(baseItem.isMapContainer) || Boolean.TRUE.equals(baseItem.isListContainer))) {
            baseItem = baseItem.items;
        }
        if (baseItem != null) {
            property.datatypeWithEnum = property.datatypeWithEnum.replace(baseItem.baseType + ")", this.toEnumName(baseItem) + ")");
            property.enumName = this.toEnumName(property);
            if (property.defaultValue != null) {
                property.defaultValue = property.defaultValue.replace(", " + property.items.baseType, ", " + this.toEnumName(property.items));
            }
        }
    }

    @Override
    public String toEnumName(CodegenProperty var) {
        if (!this.genEnums.booleanValue()) {
            return super.toEnumName(var);
        }
        if (var.items != null && var.items.isEnum) {
            return this.toEnumName(var.items);
        }
        String paramNameType = "E'" + this.toTypeName("", var.name);
        String enumValues = var._enum.toString();
        Pair<Boolean, String> duplicateEnum = this.isDuplicateEnumValues(enumValues);
        if (((Boolean)duplicateEnum.getLeft()).booleanValue()) {
            paramNameType = (String)duplicateEnum.getRight();
        } else {
            var.datatypeWithEnum = paramNameType = this.toDedupedModelName(paramNameType, enumValues, false);
            this.updateCodegenPropertyEnum(var);
            this.addEnumToUniques(paramNameType, var.dataType, enumValues, var.allowableValues, var.description);
        }
        return paramNameType;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        super.updateCodegenPropertyEnum(var);
        if (!this.genEnums.booleanValue()) {
            return;
        }
        this.updateCodegenPropertyEnumValues(var, var.datatypeWithEnum);
    }

    public void updateCodegenPropertyEnumValues(CodegenProperty var, String paramNameType) {
        if (var.items != null && var.items.allowableValues != null) {
            this.updateCodegenPropertyEnumValues(var.items, var.items.datatypeWithEnum);
            return;
        }
        if (var.isEnum && var.allowableValues != null) {
            this.updateAllowableValuesNames(paramNameType, var.allowableValues);
        }
    }

    private void updateAllowableValuesNames(String paramNameType, Map<String, Object> allowableValues) {
        if (allowableValues == null) {
            return;
        }
        for (Map enumVar : (List)allowableValues.get("enumVars")) {
            enumVar.put("name", paramNameType + (String)enumVar.get("name"));
        }
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (!this.genEnums.booleanValue()) {
            return super.toEnumVarName(value, datatype);
        }
        ArrayList<String> num = new ArrayList<String>(Arrays.asList("integer", "int", "double", "long", "float"));
        if (value.length() == 0) {
            return "'Empty";
        }
        if (this.getSymbolName(value) != null) {
            return "'" + org.apache.commons.lang3.StringUtils.capitalize((String)this.sanitizeName(this.getSymbolName(value)));
        }
        if (num.contains(datatype.toLowerCase(Locale.ROOT))) {
            String varName = "Num" + value;
            varName = varName.replaceAll("-", "Minus_");
            varName = varName.replaceAll("\\+", "Plus_");
            varName = varName.replaceAll("\\.", "_Dot_");
            return "'" + org.apache.commons.lang3.StringUtils.capitalize((String)this.sanitizeName(varName));
        }
        return "'" + org.apache.commons.lang3.StringUtils.capitalize((String)this.sanitizeName(value));
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        ArrayList<String> num = new ArrayList<String>(Arrays.asList("integer", "int", "double", "long", "float"));
        if (num.contains(datatype.toLowerCase(Locale.ROOT))) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\""));
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String haskellPostProcessFile = System.getenv("HASKELL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)haskellPostProcessFile)) {
            return;
        }
        if ("hs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = haskellPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

