/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.GzipFeatures;
import org.openapitools.codegen.languages.features.PerformBeanValidationFeatures;
import org.openapitools.codegen.templating.mustache.CaseFormatLambda;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
PerformBeanValidationFeatures,
GzipFeatures {
    static final String MEDIA_TYPE = "mediaType";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaClientCodegen.class);
    public static final String USE_RX_JAVA = "useRxJava";
    public static final String USE_RX_JAVA2 = "useRxJava2";
    public static final String DO_NOT_USE_RX = "doNotUseRx";
    public static final String USE_PLAY_WS = "usePlayWS";
    public static final String PLAY_VERSION = "playVersion";
    public static final String FEIGN_VERSION = "feignVersion";
    public static final String PARCELABLE_MODEL = "parcelableModel";
    public static final String USE_RUNTIME_EXCEPTION = "useRuntimeException";
    public static final String USE_REFLECTION_EQUALS_HASHCODE = "useReflectionEqualsHashCode";
    public static final String CASE_INSENSITIVE_RESPONSE_HEADERS = "caseInsensitiveResponseHeaders";
    public static final String PLAY_24 = "play24";
    public static final String PLAY_25 = "play25";
    public static final String PLAY_26 = "play26";
    public static final String FEIGN_9 = "9.x";
    public static final String FEIGN_10 = "10.x";
    public static final String FEIGN = "feign";
    public static final String GOOGLE_API_CLIENT = "google-api-client";
    public static final String JERSEY1 = "jersey1";
    public static final String JERSEY2 = "jersey2";
    public static final String NATIVE = "native";
    public static final String OKHTTP_GSON = "okhttp-gson";
    public static final String RESTEASY = "resteasy";
    public static final String RESTTEMPLATE = "resttemplate";
    public static final String WEBCLIENT = "webclient";
    public static final String REST_ASSURED = "rest-assured";
    public static final String RETROFIT_1 = "retrofit";
    public static final String RETROFIT_2 = "retrofit2";
    public static final String VERTX = "vertx";
    public static final String SERIALIZATION_LIBRARY_GSON = "gson";
    public static final String SERIALIZATION_LIBRARY_JACKSON = "jackson";
    protected String gradleWrapperPackage = "gradle.wrapper";
    protected boolean useRxJava = false;
    protected boolean useRxJava2 = false;
    protected boolean doNotUseRx = true;
    protected boolean usePlayWS = false;
    protected String playVersion = "play25";
    protected String feignVersion = "9.x";
    protected boolean parcelableModel = false;
    protected boolean useBeanValidation = false;
    protected boolean performBeanValidation = false;
    protected boolean useGzipFeature = false;
    protected boolean useRuntimeException = false;
    protected boolean useReflectionEqualsHashCode = false;
    protected boolean caseInsensitiveResponseHeaders = false;
    protected String authFolder;
    protected String serializationLibrary = null;
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final Pattern JSON_VENDOR_MIME_PATTERN = Pattern.compile("(?i)application\\/vnd.(.*)+json(;.*)?");

    public JavaClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "java";
        this.templateDir = "Java";
        this.embeddedTemplateDir = "Java";
        this.invokerPackage = "org.openapitools.client";
        this.artifactId = "openapi-java-client";
        this.apiPackage = "org.openapitools.client.api";
        this.modelPackage = "org.openapitools.client.model";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.modelTestTemplateFiles.put("model_test.mustache", ".java");
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA, "Whether to use the RxJava adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(USE_RX_JAVA2, "Whether to use the RxJava2 adapter with the retrofit2 library."));
        this.cliOptions.add(CliOption.newBoolean(PARCELABLE_MODEL, "Whether to generate models for Android that implement Parcelable with the okhttp-gson library."));
        this.cliOptions.add(CliOption.newBoolean(USE_PLAY_WS, "Use Play! Async HTTP client (Play WS API)"));
        this.cliOptions.add(CliOption.newString(PLAY_VERSION, "Version of Play! Framework (possible values \"play24\", \"play25\" (default), \"play26\")"));
        this.cliOptions.add(CliOption.newBoolean("supportJava6", "Whether to support Java6 with the Jersey1 library."));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Perform BeanValidation"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeature", "Send gzip-encoded requests"));
        this.cliOptions.add(CliOption.newBoolean(USE_RUNTIME_EXCEPTION, "Use RuntimeException instead of Exception"));
        this.cliOptions.add(CliOption.newBoolean(FEIGN_VERSION, "Version of OpenFeign: '10.x', '9.x' (default)"));
        this.cliOptions.add(CliOption.newBoolean(USE_REFLECTION_EQUALS_HASHCODE, "Use org.apache.commons.lang3.builder for equals and hashCode in the models. WARNING: This will fail under a security manager, unless the appropriate permissions are set up correctly and also there's potential performance impact."));
        this.cliOptions.add(CliOption.newBoolean(CASE_INSENSITIVE_RESPONSE_HEADERS, "Make API response's headers case-insensitive. Available on okhttp-gson, jersey2 libraries"));
        this.supportedLibraries.put(JERSEY1, "HTTP client: Jersey client 1.19.x. JSON processing: Jackson 2.9.x. Enable Java6 support using '-DsupportJava6=true'. Enable gzip request encoding using '-DuseGzipFeature=true'. IMPORTANT NOTE: jersey 1.x is no longer actively maintained so please upgrade to 'jersey2' or other HTTP libaries instead.");
        this.supportedLibraries.put(JERSEY2, "HTTP client: Jersey client 2.25.1. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(FEIGN, "HTTP client: OpenFeign 9.x or 10.x. JSON processing: Jackson 2.9.x. To enable OpenFeign 10.x, set the 'feignVersion' option to '10.x'");
        this.supportedLibraries.put(OKHTTP_GSON, "[DEFAULT] HTTP client: OkHttp 3.x. JSON processing: Gson 2.8.x. Enable Parcelable models on Android using '-DparcelableModel=true'. Enable gzip request encoding using '-DuseGzipFeature=true'.");
        this.supportedLibraries.put(RETROFIT_1, "HTTP client: OkHttp 2.x. JSON processing: Gson 2.x (Retrofit 1.9.0). IMPORTANT NOTE: retrofit1.x is no longer actively maintained so please upgrade to 'retrofit2' instead.");
        this.supportedLibraries.put(RETROFIT_2, "HTTP client: OkHttp 3.x. JSON processing: Gson 2.x (Retrofit 2.3.0). Enable the RxJava adapter using '-DuseRxJava[2]=true'. (RxJava 1.x or 2.x)");
        this.supportedLibraries.put(RESTTEMPLATE, "HTTP client: Spring RestTemplate 4.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(WEBCLIENT, "HTTP client: Spring WebClient 5.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(RESTEASY, "HTTP client: Resteasy client 3.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(VERTX, "HTTP client: VertX client 3.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(GOOGLE_API_CLIENT, "HTTP client: Google API client 1.x. JSON processing: Jackson 2.9.x");
        this.supportedLibraries.put(REST_ASSURED, "HTTP client: rest-assured : 4.x. JSON processing: Gson 2.x or Jackson 2.9.x. Only for Java8");
        this.supportedLibraries.put(NATIVE, "HTTP client: Java native HttpClient. JSON processing: Jackson 2.9.x. Only for Java11+");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(OKHTTP_GSON);
        this.cliOptions.add(libraryOption);
        this.setLibrary(OKHTTP_GSON);
        CliOption serializationLibrary = new CliOption("serializationLibrary", "Serialization library, default depends from the library");
        HashMap<String, String> serializationOptions = new HashMap<String, String>();
        serializationOptions.put(SERIALIZATION_LIBRARY_GSON, "Use Gson as serialization library");
        serializationOptions.put(SERIALIZATION_LIBRARY_JACKSON, "Use Jackson as serialization library");
        serializationLibrary.setEnum(serializationOptions);
        this.cliOptions.add(serializationLibrary);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public String getHelp() {
        return "Generates a Java client library (HTTP lib: Jersey (1.x, 2.x), Retrofit (1.x, 2.x), OpenFeign (9.x, 10.x) and more.";
    }

    @Override
    public void processOpts() {
        if (WEBCLIENT.equals(this.getLibrary()) && "threetenbp".equals(this.dateLibrary) || NATIVE.equals(this.getLibrary())) {
            this.dateLibrary = "java8";
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(USE_RX_JAVA) && this.additionalProperties.containsKey(USE_RX_JAVA2)) {
            LOGGER.warn("You specified both RxJava versions 1 and 2 but they are mutually exclusive. Defaulting to v2.");
        } else if (this.additionalProperties.containsKey(USE_RX_JAVA)) {
            this.setUseRxJava(Boolean.valueOf(this.additionalProperties.get(USE_RX_JAVA).toString()));
        }
        if (this.additionalProperties.containsKey(USE_RX_JAVA2)) {
            this.setUseRxJava2(Boolean.valueOf(this.additionalProperties.get(USE_RX_JAVA2).toString()));
        }
        if (!this.useRxJava && !this.useRxJava2) {
            this.additionalProperties.put(DO_NOT_USE_RX, true);
        }
        if (this.additionalProperties.containsKey(USE_PLAY_WS)) {
            this.setUsePlayWS(Boolean.valueOf(this.additionalProperties.get(USE_PLAY_WS).toString()));
        }
        this.additionalProperties.put(USE_PLAY_WS, this.usePlayWS);
        if (this.additionalProperties.containsKey(PLAY_VERSION)) {
            this.setPlayVersion(this.additionalProperties.get(PLAY_VERSION).toString());
        }
        this.additionalProperties.put(PLAY_VERSION, this.playVersion);
        if (this.additionalProperties.containsKey(FEIGN_VERSION)) {
            this.setFeignVersion(this.additionalProperties.get(FEIGN_VERSION).toString());
            if (FEIGN_10.equals(this.feignVersion)) {
                this.additionalProperties.put("useFeign10", true);
            } else if (!FEIGN_9.equals(this.feignVersion)) {
                throw new RuntimeException("Ivalid feignOoption '{}'. Must be '10.x' or '9.x'.");
            }
        }
        this.additionalProperties.put(FEIGN_VERSION, this.feignVersion);
        if (this.additionalProperties.containsKey(PARCELABLE_MODEL)) {
            this.setParcelableModel(Boolean.valueOf(this.additionalProperties.get(PARCELABLE_MODEL).toString()));
        }
        this.additionalProperties.put(PARCELABLE_MODEL, this.parcelableModel);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBooleanAndWriteBack("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey("performBeanValidation")) {
            this.setPerformBeanValidation(this.convertPropertyToBooleanAndWriteBack("performBeanValidation"));
        }
        if (this.additionalProperties.containsKey("useGzipFeature")) {
            this.setUseGzipFeature(this.convertPropertyToBooleanAndWriteBack("useGzipFeature"));
        }
        if (this.additionalProperties.containsKey(USE_RUNTIME_EXCEPTION)) {
            this.setUseRuntimeException(this.convertPropertyToBooleanAndWriteBack(USE_RUNTIME_EXCEPTION));
        }
        if (this.additionalProperties.containsKey(USE_REFLECTION_EQUALS_HASHCODE)) {
            this.setUseReflectionEqualsHashCode(this.convertPropertyToBooleanAndWriteBack(USE_REFLECTION_EQUALS_HASHCODE));
        }
        if (this.additionalProperties.containsKey(CASE_INSENSITIVE_RESPONSE_HEADERS)) {
            this.setUseReflectionEqualsHashCode(this.convertPropertyToBooleanAndWriteBack(CASE_INSENSITIVE_RESPONSE_HEADERS));
        }
        String invokerFolder = (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + '/' + this.apiPackage).replace(".", "/");
        this.authFolder = (this.sourceFolder + '/' + this.invokerPackage + ".auth").replace(".", "/");
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("build.gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.writeOptional(this.outputFolder, new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.properties.mustache", "", "gradle.properties"));
        this.writeOptional(this.outputFolder, new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", invokerFolder, "ApiClient.java"));
        if (!(RESTTEMPLATE.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("StringUtil.mustache", invokerFolder, "StringUtil.java"));
        }
        if (!(GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("auth/HttpBasicAuth.mustache", this.authFolder, "HttpBasicAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/HttpBearerAuth.mustache", this.authFolder, "HttpBearerAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/ApiKeyAuth.mustache", this.authFolder, "ApiKeyAuth.java"));
        }
        this.supportingFiles.add(new SupportingFile("gradlew.mustache", "", "gradlew"));
        this.supportingFiles.add(new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.properties.mustache", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.properties"));
        this.supportingFiles.add(new SupportingFile("gradle-wrapper.jar", this.gradleWrapperPackage.replace(".", File.separator), "gradle-wrapper.jar"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        if (this.performBeanValidation) {
            this.supportingFiles.add(new SupportingFile("BeanValidationException.mustache", invokerFolder, "BeanValidationException.java"));
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary(this.additionalProperties.get("serializationLibrary").toString());
        }
        if (FEIGN.equals(this.getLibrary()) || RETROFIT_1.equals(this.getLibrary())) {
            this.modelDocTemplateFiles.remove("model_doc.mustache");
            this.apiDocTemplateFiles.remove("api_doc.mustache");
        }
        if (!(FEIGN.equals(this.getLibrary()) || RESTTEMPLATE.equals(this.getLibrary()) || this.usesAnyRetrofitLibrary() || GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || WEBCLIENT.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("apiException.mustache", invokerFolder, "ApiException.java"));
            this.supportingFiles.add(new SupportingFile("Configuration.mustache", invokerFolder, "Configuration.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
        }
        if (!(FEIGN.equals(this.getLibrary()) || RESTTEMPLATE.equals(this.getLibrary()) || this.usesAnyRetrofitLibrary() || GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || NATIVE.equals(this.getLibrary()))) {
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
        }
        if (FEIGN.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.supportingFiles.add(new SupportingFile("ParamExpander.mustache", invokerFolder, "ParamExpander.java"));
            this.supportingFiles.add(new SupportingFile("EncodingUtils.mustache", invokerFolder, "EncodingUtils.java"));
        } else if (OKHTTP_GSON.equals(this.getLibrary()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("ApiCallback.mustache", invokerFolder, "ApiCallback.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ProgressRequestBody.mustache", invokerFolder, "ProgressRequestBody.java"));
            this.supportingFiles.add(new SupportingFile("ProgressResponseBody.mustache", invokerFolder, "ProgressResponseBody.java"));
            this.supportingFiles.add(new SupportingFile("GzipRequestInterceptor.mustache", invokerFolder, "GzipRequestInterceptor.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
        } else if (this.usesAnyRetrofitLibrary()) {
            this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.mustache", this.authFolder, "OAuthOkHttpClient.java"));
            this.supportingFiles.add(new SupportingFile("CollectionFormats.mustache", invokerFolder, "CollectionFormats.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
            if (RETROFIT_2.equals(this.getLibrary()) && !this.usePlayWS) {
                this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            }
        } else if (JERSEY2.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", invokerFolder, "ApiResponse.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (NATIVE.equals(this.getLibrary())) {
            this.setJava8Mode(true);
            this.additionalProperties.put("java8", "true");
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (RESTEASY.equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (JERSEY1.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (RESTTEMPLATE.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
        } else if (WEBCLIENT.equals(this.getLibrary())) {
            this.setJava8Mode(true);
            this.additionalProperties.put("java8", "true");
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (VERTX.equals(this.getLibrary())) {
            this.typeMapping.put("file", "AsyncFile");
            this.importMapping.put("AsyncFile", "io.vertx.core.file.AsyncFile");
            this.setJava8Mode(true);
            this.additionalProperties.put("java8", "true");
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
            this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
            this.apiTemplateFiles.put("rxApiImpl.mustache", ".java");
            this.supportingFiles.remove(new SupportingFile("manifest.mustache", this.projectFolder, "AndroidManifest.xml"));
        } else if (GOOGLE_API_CLIENT.equals(this.getLibrary())) {
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        } else if (REST_ASSURED.equals(this.getLibrary())) {
            if (this.getSerializationLibrary() == null) {
                LOGGER.info("No serializationLibrary configured, using 'gson' as fallback");
                this.setSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
            }
            if (SERIALIZATION_LIBRARY_JACKSON.equals(this.getSerializationLibrary())) {
                this.supportingFiles.add(new SupportingFile("JacksonObjectMapper.mustache", invokerFolder, "JacksonObjectMapper.java"));
            } else if (SERIALIZATION_LIBRARY_GSON.equals(this.getSerializationLibrary())) {
                this.supportingFiles.add(new SupportingFile("JSON.mustache", invokerFolder, "JSON.java"));
                this.supportingFiles.add(new SupportingFile("GsonObjectMapper.mustache", invokerFolder, "GsonObjectMapper.java"));
            }
            this.additionalProperties.put("convert", new CaseFormatLambda(CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_UNDERSCORE));
            this.apiTemplateFiles.put("api.mustache", ".java");
            this.supportingFiles.add(new SupportingFile("ResponseSpecBuilders.mustache", invokerFolder, "ResponseSpecBuilders.java"));
        } else {
            LOGGER.error("Unknown library option (-l/--library): " + this.getLibrary());
        }
        if (this.usePlayWS) {
            Iterator iter = this.supportingFiles.iterator();
            while (iter.hasNext()) {
                SupportingFile sf = (SupportingFile)iter.next();
                if (!sf.templateFile.startsWith("auth/")) continue;
                iter.remove();
            }
            this.apiTemplateFiles.remove("api.mustache");
            if (PLAY_24.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_24, true);
                this.apiTemplateFiles.put("play24/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play24/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play24/Play24CallFactory.mustache", invokerFolder, "Play24CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play24/Play24CallAdapterFactory.mustache", invokerFolder, "Play24CallAdapterFactory.java"));
            }
            if (PLAY_25.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_25, true);
                this.apiTemplateFiles.put("play25/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play25/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play25/Play25CallFactory.mustache", invokerFolder, "Play25CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play25/Play25CallAdapterFactory.mustache", invokerFolder, "Play25CallAdapterFactory.java"));
                this.additionalProperties.put("java8", "true");
            }
            if (PLAY_26.equals(this.playVersion)) {
                this.additionalProperties.put(PLAY_26, true);
                this.apiTemplateFiles.put("play26/api.mustache", ".java");
                this.supportingFiles.add(new SupportingFile("play26/ApiClient.mustache", invokerFolder, "ApiClient.java"));
                this.supportingFiles.add(new SupportingFile("play26/Play26CallFactory.mustache", invokerFolder, "Play26CallFactory.java"));
                this.supportingFiles.add(new SupportingFile("play26/Play26CallAdapterFactory.mustache", invokerFolder, "Play26CallAdapterFactory.java"));
                this.additionalProperties.put("java8", "true");
            }
            this.supportingFiles.add(new SupportingFile("play-common/auth/ApiKeyAuth.mustache", this.authFolder, "ApiKeyAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/Authentication.mustache", this.authFolder, "Authentication.java"));
            this.supportingFiles.add(new SupportingFile("Pair.mustache", invokerFolder, "Pair.java"));
            this.forceSerializationLibrary(SERIALIZATION_LIBRARY_JACKSON);
        }
        if (this.getSerializationLibrary() == null) {
            LOGGER.info("No serializationLibrary configured, using 'gson' as fallback");
            this.setSerializationLibrary(SERIALIZATION_LIBRARY_GSON);
        }
        if (SERIALIZATION_LIBRARY_JACKSON.equals(this.getSerializationLibrary())) {
            this.additionalProperties.put(SERIALIZATION_LIBRARY_JACKSON, "true");
            this.additionalProperties.remove(SERIALIZATION_LIBRARY_GSON);
            if (!NATIVE.equals(this.getLibrary())) {
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", invokerFolder, "RFC3339DateFormat.java"));
                if ("threetenbp".equals(this.dateLibrary) && !this.usePlayWS) {
                    this.supportingFiles.add(new SupportingFile("CustomInstantDeserializer.mustache", invokerFolder, "CustomInstantDeserializer.java"));
                }
            }
        } else if (SERIALIZATION_LIBRARY_GSON.equals(this.getSerializationLibrary())) {
            this.additionalProperties.put(SERIALIZATION_LIBRARY_GSON, "true");
            this.additionalProperties.remove(SERIALIZATION_LIBRARY_JACKSON);
        } else {
            this.additionalProperties.remove(SERIALIZATION_LIBRARY_JACKSON);
            this.additionalProperties.remove(SERIALIZATION_LIBRARY_GSON);
        }
    }

    private boolean usesAnyRetrofitLibrary() {
        return this.getLibrary() != null && this.getLibrary().contains(RETROFIT_1);
    }

    private boolean usesRetrofit2Library() {
        return this.getLibrary() != null && this.getLibrary().contains(RETROFIT_2);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (this.usesAnyRetrofitLibrary() && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.hasConsumes == Boolean.TRUE) {
                    if (JavaClientCodegen.isMultipartType(operation.consumes)) {
                        operation.isMultipart = Boolean.TRUE;
                    } else {
                        operation.prioritizedContentTypes = JavaClientCodegen.prioritizeContentTypes(operation.consumes);
                    }
                }
                if (this.usesRetrofit2Library() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)operation.path) && operation.path.startsWith("/")) {
                    operation.path = operation.path.substring(1);
                }
                if (operation.allParams == null) continue;
                Collections.sort(operation.allParams, new Comparator<CodegenParameter>(){

                    @Override
                    public int compare(CodegenParameter one, CodegenParameter another) {
                        if (one.isPathParam && another.isQueryParam) {
                            return -1;
                        }
                        if (one.isQueryParam && another.isPathParam) {
                            return 1;
                        }
                        return 0;
                    }
                });
                Iterator<CodegenParameter> iterator = operation.allParams.iterator();
                while (iterator.hasNext()) {
                    CodegenParameter param = iterator.next();
                    param.hasMore = iterator.hasNext();
                }
            }
        }
        if (FEIGN.equals(this.getLibrary())) {
            operations = (Map)objs.get("operations");
            List operationList = (List)operations.get("operation");
            for (CodegenOperation op : operationList) {
                String path = op.path;
                Object[] items = path.split("/", -1);
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].matches("^\\{(.*)\\}$")) continue;
                    items[i] = "{" + StringUtils.camelize(((String)items[i]).substring(1, ((String)items[i]).length() - 1), true) + "}";
                }
                op.path = org.apache.commons.lang3.StringUtils.join((Object[])items, (String)"/");
            }
        }
        if ((OKHTTP_GSON.equals(this.getLibrary()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.getLibrary())) && ProcessUtils.hasOAuthMethods(objs)) {
            this.supportingFiles.add(new SupportingFile("auth/OAuthOkHttpClient.mustache", this.authFolder, "OAuthOkHttpClient.java"));
            this.supportingFiles.add(new SupportingFile("auth/RetryingOAuth.mustache", this.authFolder, "RetryingOAuth.java"));
        }
        if (!(GOOGLE_API_CLIENT.equals(this.getLibrary()) || REST_ASSURED.equals(this.getLibrary()) || this.usePlayWS || NATIVE.equals(this.getLibrary()) || !ProcessUtils.hasOAuthMethods(objs))) {
            this.supportingFiles.add(new SupportingFile("auth/OAuth.mustache", this.authFolder, "OAuth.java"));
            this.supportingFiles.add(new SupportingFile("auth/OAuthFlow.mustache", this.authFolder, "OAuthFlow.java"));
        }
        return objs;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        if (VERTX.equals(this.getLibrary())) {
            String suffix = this.apiTemplateFiles().get(templateName);
            String subFolder = "";
            if (templateName.startsWith("rx")) {
                subFolder = "/rxjava";
            }
            return this.apiFileFolder() + subFolder + '/' + this.toApiFilename(tag) + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    static List<Map<String, String>> prioritizeContentTypes(List<Map<String, String>> consumes) {
        if (consumes.size() <= 1) {
            return consumes;
        }
        ArrayList<Map<String, String>> prioritizedContentTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonVendorMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        ArrayList<Map<String, String>> jsonMimeTypes = new ArrayList<Map<String, String>>(consumes.size());
        for (Map<String, String> consume : consumes) {
            if (JavaClientCodegen.isJsonVendorMimeType(consume.get(MEDIA_TYPE))) {
                jsonVendorMimeTypes.add(consume);
            } else if (JavaClientCodegen.isJsonMimeType(consume.get(MEDIA_TYPE))) {
                jsonMimeTypes.add(consume);
            } else {
                prioritizedContentTypes.add(consume);
            }
            consume.put("hasMore", "true");
        }
        prioritizedContentTypes.addAll(0, jsonMimeTypes);
        prioritizedContentTypes.addAll(0, jsonVendorMimeTypes);
        ((Map)prioritizedContentTypes.get(prioritizedContentTypes.size() - 1)).put("hasMore", null);
        return prioritizedContentTypes;
    }

    private static boolean isMultipartType(List<Map<String, String>> consumes) {
        Map<String, String> firstType = consumes.get(0);
        return firstType != null && "multipart/form-data".equals(firstType.get(MEDIA_TYPE));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON)) {
                model.imports.add("JsonProperty");
                model.imports.add("JsonValue");
                model.imports.add("JsonInclude");
            }
            if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_GSON)) {
                model.imports.add("SerializedName");
                model.imports.add("TypeAdapter");
                model.imports.add("JsonAdapter");
                model.imports.add("JsonReader");
                model.imports.add("JsonWriter");
                model.imports.add("IOException");
            }
        } else if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON)) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_GSON)) {
            List imports = (List)objs.get("imports");
            List models = (List)objs.get("models");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
                cm.imports.add((String)this.importMapping.get("SerializedName"));
                HashMap item = new HashMap();
                item.put("import", this.importMapping.get("SerializedName"));
                imports.add(item);
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        if (this.additionalProperties.containsKey(SERIALIZATION_LIBRARY_JACKSON) && !JERSEY1.equals(this.getLibrary())) {
            List imports = (List)objs.get("imports");
            List models = (List)objs.get("models");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                boolean addImports = false;
                for (CodegenProperty var : cm.vars) {
                    boolean isOptionalNullable = Boolean.FALSE.equals(var.required) && Boolean.TRUE.equals(var.isNullable);
                    addImports |= isOptionalNullable;
                    var.getVendorExtensions().put("isJacksonOptionalNullable", isOptionalNullable);
                }
                if (!addImports) continue;
                HashMap<String, String> imports2Classnames = new HashMap<String, String>(){
                    {
                        this.put("JsonNullable", "org.openapitools.jackson.nullable.JsonNullable");
                        this.put("NoSuchElementException", "java.util.NoSuchElementException");
                        this.put("JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
                    }
                };
                for (Map.Entry entry : imports2Classnames.entrySet()) {
                    cm.imports.add((String)entry.getKey());
                    HashMap importsItem = new HashMap();
                    importsItem.put("import", entry.getValue());
                    imports.add(importsItem);
                }
            }
        }
        return objs;
    }

    public void setUseRxJava(boolean useRxJava) {
        this.useRxJava = useRxJava;
        this.doNotUseRx = false;
    }

    public void setUseRxJava2(boolean useRxJava2) {
        this.useRxJava2 = useRxJava2;
        this.doNotUseRx = false;
    }

    public void setDoNotUseRx(boolean doNotUseRx) {
        this.doNotUseRx = doNotUseRx;
    }

    public void setUsePlayWS(boolean usePlayWS) {
        this.usePlayWS = usePlayWS;
    }

    public void setPlayVersion(String playVersion) {
        this.playVersion = playVersion;
    }

    public void setFeignVersion(String feignVersion) {
        this.feignVersion = feignVersion;
    }

    public void setParcelableModel(boolean parcelableModel) {
        this.parcelableModel = parcelableModel;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        this.performBeanValidation = performBeanValidation;
    }

    @Override
    public void setUseGzipFeature(boolean useGzipFeature) {
        this.useGzipFeature = useGzipFeature;
    }

    public void setUseRuntimeException(boolean useRuntimeException) {
        this.useRuntimeException = useRuntimeException;
    }

    public void setUseReflectionEqualsHashCode(boolean useReflectionEqualsHashCode) {
        this.useReflectionEqualsHashCode = useReflectionEqualsHashCode;
    }

    public void setCaseInsensitiveResponseHeaders(Boolean caseInsensitiveResponseHeaders) {
        this.caseInsensitiveResponseHeaders = caseInsensitiveResponseHeaders;
    }

    public String getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        if (SERIALIZATION_LIBRARY_JACKSON.equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = SERIALIZATION_LIBRARY_JACKSON;
        } else if (SERIALIZATION_LIBRARY_GSON.equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = SERIALIZATION_LIBRARY_GSON;
        } else {
            throw new IllegalArgumentException("Unexpected serializationLibrary value: " + serializationLibrary);
        }
    }

    public void forceSerializationLibrary(String serializationLibrary) {
        if (this.serializationLibrary != null && !this.serializationLibrary.equalsIgnoreCase(serializationLibrary)) {
            LOGGER.warn("The configured serializationLibrary '" + this.serializationLibrary + "', is not supported by the library: '" + this.getLibrary() + "', switching back to: " + serializationLibrary);
        }
        this.setSerializationLibrary(serializationLibrary);
    }

    static boolean isJsonMimeType(String mime) {
        return mime != null && JSON_MIME_PATTERN.matcher(mime).matches();
    }

    static boolean isJsonVendorMimeType(String mime) {
        return mime != null && JSON_VENDOR_MIME_PATTERN.matcher(mime).matches();
    }

    @Override
    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }
}

