/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufSchemaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufSchemaCodegen.class);
    protected String packageName = "openapitools";

    @Override
    public CodegenType getTag() {
        return CodegenType.CONFIG;
    }

    @Override
    public String getName() {
        return "protobuf-schema";
    }

    @Override
    public String getHelp() {
        return "Generates gRPC and protocol buffer schema files (beta)";
    }

    public ProtobufSchemaCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).wireFormatFeatures(EnumSet.of(WireFormatFeature.PROTOBUF)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)));
        this.outputFolder = "generated-code/protobuf-schema";
        this.modelTemplateFiles.put("model.mustache", ".proto");
        this.apiTemplateFiles.put("api.mustache", ".proto");
        this.templateDir = "protobuf-schema";
        this.embeddedTemplateDir = "protobuf-schema";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.modelPackage = "messages";
        this.apiPackage = "services";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("map", "array", "bool", "bytes", "string", "int32", "int64", "uint32", "uint64", "sint32", "sint64", "fixed32", "fixed64", "sfixed32", "sfixed64", "float", "double"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "repeat");
        this.typeMapping.clear();
        this.typeMapping.put("array", "array");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "bytes");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
        this.importMapping.clear();
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.cliOptions.clear();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.modelPackage = "models";
        this.apiPackage = "services";
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + StringUtils.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return StringUtils.camelize(this.sanitizeName(operationId));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = this.postProcessModelsEnum(objs);
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models, 1);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (Boolean.TRUE.equals(var.isListContainer)) {
                    var.vendorExtensions.put("x-protobuf-type", "repeated");
                }
                if (!var.vendorExtensions.containsKey("x-protobuf-data-type")) {
                    if (var.isListContainer) {
                        var.vendorExtensions.put("x-protobuf-data-type", var.items.dataType);
                    } else {
                        var.vendorExtensions.put("x-protobuf-data-type", var.dataType);
                    }
                }
                if (!var.isEnum || !var.allowableValues.containsKey("enumVars")) continue;
                List enumVars = (List)var.allowableValues.get("enumVars");
                int enumIndex = 0;
                for (Map enumVar : enumVars) {
                    enumVar.put("protobuf-enum-index", enumIndex);
                    ++enumIndex;
                }
            }
        }
        return objs;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "false";
                }
                return "true";
            }
        } else if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    if (Pattern.compile("\r\n|\r|\n").matcher((String)p.getDefault()).find()) {
                        return "'''" + p.getDefault() + "'''";
                    }
                    return "'" + p.getDefault() + "'";
                }
            } else if (ModelUtils.isArraySchema(p) && p.getDefault() != null) {
                return p.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage;
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name) + "_service";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return StringUtils.camelize(name) + "Service";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_service";
        }
        return StringUtils.underscore(name) + "_service";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(schemaType);
        }
        return type;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            int index = 1;
            for (CodegenParameter p : op.allParams) {
                if (Boolean.TRUE.equals(p.isListContainer)) {
                    p.vendorExtensions.put("x-protobuf-type", "repeated");
                } else if (Boolean.TRUE.equals(p.isMapContainer)) {
                    LOGGER.warn("Map parameter (name: {}, operation ID: {}) not yet supported", (Object)p.paramName, (Object)op.operationId);
                }
                if (!p.vendorExtensions.containsKey("x-protobuf-data-type")) {
                    if (Boolean.TRUE.equals(p.isListContainer)) {
                        p.vendorExtensions.put("x-protobuf-data-type", p.items.dataType);
                    } else {
                        p.vendorExtensions.put("x-protobuf-data-type", p.dataType);
                    }
                }
                p.vendorExtensions.put("x-index", index);
                ++index;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)op.returnType)) {
                op.vendorExtensions.put("x-grpc-response", "google.protobuf.Empty");
                continue;
            }
            if (Boolean.FALSE.equals(op.returnTypeIsPrimitive) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)op.returnContainer)) {
                op.vendorExtensions.put("x-grpc-response", op.returnType);
                continue;
            }
            if ("map".equals(op.returnContainer)) {
                LOGGER.warn("Map response (operation ID: {}) not yet supported", (Object)op.operationId);
                op.vendorExtensions.put("x-grpc-response-type", op.returnBaseType);
                continue;
            }
            if ("array".equals(op.returnContainer)) {
                op.vendorExtensions.put("x-grpc-response-type", "repeated " + op.returnBaseType);
                continue;
            }
            op.vendorExtensions.put("x-grpc-response-type", op.returnBaseType);
        }
        return objs;
    }

    @Override
    public String toModelImport(String name) {
        return StringUtils.underscore(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[str, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }
}

