/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMicronautClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(JavaClientCodegen.class);
    public static final String OPT_TITLE = "title";
    public static final String OPT_CONFIG_PACKAGE = "configPackage";
    public static final String OPT_CONFIGURE_AUTH = "configureAuth";
    public static final String OPT_BUILD = "build";
    public static final String OPT_BUILD_GRADLE = "gradle";
    public static final String OPT_BUILD_MAVEN = "maven";
    public static final String OPT_BUILD_ALL = "all";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_TEST_SPOCK = "spock";
    public static final String NAME = "java-micronaut-client";
    protected String title = "OpenAPI Micronaut Client";
    protected String configPackage;
    protected boolean useBeanValidation;
    protected boolean configureAuthorization;
    protected String buildTool;
    protected String testTool;

    public JavaMicronautClientCodegen() {
        this.invokerPackage = "org.openapitools";
        this.configPackage = "org.openapitools.configuration";
        this.useBeanValidation = true;
        this.configureAuthorization = false;
        this.buildTool = OPT_BUILD_ALL;
        this.testTool = OPT_TEST_JUNIT;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect})));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code/java-micronaut-client";
        this.templateDir = NAME;
        this.embeddedTemplateDir = NAME;
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools";
        this.artifactId = "openapi-micronaut";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.apiTestTemplateFiles.clear();
        this.additionalProperties.put("jackson", "true");
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_CONFIG_PACKAGE, "Configuration package for generated code").defaultValue(this.configPackage));
        this.cliOptions.add(CliOption.newBoolean(OPT_CONFIGURE_AUTH, "Configure all the authorization methods as specified in the file", this.configureAuthorization));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        CliOption buildToolOption = new CliOption(OPT_BUILD, "Specify for which build tool to generate files").defaultValue(this.buildTool);
        buildToolOption.setEnum((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(JavaMicronautClientCodegen.OPT_BUILD_GRADLE, "Gradle configuration is generated for the project");
                this.put(JavaMicronautClientCodegen.OPT_BUILD_MAVEN, "Maven configuration is generated for the project");
                this.put(JavaMicronautClientCodegen.OPT_BUILD_ALL, "Both Gradle and Maven configurations are generated");
            }
        });
        this.cliOptions.add(buildToolOption);
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        testToolOption.setEnum((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(JavaMicronautClientCodegen.OPT_TEST_JUNIT, "Use JUnit as test tool");
                this.put(JavaMicronautClientCodegen.OPT_TEST_SPOCK, "Use Spock as test tool");
            }
        });
        this.cliOptions.add(testToolOption);
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(v -> this.cliOptions.remove(v));
        String[] reservedWordsArray = new String[]{"client", "format", "queryvalue", "queryparam", "pathvariable", "header", "cookie", "authorization", "body", "application"};
        this.reservedWords.addAll(Arrays.asList(reservedWordsArray));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getHelp() {
        return "Generates a Java Micronaut Client.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey(OPT_CONFIG_PACKAGE)) {
            this.configPackage = (String)this.additionalProperties.get(OPT_CONFIG_PACKAGE);
        } else {
            this.additionalProperties.put(OPT_CONFIG_PACKAGE, this.configPackage);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.invokerPackage = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(OPT_CONFIGURE_AUTH)) {
            this.configureAuthorization = this.convertPropertyToBoolean(OPT_CONFIGURE_AUTH);
        }
        this.writePropertyBack(OPT_CONFIGURE_AUTH, this.configureAuthorization);
        if (this.additionalProperties.containsKey(OPT_BUILD)) {
            switch ((String)this.additionalProperties.get(OPT_BUILD)) {
                case "gradle": 
                case "maven": 
                case "all": {
                    this.buildTool = (String)this.additionalProperties.get(OPT_BUILD);
                    break;
                }
                default: {
                    throw new RuntimeException("Build tool \"" + this.additionalProperties.get(OPT_BUILD) + "\" is not supported or misspelled.");
                }
            }
        }
        this.additionalProperties.put(OPT_BUILD, this.buildTool);
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            switch ((String)this.additionalProperties.get(OPT_TEST)) {
                case "junit": 
                case "spock": {
                    this.testTool = (String)this.additionalProperties.get(OPT_TEST);
                    break;
                }
                default: {
                    throw new RuntimeException("Test tool \"" + this.additionalProperties.get(OPT_TEST) + "\" is not supported or misspelled.");
                }
            }
        }
        this.additionalProperties.put(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.additionalProperties.put("isTestSpock", true);
        }
        String invokerFolder = (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + '/' + this.apiPackage).replace(".", "/");
        String resourceFolder = this.projectFolder + "/resources";
        this.supportingFiles.add(new SupportingFile("configuration/application.yml.mustache", resourceFolder, "application.yml").doNotOverwrite());
        if (this.configureAuthorization) {
            String authFolder = invokerFolder + "/auth";
            this.supportingFiles.add(new SupportingFile("auth/Authorization.mustache", authFolder, "Authorization.java"));
            this.supportingFiles.add(new SupportingFile("auth/AuthorizationBinder.mustache", authFolder, "AuthorizationBinder.java"));
            this.supportingFiles.add(new SupportingFile("auth/Authorizations.mustache", authFolder, "Authorizations.java"));
            this.supportingFiles.add(new SupportingFile("auth/AuthorizationFilter.mustache", authFolder, "AuthorizationFilter.java"));
            String authConfigurationFolder = authFolder + "/configuration";
            this.supportingFiles.add(new SupportingFile("auth/configuration/ApiKeyAuthConfiguration.mustache", authConfigurationFolder, "ApiKeyAuthConfiguration.java"));
            this.supportingFiles.add(new SupportingFile("auth/configuration/ConfigurableAuthorization.mustache", authConfigurationFolder, "ConfigurableAuthorization.java"));
            this.supportingFiles.add(new SupportingFile("auth/configuration/HttpBasicAuthConfiguration.mustache", authConfigurationFolder, "HttpBasicAuthConfiguration.java"));
        }
        String queryFolder = invokerFolder + "/query";
        this.supportingFiles.add(new SupportingFile("query/QueryParam.mustache", queryFolder, "QueryParam.java"));
        this.supportingFiles.add(new SupportingFile("query/QueryParamBinder.mustache", queryFolder, "QueryParamBinder.java"));
        if (this.buildTool.equals(OPT_BUILD_GRADLE) || this.buildTool.equals(OPT_BUILD_ALL)) {
            this.supportingFiles.add(new SupportingFile("configuration/gradle/build.gradle.mustache", "", "build.gradle").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("configuration/gradle/settings.gradle.mustache", "", "settings.gradle").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("configuration/gradle/gradle.properties.mustache", "", "gradle.properties").doNotOverwrite());
            String gradleWrapperFolder = "gradle/wrapper";
            this.supportingFiles.add(new SupportingFile("configuration/gradlew/gradlew.mustache", "", "gradlew"));
            this.supportingFiles.add(new SupportingFile("configuration/gradlew/gradlew.bat.mustache", "", "gradlew.bat"));
            this.supportingFiles.add(new SupportingFile("configuration/gradlew/gradle-wrapper.properties.mustache", "gradle/wrapper", "gradle-wrapper.properties"));
            this.supportingFiles.add(new SupportingFile("configuration/gradlew/gradle-wrapper.jar", "gradle/wrapper", "gradle-wrapper.jar"));
        }
        if (this.buildTool.equals(OPT_BUILD_MAVEN) || this.buildTool.equals(OPT_BUILD_ALL)) {
            this.supportingFiles.add(new SupportingFile("configuration/pom.xml.mustache", "", "pom.xml").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("configuration/mavenw/mvnw.mustache", "", "mvnw"));
            this.supportingFiles.add(new SupportingFile("configuration/mavenw/mvnw.bat.mustache", "", "mvnw.bat"));
            this.supportingFiles.add(new SupportingFile("configuration/mavenw/MavenWrapperDownloader.java.mustache", ".mvn/wrapper", "MavenWrapperDownloader.java"));
            this.supportingFiles.add(new SupportingFile("configuration/mavenw/maven-wrapper.jar.mustache", ".mvn/wrapper", "maven-wrapper.jar"));
            this.supportingFiles.add(new SupportingFile("configuration/mavenw/maven-wrapper.properties.mustache", ".mvn/wrapper", "maren-wrapper.properties"));
        }
        this.supportingFiles.add(new SupportingFile("configuration/git/gitignore.mustache", "", ".gitignore").doNotOverwrite());
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("DateTime", "LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.supportingFiles.add(new SupportingFile("doc/README.mustache", "", "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("doc/auth.mustache", this.apiDocPath, "auth.md"));
        this.modelDocTemplateFiles.put("doc/model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("doc/api_doc.mustache", ".md");
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.modelTemplateFiles.remove("model.mustache");
        this.modelTemplateFiles.put("model/model.mustache", ".java");
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.apiTestTemplateFiles.put("api_test.mustache", ".java");
            this.modelTestTemplateFiles.put("model_test.mustache", ".java");
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.apiTestTemplateFiles.put("api_test.groovy.mustache", ".groovy");
            this.modelTestTemplateFiles.put("model_test.groovy.mustache", ".groovy");
        }
    }

    @Override
    public String apiTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.getInvokerPackage().replaceAll("\\.", "/") + "/api";
        }
        return this.getOutputDir() + "/src/test/java/" + this.getInvokerPackage().replaceAll("\\.", "/") + "/api";
    }

    @Override
    public String modelTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.getInvokerPackage().replaceAll("\\.", "/") + "/model";
        }
        return this.getOutputDir() + "/src/test/java/" + this.getInvokerPackage().replaceAll("\\.", "/") + "/model";
    }

    @Override
    public String toApiTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toApiName(name) + "Spec";
        }
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toModelTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toModelName(name) + "Spec";
        }
        return this.toModelName(name) + "Test";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    public boolean isUseBeanValidation() {
        return this.useBeanValidation;
    }

    public boolean isConfigureAuthorization() {
        return this.configureAuthorization;
    }
}

