/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Iterables;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoClientCodegen
extends AbstractGoCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(GoClientCodegen.class);
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    public static final String WITH_XML = "withXml";
    public static final String STRUCT_PREFIX = "structPrefix";
    public static final String WITH_AWSV4_SIGNATURE = "withAWSV4Signature";
    public static final String GENERATE_INTERFACES = "generateInterfaces";
    protected String goImportAlias = "openapiclient";
    protected boolean isGoSubmodule = false;
    protected boolean useOneOfDiscriminatorLookup = false;
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    public GoClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.outputFolder = "generated-code/go";
        this.templateDir = "go";
        this.embeddedTemplateDir = "go";
        this.usesOptionals = false;
        this.apiTemplateFiles.put("api.mustache", ".go");
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.cliOptions.add(CliOption.newBoolean("isGoSubmodule", "whether the generated Go module is a submodule"));
        this.cliOptions.add(CliOption.newBoolean(WITH_XML, "whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        this.cliOptions.add(CliOption.newBoolean("enumClassPrefix", "Prefix enum with class name"));
        this.cliOptions.add(CliOption.newBoolean(STRUCT_PREFIX, "whether to prefix struct with the class name. e.g. DeletePetOpts => PetApiDeletePetOpts"));
        this.cliOptions.add(CliOption.newBoolean(WITH_AWSV4_SIGNATURE, "whether to include AWS v4 signature support"));
        this.cliOptions.add(CliOption.newBoolean(GENERATE_INTERFACES, "Generate interfaces for api classes"));
        this.cliOptions.add(CliOption.newBoolean("prependFormOrBodyParameters", "Add form or body parameters to the beginning of the parameter list.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped.").defaultValue("false"));
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
    }

    @Override
    public String getName() {
        return "go";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String toGetter(String name) {
        return "Get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getHelp() {
        return "Generates a Go client library.";
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        if (this.additionalProperties.containsKey(WITH_AWSV4_SIGNATURE)) {
            this.setWithAWSV4Signature(Boolean.parseBoolean(this.additionalProperties.get(WITH_AWSV4_SIGNATURE).toString()));
            this.additionalProperties.put(WITH_AWSV4_SIGNATURE, this.withAWSV4Signature);
        }
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get(WITH_XML).toString()));
            this.additionalProperties.put(WITH_XML, this.withXml);
        }
        if (this.additionalProperties.containsKey("enumClassPrefix")) {
            this.setEnumClassPrefix(Boolean.parseBoolean(this.additionalProperties.get("enumClassPrefix").toString()));
            this.additionalProperties.put("enumClassPrefix", this.enumClassPrefix);
        }
        if (this.additionalProperties.containsKey("isGoSubmodule")) {
            this.setIsGoSubmodule(Boolean.parseBoolean(this.additionalProperties.get("isGoSubmodule").toString()));
            this.additionalProperties.put("isGoSubmodule", this.isGoSubmodule);
        }
        if (this.additionalProperties.containsKey(STRUCT_PREFIX)) {
            this.setStructPrefix(Boolean.parseBoolean(this.additionalProperties.get(STRUCT_PREFIX).toString()));
            this.additionalProperties.put(STRUCT_PREFIX, this.structPrefix);
        }
        if (this.additionalProperties.containsKey(GENERATE_INTERFACES)) {
            this.setGenerateInterfaces(Boolean.parseBoolean(this.additionalProperties.get(GENERATE_INTERFACES).toString()));
            this.additionalProperties.put(GENERATE_INTERFACES, this.generateInterfaces);
        }
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", "", "signing.go"));
        }
        if (this.additionalProperties.containsKey("goImportAlias")) {
            this.setGoImportAlias(this.additionalProperties.get("goImportAlias").toString());
        } else {
            this.additionalProperties.put("goImportAlias", this.goImportAlias);
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.getUseOneOfDiscriminatorLookup());
        }
        if (this.additionalProperties.containsKey("disallowAdditionalPropertiesIfNotPresent")) {
            this.setDisallowAdditionalPropertiesIfNotPresent(Boolean.parseBoolean(this.additionalProperties.get("disallowAdditionalPropertiesIfNotPresent").toString()));
        }
        this.additionalProperties.put("lambda.type-to-name", (fragment, writer) -> writer.write(this.typeToName(fragment.execute())));
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.go"));
        this.supportingFiles.add(new SupportingFile("client.mustache", "", "client.go"));
        this.supportingFiles.add(new SupportingFile("response.mustache", "", "response.go"));
        this.supportingFiles.add(new SupportingFile("go.mod.mustache", "", "go.mod"));
        this.supportingFiles.add(new SupportingFile("go.sum", "", "go.sum"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("utils.mustache", "", "utils.go"));
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    public void setGoImportAlias(String goImportAlias) {
        this.goImportAlias = goImportAlias;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setIsGoSubmodule(boolean isGoSubmodule) {
        this.isGoSubmodule = isGoSubmodule;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator;
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.schemaKeyToModelNameCache.containsKey(name)) {
            return this.schemaKeyToModelNameCache.get(name);
        }
        String camelizedName = StringUtils.camelize(this.toModel(name, false));
        this.schemaKeyToModelNameCache.put(name, camelizedName);
        return camelizedName;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return name + '_';
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        String prefix = "";
        if (this.enumClassPrefix) {
            prefix = datatype.toUpperCase(Locale.ROOT) + "_";
        }
        return prefix + value;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        String enumDefault = null;
        if (var.isEnum && var.defaultValue != null) {
            enumDefault = var.defaultValue;
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum && enumDefault != null) {
            var.defaultValue = enumDefault;
        }
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p = ModelUtils.getReferencedSchema(this.openAPI, p))) {
            Object defaultObj = p.getDefault();
            if (defaultObj != null) {
                if (defaultObj instanceof String) {
                    return "\"" + this.escapeText((String)defaultObj) + "\"";
                }
                return "\"" + this.escapeText(defaultObj.toString()) + "\"";
            }
            return null;
        }
        return super.toDefaultValue(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty prop = super.fromProperty(name, p);
        String cc = StringUtils.camelize(prop.name, true);
        if (this.isReservedWord(cc)) {
            cc = this.escapeReservedWord(cc);
        }
        prop.nameInCamelCase = cc;
        return prop;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap m : objs.getModels()) {
            CodegenModel model = m.getModel();
            if (model.isEnum) continue;
            for (CodegenProperty param : Iterables.concat(model.vars, model.allVars, model.requiredVars, model.optionalVars)) {
                param.vendorExtensions.put("x-go-base-type", param.dataType);
                if (!param.isNullable || param.isContainer || param.isFreeFormObject || param.isAnyType && !param.isModel) continue;
                if (param.isDateTime) {
                    param.dataType = "NullableTime";
                    continue;
                }
                param.dataType = "Nullable" + Character.toUpperCase(param.dataType.charAt(0)) + param.dataType.substring(1);
            }
            if (model.oneOf != null && !model.oneOf.isEmpty()) {
                imports.add(this.createMapping("import", "fmt"));
            }
            if (model.anyOf != null && !model.anyOf.isEmpty()) {
                imports.add(this.createMapping("import", "fmt"));
            }
            if (!model.isAdditionalPropertiesTrue || model.parent == null || !Boolean.FALSE.equals(model.isMap)) continue;
            imports.add(this.createMapping("import", "reflect"));
            imports.add(this.createMapping("import", "strings"));
        }
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, ArrayList<Integer>> processedModelMaps = new HashMap<String, ArrayList<Integer>>();
        for (ModelMap modelMap : allModels) {
            CodegenModel m = modelMap.getModel();
            modelMaps.put(m.classname, m);
        }
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-go-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
            }
            processedModelMaps.clear();
        }
        for (CodegenOperation operation : operationList) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-go-example", this.constructExampleCode(cp, modelMaps, processedModelMaps));
            }
            if (processedModelMaps.containsKey("time.Time")) {
                operation.vendorExtensions.put("x-go-import", "    \"time\"");
            }
            processedModelMaps.clear();
        }
        return objs;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, ArrayList<Integer>> processedModelMap) {
        if (codegenParameter.isArray) {
            String prefix = codegenParameter.dataType;
            String dataType = org.apache.commons.lang3.StringUtils.removeStart((String)codegenParameter.dataType, (String)"[]");
            if (modelMaps.containsKey(dataType)) {
                prefix = "[]" + this.goImportAlias + "." + dataType;
            }
            return prefix + "{" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap, 0) + "}";
        }
        if (codegenParameter.isMap) {
            String prefix = codegenParameter.dataType;
            String dataType = org.apache.commons.lang3.StringUtils.removeStart((String)codegenParameter.dataType, (String)"map[string][]");
            if (modelMaps.containsKey(dataType)) {
                prefix = "map[string][]" + this.goImportAlias + "." + dataType;
            }
            if (codegenParameter.items == null) {
                return prefix + "{ ... }";
            }
            return prefix + "{\"key\": " + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap, 0) + "}";
        }
        if (codegenParameter.isPrimitiveType) {
            if (codegenParameter.isString) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                    return "\"" + codegenParameter.example + "\"";
                }
                return "\"" + codegenParameter.paramName + "_example\"";
            }
            if (codegenParameter.isBoolean) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenParameter.isUri) {
                return "\"https://example.com\"";
            }
            if (codegenParameter.isDateTime || codegenParameter.isDate) {
                ArrayList<Integer> v = new ArrayList<Integer>();
                v.add(1);
                processedModelMap.put("time.Time", v);
                return "time.Now()";
            }
            if (codegenParameter.isFile) {
                return "os.NewFile(1234, \"some_file\")";
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                return codegenParameter.dataType + "(" + codegenParameter.example + ")";
            }
            return codegenParameter.dataType + "(987)";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap, 0);
        }
        if (codegenParameter.isEmail) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example) && !"null".equals(codegenParameter.example)) {
                return "\"" + codegenParameter.example + "\"";
            }
            return "\"" + codegenParameter.paramName + "@example.com\"";
        }
        if (codegenParameter.isDateTime || codegenParameter.isDate) {
            ArrayList<Integer> v = new ArrayList<Integer>();
            v.add(1);
            processedModelMap.put("time.Time", v);
            return "time.Now()";
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, ArrayList<Integer>> processedModelMap, int depth) {
        if (codegenProperty.isArray) {
            String prefix = codegenProperty.dataType;
            String dataType = org.apache.commons.lang3.StringUtils.removeStart((String)codegenProperty.dataType, (String)"[]");
            if (modelMaps.containsKey(dataType)) {
                prefix = "[]" + this.goImportAlias + "." + dataType;
            }
            if (codegenProperty.items.isNullable) {
                return prefix + "{nil}";
            }
            return prefix + "{" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap, depth + 1) + "}";
        }
        if (codegenProperty.isMap) {
            String prefix = codegenProperty.dataType;
            String dataType = org.apache.commons.lang3.StringUtils.removeStart((String)codegenProperty.dataType, (String)"map[string][]");
            if (modelMaps.containsKey(dataType)) {
                prefix = "map[string][]" + this.goImportAlias + "." + dataType;
            }
            if (codegenProperty.items == null) {
                return prefix + "{ ... }";
            }
            return prefix + "{\"key\": " + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap, depth + 1) + "}";
        }
        if (codegenProperty.isPrimitiveType) {
            if (codegenProperty.isString) {
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if (codegenProperty.isBoolean) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "true";
                }
                return "false";
            }
            if (codegenProperty.isUri) {
                return "\"https://example.com\"";
            }
            if (codegenProperty.isDateTime || codegenProperty.isDate) {
                ArrayList<Integer> v = new ArrayList<Integer>();
                v.add(1);
                processedModelMap.put("time.Time", v);
                return "time.Now()";
            }
            String example = !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example) ? codegenProperty.example : "123";
            return codegenProperty.dataType + "(" + example + ")";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap, depth + 1);
        }
        if (codegenProperty.isEmail) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example) && !"null".equals(codegenProperty.example)) {
                return "\"" + codegenProperty.example + "\"";
            }
            return "\"" + codegenProperty.name + "@example.com\"";
        }
        if (codegenProperty.isDateTime || codegenProperty.isDate) {
            ArrayList<Integer> v = new ArrayList<Integer>();
            v.add(1);
            processedModelMap.put("time.Time", v);
            return "time.Now()";
        }
        return "\"TODO\"";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, ArrayList<Integer>> processedModelMap, int depth) {
        String model = codegenModel.name;
        if (processedModelMap.containsKey(model)) {
            ArrayList<Integer> depthList = processedModelMap.get(model);
            if (depthList.size() != 1) {
                if (depthList.size() != 2) throw new RuntimeException("Invalid count when constructing example: " + depthList.size());
                return "";
            }
            if (depthList.get(0) != depth) {
                depthList.add(depth);
                processedModelMap.put(model, depthList);
            }
        } else {
            if (codegenModel.isEnum) {
                Map<String, Object> allowableValues = codegenModel.allowableValues;
                List values = (List)allowableValues.get("values");
                String example = String.valueOf(values.get(0));
                if (!codegenModel.isString) return this.goImportAlias + "." + model + "(" + example + ")";
                example = "\"" + example + "\"";
                return this.goImportAlias + "." + model + "(" + example + ")";
            }
            if (codegenModel.oneOf != null && !codegenModel.oneOf.isEmpty()) {
                String oneOf;
                String subModel = (String)codegenModel.oneOf.toArray()[0];
                if (modelMaps.get(subModel) == null) {
                    oneOf = "new(" + subModel + ")";
                    return this.goImportAlias + "." + model + "{" + this.typeToName(subModel) + ": " + oneOf + "}";
                }
                oneOf = this.constructExampleCode(modelMaps.get(subModel), modelMaps, processedModelMap, depth + 1).substring(1);
                return this.goImportAlias + "." + model + "{" + this.typeToName(subModel) + ": " + oneOf + "}";
            }
            ArrayList<Integer> v = new ArrayList<Integer>();
            v.add(depth);
            processedModelMap.put(model, v);
        }
        ArrayList<String> propertyExamples = new ArrayList<String>();
        Iterator<CodegenProperty> iterator = codegenModel.requiredVars.iterator();
        while (iterator.hasNext()) {
            CodegenProperty codegenProperty = iterator.next();
            propertyExamples.add(this.constructExampleCode(codegenProperty, modelMaps, processedModelMap, depth + 1));
        }
        return "*" + this.goImportAlias + ".New" + this.toModelName(model) + "(" + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ") + ")";
    }

    private String typeToName(String content) {
        content = content.trim().replace("[]", "array_of_");
        content = content.trim().replace("[", "map_of_");
        content = content.trim().replace("]", "");
        return StringUtils.camelize(content);
    }
}

